/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.SplashProgress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class TextureUtil {
    private static final Logger field_147959_c = LogManager.getLogger();

    public static int func_110996_a() {
        return GlStateManager.func_179146_y();
    }

    public static void func_147942_a(int textureId) {
        GlStateManager.func_179150_h((int)textureId);
    }

    public static void func_110991_a(int textureId, int width, int height) {
        TextureUtil.func_211682_a(NativeImage.PixelFormatGLCode.RGBA, textureId, 0, width, height);
    }

    public static void func_211681_a(NativeImage.PixelFormatGLCode pixelFormat, int glTextureId, int width, int height) {
        TextureUtil.func_211682_a(pixelFormat, glTextureId, 0, width, height);
    }

    public static void func_180600_a(int glTextureId, int mipmapLevels, int width, int height) {
        TextureUtil.func_211682_a(NativeImage.PixelFormatGLCode.RGBA, glTextureId, mipmapLevels, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void func_211682_a(NativeImage.PixelFormatGLCode internalFormat, int glTextureId, int mipmapLevels, int width, int height) {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            TextureUtil.func_94277_a(glTextureId);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (mipmapLevels >= 0) {
                GlStateManager.func_187421_b((int)3553, (int)33085, (int)mipmapLevels);
                GlStateManager.func_187421_b((int)3553, (int)33082, (int)0);
                GlStateManager.func_187421_b((int)3553, (int)33083, (int)mipmapLevels);
                GlStateManager.func_187403_b((int)3553, (int)34049, (float)0.0f);
            }
            for (int i = 0; i <= mipmapLevels; ++i) {
                GlStateManager.func_187419_a((int)3553, (int)i, (int)internalFormat.func_211672_a(), (int)(width >> i), (int)(height >> i), (int)0, (int)6408, (int)5121, (IntBuffer)null);
            }
            return;
        }
    }

    private static void func_94277_a(int glTextureId) {
        GlStateManager.func_179144_i((int)glTextureId);
    }

    @Deprecated
    public static int[] func_195725_a(IResourceManager resourceManager, ResourceLocation imageLocation) throws IOException {
        int[] object;
        try (IResource iresource = resourceManager.func_199002_a(imageLocation);
             NativeImage nativeimage = NativeImage.func_195713_a((InputStream)iresource.func_199027_b());){
            object = nativeimage.func_195716_c();
        }
        return object;
    }

    public static ByteBuffer func_195724_a(InputStream inputStream) throws IOException {
        ByteBuffer bytebuffer;
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)inputStream;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(inputStream);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }
}

