/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.ModelShulker;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityBannerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityBedRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityChestRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityConduitRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEnchantmentTableRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEndGatewayRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityEndPortalRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityMobSpawnerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityPistonRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityShulkerBoxRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySignRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityStructureRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityConduit;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityRendererDispatcher {
    private final Map<Class<? extends TileEntity>, TileEntityRenderer<? extends TileEntity>> field_147559_m = Maps.newHashMap();
    public static TileEntityRendererDispatcher field_147556_a = new TileEntityRendererDispatcher();
    public FontRenderer field_147557_n;
    public static double field_147554_b;
    public static double field_147555_c;
    public static double field_147552_d;
    public TextureManager field_147553_e;
    public World field_147550_f;
    public Entity field_147551_g;
    public float field_147562_h;
    public float field_147563_i;
    public RayTraceResult field_190057_j;
    public double field_147560_j;
    public double field_147561_k;
    public double field_147558_l;
    private Tessellator batchBuffer = new Tessellator(0x200000);
    private boolean drawingBatch = false;

    private TileEntityRendererDispatcher() {
        this.field_147559_m.put(TileEntitySign.class, (TileEntityRenderer<? extends TileEntity>)new TileEntitySignRenderer());
        this.field_147559_m.put(TileEntityMobSpawner.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityMobSpawnerRenderer());
        this.field_147559_m.put(TileEntityPiston.class, new TileEntityPistonRenderer());
        this.field_147559_m.put(TileEntityChest.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityChestRenderer());
        this.field_147559_m.put(TileEntityEnderChest.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityChestRenderer());
        this.field_147559_m.put(TileEntityEnchantmentTable.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityEnchantmentTableRenderer());
        this.field_147559_m.put(TileEntityEndPortal.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityEndPortalRenderer());
        this.field_147559_m.put(TileEntityEndGateway.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityEndGatewayRenderer());
        this.field_147559_m.put(TileEntityBeacon.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityBeaconRenderer());
        this.field_147559_m.put(TileEntitySkull.class, (TileEntityRenderer<? extends TileEntity>)new TileEntitySkullRenderer());
        this.field_147559_m.put(TileEntityBanner.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityBannerRenderer());
        this.field_147559_m.put(TileEntityStructure.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityStructureRenderer());
        this.field_147559_m.put(TileEntityShulkerBox.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityShulkerBoxRenderer(new ModelShulker()));
        this.field_147559_m.put(TileEntityBed.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityBedRenderer());
        this.field_147559_m.put(TileEntityConduit.class, (TileEntityRenderer<? extends TileEntity>)new TileEntityConduitRenderer());
        for (TileEntityRenderer<? extends TileEntity> tileentityrenderer : this.field_147559_m.values()) {
            tileentityrenderer.func_147497_a(this);
        }
    }

    public <T extends TileEntity> TileEntityRenderer<T> func_147546_a(Class<? extends TileEntity> teClass) {
        TileEntityRenderer<TileEntity> tileentityrenderer = this.field_147559_m.get(teClass);
        if (tileentityrenderer == null && teClass != TileEntity.class) {
            tileentityrenderer = this.func_147546_a(teClass.getSuperclass());
            this.field_147559_m.put(teClass, tileentityrenderer);
        }
        return tileentityrenderer;
    }

    @Nullable
    public <T extends TileEntity> TileEntityRenderer<T> func_147547_b(@Nullable TileEntity tileEntityIn) {
        return tileEntityIn == null || tileEntityIn.func_145837_r() ? null : this.func_147546_a(((Object)((Object)tileEntityIn)).getClass());
    }

    public void func_190056_a(World worldIn, TextureManager renderEngineIn, FontRenderer fontRendererIn, Entity entityIn, RayTraceResult cameraHitResultIn, float partialTicks) {
        if (this.field_147550_f != worldIn) {
            this.func_147543_a(worldIn);
        }
        this.field_147553_e = renderEngineIn;
        this.field_147551_g = entityIn;
        this.field_147557_n = fontRendererIn;
        this.field_190057_j = cameraHitResultIn;
        this.field_147562_h = entityIn.field_70126_B + (entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks;
        this.field_147563_i = entityIn.field_70127_C + (entityIn.field_70125_A - entityIn.field_70127_C) * partialTicks;
        this.field_147560_j = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        this.field_147561_k = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        this.field_147558_l = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
    }

    public void func_180546_a(TileEntity tileentityIn, float partialTicks, int destroyStage) {
        if (tileentityIn.func_145835_a(this.field_147560_j, this.field_147561_k, this.field_147558_l) < tileentityIn.func_145833_n()) {
            if (!this.drawingBatch || !tileentityIn.hasFastRenderer()) {
                RenderHelper.func_74519_b();
                int i = this.field_147550_f.func_175626_b(tileentityIn.func_174877_v(), 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, j, k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            BlockPos blockpos = tileentityIn.func_174877_v();
            this.func_203602_a(tileentityIn, (double)blockpos.func_177958_n() - field_147554_b, (double)blockpos.func_177956_o() - field_147555_c, (double)blockpos.func_177952_p() - field_147552_d, partialTicks, destroyStage, false);
        }
    }

    public void func_147549_a(TileEntity tileEntityIn, double x, double y, double z, float partialTicks) {
        this.func_203602_a(tileEntityIn, x, y, z, partialTicks, -1, false);
    }

    public void func_203601_b(TileEntity tileEntityIn) {
        this.func_203602_a(tileEntityIn, 0.0, 0.0, 0.0, 0.0f, -1, true);
    }

    public void func_203602_a(TileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage, boolean hasNoBlock) {
        TileEntityRenderer<TileEntity> tileentityrenderer = this.func_147547_b(tileEntityIn);
        if (tileentityrenderer != null) {
            try {
                if (!(hasNoBlock || tileEntityIn.func_145830_o() && tileEntityIn.func_195044_w().hasTileEntity())) {
                    return;
                }
                if (this.drawingBatch && tileEntityIn.hasFastRenderer()) {
                    tileentityrenderer.renderTileEntityFast(tileEntityIn, x, y, z, partialTicks, destroyStage, this.batchBuffer.func_178180_c());
                } else {
                    tileentityrenderer.func_199341_a(tileEntityIn, x, y, z, partialTicks, destroyStage);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering Block Entity");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block Entity Details");
                tileEntityIn.func_145828_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
        }
    }

    public void func_147543_a(@Nullable World worldIn) {
        this.field_147550_f = worldIn;
        if (worldIn == null) {
            this.field_147551_g = null;
        }
    }

    public FontRenderer func_147548_a() {
        return this.field_147557_n;
    }

    public void preDrawBatch() {
        this.batchBuffer.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.drawingBatch = true;
    }

    public void drawBatch(int pass) {
        this.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        if (pass > 0) {
            Vec3d cameraPos = ActiveRenderInfo.getCameraPosition();
            this.batchBuffer.func_178180_c().func_181674_a((float)cameraPos.field_72450_a, (float)cameraPos.field_72448_b, (float)cameraPos.field_72449_c);
        }
        this.batchBuffer.func_78381_a();
        RenderHelper.func_74519_b();
        this.drawingBatch = false;
    }

    public synchronized <T extends TileEntity> void setSpecialRenderer(Class<T> tileEntityClass, TileEntityRenderer<? super T> specialRenderer) {
        this.field_147559_m.put(tileEntityClass, specialRenderer);
    }
}

