/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import java.nio.IntBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Framebuffer {
    public int field_147622_a;
    public int field_147620_b;
    public int field_147621_c;
    public int field_147618_d;
    public boolean field_147619_e;
    public int field_147616_f;
    public int field_147617_g;
    public int field_147624_h;
    public float[] field_147625_i;
    public int field_147623_j;
    private boolean stencilEnabled = false;

    public Framebuffer(int width, int height, boolean useDepthIn) {
        this.field_147619_e = useDepthIn;
        this.field_147616_f = -1;
        this.field_147617_g = -1;
        this.field_147624_h = -1;
        this.field_147625_i = new float[4];
        this.field_147625_i[0] = 1.0f;
        this.field_147625_i[1] = 1.0f;
        this.field_147625_i[2] = 1.0f;
        this.field_147625_i[3] = 0.0f;
        this.func_147613_a(width, height);
    }

    public void func_147613_a(int width, int height) {
        if (!OpenGlHelper.func_148822_b()) {
            this.field_147621_c = width;
            this.field_147618_d = height;
        } else {
            GlStateManager.func_179126_j();
            if (this.field_147616_f >= 0) {
                this.func_147608_a();
            }
            this.func_147605_b(width, height);
            OpenGlHelper.func_153171_g(OpenGlHelper.field_153198_e, 0);
        }
    }

    public void func_147608_a() {
        if (OpenGlHelper.func_148822_b()) {
            this.func_147606_d();
            this.func_147609_e();
            if (this.field_147624_h > -1) {
                OpenGlHelper.func_153184_g(this.field_147624_h);
                this.field_147624_h = -1;
            }
            if (this.field_147617_g > -1) {
                TextureUtil.func_147942_a(this.field_147617_g);
                this.field_147617_g = -1;
            }
            if (this.field_147616_f > -1) {
                OpenGlHelper.func_153171_g(OpenGlHelper.field_153198_e, 0);
                OpenGlHelper.func_153174_h(this.field_147616_f);
                this.field_147616_f = -1;
            }
        }
    }

    public void func_147605_b(int width, int height) {
        this.field_147621_c = width;
        this.field_147618_d = height;
        this.field_147622_a = width;
        this.field_147620_b = height;
        if (!OpenGlHelper.func_148822_b()) {
            this.func_147614_f();
        } else {
            this.field_147616_f = OpenGlHelper.func_153165_e();
            this.field_147617_g = TextureUtil.func_110996_a();
            if (this.field_147619_e) {
                this.field_147624_h = OpenGlHelper.func_153185_f();
            }
            this.func_147607_a(9728);
            GlStateManager.func_179144_i((int)this.field_147617_g);
            GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            OpenGlHelper.func_153171_g(OpenGlHelper.field_153198_e, this.field_147616_f);
            OpenGlHelper.func_153188_a(OpenGlHelper.field_153198_e, OpenGlHelper.field_153200_g, 3553, this.field_147617_g, 0);
            if (this.field_147619_e) {
                OpenGlHelper.func_153176_h(OpenGlHelper.field_153199_f, this.field_147624_h);
                if (!this.stencilEnabled) {
                    OpenGlHelper.func_153186_a(OpenGlHelper.field_153199_f, 33190, this.field_147622_a, this.field_147620_b);
                    OpenGlHelper.func_153190_b(OpenGlHelper.field_153198_e, OpenGlHelper.field_153201_h, OpenGlHelper.field_153199_f, this.field_147624_h);
                } else {
                    OpenGlHelper.func_153186_a(OpenGlHelper.field_153199_f, 35056, this.field_147622_a, this.field_147620_b);
                    OpenGlHelper.func_153190_b(OpenGlHelper.field_153198_e, 36096, OpenGlHelper.field_153199_f, this.field_147624_h);
                    OpenGlHelper.func_153190_b(OpenGlHelper.field_153198_e, 36128, OpenGlHelper.field_153199_f, this.field_147624_h);
                }
            }
            this.func_147611_b();
            this.func_147614_f();
            this.func_147606_d();
        }
    }

    public void func_147607_a(int framebufferFilterIn) {
        if (OpenGlHelper.func_148822_b()) {
            this.field_147623_j = framebufferFilterIn;
            GlStateManager.func_179144_i((int)this.field_147617_g);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)framebufferFilterIn);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)framebufferFilterIn);
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
            GlStateManager.func_179144_i((int)0);
        }
    }

    public void func_147611_b() {
        int i = OpenGlHelper.func_153167_i(OpenGlHelper.field_153198_e);
        if (i != OpenGlHelper.field_153202_i) {
            if (i == OpenGlHelper.field_153203_j) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153204_k) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153205_l) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == OpenGlHelper.field_153206_m) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public void func_147612_c() {
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179144_i((int)this.field_147617_g);
        }
    }

    public void func_147606_d() {
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179144_i((int)0);
        }
    }

    public void func_147610_a(boolean p_147610_1_) {
        if (OpenGlHelper.func_148822_b()) {
            OpenGlHelper.func_153171_g(OpenGlHelper.field_153198_e, this.field_147616_f);
            if (p_147610_1_) {
                GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_147621_c, (int)this.field_147618_d);
            }
        }
    }

    public void func_147609_e() {
        if (OpenGlHelper.func_148822_b()) {
            OpenGlHelper.func_153171_g(OpenGlHelper.field_153198_e, 0);
        }
    }

    public void func_147604_a(float red, float green, float blue, float alpha) {
        this.field_147625_i[0] = red;
        this.field_147625_i[1] = green;
        this.field_147625_i[2] = blue;
        this.field_147625_i[3] = alpha;
    }

    public void func_147615_c(int width, int height) {
        this.func_178038_a(width, height, true);
    }

    public void func_178038_a(int width, int height, boolean p_178038_3_) {
        if (OpenGlHelper.func_148822_b()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
            GlStateManager.func_179098_w();
            GlStateManager.func_179140_f();
            GlStateManager.func_179118_c();
            if (p_178038_3_) {
                GlStateManager.func_179084_k();
                GlStateManager.func_179142_g();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147612_c();
            float f = width;
            float f1 = height;
            float f2 = (float)this.field_147621_c / (float)this.field_147622_a;
            float f3 = (float)this.field_147618_d / (float)this.field_147620_b;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(0.0, f1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(f, f1, 0.0).func_187315_a(f2, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(f, 0.0, 0.0).func_187315_a(f2, f3).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, f3).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
            this.func_147606_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public void func_147614_f() {
        this.func_147610_a(true);
        GlStateManager.func_179082_a((float)this.field_147625_i[0], (float)this.field_147625_i[1], (float)this.field_147625_i[2], (float)this.field_147625_i[3]);
        int i = 16384;
        if (this.field_147619_e) {
            GlStateManager.func_179151_a((double)1.0);
            i |= 0x100;
        }
        GlStateManager.func_179086_m((int)i);
        this.func_147609_e();
    }

    public boolean enableStencil() {
        if (!OpenGlHelper.func_148822_b()) {
            return false;
        }
        this.stencilEnabled = true;
        this.func_147613_a(this.field_147621_c, this.field_147618_d);
        return true;
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }
}

