/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.util.JsonException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class ShaderLoader {
    private final ShaderType field_148061_a;
    private final String field_148059_b;
    private final int field_148060_c;
    private int field_148058_d;

    private ShaderLoader(ShaderType type, int shaderId, String filename) {
        this.field_148061_a = type;
        this.field_148060_c = shaderId;
        this.field_148059_b = filename;
    }

    public void func_148056_a(ShaderManager manager) {
        ++this.field_148058_d;
        OpenGlHelper.func_153178_b(manager.func_147986_h(), this.field_148060_c);
    }

    public void func_195656_a() {
        --this.field_148058_d;
        if (this.field_148058_d <= 0) {
            OpenGlHelper.func_153180_a(this.field_148060_c);
            this.field_148061_a.func_148064_d().remove(this.field_148059_b);
        }
    }

    public String func_148055_a() {
        return this.field_148059_b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderLoader func_195655_a(IResourceManager p_195655_0_, ShaderType p_195655_1_, String p_195655_2_) throws IOException {
        ShaderLoader shaderloader = (ShaderLoader)p_195655_1_.func_148064_d().get(p_195655_2_);
        if (shaderloader == null) {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)p_195655_2_);
            ResourceLocation resourcelocation = new ResourceLocation(rl.func_110624_b(), "shaders/program/" + rl.func_110623_a() + p_195655_1_.func_148063_b());
            IResource iresource = p_195655_0_.func_199002_a(resourcelocation);
            ByteBuffer bytebuffer = null;
            try {
                bytebuffer = TextureUtil.func_195724_a(iresource.func_199027_b());
                int i = bytebuffer.position();
                bytebuffer.rewind();
                int j = OpenGlHelper.func_153195_b(p_195655_1_.func_148065_c());
                String s = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
                OpenGlHelper.func_195918_a(j, s);
                OpenGlHelper.func_153170_c(j);
                if (OpenGlHelper.func_153157_c(j, OpenGlHelper.field_153208_p) == 0) {
                    String s1 = StringUtils.trim((String)OpenGlHelper.func_153158_d(j, 32768));
                    JsonException jsonexception = new JsonException("Couldn't compile " + p_195655_1_.func_148062_a() + " program: " + s1);
                    jsonexception.func_151381_b(resourcelocation.func_110623_a());
                    throw jsonexception;
                }
                shaderloader = new ShaderLoader(p_195655_1_, j, p_195655_2_);
                p_195655_1_.func_148064_d().put(p_195655_2_, shaderloader);
            }
            finally {
                IOUtils.closeQuietly((Closeable)iresource);
                if (bytebuffer != null) {
                    MemoryUtil.memFree((Buffer)bytebuffer);
                }
            }
        }
        return shaderloader;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ShaderType {
        VERTEX("vertex", ".vsh", OpenGlHelper.field_153209_q),
        FRAGMENT("fragment", ".fsh", OpenGlHelper.field_153210_r);

        private final String field_148072_c;
        private final String field_148069_d;
        private final int field_148070_e;
        private final Map<String, ShaderLoader> field_148067_f = Maps.newHashMap();

        private ShaderType(String shaderNameIn, String shaderExtensionIn, int shaderModeIn) {
            this.field_148072_c = shaderNameIn;
            this.field_148069_d = shaderExtensionIn;
            this.field_148070_e = shaderModeIn;
        }

        public String func_148062_a() {
            return this.field_148072_c;
        }

        private String func_148063_b() {
            return this.field_148069_d;
        }

        private int func_148065_c() {
            return this.field_148070_e;
        }

        private Map<String, ShaderLoader> func_148064_d() {
            return this.field_148067_f;
        }
    }
}

