/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.util.TriPredicate;

public class EntitySpawnPlacementRegistry {
    private static final Map<EntityType<?>, Entry> field_209347_a = Maps.newHashMap();

    private static void func_209343_a(EntityType<?> entityTypeIn, SpawnPlacementType placementType, Heightmap.Type heightMapType) {
        EntitySpawnPlacementRegistry.func_209346_a(entityTypeIn, placementType, heightMapType, null);
    }

    public static void func_209346_a(EntityType<?> p_209346_0_, SpawnPlacementType placementType, Heightmap.Type heightMapType, @Nullable Tag<Block> spawnBlockTag) {
        if (field_209347_a.containsKey(p_209346_0_)) {
            throw new IllegalArgumentException("Invalid register call, " + p_209346_0_ + " already registered.");
        }
        field_209347_a.put(p_209346_0_, new Entry(heightMapType, placementType, spawnBlockTag));
    }

    @Nullable
    public static SpawnPlacementType func_209344_a(EntityType<? extends EntityLiving> entityTypeIn) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(entityTypeIn);
        return entityspawnplacementregistry$entry == null ? null : entityspawnplacementregistry$entry.field_209340_b;
    }

    public static Heightmap.Type func_209342_b(@Nullable EntityType<? extends EntityLiving> entityTypeIn) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(entityTypeIn);
        return entityspawnplacementregistry$entry == null ? Heightmap.Type.MOTION_BLOCKING_NO_LEAVES : entityspawnplacementregistry$entry.field_209339_a;
    }

    public static boolean func_209345_a(EntityType<? extends EntityLiving> p_209345_0_, IBlockState state) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(p_209345_0_);
        if (entityspawnplacementregistry$entry == null) {
            return false;
        }
        return entityspawnplacementregistry$entry.field_209341_c != null && state.func_203425_a(entityspawnplacementregistry$entry.field_209341_c);
    }

    static {
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203780_j, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_205137_n, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_204724_o, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200761_A, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203779_Z, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203778_ae, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200749_ao, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_204262_at, SpawnPlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209346_a(EntityType.field_200781_U, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, BlockTags.field_206952_E);
        EntitySpawnPlacementRegistry.func_209346_a(EntityType.field_200783_W, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, BlockTags.field_206952_E);
        EntitySpawnPlacementRegistry.func_209346_a(EntityType.field_200786_Z, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BlockTags.field_205213_E);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200791_e, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200792_f, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200794_h, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200795_i, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200796_j, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200797_k, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200798_l, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200803_q, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200804_r, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200802_p, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200811_y, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200812_z, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200762_B, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200763_C, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200769_I, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200771_K, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200780_T, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200779_S, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200784_X, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200736_ab, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200737_ac, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200740_af, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200741_ag, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200742_ah, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200743_ai, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200745_ak, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200748_an, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200750_ap, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203099_aq, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200756_av, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200757_aw, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200759_ay, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200760_az, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200722_aA, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200724_aC, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200725_aD, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200726_aE, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200785_Y, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200727_aF, SpawnPlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
    }

    public static enum SpawnPlacementType implements IExtensibleEnum
    {
        ON_GROUND,
        IN_WATER;

        private TriPredicate<IWorldReaderBase, BlockPos, EntityType<? extends EntityLiving>> predicate;

        public static SpawnPlacementType create(String name, TriPredicate<IWorldReaderBase, BlockPos, EntityType<? extends EntityLiving>> predicate) {
            throw new IllegalStateException("Enum not extended");
        }

        private SpawnPlacementType() {
            this(null);
        }

        private SpawnPlacementType(TriPredicate<IWorldReaderBase, BlockPos, EntityType<? extends EntityLiving>> predicate) {
            this.predicate = predicate;
        }

        public boolean canSpawnAt(IWorldReaderBase world, BlockPos pos, EntityType<? extends EntityLiving> type) {
            if (this.predicate == null) {
                return WorldEntitySpawner.canSpawnAtBody(this, world, pos, type);
            }
            return this.predicate.test((Object)world, (Object)pos, type);
        }
    }

    static class Entry {
        private final Heightmap.Type field_209339_a;
        private final SpawnPlacementType field_209340_b;
        @Nullable
        private final Tag<Block> field_209341_c;

        public Entry(Heightmap.Type heightMapType, SpawnPlacementType placementTypeIn, @Nullable Tag<Block> spawnBlockTagIn) {
            this.field_209339_a = heightMapType;
            this.field_209340_b = placementTypeIn;
            this.field_209341_c = spawnBlockTagIn;
        }
    }
}

