/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityDrowned;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPhantom;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCod;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDolphin;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityPufferFish;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySalmon;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTropicalFish;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityTrident;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityType<T extends Entity>
extends ForgeRegistryEntry<EntityType<?>> {
    private static final Logger field_200731_aJ = LogManager.getLogger();
    public static final EntityType<EntityAreaEffectCloud> field_200788_b = EntityType.func_200712_a("area_effect_cloud", Builder.func_201757_a(EntityAreaEffectCloud.class, EntityAreaEffectCloud::new));
    public static final EntityType<EntityArmorStand> field_200789_c = EntityType.func_200712_a("armor_stand", Builder.func_201757_a(EntityArmorStand.class, EntityArmorStand::new));
    public static final EntityType<EntityTippedArrow> field_200790_d = EntityType.func_200712_a("arrow", Builder.func_201757_a(EntityTippedArrow.class, EntityTippedArrow::new));
    public static final EntityType<EntityBat> field_200791_e = EntityType.func_200712_a("bat", Builder.func_201757_a(EntityBat.class, EntityBat::new));
    public static final EntityType<EntityBlaze> field_200792_f = EntityType.func_200712_a("blaze", Builder.func_201757_a(EntityBlaze.class, EntityBlaze::new));
    public static final EntityType<EntityBoat> field_200793_g = EntityType.func_200712_a("boat", Builder.func_201757_a(EntityBoat.class, EntityBoat::new));
    public static final EntityType<EntityCaveSpider> field_200794_h = EntityType.func_200712_a("cave_spider", Builder.func_201757_a(EntityCaveSpider.class, EntityCaveSpider::new));
    public static final EntityType<EntityChicken> field_200795_i = EntityType.func_200712_a("chicken", Builder.func_201757_a(EntityChicken.class, EntityChicken::new));
    public static final EntityType<EntityCod> field_203780_j = EntityType.func_200712_a("cod", Builder.func_201757_a(EntityCod.class, EntityCod::new));
    public static final EntityType<EntityCow> field_200796_j = EntityType.func_200712_a("cow", Builder.func_201757_a(EntityCow.class, EntityCow::new));
    public static final EntityType<EntityCreeper> field_200797_k = EntityType.func_200712_a("creeper", Builder.func_201757_a(EntityCreeper.class, EntityCreeper::new));
    public static final EntityType<EntityDonkey> field_200798_l = EntityType.func_200712_a("donkey", Builder.func_201757_a(EntityDonkey.class, EntityDonkey::new));
    public static final EntityType<EntityDolphin> field_205137_n = EntityType.func_200712_a("dolphin", Builder.func_201757_a(EntityDolphin.class, EntityDolphin::new));
    public static final EntityType<EntityDragonFireball> field_200799_m = EntityType.func_200712_a("dragon_fireball", Builder.func_201757_a(EntityDragonFireball.class, EntityDragonFireball::new));
    public static final EntityType<EntityDrowned> field_204724_o = EntityType.func_200712_a("drowned", Builder.func_201757_a(EntityDrowned.class, EntityDrowned::new));
    public static final EntityType<EntityElderGuardian> field_200800_n = EntityType.func_200712_a("elder_guardian", Builder.func_201757_a(EntityElderGuardian.class, EntityElderGuardian::new));
    public static final EntityType<EntityEnderCrystal> field_200801_o = EntityType.func_200712_a("end_crystal", Builder.func_201757_a(EntityEnderCrystal.class, EntityEnderCrystal::new));
    public static final EntityType<EntityDragon> field_200802_p = EntityType.func_200712_a("ender_dragon", Builder.func_201757_a(EntityDragon.class, EntityDragon::new));
    public static final EntityType<EntityEnderman> field_200803_q = EntityType.func_200712_a("enderman", Builder.func_201757_a(EntityEnderman.class, EntityEnderman::new));
    public static final EntityType<EntityEndermite> field_200804_r = EntityType.func_200712_a("endermite", Builder.func_201757_a(EntityEndermite.class, EntityEndermite::new));
    public static final EntityType<EntityEvokerFangs> field_200805_s = EntityType.func_200712_a("evoker_fangs", Builder.func_201757_a(EntityEvokerFangs.class, EntityEvokerFangs::new));
    public static final EntityType<EntityEvoker> field_200806_t = EntityType.func_200712_a("evoker", Builder.func_201757_a(EntityEvoker.class, EntityEvoker::new));
    public static final EntityType<EntityXPOrb> field_200807_u = EntityType.func_200712_a("experience_orb", Builder.func_201757_a(EntityXPOrb.class, EntityXPOrb::new));
    public static final EntityType<EntityEnderEye> field_200808_v = EntityType.func_200712_a("eye_of_ender", Builder.func_201757_a(EntityEnderEye.class, EntityEnderEye::new));
    public static final EntityType<EntityFallingBlock> field_200809_w = EntityType.func_200712_a("falling_block", Builder.func_201757_a(EntityFallingBlock.class, EntityFallingBlock::new));
    public static final EntityType<EntityFireworkRocket> field_200810_x = EntityType.func_200712_a("firework_rocket", Builder.func_201757_a(EntityFireworkRocket.class, EntityFireworkRocket::new));
    public static final EntityType<EntityGhast> field_200811_y = EntityType.func_200712_a("ghast", Builder.func_201757_a(EntityGhast.class, EntityGhast::new));
    public static final EntityType<EntityGiantZombie> field_200812_z = EntityType.func_200712_a("giant", Builder.func_201757_a(EntityGiantZombie.class, EntityGiantZombie::new));
    public static final EntityType<EntityGuardian> field_200761_A = EntityType.func_200712_a("guardian", Builder.func_201757_a(EntityGuardian.class, EntityGuardian::new));
    public static final EntityType<EntityHorse> field_200762_B = EntityType.func_200712_a("horse", Builder.func_201757_a(EntityHorse.class, EntityHorse::new));
    public static final EntityType<EntityHusk> field_200763_C = EntityType.func_200712_a("husk", Builder.func_201757_a(EntityHusk.class, EntityHusk::new));
    public static final EntityType<EntityIllusionIllager> field_200764_D = EntityType.func_200712_a("illusioner", Builder.func_201757_a(EntityIllusionIllager.class, EntityIllusionIllager::new));
    public static final EntityType<EntityItem> field_200765_E = EntityType.func_200712_a("item", Builder.func_201757_a(EntityItem.class, EntityItem::new));
    public static final EntityType<EntityItemFrame> field_200766_F = EntityType.func_200712_a("item_frame", Builder.func_201757_a(EntityItemFrame.class, EntityItemFrame::new));
    public static final EntityType<EntityLargeFireball> field_200767_G = EntityType.func_200712_a("fireball", Builder.func_201757_a(EntityLargeFireball.class, EntityLargeFireball::new));
    public static final EntityType<EntityLeashKnot> field_200768_H = EntityType.func_200712_a("leash_knot", Builder.func_201757_a(EntityLeashKnot.class, EntityLeashKnot::new).func_200706_c());
    public static final EntityType<EntityLlama> field_200769_I = EntityType.func_200712_a("llama", Builder.func_201757_a(EntityLlama.class, EntityLlama::new));
    public static final EntityType<EntityLlamaSpit> field_200770_J = EntityType.func_200712_a("llama_spit", Builder.func_201757_a(EntityLlamaSpit.class, EntityLlamaSpit::new));
    public static final EntityType<EntityMagmaCube> field_200771_K = EntityType.func_200712_a("magma_cube", Builder.func_201757_a(EntityMagmaCube.class, EntityMagmaCube::new));
    public static final EntityType<EntityMinecartEmpty> field_200772_L = EntityType.func_200712_a("minecart", Builder.func_201757_a(EntityMinecartEmpty.class, EntityMinecartEmpty::new));
    public static final EntityType<EntityMinecartChest> field_200773_M = EntityType.func_200712_a("chest_minecart", Builder.func_201757_a(EntityMinecartChest.class, EntityMinecartChest::new));
    public static final EntityType<EntityMinecartCommandBlock> field_200774_N = EntityType.func_200712_a("command_block_minecart", Builder.func_201757_a(EntityMinecartCommandBlock.class, EntityMinecartCommandBlock::new));
    public static final EntityType<EntityMinecartFurnace> field_200775_O = EntityType.func_200712_a("furnace_minecart", Builder.func_201757_a(EntityMinecartFurnace.class, EntityMinecartFurnace::new));
    public static final EntityType<EntityMinecartHopper> field_200776_P = EntityType.func_200712_a("hopper_minecart", Builder.func_201757_a(EntityMinecartHopper.class, EntityMinecartHopper::new));
    public static final EntityType<EntityMinecartMobSpawner> field_200777_Q = EntityType.func_200712_a("spawner_minecart", Builder.func_201757_a(EntityMinecartMobSpawner.class, EntityMinecartMobSpawner::new));
    public static final EntityType<EntityMinecartTNT> field_200778_R = EntityType.func_200712_a("tnt_minecart", Builder.func_201757_a(EntityMinecartTNT.class, EntityMinecartTNT::new));
    public static final EntityType<EntityMule> field_200779_S = EntityType.func_200712_a("mule", Builder.func_201757_a(EntityMule.class, EntityMule::new));
    public static final EntityType<EntityMooshroom> field_200780_T = EntityType.func_200712_a("mooshroom", Builder.func_201757_a(EntityMooshroom.class, EntityMooshroom::new));
    public static final EntityType<EntityOcelot> field_200781_U = EntityType.func_200712_a("ocelot", Builder.func_201757_a(EntityOcelot.class, EntityOcelot::new));
    public static final EntityType<EntityPainting> field_200782_V = EntityType.func_200712_a("painting", Builder.func_201757_a(EntityPainting.class, EntityPainting::new));
    public static final EntityType<EntityParrot> field_200783_W = EntityType.func_200712_a("parrot", Builder.func_201757_a(EntityParrot.class, EntityParrot::new));
    public static final EntityType<EntityPig> field_200784_X = EntityType.func_200712_a("pig", Builder.func_201757_a(EntityPig.class, EntityPig::new));
    public static final EntityType<EntityPufferFish> field_203779_Z = EntityType.func_200712_a("pufferfish", Builder.func_201757_a(EntityPufferFish.class, EntityPufferFish::new));
    public static final EntityType<EntityPigZombie> field_200785_Y = EntityType.func_200712_a("zombie_pigman", Builder.func_201757_a(EntityPigZombie.class, EntityPigZombie::new));
    public static final EntityType<EntityPolarBear> field_200786_Z = EntityType.func_200712_a("polar_bear", Builder.func_201757_a(EntityPolarBear.class, EntityPolarBear::new));
    public static final EntityType<EntityTNTPrimed> field_200735_aa = EntityType.func_200712_a("tnt", Builder.func_201757_a(EntityTNTPrimed.class, EntityTNTPrimed::new));
    public static final EntityType<EntityRabbit> field_200736_ab = EntityType.func_200712_a("rabbit", Builder.func_201757_a(EntityRabbit.class, EntityRabbit::new));
    public static final EntityType<EntitySalmon> field_203778_ae = EntityType.func_200712_a("salmon", Builder.func_201757_a(EntitySalmon.class, EntitySalmon::new));
    public static final EntityType<EntitySheep> field_200737_ac = EntityType.func_200712_a("sheep", Builder.func_201757_a(EntitySheep.class, EntitySheep::new));
    public static final EntityType<EntityShulker> field_200738_ad = EntityType.func_200712_a("shulker", Builder.func_201757_a(EntityShulker.class, EntityShulker::new));
    public static final EntityType<EntityShulkerBullet> field_200739_ae = EntityType.func_200712_a("shulker_bullet", Builder.func_201757_a(EntityShulkerBullet.class, EntityShulkerBullet::new));
    public static final EntityType<EntitySilverfish> field_200740_af = EntityType.func_200712_a("silverfish", Builder.func_201757_a(EntitySilverfish.class, EntitySilverfish::new));
    public static final EntityType<EntitySkeleton> field_200741_ag = EntityType.func_200712_a("skeleton", Builder.func_201757_a(EntitySkeleton.class, EntitySkeleton::new));
    public static final EntityType<EntitySkeletonHorse> field_200742_ah = EntityType.func_200712_a("skeleton_horse", Builder.func_201757_a(EntitySkeletonHorse.class, EntitySkeletonHorse::new));
    public static final EntityType<EntitySlime> field_200743_ai = EntityType.func_200712_a("slime", Builder.func_201757_a(EntitySlime.class, EntitySlime::new));
    public static final EntityType<EntitySmallFireball> field_200744_aj = EntityType.func_200712_a("small_fireball", Builder.func_201757_a(EntitySmallFireball.class, EntitySmallFireball::new));
    public static final EntityType<EntitySnowman> field_200745_ak = EntityType.func_200712_a("snow_golem", Builder.func_201757_a(EntitySnowman.class, EntitySnowman::new));
    public static final EntityType<EntitySnowball> field_200746_al = EntityType.func_200712_a("snowball", Builder.func_201757_a(EntitySnowball.class, EntitySnowball::new));
    public static final EntityType<EntitySpectralArrow> field_200747_am = EntityType.func_200712_a("spectral_arrow", Builder.func_201757_a(EntitySpectralArrow.class, EntitySpectralArrow::new));
    public static final EntityType<EntitySpider> field_200748_an = EntityType.func_200712_a("spider", Builder.func_201757_a(EntitySpider.class, EntitySpider::new));
    public static final EntityType<EntitySquid> field_200749_ao = EntityType.func_200712_a("squid", Builder.func_201757_a(EntitySquid.class, EntitySquid::new));
    public static final EntityType<EntityStray> field_200750_ap = EntityType.func_200712_a("stray", Builder.func_201757_a(EntityStray.class, EntityStray::new));
    public static final EntityType<EntityTropicalFish> field_204262_at = EntityType.func_200712_a("tropical_fish", Builder.func_201757_a(EntityTropicalFish.class, EntityTropicalFish::new));
    public static final EntityType<EntityTurtle> field_203099_aq = EntityType.func_200712_a("turtle", Builder.func_201757_a(EntityTurtle.class, EntityTurtle::new));
    public static final EntityType<EntityEgg> field_200751_aq = EntityType.func_200712_a("egg", Builder.func_201757_a(EntityEgg.class, EntityEgg::new));
    public static final EntityType<EntityEnderPearl> field_200752_ar = EntityType.func_200712_a("ender_pearl", Builder.func_201757_a(EntityEnderPearl.class, EntityEnderPearl::new));
    public static final EntityType<EntityExpBottle> field_200753_as = EntityType.func_200712_a("experience_bottle", Builder.func_201757_a(EntityExpBottle.class, EntityExpBottle::new));
    public static final EntityType<EntityPotion> field_200754_at = EntityType.func_200712_a("potion", Builder.func_201757_a(EntityPotion.class, EntityPotion::new));
    public static final EntityType<EntityVex> field_200755_au = EntityType.func_200712_a("vex", Builder.func_201757_a(EntityVex.class, EntityVex::new));
    public static final EntityType<EntityVillager> field_200756_av = EntityType.func_200712_a("villager", Builder.func_201757_a(EntityVillager.class, EntityVillager::new));
    public static final EntityType<EntityIronGolem> field_200757_aw = EntityType.func_200712_a("iron_golem", Builder.func_201757_a(EntityIronGolem.class, EntityIronGolem::new));
    public static final EntityType<EntityVindicator> field_200758_ax = EntityType.func_200712_a("vindicator", Builder.func_201757_a(EntityVindicator.class, EntityVindicator::new));
    public static final EntityType<EntityWitch> field_200759_ay = EntityType.func_200712_a("witch", Builder.func_201757_a(EntityWitch.class, EntityWitch::new));
    public static final EntityType<EntityWither> field_200760_az = EntityType.func_200712_a("wither", Builder.func_201757_a(EntityWither.class, EntityWither::new));
    public static final EntityType<EntityWitherSkeleton> field_200722_aA = EntityType.func_200712_a("wither_skeleton", Builder.func_201757_a(EntityWitherSkeleton.class, EntityWitherSkeleton::new));
    public static final EntityType<EntityWitherSkull> field_200723_aB = EntityType.func_200712_a("wither_skull", Builder.func_201757_a(EntityWitherSkull.class, EntityWitherSkull::new));
    public static final EntityType<EntityWolf> field_200724_aC = EntityType.func_200712_a("wolf", Builder.func_201757_a(EntityWolf.class, EntityWolf::new));
    public static final EntityType<EntityZombie> field_200725_aD = EntityType.func_200712_a("zombie", Builder.func_201757_a(EntityZombie.class, EntityZombie::new));
    public static final EntityType<EntityZombieHorse> field_200726_aE = EntityType.func_200712_a("zombie_horse", Builder.func_201757_a(EntityZombieHorse.class, EntityZombieHorse::new));
    public static final EntityType<EntityZombieVillager> field_200727_aF = EntityType.func_200712_a("zombie_villager", Builder.func_201757_a(EntityZombieVillager.class, EntityZombieVillager::new));
    public static final EntityType<EntityPhantom> field_203097_aH = EntityType.func_200712_a("phantom", Builder.func_201757_a(EntityPhantom.class, EntityPhantom::new));
    public static final EntityType<EntityLightningBolt> field_200728_aG = EntityType.func_200712_a("lightning_bolt", Builder.func_201758_a(EntityLightningBolt.class).func_200706_c());
    public static final EntityType<EntityPlayer> field_200729_aH = EntityType.func_200712_a("player", Builder.func_201758_a(EntityPlayer.class).func_200706_c().func_200705_b());
    public static final EntityType<EntityFishHook> field_200730_aI = EntityType.func_200712_a("fishing_bobber", Builder.func_201758_a(EntityFishHook.class).func_200706_c().func_200705_b());
    public static final EntityType<EntityTrident> field_203098_aL = EntityType.func_200712_a("trident", Builder.func_201757_a(EntityTrident.class, EntityTrident::new));
    private final Class<? extends T> field_201761_aK;
    private final Function<? super World, ? extends T> field_200732_aK;
    private final boolean field_200733_aL;
    private final boolean field_200734_aM;
    @Nullable
    private String field_210762_aX;
    @Nullable
    private ITextComponent field_212547_aX;
    @Nullable
    private final Type<?> field_206832_aX;
    private boolean useVanillaSpawning;
    private Function<FMLPlayMessages.SpawnEntity, Entity> customSpawnCallback;
    private boolean hasCustomTracking;
    private int customTrackingRange;
    private int customUpdateFrequency;
    private boolean customSendVelocityUpdates;

    public static <T extends Entity> EntityType<T> func_200712_a(String id, Builder<T> builder) {
        EntityType<T> entitytype = builder.func_206830_a(id);
        IRegistry.field_212629_r.func_82595_a(new ResourceLocation(id), entitytype);
        return entitytype;
    }

    @Nullable
    public static ResourceLocation func_200718_a(EntityType<?> entityTypeIn) {
        return IRegistry.field_212629_r.func_177774_c(entityTypeIn);
    }

    @Nullable
    public static EntityType<?> func_200713_a(String id) {
        return IRegistry.field_212629_r.func_212608_b(ResourceLocation.func_208304_a((String)id));
    }

    public EntityType(Class<? extends T> entityClassIn, Function<? super World, ? extends T> factoryIn, boolean p_i49579_3_, boolean p_i49579_4_, @Nullable Type<?> p_i49579_5_) {
        this.field_201761_aK = entityClassIn;
        this.field_200732_aK = factoryIn;
        this.field_200733_aL = p_i49579_3_;
        this.field_200734_aM = p_i49579_4_;
        this.field_206832_aX = p_i49579_5_;
    }

    @Nullable
    public Entity func_208049_a(World worldIn, @Nullable ItemStack itemIn, @Nullable EntityPlayer player, BlockPos pos, boolean p_208049_5_, boolean p_208049_6_) {
        return this.func_208050_a(worldIn, itemIn == null ? null : itemIn.func_77978_p(), itemIn != null && itemIn.func_82837_s() ? itemIn.func_200301_q() : null, player, pos, p_208049_5_, p_208049_6_);
    }

    @Nullable
    public T func_208050_a(World worldIn, @Nullable NBTTagCompound nbt, @Nullable ITextComponent livingEntityCustomName, @Nullable EntityPlayer p_208050_4_, BlockPos p_208050_5_, boolean p_208050_6_, boolean p_208050_7_) {
        T t = this.func_210761_b(worldIn, nbt, livingEntityCustomName, p_208050_4_, p_208050_5_, p_208050_6_, p_208050_7_);
        if (t instanceof EntityLiving && ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)((Object)t)), (World)worldIn, (float)p_208050_5_.func_177958_n(), (float)p_208050_5_.func_177956_o(), (float)p_208050_5_.func_177952_p(), null)) {
            return null;
        }
        worldIn.func_72838_d((Entity)((Object)t));
        return t;
    }

    @Nullable
    public T func_210761_b(World worldIn, @Nullable NBTTagCompound nbt, @Nullable ITextComponent livingEntityCustomName, @Nullable EntityPlayer p_210761_4_, BlockPos pos, boolean p_210761_6_, boolean p_210761_7_) {
        double d0;
        T t = this.func_200721_a(worldIn);
        if (t == null) {
            return (T)((Object)((Entity)null));
        }
        if (p_210761_6_) {
            ((Entity)((Object)t)).func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            d0 = EntityType.func_208051_a(worldIn, pos, p_210761_7_, ((Entity)((Object)t)).func_174813_aQ());
        } else {
            d0 = 0.0;
        }
        ((Entity)((Object)t)).func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        if (t instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)((Object)t);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_204210_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), null, nbt);
            entityliving.func_70642_aH();
        }
        if (livingEntityCustomName != null && t instanceof EntityLivingBase) {
            ((Entity)((Object)t)).func_200203_b(livingEntityCustomName);
        }
        EntityType.func_208048_a(worldIn, p_210761_4_, t, nbt);
        return t;
    }

    protected static double func_208051_a(IWorldReaderBase p_208051_0_, BlockPos p_208051_1_, boolean p_208051_2_, AxisAlignedBB p_208051_3_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_208051_1_);
        if (p_208051_2_) {
            axisalignedbb = axisalignedbb.func_72321_a(0.0, -1.0, 0.0);
        }
        Stream stream = p_208051_0_.func_212388_b((Entity)null, axisalignedbb);
        return 1.0 + VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)p_208051_3_, (Stream)stream, (double)(p_208051_2_ ? -2.0 : -1.0));
    }

    public static void func_208048_a(World p_208048_0_, @Nullable EntityPlayer p_208048_1_, @Nullable Entity p_208048_2_, @Nullable NBTTagCompound p_208048_3_) {
        MinecraftServer minecraftserver;
        if (p_208048_3_ != null && p_208048_3_.func_150297_b("EntityTag", 10) && (minecraftserver = p_208048_0_.func_73046_m()) != null && p_208048_2_ != null && (p_208048_0_.field_72995_K || !p_208048_2_.func_184213_bq() || p_208048_1_ != null && minecraftserver.func_184103_al().func_152596_g(p_208048_1_.func_146103_bH()))) {
            NBTTagCompound nbttagcompound = p_208048_2_.func_189511_e(new NBTTagCompound());
            UUID uuid = p_208048_2_.func_110124_au();
            nbttagcompound.func_197643_a(p_208048_3_.func_74775_l("EntityTag"));
            p_208048_2_.func_184221_a(uuid);
            p_208048_2_.func_70020_e(nbttagcompound);
        }
    }

    public boolean func_200715_a() {
        return this.field_200733_aL;
    }

    public boolean func_200720_b() {
        return this.field_200734_aM;
    }

    public Class<? extends T> func_201760_c() {
        return this.field_201761_aK;
    }

    public String func_210760_d() {
        if (this.field_210762_aX == null) {
            this.field_210762_aX = Util.func_200697_a((String)"entity", (ResourceLocation)IRegistry.field_212629_r.func_177774_c(this));
        }
        return this.field_210762_aX;
    }

    public ITextComponent func_212546_e() {
        if (this.field_212547_aX == null) {
            this.field_212547_aX = new TextComponentTranslation(this.func_210760_d(), new Object[0]);
        }
        return this.field_212547_aX;
    }

    @Nullable
    public T func_200721_a(World worldIn) {
        return (T)((Object)((Entity)((Object)this.field_200732_aK.apply(worldIn))));
    }

    @Nullable
    public static Entity func_200714_a(World worldIn, ResourceLocation id) {
        return EntityType.func_200719_a(worldIn, IRegistry.field_212629_r.func_212608_b(id));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Entity func_200717_a(int id, World worldIn) {
        return EntityType.func_200719_a(worldIn, IRegistry.field_212629_r.func_148754_a(id));
    }

    @Nullable
    public static Entity func_200716_a(NBTTagCompound p_200716_0_, World p_200716_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_200716_0_.func_74779_i("id"));
        Entity entity = EntityType.func_200714_a(p_200716_1_, resourcelocation);
        if (entity == null) {
            field_200731_aJ.warn("Skipping Entity with id {}", (Object)resourcelocation);
        } else {
            entity.func_70020_e(p_200716_0_);
        }
        return entity;
    }

    @Nullable
    private static Entity func_200719_a(World worldIn, @Nullable EntityType<?> type) {
        return type == null ? null : (Entity)((Object)type.func_200721_a(worldIn));
    }

    public boolean hasCustomTracking() {
        return this.hasCustomTracking;
    }

    public int getTrackingRange() {
        return this.customTrackingRange;
    }

    public int getUpdateFrequency() {
        return this.customUpdateFrequency;
    }

    public boolean shouldSendVelocityUpdates() {
        return this.customSendVelocityUpdates;
    }

    public boolean usesVanillaSpawning() {
        return this.useVanillaSpawning;
    }

    public EntityType(Class<? extends T> clazz, Function<? super World, ? extends T> factory, boolean serializable, boolean summonable, @Nullable Type<?> dataFixerType, boolean useVanillaSpawning, Function<FMLPlayMessages.SpawnEntity, Entity> customSpawnCallback, boolean hasCustomTracking, int range, int updateFreq, boolean sendVelocityUpdates) {
        this(clazz, factory, serializable, summonable, dataFixerType);
        this.useVanillaSpawning = useVanillaSpawning;
        this.customSpawnCallback = customSpawnCallback;
        this.hasCustomTracking = hasCustomTracking;
        this.customTrackingRange = range;
        this.customUpdateFrequency = updateFreq;
        this.customSendVelocityUpdates = sendVelocityUpdates;
    }

    @Nullable
    public Entity handleSpawnMessage(World world, FMLPlayMessages.SpawnEntity msg) {
        return this.customSpawnCallback == null ? this.func_200721_a(world) : this.customSpawnCallback.apply(msg);
    }

    public static class Builder<T extends Entity> {
        private final Class<? extends T> field_201759_a;
        private final Function<? super World, ? extends T> field_200709_a;
        private boolean field_200710_b = true;
        private boolean field_200711_c = true;
        private boolean useVanillaSpawning;
        private Function<FMLPlayMessages.SpawnEntity, Entity> customSpawnCallback = null;
        private boolean hasCustomTracking = false;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendVelocityUpdates;

        private Builder(Class<? extends T> entityClassIn, Function<? super World, ? extends T> factoryIn) {
            this.field_201759_a = entityClassIn;
            this.field_200709_a = factoryIn;
            this.useVanillaSpawning = this.field_201759_a.getName().startsWith("net.minecraft.");
        }

        public static <T extends Entity> Builder<T> func_201757_a(Class<? extends T> entityClassIn, Function<? super World, ? extends T> factoryIn) {
            return new Builder<T>(entityClassIn, factoryIn);
        }

        public static <T extends Entity> Builder<T> func_201758_a(Class<? extends T> entityClassIn) {
            return new Builder<Entity>(entityClassIn, p_200708_0_ -> null);
        }

        public Builder<T> func_200705_b() {
            this.field_200711_c = false;
            return this;
        }

        public Builder<T> func_200706_c() {
            this.field_200710_b = false;
            return this;
        }

        public Builder<T> customSpawning(Function<FMLPlayMessages.SpawnEntity, Entity> cb, boolean useVanillaSpawning) {
            this.customSpawnCallback = cb;
            this.useVanillaSpawning = useVanillaSpawning;
            return this;
        }

        public final Builder<T> tracker(int range, int updateFrequency, boolean sendVelocityUpdates) {
            this.hasCustomTracking = true;
            this.trackingRange = range;
            this.updateFrequency = updateFrequency;
            this.sendVelocityUpdates = sendVelocityUpdates;
            return this;
        }

        public EntityType<T> func_206830_a(String id) {
            Type type = null;
            if (this.field_200710_b) {
                try {
                    type = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)1631)).getChoiceType(TypeReferences.field_211298_n, id);
                }
                catch (IllegalArgumentException illegalstateexception) {
                    if (SharedConstants.field_206244_b) {
                        throw illegalstateexception;
                    }
                    field_200731_aJ.warn("No data fixer registered for entity {}", (Object)id);
                }
            }
            return new EntityType<T>(this.field_201759_a, this.field_200709_a, this.field_200710_b, this.field_200711_c, type, this.useVanillaSpawning, this.customSpawnCallback, this.hasCustomTracking, this.trackingRange, this.updateFrequency, this.sendVelocityUpdates);
        }
    }
}

