/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityWither
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> field_184741_a = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184742_b = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184743_c = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private static final List<DataParameter<Integer>> field_184745_bv = ImmutableList.of(field_184741_a, field_184742_b, field_184743_c);
    private static final DataParameter<Integer> field_184746_bw = EntityDataManager.func_187226_a(EntityWither.class, DataSerializers.field_187192_b);
    private final float[] field_82220_d = new float[2];
    private final float[] field_82221_e = new float[2];
    private final float[] field_82217_f = new float[2];
    private final float[] field_82218_g = new float[2];
    private final int[] field_82223_h = new int[2];
    private final int[] field_82224_i = new int[2];
    private int field_82222_j;
    private final BossInfoServer field_184744_bE = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<Entity> field_82219_bJ = p_210135_0_ -> p_210135_0_ instanceof EntityLivingBase && ((EntityLivingBase)((Object)p_210135_0_)).func_70668_bt() != CreatureAttribute.UNDEAD && ((EntityLivingBase)((Object)p_210135_0_)).func_190631_cK();

    public EntityWither(World worldIn) {
        super(EntityType.field_200760_az, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_212239_d(true);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, field_82219_bJ));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184741_a, 0);
        this.field_70180_af.func_187214_a(field_184742_b, 0);
        this.field_70180_af.func_187214_a(field_184743_c, 0);
        this.field_70180_af.func_187214_a(field_184746_bw, 0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.func_82212_n());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_82215_s(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.field_184744_bE.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.field_184744_bE.func_186739_a(this.func_145748_c_());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187925_gy;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public void func_70636_d() {
        Entity entity;
        this.field_70181_x *= (double)0.6f;
        if (!this.field_70170_p.field_72995_K && this.func_82203_t(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.func_82203_t(0))) != null) {
            double d1;
            double d0;
            double d3;
            if (this.field_70163_u < entity.field_70163_u || !this.func_82205_o() && this.field_70163_u < entity.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * (double)0.6f;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * (double)0.6f;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (int i = 0; i < 2; ++i) {
            this.field_82218_g[i] = this.field_82221_e[i];
            this.field_82217_f[i] = this.field_82220_d[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.func_82203_t(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.field_70170_p.func_73045_a(k);
            }
            if (entity1 != null) {
                double d11 = this.func_82214_u(j + 1);
                double d12 = this.func_82208_v(j + 1);
                double d13 = this.func_82213_w(j + 1);
                double d6 = entity1.field_70165_t - d11;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d12;
                double d8 = entity1.field_70161_v - d13;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(MathHelper.func_181159_b((double)d8, (double)d6) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d7, (double)d9) * 57.2957763671875));
                this.field_82220_d[j] = this.func_82204_b(this.field_82220_d[j], f1, 40.0f);
                this.field_82221_e[j] = this.func_82204_b(this.field_82221_e[j], f, 10.0f);
                continue;
            }
            this.field_82221_e[j] = this.func_82204_b(this.field_82221_e[j], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.func_82205_o();
        for (int l = 0; l < 3; ++l) {
            double d10 = this.func_82214_u(l);
            double d2 = this.func_82208_v(l);
            double d4 = this.func_82213_w(l);
            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197601_L, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197625_r, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.func_82212_n() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197625_r, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.func_82212_n() > 0) {
            int j1 = this.func_82212_n() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_72885_a((Entity)((Object)this), this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this)));
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)((Object)this)), 0);
            }
            this.func_82215_s(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
        } else {
            super.func_70619_bc();
            block0: for (int i = 1; i < 3; ++i) {
                int k1;
                if (this.field_70173_aa < this.field_82223_h[i - 1]) continue;
                this.field_82223_h[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int j3 = i - 1;
                    int k3 = this.field_82224_i[i - 1];
                    this.field_82224_i[j3] = this.field_82224_i[i - 1] + 1;
                    if (k3 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - 10.0), (double)(this.field_70165_t + 10.0));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - 5.0), (double)(this.field_70163_u + 5.0));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - 10.0), (double)(this.field_70161_v + 10.0));
                        this.func_82209_a(i + 1, d0, d1, d2, true);
                        this.field_82224_i[i - 1] = 0;
                    }
                }
                if ((k1 = this.func_82203_t(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(k1);
                    if (entity != null && entity.func_70089_S() && !(this.func_70068_e(entity) > 900.0) && this.func_70685_l(entity)) {
                        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
                            this.func_82211_c(i, 0);
                            continue;
                        }
                        this.func_82216_a(i + 1, (EntityLivingBase)entity);
                        this.field_82223_h[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.field_82224_i[i - 1] = 0;
                        continue;
                    }
                    this.func_82211_c(i, 0);
                    continue;
                }
                List<Entity> list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), field_82219_bJ.and(EntitySelectors.field_180132_d));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l(entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block0;
                            this.func_82211_c(i, entitylivingbase.func_145782_y());
                            continue block0;
                        }
                        this.func_82211_c(i, entitylivingbase.func_145782_y());
                        continue block0;
                    }
                    list.remove((Object)entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.func_82211_c(0, this.func_70638_az().func_145782_y());
            } else {
                this.func_82211_c(0, 0);
            }
            if (this.field_82222_j > 0) {
                --this.field_82222_j;
                if (this.field_82222_j == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)((Object)this))) {
                    int i1 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockReader)this.field_70170_p, blockpos, (Entity)((Object)this)) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)((Object)this), (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a(null, 1022, new BlockPos((Entity)((Object)this)), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            this.field_184744_bE.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public static boolean func_181033_a(Block blockIn) {
        return blockIn != Blocks.field_150357_h && blockIn != Blocks.field_150384_bq && blockIn != Blocks.field_150378_br && blockIn != Blocks.field_150483_bI && blockIn != Blocks.field_185776_dc && blockIn != Blocks.field_185777_dd && blockIn != Blocks.field_180401_cv && blockIn != Blocks.field_185779_df && blockIn != Blocks.field_189881_dj && blockIn != Blocks.field_196603_bb && blockIn != Blocks.field_185775_db;
    }

    public void func_82206_m() {
        this.func_82215_s(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.field_184744_bE.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.field_184744_bE.func_186761_b(player);
    }

    private double func_82214_u(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double func_82208_v(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double func_82213_w(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float func_82204_b(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    private void func_82216_a(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.func_82209_a(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void func_82209_a(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)((Object)this)), 0);
        double d0 = this.func_82214_u(p_82209_1_);
        double d1 = this.func_82208_v(p_82209_1_);
        double d2 = this.func_82213_w(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)((Object)this), d3, d4, d5);
        if (invulnerable) {
            entitywitherskull.func_82343_e(true);
        }
        entitywitherskull.field_70163_u = d1;
        entitywitherskull.field_70165_t = d0;
        entitywitherskull.field_70161_v = d2;
        this.field_70170_p.func_72838_d(entitywitherskull);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.func_82216_a(0, target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityWither)) {
            Entity entity;
            if (this.func_82212_n() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.func_82205_o() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            Entity entity1 = source.func_76346_g();
            if (entity1 != null && !(entity1 instanceof EntityPlayer) && entity1 instanceof EntityLivingBase && ((EntityLivingBase)entity1).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.field_82222_j <= 0) {
                this.field_82222_j = 20;
            }
            int i = 0;
            while (i < this.field_82224_i.length) {
                int n = i++;
                this.field_82224_i[n] = this.field_82224_i[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        EntityItem entityitem = this.func_199703_a(Items.field_151156_bN);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_195064_c(PotionEffect p_195064_1_) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_82207_a(int p_82207_1_) {
        return this.field_82221_e[p_82207_1_];
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_82210_r(int p_82210_1_) {
        return this.field_82220_d[p_82210_1_];
    }

    public int func_82212_n() {
        return this.field_70180_af.func_187225_a(field_184746_bw);
    }

    public void func_82215_s(int time) {
        this.field_70180_af.func_187227_b(field_184746_bw, time);
    }

    public int func_82203_t(int head) {
        return this.field_70180_af.func_187225_a(field_184745_bv.get(head));
    }

    public void func_82211_c(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(field_184745_bv.get(targetOffset), newId);
    }

    public boolean func_82205_o() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityWither.this.func_82212_n() > 0;
        }
    }
}

