/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class EntityItem
extends Entity {
    private static final DataParameter<ItemStack> field_184533_c = EntityDataManager.func_187226_a(EntityItem.class, DataSerializers.field_187196_f);
    private int field_70292_b;
    private int field_145804_b;
    private int field_70291_e = 5;
    private UUID field_145801_f;
    private UUID field_145802_g;
    public int lifespan = 6000;
    public float field_70290_d = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World worldIn) {
        super(EntityType.field_200765_E, worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityItem(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.field_70181_x = 0.2f;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    public EntityItem(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.func_92058_a(stack);
        this.lifespan = stack.func_77973_b() == null ? 6000 : stack.getEntityLifespan(worldIn);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184533_c, ItemStack.field_190927_a);
    }

    @Override
    public void func_70071_h_() {
        if (this.func_92059_d().onEntityItemUpdate(this)) {
            return;
        }
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        } else {
            double d5;
            double d4;
            double d3;
            double d6;
            boolean flag;
            super.func_70071_h_();
            if (this.field_145804_b > 0 && this.field_145804_b != Short.MAX_VALUE) {
                --this.field_145804_b;
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            double d0 = this.field_70159_w;
            double d1 = this.field_70181_x;
            double d2 = this.field_70179_y;
            if (this.func_208600_a(FluidTags.field_206959_a)) {
                this.func_203043_v();
            } else if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.field_70145_X = this.field_70170_p.field_72995_K ? false : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
            if (flag || this.field_70173_aa % 25 == 0) {
                if (this.field_70170_p.func_204610_c(new BlockPos((Entity)this)).func_206884_a(FluidTags.field_206960_b)) {
                    this.field_70181_x = 0.2f;
                    this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_85054_d();
                }
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                f = this.field_70170_p.func_180495_p(pos).getSlipperiness(this.field_70170_p, pos, this) * 0.98f;
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            if (this.field_70122_E) {
                this.field_70181_x *= -0.5;
            }
            if (this.field_70292_b != Short.MIN_VALUE) {
                ++this.field_70292_b;
            }
            this.field_70160_al |= this.func_70072_I();
            if (!this.field_70170_p.field_72995_K && (d6 = (d3 = this.field_70159_w - d0) * d3 + (d4 = this.field_70181_x - d1) * d4 + (d5 = this.field_70179_y - d2) * d5) > 0.01) {
                this.field_70160_al = true;
            }
            ItemStack item = this.func_92059_d();
            if (!this.field_70170_p.field_72995_K && this.field_70292_b >= this.lifespan) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)this, (ItemStack)item);
                if (hook < 0) {
                    this.func_70106_y();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item.func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    private void func_203043_v() {
        if (this.field_70181_x < (double)0.06f) {
            this.field_70181_x += (double)5.0E-4f;
        }
        this.field_70159_w *= (double)0.99f;
        this.field_70179_y *= (double)0.99f;
    }

    private void func_85054_d() {
        for (EntityItem entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5))) {
            this.func_70289_a(entityitem);
        }
    }

    private boolean func_70289_a(EntityItem other) {
        if (other == this) {
            return false;
        }
        if (other.func_70089_S() && this.func_70089_S()) {
            ItemStack itemstack = this.func_92059_d();
            ItemStack itemstack1 = other.func_92059_d().func_77946_l();
            if (this.field_145804_b != Short.MAX_VALUE && other.field_145804_b != Short.MAX_VALUE) {
                if (this.field_70292_b != Short.MIN_VALUE && other.field_70292_b != Short.MIN_VALUE) {
                    if (itemstack1.func_77973_b() != itemstack.func_77973_b()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() ^ itemstack.func_77942_o()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() && !itemstack1.func_77978_p().equals(itemstack.func_77978_p())) {
                        return false;
                    }
                    if (itemstack1.func_77973_b() == null) {
                        return false;
                    }
                    if (itemstack1.func_190916_E() < itemstack.func_190916_E()) {
                        return other.func_70289_a(this);
                    }
                    if (itemstack1.func_190916_E() + itemstack.func_190916_E() > itemstack1.func_77976_d()) {
                        return false;
                    }
                    if (!itemstack.areCapsCompatible(itemstack1)) {
                        return false;
                    }
                    itemstack1.func_190917_f(itemstack.func_190916_E());
                    other.field_145804_b = Math.max(other.field_145804_b, this.field_145804_b);
                    other.field_70292_b = Math.min(other.field_70292_b, this.field_70292_b);
                    other.func_92058_a(itemstack1);
                    this.func_70106_y();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void func_70288_d() {
        this.field_70292_b = 4800;
    }

    @Override
    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.func_92059_d().func_190926_b() && this.func_92059_d().func_77973_b() == Items.field_151156_bN && source.func_94541_c()) {
            return false;
        }
        this.func_70018_K();
        this.field_70291_e = (int)((float)this.field_70291_e - amount);
        if (this.field_70291_e <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.field_70291_e);
        compound.func_74777_a("Age", (short)this.field_70292_b);
        compound.func_74777_a("PickupDelay", (short)this.field_145804_b);
        compound.func_74768_a("Lifespan", this.lifespan);
        if (this.func_200214_m() != null) {
            compound.func_74782_a("Thrower", NBTUtil.func_186862_a((UUID)this.func_200214_m()));
        }
        if (this.func_200215_l() != null) {
            compound.func_74782_a("Owner", NBTUtil.func_186862_a((UUID)this.func_200215_l()));
        }
        if (!this.func_92059_d().func_190926_b()) {
            compound.func_74782_a("Item", this.func_92059_d().func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_70291_e = compound.func_74765_d("Health");
        this.field_70292_b = compound.func_74765_d("Age");
        if (compound.func_74764_b("PickupDelay")) {
            this.field_145804_b = compound.func_74765_d("PickupDelay");
        }
        if (compound.func_74764_b("Lifespan")) {
            this.lifespan = compound.func_74762_e("Lifespan");
        }
        if (compound.func_150297_b("Owner", 10)) {
            this.field_145802_g = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("Owner"));
        }
        if (compound.func_150297_b("Thrower", 10)) {
            this.field_145801_f = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("Thrower"));
        }
        NBTTagCompound nbttagcompound = compound.func_74775_l("Item");
        this.func_92058_a(ItemStack.func_199557_a(nbttagcompound));
        if (this.func_92059_d().func_190926_b()) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_145804_b > 0) {
                return;
            }
            ItemStack itemstack = this.func_92059_d();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((EntityItem)this, (EntityPlayer)entityIn);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.func_77946_l();
            if (this.field_145804_b == 0 && (this.field_145802_g == null || this.lifespan - this.field_70292_b <= 200 || this.field_145802_g.equals(entityIn.func_110124_au())) && (hook == 1 || i <= 0 || entityIn.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - this.func_92059_d().func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((EntityPlayer)entityIn, (EntityItem)this, (ItemStack)copy);
                if (itemstack.func_190926_b()) {
                    entityIn.func_71001_a(this, i);
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                entityIn.func_71064_a(StatList.field_199089_f.func_199076_b((Object)item), i);
            }
        }
    }

    @Override
    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TextComponentTranslation(this.func_92059_d().func_77977_a(), new Object[0]);
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionType p_212321_1_, ITeleporter teleporter) {
        Entity entity = super.changeDimension(p_212321_1_, teleporter);
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityItem) {
            ((EntityItem)entity).func_85054_d();
        }
        return entity;
    }

    public ItemStack func_92059_d() {
        return this.func_184212_Q().func_187225_a(field_184533_c);
    }

    public void func_92058_a(ItemStack stack) {
        this.func_184212_Q().func_187227_b(field_184533_c, stack);
    }

    @Nullable
    public UUID func_200215_l() {
        return this.field_145802_g;
    }

    public void func_200217_b(@Nullable UUID p_200217_1_) {
        this.field_145802_g = p_200217_1_;
    }

    @Nullable
    public UUID func_200214_m() {
        return this.field_145801_f;
    }

    public void func_200216_c(@Nullable UUID p_200216_1_) {
        this.field_145801_f = p_200216_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_174872_o() {
        return this.field_70292_b;
    }

    public void func_174869_p() {
        this.field_145804_b = 10;
    }

    public void func_174868_q() {
        this.field_145804_b = 0;
    }

    public void func_174871_r() {
        this.field_145804_b = Short.MAX_VALUE;
    }

    public void func_174867_a(int ticks) {
        this.field_145804_b = ticks;
    }

    public boolean func_174874_s() {
        return this.field_145804_b > 0;
    }

    public void func_174873_u() {
        this.field_70292_b = -6000;
    }

    public void func_174870_v() {
        this.func_174871_r();
        this.field_70292_b = this.func_92059_d().getEntityLifespan(this.field_70170_p) - 1;
    }
}

