/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMinecartFurnace
extends EntityMinecart {
    private static final DataParameter<Boolean> field_184275_c = EntityDataManager.func_187226_a(EntityMinecartFurnace.class, DataSerializers.field_187198_h);
    private int field_94110_c;
    public double field_94111_a;
    public double field_94109_b;
    private static final Ingredient field_195407_e = Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l);

    public EntityMinecartFurnace(World worldIn) {
        super(EntityType.field_200775_O, worldIn);
    }

    public EntityMinecartFurnace(World worldIn, double x, double y, double z) {
        super(EntityType.field_200775_O, worldIn, x, y, z);
    }

    @Override
    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.FURNACE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184275_c, false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_94110_c > 0) {
            --this.field_94110_c;
        }
        if (this.field_94110_c <= 0) {
            this.field_94111_a = 0.0;
            this.field_94109_b = 0.0;
        }
        this.func_94107_f(this.field_94110_c > 0);
        if (this.func_94108_c() && this.field_70146_Z.nextInt(4) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected double func_174898_m() {
        return 0.2;
    }

    @Override
    public void func_94095_a(DamageSource source) {
        super.func_94095_a(source);
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_199703_a(Blocks.field_150460_al);
        }
    }

    @Override
    protected void func_180460_a(BlockPos pos, IBlockState state) {
        super.func_180460_a(pos, state);
        double d0 = this.field_94111_a * this.field_94111_a + this.field_94109_b * this.field_94109_b;
        if (d0 > 1.0E-4 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.field_94111_a /= d0;
            this.field_94109_b /= d0;
            if (this.field_94111_a * this.field_70159_w + this.field_94109_b * this.field_70179_y < 0.0) {
                this.field_94111_a = 0.0;
                this.field_94109_b = 0.0;
            } else {
                double d1 = d0 / this.func_174898_m();
                this.field_94111_a *= d1;
                this.field_94109_b *= d1;
            }
        }
    }

    @Override
    protected void func_94101_h() {
        double d0 = this.field_94111_a * this.field_94111_a + this.field_94109_b * this.field_94109_b;
        if (d0 > 1.0E-4) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.field_94111_a /= d0;
            this.field_94109_b /= d0;
            double d1 = 1.0;
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.8f;
            this.field_70159_w += this.field_94111_a * 1.0;
            this.field_70179_y += this.field_94109_b * 1.0;
        } else {
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.98f;
        }
        super.func_94101_h();
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (field_195407_e.test(itemstack) && this.field_94110_c + 3600 <= 32000) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.field_94110_c += 3600;
        }
        this.field_94111_a = this.field_70165_t - player.field_70165_t;
        this.field_94109_b = this.field_70161_v - player.field_70161_v;
        return true;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a("PushX", this.field_94111_a);
        compound.func_74780_a("PushZ", this.field_94109_b);
        compound.func_74777_a("Fuel", (short)this.field_94110_c);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_94111_a = compound.func_74769_h("PushX");
        this.field_94109_b = compound.func_74769_h("PushZ");
        this.field_94110_c = compound.func_74765_d("Fuel");
    }

    protected boolean func_94108_c() {
        return this.field_70180_af.func_187225_a(field_184275_c);
    }

    protected void func_94107_f(boolean p_94107_1_) {
        this.field_70180_af.func_187227_b(field_184275_c, p_94107_1_);
    }

    @Override
    public IBlockState func_180457_u() {
        return (IBlockState)((IBlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((IProperty)BlockFurnace.field_176447_a, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)BlockFurnace.field_196325_b, Boolean.valueOf(this.func_94108_c()));
    }
}

