/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;

public enum HorseArmorType implements IExtensibleEnum
{
    NONE(0),
    IRON(5, "iron", "meo"),
    GOLD(7, "gold", "goo"),
    DIAMOND(11, "diamond", "dio");

    private final String field_188586_e;
    private final String field_188587_f;
    private final int field_188588_g;
    private Item item;

    private HorseArmorType(int armorStrengthIn) {
        this.field_188588_g = armorStrengthIn;
        this.field_188586_e = null;
        this.field_188587_f = "";
    }

    private HorseArmorType(int armorStrengthIn, String p_i46800_4_, String p_i46800_5_) {
        this.field_188588_g = armorStrengthIn;
        this.field_188586_e = "textures/entity/horse/armor/horse_armor_" + p_i46800_4_ + ".png";
        this.field_188587_f = p_i46800_5_;
    }

    private HorseArmorType(int strength, String texture, String hash, Item item) {
        this.field_188588_g = strength;
        this.field_188586_e = texture;
        this.field_188587_f = hash;
        this.item = item;
    }

    public static HorseArmorType create(String name, int strength, String texture, String hash, Item item) {
        throw new IllegalStateException("Enum not extended");
    }

    public int func_188579_a() {
        return this.ordinal();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_188573_b() {
        return this.field_188587_f;
    }

    public int func_188578_c() {
        return this.field_188588_g;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String func_188574_d() {
        return this.field_188586_e;
    }

    @Deprecated
    public static HorseArmorType func_188575_a(int ordinal) {
        return HorseArmorType.values()[ordinal];
    }

    public static HorseArmorType func_188580_a(ItemStack stack) {
        return stack.func_190926_b() ? NONE : stack.getHorseArmorType();
    }

    @Deprecated
    public static HorseArmorType func_188576_a(Item itemIn) {
        if (itemIn == Items.field_151138_bX) {
            return IRON;
        }
        if (itemIn == Items.field_151136_bY) {
            return GOLD;
        }
        if (itemIn == Items.field_151125_bZ) {
            return DIAMOND;
        }
        for (HorseArmorType type : HorseArmorType.values()) {
            if (type.item == null || type.item.delegate.get() != itemIn.delegate.get()) continue;
            return type;
        }
        return NONE;
    }

    @Deprecated
    public static boolean func_188577_b(Item itemIn) {
        return HorseArmorType.func_188576_a(itemIn) != NONE;
    }

    public static boolean isHorseArmor(ItemStack stack) {
        return stack.getHorseArmorType() != NONE;
    }
}

