/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketCamera;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCloseWindow;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerLook;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.CooldownTrackerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPlayerMP
extends EntityPlayer
implements IContainerListener {
    private static final Logger field_147102_bM = LogManager.getLogger();
    private String field_71148_cg = "en_US";
    public NetHandlerPlayServer field_71135_a;
    public final MinecraftServer field_71133_b;
    public final PlayerInteractionManager field_71134_c;
    public double field_71131_d;
    public double field_71132_e;
    private final List<Integer> field_71130_g = Lists.newLinkedList();
    private final PlayerAdvancements field_192042_bX;
    private final StatisticsManagerServer field_147103_bO;
    private float field_130068_bO = Float.MIN_VALUE;
    private int field_184852_bV = Integer.MIN_VALUE;
    private int field_184853_bW = Integer.MIN_VALUE;
    private int field_184854_bX = Integer.MIN_VALUE;
    private int field_184855_bY = Integer.MIN_VALUE;
    private int field_184856_bZ = Integer.MIN_VALUE;
    private float field_71149_ch = -1.0E8f;
    private int field_71146_ci = -99999999;
    private boolean field_71147_cj = true;
    private int field_71144_ck = -99999999;
    private int field_147101_bU = 60;
    private EntityPlayer.EnumChatVisibility field_71143_cn;
    private boolean field_71140_co = true;
    private long field_143005_bX = Util.func_211177_b();
    private Entity field_175401_bS;
    private boolean field_184851_cj;
    private boolean field_192040_cp;
    private final ServerRecipeBook field_192041_cq;
    private Vec3d field_193107_ct;
    private int field_193108_cu;
    private boolean field_193109_cv;
    private Vec3d field_193110_cw;
    public int field_71139_cq;
    public boolean field_71137_h;
    public int field_71138_i;
    public boolean field_71136_j;

    public EntityPlayerMP(MinecraftServer server, WorldServer worldIn, GameProfile profile, PlayerInteractionManager interactionManagerIn) {
        super(worldIn, profile);
        interactionManagerIn.field_73090_b = this;
        this.field_71134_c = interactionManagerIn;
        this.field_71133_b = server;
        this.field_192041_cq = new ServerRecipeBook(server.func_199529_aN());
        this.field_147103_bO = server.func_184103_al().func_152602_a(this);
        this.field_192042_bX = server.func_184103_al().func_192054_h(this);
        this.field_70138_W = 1.0f;
        this.func_205734_a(worldIn);
    }

    private void func_205734_a(WorldServer p_205734_1_) {
        BlockPos blockpos = p_205734_1_.func_175694_M();
        if (p_205734_1_.field_73011_w.func_191066_m() && p_205734_1_.func_72912_H().func_76077_q() != GameType.ADVENTURE) {
            int i = Math.max(0, this.field_71133_b.func_184108_a(p_205734_1_));
            int j = MathHelper.func_76128_c((double)p_205734_1_.func_175723_af().func_177729_b(blockpos.func_177958_n(), blockpos.func_177952_p()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int k = (i * 2 + 1) * (i * 2 + 1);
            int l = this.func_205735_q(k);
            int i1 = new Random().nextInt(k);
            for (int j1 = 0; j1 < k; ++j1) {
                int k1 = (i1 + l * j1) % k;
                int l1 = k1 % (i * 2 + 1);
                int i2 = k1 / (i * 2 + 1);
                BlockPos blockpos1 = p_205734_1_.func_201675_m().func_206921_a(blockpos.func_177958_n() + l1 - i, blockpos.func_177952_p() + i2 - i, false);
                if (blockpos1 == null) continue;
                this.func_174828_a(blockpos1, 0.0f, 0.0f);
                if (!p_205734_1_.func_195586_b(this, this.func_174813_aQ())) {
                    continue;
                }
                break;
            }
        } else {
            this.func_174828_a(blockpos, 0.0f, 0.0f);
            while (!p_205734_1_.func_195586_b(this, this.func_174813_aQ()) && this.field_70163_u < 255.0) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
            }
        }
    }

    private int func_205735_q(int p_205735_1_) {
        return p_205735_1_ <= 16 ? p_205735_1_ - 1 : 17;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("playerGameType", 99)) {
            if (this.func_184102_h().func_104056_am()) {
                this.field_71134_c.func_73076_a(this.func_184102_h().func_71265_f());
            } else {
                this.field_71134_c.func_73076_a(GameType.func_77146_a((int)compound.func_74762_e("playerGameType")));
            }
        }
        if (compound.func_150297_b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("enteredNetherPosition");
            this.field_193110_cw = new Vec3d(nbttagcompound.func_74769_h("x"), nbttagcompound.func_74769_h("y"), nbttagcompound.func_74769_h("z"));
        }
        this.field_192040_cp = compound.func_74767_n("seenCredits");
        if (compound.func_150297_b("recipeBook", 10)) {
            this.field_192041_cq.func_192825_a(compound.func_74775_l("recipeBook"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("playerGameType", this.field_71134_c.func_73081_b().func_77148_a());
        compound.func_74757_a("seenCredits", this.field_192040_cp);
        if (this.field_193110_cw != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74780_a("x", this.field_193110_cw.field_72450_a);
            nbttagcompound.func_74780_a("y", this.field_193110_cw.field_72448_b);
            nbttagcompound.func_74780_a("z", this.field_193110_cw.field_72449_c);
            compound.func_74782_a("enteredNetherPosition", nbttagcompound);
        }
        Entity entity1 = this.func_184208_bv();
        Entity entity = this.func_184187_bx();
        if (entity != null && entity1 != this && entity1.func_200601_bK()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            entity1.func_70039_c(nbttagcompound2);
            nbttagcompound1.func_186854_a("Attach", entity.func_110124_au());
            nbttagcompound1.func_74782_a("Entity", nbttagcompound2);
            compound.func_74782_a("RootVehicle", nbttagcompound1);
        }
        compound.func_74782_a("recipeBook", this.field_192041_cq.func_192824_e());
    }

    public void func_195394_a(int p_195394_1_) {
        float f = this.func_71050_bK();
        float f1 = (f - 1.0f) / f;
        this.field_71106_cc = MathHelper.func_76131_a((float)((float)p_195394_1_ / f), (float)0.0f, (float)f1);
        this.field_71144_ck = -1;
    }

    public void func_195399_b(int p_195399_1_) {
        this.field_71068_ca = p_195399_1_;
        this.field_71144_ck = -1;
    }

    @Override
    public void func_82242_a(int levels) {
        super.func_82242_a(levels);
        this.field_71144_ck = -1;
    }

    @Override
    public void func_192024_a(ItemStack enchantedItem, int cost) {
        super.func_192024_a(enchantedItem, cost);
        this.field_71144_ck = -1;
    }

    public void func_71116_b() {
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_152111_bt() {
        super.func_152111_bt();
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTER_COMBAT));
    }

    @Override
    public void func_152112_bu() {
        super.func_152112_bu();
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.END_COMBAT));
    }

    @Override
    protected void func_191955_a(IBlockState p_191955_1_) {
        CriteriaTriggers.field_192124_d.func_192193_a(this, p_191955_1_);
    }

    @Override
    protected CooldownTracker func_184815_l() {
        return new CooldownTrackerServer(this);
    }

    @Override
    public void func_70071_h_() {
        this.field_71134_c.func_73075_a();
        --this.field_147101_bU;
        if (this.field_70172_ad > 0) {
            --this.field_70172_ad;
        }
        this.field_71070_bA.func_75142_b();
        if (!this.field_70170_p.field_72995_K && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        while (!this.field_71130_g.isEmpty()) {
            int i = Math.min(this.field_71130_g.size(), Integer.MAX_VALUE);
            int[] aint = new int[i];
            Iterator<Integer> iterator = this.field_71130_g.iterator();
            int j = 0;
            while (iterator.hasNext() && j < i) {
                aint[j++] = iterator.next();
                iterator.remove();
            }
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketDestroyEntities(aint));
        }
        Entity entity = this.func_175398_C();
        if (entity != this) {
            if (entity.func_70089_S()) {
                this.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                this.field_71133_b.func_184103_al().func_72358_d(this);
                if (this.func_70093_af()) {
                    this.func_175399_e(this);
                }
            } else {
                this.func_175399_e(this);
            }
        }
        CriteriaTriggers.field_193135_v.func_193182_a(this);
        if (this.field_193107_ct != null) {
            CriteriaTriggers.field_193133_t.func_193162_a(this, this.field_193107_ct, this.field_70173_aa - this.field_193108_cu);
        }
        this.field_192042_bX.func_192741_b(this);
    }

    public void func_71127_g() {
        try {
            super.func_70071_h_();
            for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
                Packet packet;
                ItemStack itemstack = this.field_71071_by.func_70301_a(i);
                if (!itemstack.func_77973_b().func_77643_m_() || (packet = ((ItemMapBase)itemstack.func_77973_b()).func_150911_c(itemstack, this.field_70170_p, (EntityPlayer)this)) == null) continue;
                this.field_71135_a.func_147359_a(packet);
            }
            if (this.func_110143_aJ() != this.field_71149_ch || this.field_71146_ci != this.field_71100_bB.func_75116_a() || this.field_71100_bB.func_75115_e() == 0.0f != this.field_71147_cj) {
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketUpdateHealth(this.func_110143_aJ(), this.field_71100_bB.func_75116_a(), this.field_71100_bB.func_75115_e()));
                this.field_71149_ch = this.func_110143_aJ();
                this.field_71146_ci = this.field_71100_bB.func_75116_a();
                boolean bl = this.field_71147_cj = this.field_71100_bB.func_75115_e() == 0.0f;
            }
            if (this.func_110143_aJ() + this.func_110139_bj() != this.field_130068_bO) {
                this.field_130068_bO = this.func_110143_aJ() + this.func_110139_bj();
                this.func_184849_a(ScoreCriteria.field_96638_f, MathHelper.func_76123_f((float)this.field_130068_bO));
            }
            if (this.field_71100_bB.func_75116_a() != this.field_184852_bV) {
                this.field_184852_bV = this.field_71100_bB.func_75116_a();
                this.func_184849_a(ScoreCriteria.field_186698_h, MathHelper.func_76123_f((float)this.field_184852_bV));
            }
            if (this.func_70086_ai() != this.field_184853_bW) {
                this.field_184853_bW = this.func_70086_ai();
                this.func_184849_a(ScoreCriteria.field_186699_i, MathHelper.func_76123_f((float)this.field_184853_bW));
            }
            if (this.func_70658_aO() != this.field_184854_bX) {
                this.field_184854_bX = this.func_70658_aO();
                this.func_184849_a(ScoreCriteria.field_186700_j, MathHelper.func_76123_f((float)this.field_184854_bX));
            }
            if (this.field_71067_cb != this.field_184856_bZ) {
                this.field_184856_bZ = this.field_71067_cb;
                this.func_184849_a(ScoreCriteria.field_186701_k, MathHelper.func_76123_f((float)this.field_184856_bZ));
            }
            if (this.field_71068_ca != this.field_184855_bY) {
                this.field_184855_bY = this.field_71068_ca;
                this.func_184849_a(ScoreCriteria.field_186702_l, MathHelper.func_76123_f((float)this.field_184855_bY));
            }
            if (this.field_71067_cb != this.field_71144_ck) {
                this.field_71144_ck = this.field_71067_cb;
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketSetExperience(this.field_71106_cc, this.field_71067_cb, this.field_71068_ca));
            }
            if (this.field_70173_aa % 20 == 0) {
                CriteriaTriggers.field_192135_o.func_192215_a(this);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking player");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Player being ticked");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    private void func_184849_a(ScoreCriteria criteria, int points) {
        this.func_96123_co().func_197893_a(criteria, this.func_195047_I_(), p_195397_1_ -> p_195397_1_.func_96647_c(points));
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)cause)) {
            return;
        }
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
        if (flag) {
            ITextComponent itextcomponent = this.func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a((Packet<?>)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, itextcomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s = itextcomponent.func_212636_a(256);
                    TextComponentTranslation itextcomponent1 = new TextComponentTranslation("death.attack.message_too_long", new TextComponentString(s).func_211708_a(TextFormatting.YELLOW));
                    ITextComponent itextcomponent2 = new TextComponentTranslation("death.attack.even_more_magic", this.func_145748_c_()).func_211710_a(arg_0 -> EntityPlayerMP.lambda$null$1((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((Packet<?>)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, itextcomponent2));
                }
            }));
            Team team = this.func_96124_cp();
            if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a(this, itextcomponent);
                } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b(this, itextcomponent);
                }
            } else {
                this.field_71133_b.func_184103_al().func_148539_a(itextcomponent);
            }
        } else {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            this.captureDrops(new ArrayList<EntityItem>());
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
            if (!this.field_70170_p.field_72995_K) {
                ForgeEventFactory.onPlayerDrops((EntityPlayer)this, (DamageSource)cause, this.captureDrops(null), (this.field_70718_bc > 0 ? 1 : 0) != 0);
            }
        }
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        EntityLivingBase entitylivingbase = this.func_94060_bK();
        if (entitylivingbase != null) {
            this.func_71029_a(StatList.field_199091_i.func_199076_b(entitylivingbase.func_200600_R()));
            entitylivingbase.func_191956_a(this, this.field_70744_aE, cause);
        }
        this.func_195066_a(StatList.field_188069_A);
        this.func_175145_a(StatList.field_199092_j.func_199076_b((Object)StatList.field_188098_h));
        this.func_175145_a(StatList.field_199092_j.func_199076_b((Object)StatList.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Override
    public void func_191956_a(Entity p_191956_1_, int p_191956_2_, DamageSource p_191956_3_) {
        if (p_191956_1_ != this) {
            super.func_191956_a(p_191956_1_, p_191956_2_, p_191956_3_);
            this.func_85039_t(p_191956_2_);
            String s = this.func_195047_I_();
            String s1 = p_191956_1_.func_195047_I_();
            this.func_96123_co().func_197893_a(ScoreCriteria.field_96640_e, s, Score::func_96648_a);
            if (p_191956_1_ instanceof EntityPlayer) {
                this.func_195066_a(StatList.field_75932_A);
                this.func_96123_co().func_197893_a(ScoreCriteria.field_96639_d, s, Score::func_96648_a);
            } else {
                this.func_195066_a(StatList.field_188070_B);
            }
            this.func_195398_a(s, s1, ScoreCriteria.field_197913_m);
            this.func_195398_a(s1, s, ScoreCriteria.field_197914_n);
            CriteriaTriggers.field_192122_b.func_192211_a(this, p_191956_1_, p_191956_3_);
        }
    }

    private void func_195398_a(String p_195398_1_, String p_195398_2_, ScoreCriteria[] p_195398_3_) {
        int i;
        ScorePlayerTeam scoreplayerteam = this.func_96123_co().func_96509_i(p_195398_2_);
        if (scoreplayerteam != null && (i = scoreplayerteam.func_178775_l().func_175746_b()) >= 0 && i < p_195398_3_.length) {
            this.func_96123_co().func_197893_a(p_195398_3_[i], p_195398_1_, Score::func_96648_a);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag;
        if (this.func_180431_b(source)) {
            return false;
        }
        boolean bl = flag = this.field_71133_b.func_71262_S() && this.func_175400_cq() && "fall".equals(source.field_76373_n);
        if (!flag && this.field_147101_bU > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            EntityArrow entityarrow;
            Entity entity1;
            Entity entity = source.func_76346_g();
            if (entity instanceof EntityPlayer && !this.func_96122_a((EntityPlayer)entity)) {
                return false;
            }
            if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).func_212360_k()) instanceof EntityPlayer && !this.func_96122_a((EntityPlayer)entity1)) {
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_96122_a(EntityPlayer other) {
        return !this.func_175400_cq() ? false : super.func_96122_a(other);
    }

    private boolean func_175400_cq() {
        return this.field_71133_b.func_71219_W();
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionType p_212321_1_, ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, (DimensionType)p_212321_1_)) {
            return null;
        }
        this.field_184851_cj = true;
        if (this.field_71093_bK == DimensionType.OVERWORLD && p_212321_1_ == DimensionType.NETHER) {
            this.field_193110_cw = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else if (this.field_71093_bK != DimensionType.NETHER && p_212321_1_ != DimensionType.OVERWORLD) {
            this.field_193110_cw = null;
        }
        if (this.field_71093_bK == DimensionType.THE_END && p_212321_1_ == DimensionType.THE_END && teleporter.isVanilla()) {
            this.field_70170_p.func_72900_e(this);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(4, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return this;
        }
        if (this.field_71093_bK == DimensionType.OVERWORLD && p_212321_1_ == DimensionType.THE_END) {
            p_212321_1_ = DimensionType.THE_END;
        }
        this.field_71133_b.func_184103_al().changePlayerDimension(this, p_212321_1_, teleporter);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        return this;
    }

    @Override
    public boolean func_174827_a(EntityPlayerMP player) {
        if (player.func_175149_v()) {
            return this.func_175398_C() == this;
        }
        return this.func_175149_v() ? false : super.func_174827_a(player);
    }

    private void func_147097_b(TileEntity p_147097_1_) {
        SPacketUpdateTileEntity spacketupdatetileentity;
        if (p_147097_1_ != null && (spacketupdatetileentity = p_147097_1_.func_189518_D_()) != null) {
            this.field_71135_a.func_147359_a((Packet<?>)spacketupdatetileentity);
        }
    }

    @Override
    public void func_71001_a(Entity entityIn, int quantity) {
        super.func_71001_a(entityIn, quantity);
        this.field_71070_bA.func_75142_b();
    }

    @Override
    public EntityPlayer.SleepResult func_180469_a(BlockPos bedLocation) {
        EntityPlayer.SleepResult entityplayer$sleepresult = super.func_180469_a(bedLocation);
        if (entityplayer$sleepresult == EntityPlayer.SleepResult.OK) {
            this.func_195066_a(StatList.field_188064_ad);
            SPacketUseBed packet = new SPacketUseBed((EntityPlayer)this, bedLocation);
            this.func_71121_q().func_73039_n().func_151247_a(this, (Packet<?>)packet);
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_71135_a.func_147359_a((Packet<?>)packet);
            CriteriaTriggers.field_192136_p.func_192215_a(this);
        }
        return entityplayer$sleepresult;
    }

    @Override
    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        if (this.func_70608_bn()) {
            this.func_71121_q().func_73039_n().func_151248_b(this, (Packet<?>)new SPacketAnimation((Entity)this, 2));
        }
        super.func_70999_a(immediately, updateWorldFlag, setSpawn);
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_184205_a(Entity entityIn, boolean force) {
        Entity entity = this.func_184187_bx();
        if (!super.func_184205_a(entityIn, force)) {
            return false;
        }
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        Entity entity1 = this.func_184187_bx();
        if (entity1 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184850_K();
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Override
    protected void func_184594_b(BlockPos pos) {
        if (!this.func_175149_v()) {
            super.func_184594_b(pos);
        }
    }

    public void func_71122_b(double y, boolean onGroundIn) {
        BlockPos blockpos1;
        IBlockState iblockstate1;
        Block block;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        if (iblockstate.isAir((IBlockReader)this.field_70170_p, blockpos) && ((block = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate)) {
            blockpos = blockpos1;
            iblockstate = iblockstate1;
        }
        super.func_184231_a(y, onGroundIn, iblockstate, blockpos);
    }

    @Override
    public void func_175141_a(TileEntitySign signTile) {
        signTile.func_145912_a((EntityPlayer)this);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketSignEditorOpen(signTile.func_174877_v()));
    }

    public void func_71117_bO() {
        this.field_71139_cq = this.field_71139_cq % 100 + 1;
    }

    @Override
    public void func_180468_a(IInteractionObject guiOwner) {
        if (guiOwner instanceof ILootContainer && ((ILootContainer)guiOwner).func_184276_b() != null && this.func_175149_v()) {
            this.func_146105_b(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
        } else {
            this.func_71117_bO();
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketOpenWindow(this.field_71139_cq, guiOwner.func_174875_k(), guiOwner.func_145748_c_()));
            this.field_71070_bA = guiOwner.func_174876_a(this.field_71071_by, (EntityPlayer)this);
            this.field_71070_bA.field_75152_c = this.field_71139_cq;
            this.field_71070_bA.func_75132_a(this);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)this, this.field_71070_bA));
        }
    }

    @Override
    public void func_71007_a(IInventory chestInventory) {
        if (chestInventory instanceof ILootContainer && ((ILootContainer)chestInventory).func_184276_b() != null && this.func_175149_v()) {
            this.func_146105_b(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
        } else {
            ILockableContainer ilockablecontainer;
            if (this.field_71070_bA != this.field_71069_bz) {
                this.func_71053_j();
            }
            if (chestInventory instanceof ILockableContainer && (ilockablecontainer = (ILockableContainer)chestInventory).func_174893_q_() && !this.func_175146_a(ilockablecontainer.func_174891_i()) && !this.func_175149_v()) {
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketChat((ITextComponent)new TextComponentTranslation("container.isLocked", chestInventory.func_145748_c_()), ChatType.GAME_INFO));
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketSoundEffect(SoundEvents.field_187654_U, SoundCategory.BLOCKS, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f));
                return;
            }
            this.func_71117_bO();
            if (chestInventory instanceof IInteractionObject) {
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketOpenWindow(this.field_71139_cq, ((IInteractionObject)chestInventory).func_174875_k(), chestInventory.func_145748_c_(), chestInventory.func_70302_i_()));
                this.field_71070_bA = ((IInteractionObject)chestInventory).func_174876_a(this.field_71071_by, (EntityPlayer)this);
            } else {
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketOpenWindow(this.field_71139_cq, "minecraft:container", chestInventory.func_145748_c_(), chestInventory.func_70302_i_()));
                this.field_71070_bA = new ContainerChest((IInventory)this.field_71071_by, chestInventory, (EntityPlayer)this);
            }
            this.field_71070_bA.field_75152_c = this.field_71139_cq;
            this.field_71070_bA.func_75132_a(this);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)this, this.field_71070_bA));
        }
    }

    @Override
    public void func_180472_a(IMerchant villager) {
        this.func_71117_bO();
        this.field_71070_bA = new ContainerMerchant(this.field_71071_by, villager, this.field_70170_p);
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)this, this.field_71070_bA));
        InventoryMerchant iinventory = ((ContainerMerchant)this.field_71070_bA).func_75174_d();
        ITextComponent itextcomponent = villager.func_145748_c_();
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketOpenWindow(this.field_71139_cq, "minecraft:villager", itextcomponent, iinventory.func_70302_i_()));
        MerchantRecipeList merchantrecipelist = villager.func_70934_b((EntityPlayer)this);
        if (merchantrecipelist != null) {
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeInt(this.field_71139_cq);
            merchantrecipelist.func_151391_a(packetbuffer);
            this.field_71135_a.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209910_a, packetbuffer));
        }
    }

    @Override
    public void func_184826_a(AbstractHorse horse, IInventory inventoryIn) {
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketOpenWindow(this.field_71139_cq, "EntityHorse", inventoryIn.func_145748_c_(), inventoryIn.func_70302_i_(), horse.func_145782_y()));
        this.field_71070_bA = new ContainerHorseInventory((IInventory)this.field_71071_by, inventoryIn, horse, (EntityPlayer)this);
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)this, this.field_71070_bA));
    }

    @Override
    public void func_184814_a(ItemStack stack, EnumHand hand) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151164_bB) {
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.func_179249_a((Enum<?>)hand);
            this.field_71135_a.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209912_c, packetbuffer));
        }
    }

    @Override
    public void func_184824_a(TileEntityCommandBlock commandBlock) {
        commandBlock.func_184252_d(true);
        this.func_147097_b((TileEntity)commandBlock);
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.func_75139_a(slotInd) instanceof SlotCrafting)) {
            if (containerToSend == this.field_71069_bz) {
                CriteriaTriggers.field_192125_e.func_192208_a(this, this.field_71071_by);
            }
            if (!this.field_71137_h) {
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketSetSlot(containerToSend.field_75152_c, slotInd, stack));
            }
        }
    }

    public void func_71120_a(Container containerIn) {
        this.func_71110_a(containerIn, containerIn.func_75138_a());
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketWindowItems(containerToSend.field_75152_c, itemsList));
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketSetSlot(-1, -1, this.field_71071_by.func_70445_o()));
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketWindowProperty(containerIn.field_75152_c, varToUpdate, newValue));
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
        for (int i = 0; i < inventory.func_174890_g(); ++i) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketWindowProperty(containerIn.field_75152_c, i, inventory.func_174887_a_(i)));
        }
    }

    @Override
    public void func_71053_j() {
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketCloseWindow(this.field_71070_bA.field_75152_c));
        this.func_71128_l();
    }

    public void func_71113_k() {
        if (!this.field_71137_h) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketSetSlot(-1, -1, this.field_71071_by.func_70445_o()));
        }
    }

    public void func_71128_l() {
        this.field_71070_bA.func_75134_a(this);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Close((EntityPlayer)this, this.field_71070_bA));
        this.field_71070_bA = this.field_71069_bz;
    }

    public void func_110430_a(float strafe, float forward, boolean jumping, boolean sneaking) {
        if (this.func_184218_aH()) {
            if (strafe >= -1.0f && strafe <= 1.0f) {
                this.field_70702_br = strafe;
            }
            if (forward >= -1.0f && forward <= 1.0f) {
                this.field_191988_bg = forward;
            }
            this.field_70703_bu = jumping;
            this.func_70095_a(sneaking);
        }
    }

    @Override
    public void func_71064_a(Stat<?> stat, int amount) {
        this.field_147103_bO.func_150871_b((EntityPlayer)this, stat, amount);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), p_195396_1_ -> p_195396_1_.func_96649_a(amount));
    }

    @Override
    public void func_175145_a(Stat<?> stat) {
        this.field_147103_bO.func_150873_a((EntityPlayer)this, stat, 0);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), Score::func_197891_c);
    }

    @Override
    public int func_195065_a(Collection<IRecipe> p_195065_1_) {
        return this.field_192041_cq.func_197926_a(p_195065_1_, this);
    }

    @Override
    public void func_193102_a(ResourceLocation[] p_193102_1_) {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation resourcelocation : p_193102_1_) {
            IRecipe irecipe = this.field_71133_b.func_199529_aN().func_199517_a(resourcelocation);
            if (irecipe == null) continue;
            list.add(irecipe);
        }
        this.func_195065_a(list);
    }

    @Override
    public int func_195069_b(Collection<IRecipe> p_195069_1_) {
        return this.field_192041_cq.func_197925_b(p_195069_1_, this);
    }

    @Override
    public void func_195068_e(int p_195068_1_) {
        super.func_195068_e(p_195068_1_);
        this.field_71144_ck = -1;
    }

    public void func_71123_m() {
        this.field_193109_cv = true;
        this.func_184226_ay();
        if (this.field_71083_bS) {
            this.func_70999_a(true, false, false);
        }
    }

    public boolean func_193105_t() {
        return this.field_193109_cv;
    }

    public void func_71118_n() {
        this.field_71149_ch = -1.0E8f;
    }

    @Override
    public void func_146105_b(ITextComponent chatComponent, boolean actionBar) {
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketChat(chatComponent, actionBar ? ChatType.GAME_INFO : ChatType.CHAT));
    }

    @Override
    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityStatus((Entity)this, 9));
            super.func_71036_o();
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type p_200602_1_, Vec3d p_200602_2_) {
        super.func_200602_a(p_200602_1_, p_200602_2_);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerLook(p_200602_1_, p_200602_2_.field_72450_a, p_200602_2_.field_72448_b, p_200602_2_.field_72449_c));
    }

    public void func_200618_a(EntityAnchorArgument.Type p_200618_1_, Entity p_200618_2_, EntityAnchorArgument.Type p_200618_3_) {
        Vec3d vec3d = p_200618_3_.func_201017_a(p_200618_2_);
        super.func_200602_a(p_200618_1_, vec3d);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerLook(p_200618_1_, p_200618_2_, p_200618_3_));
    }

    public void func_193104_a(EntityPlayerMP that, boolean keepEverything) {
        NBTTagCompound old;
        if (keepEverything) {
            this.field_71071_by.func_70455_b(that.field_71071_by);
            this.func_70606_j(that.func_110143_aJ());
            this.field_71100_bB = that.field_71100_bB;
            this.field_71068_ca = that.field_71068_ca;
            this.field_71067_cb = that.field_71067_cb;
            this.field_71106_cc = that.field_71106_cc;
            this.func_85040_s(that.func_71037_bA());
            this.field_181016_an = that.field_181016_an;
            this.field_181017_ao = that.field_181017_ao;
            this.field_181018_ap = that.field_181018_ap;
        } else if (this.field_70170_p.func_82736_K().func_82766_b("keepInventory") || that.func_175149_v()) {
            this.field_71071_by.func_70455_b(that.field_71071_by);
            this.field_71068_ca = that.field_71068_ca;
            this.field_71067_cb = that.field_71067_cb;
            this.field_71106_cc = that.field_71106_cc;
            this.func_85040_s(that.func_71037_bA());
        }
        this.field_175152_f = that.field_175152_f;
        this.field_71078_a = that.field_71078_a;
        this.func_184212_Q().func_187227_b(field_184827_bp, that.func_184212_Q().func_187225_a(field_184827_bp));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.field_192041_cq.func_193824_a((RecipeBook)that.field_192041_cq);
        this.field_71130_g.addAll(that.field_71130_g);
        this.field_192040_cp = that.field_192040_cp;
        this.field_193110_cw = that.field_193110_cw;
        this.func_192029_h(that.func_192023_dk());
        this.func_192031_i(that.func_192025_dl());
        this.spawnPosMap = that.spawnPosMap;
        this.spawnForcedMap = that.spawnForcedMap;
        if (that.field_71093_bK != DimensionType.OVERWORLD) {
            this.field_71077_c = that.field_71077_c;
            this.field_82248_d = that.field_82248_d;
        }
        if ((old = that.getEntityData()).func_74764_b("PlayerPersisted")) {
            this.getEntityData().func_74782_a("PlayerPersisted", old.func_74781_a("PlayerPersisted"));
        }
        ForgeEventFactory.onPlayerClone((EntityPlayer)this, (EntityPlayer)that, (!keepEverything ? 1 : 0) != 0);
    }

    @Override
    protected void func_70670_a(PotionEffect id) {
        super.func_70670_a(id);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityEffect(this.func_145782_y(), id));
        if (id.func_188419_a() == MobEffects.field_188424_y) {
            this.field_193108_cu = this.field_70173_aa;
            this.field_193107_ct = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70695_b(PotionEffect id, boolean p_70695_2_) {
        super.func_70695_b(id, p_70695_2_);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityEffect(this.func_145782_y(), id));
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70688_c(PotionEffect effect) {
        super.func_70688_c(effect);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketRemoveEntityEffect(this.func_145782_y(), effect.func_188419_a()));
        if (effect.func_188419_a() == MobEffects.field_188424_y) {
            this.field_193107_ct = null;
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    public void func_70634_a(double x, double y, double z) {
        this.field_71135_a.func_147364_a(x, y, z, this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_71009_b(Entity entityHit) {
        this.func_71121_q().func_73039_n().func_151248_b(this, (Packet<?>)new SPacketAnimation(entityHit, 4));
    }

    @Override
    public void func_71047_c(Entity entityHit) {
        this.func_71121_q().func_73039_n().func_151248_b(this, (Packet<?>)new SPacketAnimation(entityHit, 5));
    }

    @Override
    public void func_71016_p() {
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerAbilities(this.field_71075_bZ));
            this.func_175135_B();
        }
    }

    public WorldServer func_71121_q() {
        return (WorldServer)this.field_70170_p;
    }

    @Override
    public void func_71033_a(GameType gameType) {
        this.field_71134_c.func_73076_a(gameType);
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(3, (float)gameType.func_77148_a()));
        if (gameType == GameType.SPECTATOR) {
            this.func_192030_dh();
            this.func_184210_p();
        } else {
            this.func_175399_e(this);
        }
        this.func_71016_p();
        this.func_175136_bO();
    }

    @Override
    public boolean func_175149_v() {
        return this.field_71134_c.func_73081_b() == GameType.SPECTATOR;
    }

    @Override
    public boolean func_184812_l_() {
        return this.field_71134_c.func_73081_b() == GameType.CREATIVE;
    }

    @Override
    public void func_145747_a(ITextComponent component) {
        this.func_195395_a(component, ChatType.SYSTEM);
    }

    public void func_195395_a(ITextComponent textComponent, ChatType chatTypeIn) {
        this.field_71135_a.func_211148_a((Packet<?>)new SPacketChat(textComponent, chatTypeIn), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_211144_3_ -> {
            if (!(p_211144_3_.isSuccess() || chatTypeIn != ChatType.GAME_INFO && chatTypeIn != ChatType.SYSTEM)) {
                int i = 256;
                String s = textComponent.func_212636_a(256);
                ITextComponent itextcomponent = new TextComponentString(s).func_211708_a(TextFormatting.YELLOW);
                this.field_71135_a.func_147359_a((Packet<?>)new SPacketChat(new TextComponentTranslation("multiplayer.message_not_delivered", itextcomponent).func_211708_a(TextFormatting.RED), ChatType.SYSTEM));
            }
        }));
    }

    public String func_71114_r() {
        String s = this.field_71135_a.field_147371_a.func_74430_c().toString();
        s = s.substring(s.indexOf("/") + 1);
        s = s.substring(0, s.indexOf(":"));
        return s;
    }

    public void func_147100_a(CPacketClientSettings packetIn) {
        this.field_71148_cg = packetIn.func_149524_c();
        this.field_71143_cn = packetIn.func_149523_e();
        this.field_71140_co = packetIn.func_149520_f();
        this.func_184212_Q().func_187227_b(field_184827_bp, (byte)packetIn.func_149521_d());
        this.func_184212_Q().func_187227_b(field_184828_bq, (byte)(packetIn.func_186991_f() != EnumHandSide.LEFT ? 1 : 0));
    }

    public EntityPlayer.EnumChatVisibility func_147096_v() {
        return this.field_71143_cn;
    }

    public void func_175397_a(String url, String hash) {
        this.field_71135_a.func_147359_a((Packet<?>)new SPacketResourcePackSend(url, hash));
    }

    @Override
    protected int func_184840_I() {
        return this.field_71133_b.func_211833_a(this.func_146103_bH());
    }

    public void func_143004_u() {
        this.field_143005_bX = Util.func_211177_b();
    }

    public StatisticsManagerServer func_147099_x() {
        return this.field_147103_bO;
    }

    public ServerRecipeBook func_192037_E() {
        return this.field_192041_cq;
    }

    public void func_152339_d(Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketDestroyEntities(new int[]{entityIn.func_145782_y()}));
        } else {
            this.field_71130_g.add(entityIn.func_145782_y());
        }
    }

    public void func_184848_d(Entity entityIn) {
        this.field_71130_g.remove((Object)entityIn.func_145782_y());
    }

    @Override
    protected void func_175135_B() {
        if (this.func_175149_v()) {
            this.func_175133_bi();
            this.func_82142_c(true);
        } else {
            super.func_175135_B();
        }
        this.func_71121_q().func_73039_n().func_180245_a(this);
    }

    public Entity func_175398_C() {
        return this.field_175401_bS == null ? this : this.field_175401_bS;
    }

    public void func_175399_e(Entity entityToSpectate) {
        Entity entity = this.func_175398_C();
        Entity entity2 = this.field_175401_bS = entityToSpectate == null ? this : entityToSpectate;
        if (entity != this.field_175401_bS) {
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketCamera(this.field_175401_bS));
            this.func_70634_a(this.field_175401_bS.field_70165_t, this.field_175401_bS.field_70163_u, this.field_175401_bS.field_70161_v);
        }
    }

    @Override
    protected void func_184173_H() {
        if (this.field_71088_bW > 0 && !this.field_184851_cj) {
            --this.field_71088_bW;
        }
    }

    @Override
    public void func_71059_n(Entity targetEntity) {
        if (this.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            this.func_175399_e(targetEntity);
        } else {
            super.func_71059_n(targetEntity);
        }
    }

    public long func_154331_x() {
        return this.field_143005_bX;
    }

    @Nullable
    public ITextComponent func_175396_E() {
        return null;
    }

    @Override
    public void func_184609_a(EnumHand hand) {
        super.func_184609_a(hand);
        this.func_184821_cY();
    }

    public boolean func_184850_K() {
        return this.field_184851_cj;
    }

    public void func_184846_L() {
        this.field_184851_cj = false;
    }

    public void func_184847_M() {
        this.func_70052_a(7, true);
    }

    public void func_189103_N() {
        this.func_70052_a(7, true);
        this.func_70052_a(7, false);
    }

    public PlayerAdvancements func_192039_O() {
        return this.field_192042_bX;
    }

    @Nullable
    public Vec3d func_193106_Q() {
        return this.field_193110_cw;
    }

    public void func_200619_a(WorldServer p_200619_1_, double x, double y, double z, float yaw, float pitch) {
        this.func_175399_e(this);
        this.func_184210_p();
        if (p_200619_1_ == this.field_70170_p) {
            this.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        } else if (ForgeHooks.onTravelToDimension((Entity)this, (DimensionType)p_200619_1_.field_73011_w.func_186058_p())) {
            WorldServer worldserver = this.func_71121_q();
            this.field_71093_bK = p_200619_1_.field_73011_w.func_186058_p();
            this.field_71135_a.func_147359_a((Packet<?>)new SPacketRespawn(this.field_71093_bK, p_200619_1_.func_175659_aa(), p_200619_1_.func_72912_H().func_76067_t(), this.field_71134_c.func_73081_b()));
            this.field_71133_b.func_184103_al().func_187243_f(this);
            worldserver.removeEntityDangerously(this, true);
            this.revive();
            this.func_70012_b(x, y, z, yaw, pitch);
            if (this.func_70089_S()) {
                worldserver.func_72866_a(this, false);
                p_200619_1_.func_72838_d(this);
                p_200619_1_.func_72866_a(this, false);
            }
            this.func_70029_a(p_200619_1_);
            this.field_71133_b.func_184103_al().func_72375_a(this, worldserver);
            this.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            this.field_71134_c.func_73080_a(p_200619_1_);
            this.field_71133_b.func_184103_al().func_72354_b(this, p_200619_1_);
            this.field_71133_b.func_184103_al().func_72385_f(this);
            BasicEventHooks.firePlayerChangedDimensionEvent((EntityPlayer)this, (DimensionType)p_200619_1_.field_73011_w.func_186058_p(), (DimensionType)this.field_71093_bK);
        }
    }

    private static /* synthetic */ void lambda$null$1(ITextComponent itextcomponent1, Style p_212357_1_) {
        p_212357_1_.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent1));
    }
}

