/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityFishHook
extends Entity {
    private static final DataParameter<Integer> field_184528_c = EntityDataManager.func_187226_a(EntityFishHook.class, DataSerializers.field_187192_b);
    private boolean field_146051_au;
    private int field_146049_av;
    private EntityPlayer field_146042_b;
    private int field_146047_aw;
    private int field_146045_ax;
    private int field_146040_ay;
    private int field_146038_az;
    private float field_146054_aA;
    public Entity field_146043_c;
    private State field_190627_av = State.FLYING;
    private int field_191518_aw;
    private int field_191519_ax;

    private EntityFishHook(World p_i48558_1_) {
        super(EntityType.field_200730_aI, p_i48558_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityFishHook(World worldIn, EntityPlayer p_i47290_2_, double x, double y, double z) {
        this(worldIn);
        this.func_190626_a(p_i47290_2_);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public EntityFishHook(World worldIn, EntityPlayer fishingPlayer) {
        this(worldIn);
        this.func_190626_a(fishingPlayer);
        this.func_190620_n();
    }

    private void func_190626_a(EntityPlayer p_190626_1_) {
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.field_146042_b = p_190626_1_;
        this.field_146042_b.field_71104_cf = this;
    }

    public void func_191516_a(int p_191516_1_) {
        this.field_191519_ax = p_191516_1_;
    }

    public void func_191517_b(int p_191517_1_) {
        this.field_191518_aw = p_191517_1_;
    }

    private void func_190620_n() {
        float f = this.field_146042_b.field_70125_A;
        float f1 = this.field_146042_b.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.field_146042_b.field_70165_t - (double)f3 * 0.3;
        double d1 = this.field_146042_b.field_70163_u + (double)this.field_146042_b.func_70047_e();
        double d2 = this.field_146042_b.field_70161_v - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        this.field_70159_w = -f3;
        this.field_70181_x = MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f);
        this.field_70179_y = -f2;
        float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70181_x *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70179_y *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        float f7 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f7) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184528_c, 0);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184528_c.equals(key)) {
            int i = this.func_184212_Q().func_187225_a(field_184528_c);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0;
        return distance < 4096.0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_146042_b == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.func_190625_o()) {
            if (this.field_146051_au) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_206885_f();
            }
            if (this.field_190627_av == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_190627_av = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.field_190627_av = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_190624_r();
                }
                if (!(this.field_146051_au || this.field_70122_E || this.field_70123_F)) {
                    ++this.field_146047_aw;
                } else {
                    this.field_146047_aw = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.field_190627_av == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.field_190627_av = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.field_190627_av == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.func_190621_a(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.func_190623_q();
            double d1 = 0.92;
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private boolean func_190625_o() {
        ItemStack itemstack = this.field_146042_b.func_184614_ca();
        ItemStack itemstack1 = this.field_146042_b.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof ItemFishingRod;
        boolean flag1 = itemstack1.func_77973_b() instanceof ItemFishingRod;
        if (!this.field_146042_b.field_70128_L && this.field_146042_b.func_70089_S() && (flag || flag1) && !(this.func_70068_e(this.field_146042_b) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void func_190623_q() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void func_190624_r() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_200259_a(vec3d, vec3d1, RayTraceFluidMode.NEVER, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!this.func_189739_a(entity1) || entity1 == this.field_146042_b && this.field_146047_aw < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = raytraceresult.field_72308_g;
                this.func_190622_s();
            } else {
                this.field_146051_au = true;
            }
        }
    }

    private void func_190622_s() {
        this.func_184212_Q().func_187227_b(field_184528_c, this.field_146043_c.func_145782_y() + 1);
    }

    private void func_190621_a(BlockPos p_190621_1_) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= i;
            if (this.field_146038_az > 0) {
                double d2;
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.field_146054_aA * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.field_146038_az * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                if (worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.field_146038_az * 0.1f))).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_195598_a(Particles.field_197612_e, d0, d1 - (double)0.1f, d2, 1, f1, 0.1, f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_195598_a(Particles.field_197630_w, d0, d1, d2, 0, f4, 0.01, -f3, 1.0);
                    worldserver.func_195598_a(Particles.field_197630_w, d0, d1, d2, 0, -f4, 0.01, f3, 1.0);
                }
            } else {
                this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                worldserver.func_195598_a(Particles.field_197612_e, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), this.field_70130_N, 0.0, this.field_70130_N, 0.2f);
                worldserver.func_195598_a(Particles.field_197630_w, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), this.field_70130_N, 0.0, this.field_70130_N, 0.2f);
                this.field_146045_ax = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= i;
            float f5 = 0.15f;
            if (this.field_146040_ay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                if (worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f)))).func_185904_a() == Material.field_151586_h) {
                    worldserver.func_195598_a(Particles.field_197606_Q, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.field_146038_az = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    protected boolean func_189739_a(Entity p_189739_1_) {
        return p_189739_1_.func_70067_L() || p_189739_1_ instanceof EntityItem;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
    }

    public int func_146034_e(ItemStack p_146034_1_) {
        if (!this.field_70170_p.field_72995_K && this.field_146042_b != null) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((EntityPlayerMP)this.field_146042_b, p_146034_1_, this, Collections.emptyList());
                this.field_70170_p.func_72960_a(this, (byte)31);
                i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.field_146045_ax > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_204313_a(new BlockPos((Entity)this));
                lootcontext$builder.func_186469_a((float)this.field_191518_aw + this.field_146042_b.func_184817_da());
                lootcontext$builder.func_186470_a(this.field_146042_b).func_186472_a(this);
                List<ItemStack> list = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a());
                event = new ItemFishedEvent(list, this.field_146051_au ? 2 : 1, this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                CriteriaTriggers.field_204811_D.func_204820_a((EntityPlayerMP)this.field_146042_b, p_146034_1_, this, list);
                for (ItemStack itemstack : list) {
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.field_146042_b.field_70165_t - this.field_70165_t;
                    double d1 = this.field_146042_b.field_70163_u - this.field_70163_u;
                    double d2 = this.field_146042_b.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d4 = 0.1;
                    entityitem.field_70159_w = d0 * 0.1;
                    entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * 0.1;
                    this.field_70170_p.func_72838_d(entityitem);
                    this.field_146042_b.field_70170_p.func_72838_d(new EntityXPOrb(this.field_146042_b.field_70170_p, this.field_146042_b.field_70165_t, this.field_146042_b.field_70163_u + 0.5, this.field_146042_b.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                    this.field_146042_b.func_195067_a(StatList.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_146051_au) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.field_146043_c instanceof EntityPlayer && ((EntityPlayer)this.field_146043_c).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(id);
    }

    protected void func_184527_k() {
        if (this.field_146042_b != null) {
            double d0 = this.field_146042_b.field_70165_t - this.field_70165_t;
            double d1 = this.field_146042_b.field_70163_u - this.field_70163_u;
            double d2 = this.field_146042_b.field_70161_v - this.field_70161_v;
            double d3 = 0.1;
            this.field_146043_c.field_70159_w += d0 * 0.1;
            this.field_146043_c.field_70181_x += d1 * 0.1;
            this.field_146043_c.field_70179_y += d2 * 0.1;
        }
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_146042_b != null) {
            this.field_146042_b.field_71104_cf = null;
        }
    }

    public EntityPlayer func_190619_l() {
        return this.field_146042_b;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

