/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class ContainerEnchantment
extends Container {
    public IInventory field_75168_e = new InventoryBasic((ITextComponent)new TextComponentString("Enchant"), 2){

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
            ContainerEnchantment.this.func_75130_a((IInventory)this);
        }
    };
    private final World field_75172_h;
    private final BlockPos field_178150_j;
    private final Random field_75169_l = new Random();
    public int field_178149_f;
    public int[] field_75167_g = new int[3];
    public int[] field_185001_h = new int[]{-1, -1, -1};
    public int[] field_185002_i = new int[]{-1, -1, -1};

    @OnlyIn(value=Dist.CLIENT)
    public ContainerEnchantment(InventoryPlayer playerInv, World worldIn) {
        this(playerInv, worldIn, BlockPos.field_177992_a);
    }

    public ContainerEnchantment(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        this.field_75172_h = worldIn;
        this.field_178150_j = pos;
        this.field_178149_f = playerInv.field_70458_d.func_175138_ci();
        this.func_75146_a(new Slot(this.field_75168_e, 0, 15, 47){

            @Override
            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            @Override
            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.field_75168_e, 1, 35, 47){

            @Override
            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.GEMS_LAPIS.func_199685_a_(stack.func_77973_b());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot(playerInv, k, 8 + k * 18, 142));
        }
    }

    protected void func_185000_c(IContainerListener crafting) {
        crafting.func_71112_a((Container)this, 0, this.field_75167_g[0]);
        crafting.func_71112_a((Container)this, 1, this.field_75167_g[1]);
        crafting.func_71112_a((Container)this, 2, this.field_75167_g[2]);
        crafting.func_71112_a((Container)this, 3, this.field_178149_f & 0xFFFFFFF0);
        crafting.func_71112_a((Container)this, 4, this.field_185001_h[0]);
        crafting.func_71112_a((Container)this, 5, this.field_185001_h[1]);
        crafting.func_71112_a((Container)this, 6, this.field_185001_h[2]);
        crafting.func_71112_a((Container)this, 7, this.field_185002_i[0]);
        crafting.func_71112_a((Container)this, 8, this.field_185002_i[1]);
        crafting.func_71112_a((Container)this, 9, this.field_185002_i[2]);
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.func_185000_c(listener);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.field_75149_d.get(i);
            this.func_185000_c(icontainerlistener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id >= 0 && id <= 2) {
            this.field_75167_g[id] = data;
        } else if (id == 3) {
            this.field_178149_f = data;
        } else if (id >= 4 && id <= 6) {
            this.field_185001_h[id - 4] = data;
        } else if (id >= 7 && id <= 9) {
            this.field_185002_i[id - 7] = data;
        } else {
            super.func_75137_b(id, data);
        }
    }

    private float getPower(BlockPos pos) {
        return this.field_75172_h.func_180495_p(pos).getEnchantPowerBonus(this.field_75172_h, pos);
    }

    @Override
    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.field_75168_e) {
            ItemStack itemstack = inventoryIn.func_70301_a(0);
            if (!itemstack.func_190926_b() && itemstack.func_77956_u()) {
                if (!this.field_75172_h.field_72995_K) {
                    boolean l = false;
                    float power = 0.0f;
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (j == 0 && k == 0 || !this.field_75172_h.func_175623_d(this.field_178150_j.func_177982_a(k, 0, j)) || !this.field_75172_h.func_175623_d(this.field_178150_j.func_177982_a(k, 1, j))) continue;
                            power += this.getPower(this.field_178150_j.func_177982_a(k * 2, 0, j * 2));
                            power += this.getPower(this.field_178150_j.func_177982_a(k * 2, 1, j * 2));
                            if (k == 0 || j == 0) continue;
                            power += this.getPower(this.field_178150_j.func_177982_a(k * 2, 0, j));
                            power += this.getPower(this.field_178150_j.func_177982_a(k * 2, 1, j));
                            power += this.getPower(this.field_178150_j.func_177982_a(k, 0, j * 2));
                            power += this.getPower(this.field_178150_j.func_177982_a(k, 1, j * 2));
                        }
                    }
                    this.field_75169_l.setSeed(this.field_178149_f);
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.field_75167_g[i1] = EnchantmentHelper.func_77514_a(this.field_75169_l, i1, (int)power, itemstack);
                        this.field_185001_h[i1] = -1;
                        this.field_185002_i[i1] = -1;
                        if (this.field_75167_g[i1] < i1 + 1) {
                            this.field_75167_g[i1] = 0;
                        }
                        this.field_75167_g[i1] = ForgeEventFactory.onEnchantmentLevelSet((World)this.field_75172_h, (BlockPos)this.field_178150_j, (int)i1, (int)((int)power), (ItemStack)itemstack, (int)this.field_75167_g[i1]);
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list;
                        if (this.field_75167_g[j1] <= 0 || (list = this.func_178148_a(itemstack, j1, this.field_75167_g[j1])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.field_75169_l.nextInt(list.size()));
                        this.field_185001_h[j1] = IRegistry.field_212628_q.func_148757_b(enchantmentdata.field_76302_b);
                        this.field_185002_i[j1] = enchantmentdata.field_76303_c;
                    }
                    this.func_75142_b();
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.field_75167_g[i] = 0;
                    this.field_185001_h[i] = -1;
                    this.field_185002_i[i] = -1;
                }
            }
        }
    }

    @Override
    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        ItemStack itemstack = this.field_75168_e.func_70301_a(0);
        ItemStack itemstack1 = this.field_75168_e.func_70301_a(1);
        int i = id + 1;
        if ((itemstack1.func_190926_b() || itemstack1.func_190916_E() < i) && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.field_75167_g[id] > 0 && !itemstack.func_190926_b() && (playerIn.field_71068_ca >= i && playerIn.field_71068_ca >= this.field_75167_g[id] || playerIn.field_71075_bZ.field_75098_d)) {
            List<EnchantmentData> list;
            if (!this.field_75172_h.field_72995_K && !(list = this.func_178148_a(itemstack, id, this.field_75167_g[id])).isEmpty()) {
                boolean flag;
                playerIn.func_192024_a(itemstack, i);
                boolean bl = flag = itemstack.func_77973_b() == Items.field_151122_aG;
                if (flag) {
                    itemstack = new ItemStack(Items.field_151134_bR);
                    this.field_75168_e.func_70299_a(0, itemstack);
                }
                for (int j = 0; j < list.size(); ++j) {
                    EnchantmentData enchantmentdata = list.get(j);
                    if (flag) {
                        ItemEnchantedBook.func_92115_a((ItemStack)itemstack, (EnchantmentData)enchantmentdata);
                        continue;
                    }
                    itemstack.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack1.func_190918_g(i);
                    if (itemstack1.func_190926_b()) {
                        this.field_75168_e.func_70299_a(1, ItemStack.field_190927_a);
                    }
                }
                playerIn.func_195066_a(StatList.field_188091_Y);
                if (playerIn instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_192129_i.func_192190_a((EntityPlayerMP)playerIn, itemstack, i);
                }
                this.field_75168_e.func_70296_d();
                this.field_178149_f = playerIn.func_175138_ci();
                this.func_75130_a(this.field_75168_e);
                this.field_75172_h.func_184133_a(null, this.field_178150_j, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, this.field_75172_h.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private List<EnchantmentData> func_178148_a(ItemStack stack, int enchantSlot, int level) {
        this.field_75169_l.setSeed(this.field_178149_f + enchantSlot);
        List<EnchantmentData> list = EnchantmentHelper.func_77513_b(this.field_75169_l, stack, level, false);
        if (stack.func_77973_b() == Items.field_151122_aG && list.size() > 1) {
            list.remove(this.field_75169_l.nextInt(list.size()));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_178147_e() {
        ItemStack itemstack = this.field_75168_e.func_70301_a(1);
        return itemstack.func_190926_b() ? 0 : itemstack.func_190916_E();
    }

    @Override
    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.field_75172_h.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, this.field_75168_e);
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.field_75172_h.func_180495_p(this.field_178150_j).func_177230_c() != Blocks.field_150381_bn) {
            return false;
        }
        return !(playerIn.func_70092_e((double)this.field_178150_j.func_177958_n() + 0.5, (double)this.field_178150_j.func_177956_o() + 0.5, (double)this.field_178150_j.func_177952_p() + 0.5) > 64.0);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Items.field_196128_bn) {
                if (!this.func_75135_a(itemstack1, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack1.func_77979_a(1));
                } else if (!itemstack1.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(new ItemStack(itemstack1.func_77973_b()));
                    itemstack1.func_190918_g(1);
                }
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

