/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemArmor
extends Item {
    private static final UUID[] field_185084_n = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final IBehaviorDispenseItem field_96605_cw = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemArmor.func_185082_a(source, stack);
            return itemstack.func_190926_b() ? super.func_82487_b(source, stack) : itemstack;
        }
    };
    protected final EntityEquipmentSlot field_77881_a;
    protected final int field_77879_b;
    protected final float field_189415_e;
    protected final IArmorMaterial field_200882_e;

    public static ItemStack func_185082_a(IBlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.func_180699_d().func_177972_a((EnumFacing)((Object)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)));
        List<EntityLivingBase> list = blockSource.func_197524_h().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(blockpos), EntitySelectors.field_180132_d.and(new EntitySelectors.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        EntityLivingBase entitylivingbase = list.get(0);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(stack);
        ItemStack itemstack = stack.func_77979_a(1);
        entitylivingbase.func_184201_a(entityequipmentslot, itemstack);
        if (entitylivingbase instanceof EntityLiving) {
            ((EntityLiving)entitylivingbase).func_184642_a(entityequipmentslot, 2.0f);
            ((EntityLiving)entitylivingbase).func_110163_bv();
        }
        return stack;
    }

    public ItemArmor(IArmorMaterial materialIn, EntityEquipmentSlot slots, Item.Properties builder) {
        super(builder.func_200915_b(materialIn.func_200896_a(slots)));
        this.field_200882_e = materialIn;
        this.field_77881_a = slots;
        this.field_77879_b = materialIn.func_200902_b(slots);
        this.field_189415_e = materialIn.func_200901_e();
        BlockDispenser.func_199774_a((IItemProvider)this, (IBehaviorDispenseItem)field_96605_cw);
    }

    public EntityEquipmentSlot func_185083_B_() {
        return this.field_77881_a;
    }

    @Override
    public int func_77619_b() {
        return this.field_200882_e.func_200900_a();
    }

    public IArmorMaterial func_200880_d() {
        return this.field_200882_e;
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.field_200882_e.func_200898_c().test(repair) || super.func_82789_a(toRepair, repair);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(itemstack);
        ItemStack itemstack1 = playerIn.func_184582_a(entityequipmentslot);
        if (itemstack1.func_190926_b()) {
            playerIn.func_184201_a(entityequipmentslot, itemstack.func_77946_l());
            itemstack.func_190920_e(0);
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
    }

    @Override
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(field_185084_n[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(field_185084_n[equipmentSlot.func_188454_b()], "Armor toughness", (double)this.field_189415_e, 0));
        }
        return multimap;
    }

    public int func_200881_e() {
        return this.field_77879_b;
    }

    public float getToughness() {
        return this.field_189415_e;
    }
}

