/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMap
extends ItemMapBase {
    public ItemMap(Item.Properties builder) {
        super(builder);
    }

    public static ItemStack func_195952_a(World p_195952_0_, int p_195952_1_, int p_195952_2_, byte p_195952_3_, boolean p_195952_4_, boolean p_195952_5_) {
        ItemStack itemstack = new ItemStack(Items.field_151098_aY);
        ItemMap.func_195951_a(itemstack, p_195952_0_, p_195952_1_, p_195952_2_, p_195952_3_, p_195952_4_, p_195952_5_, p_195952_0_.field_73011_w.func_186058_p());
        return itemstack;
    }

    @Nullable
    public static MapData func_195950_a(ItemStack p_195950_0_, World p_195950_1_) {
        Item map = p_195950_0_.func_77973_b();
        if (map instanceof ItemMap) {
            return ((ItemMap)((Object)map)).getCustomMapData(p_195950_0_, p_195950_1_);
        }
        return null;
    }

    @Nullable
    protected MapData getCustomMapData(ItemStack p_195950_0_, World p_195950_1_) {
        MapData mapdata = ItemMap.func_195953_a(p_195950_1_, "map_" + ItemMap.func_195949_f(p_195950_0_));
        if (mapdata == null && !p_195950_1_.field_72995_K) {
            mapdata = ItemMap.func_195951_a(p_195950_0_, p_195950_1_, p_195950_1_.func_72912_H().func_76079_c(), p_195950_1_.func_72912_H().func_76074_e(), 3, false, false, p_195950_1_.field_73011_w.func_186058_p());
        }
        return mapdata;
    }

    public static int func_195949_f(ItemStack p_195949_0_) {
        NBTTagCompound nbttagcompound = p_195949_0_.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("map", 99) ? nbttagcompound.func_74762_e("map") : 0;
    }

    private static MapData func_195951_a(ItemStack p_195951_0_, World p_195951_1_, int p_195951_2_, int p_195951_3_, int p_195951_4_, boolean p_195951_5_, boolean p_195951_6_, DimensionType p_195951_7_) {
        int i = p_195951_1_.func_212410_a(DimensionType.OVERWORLD, "map");
        MapData mapdata = new MapData("map_" + i);
        mapdata.func_212440_a(p_195951_2_, p_195951_3_, p_195951_4_, p_195951_5_, p_195951_6_, p_195951_7_);
        p_195951_1_.func_212409_a(DimensionType.OVERWORLD, mapdata.func_195925_e(), mapdata);
        p_195951_0_.func_196082_o().func_74768_a("map", i);
        return mapdata;
    }

    @Nullable
    public static MapData func_195953_a(IWorld worldIn, String mapId) {
        return (MapData)worldIn.func_212411_a(DimensionType.OVERWORLD, MapData::new, mapId);
    }

    public void func_77872_a(World worldIn, Entity viewer, MapData data) {
        if (worldIn.field_73011_w.func_186058_p() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int i = 1 << data.field_76197_d;
            int j = data.field_76201_a;
            int k = data.field_76199_b;
            int l = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)j)) / i + 64;
            int i1 = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)k)) / i + 64;
            int j1 = 128 / i;
            if (worldIn.field_73011_w.func_177495_o()) {
                j1 /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int k1 = l - j1 + 1; k1 < l + j1; ++k1) {
                if ((k1 & 0xF) != (mapdata$mapinfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    byte b1;
                    byte b0;
                    MaterialColor materialcolor;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i2 = k1 - l;
                    int j2 = l1 - i1;
                    boolean flag1 = i2 * i2 + j2 * j2 > (j1 - 2) * (j1 - 2);
                    int k2 = (j / i + k1 - 64) * i;
                    int l2 = (k / i + l1 - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk chunk = worldIn.func_175726_f(new BlockPos(k2, 0, l2));
                    if (chunk.func_76621_g()) continue;
                    int i3 = k2 & 0xF;
                    int j3 = l2 & 0xF;
                    int k3 = 0;
                    double d1 = 0.0;
                    if (worldIn.field_73011_w.func_177495_o()) {
                        int l3 = k2 + l2 * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_185909_g((IBlockReader)worldIn, BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_185909_g((IBlockReader)worldIn, BlockPos.field_177992_a), 100);
                        }
                        d1 = 100.0;
                    } else {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int i4 = 0; i4 < i; ++i4) {
                            for (int j4 = 0; j4 < i; ++j4) {
                                IBlockState iblockstate;
                                int k4 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, i4 + i3, j4 + j3) + 1;
                                if (k4 <= 1) {
                                    iblockstate = Blocks.field_150357_h.func_176223_P();
                                } else {
                                    do {
                                        iblockstate = chunk.func_186032_a(i4 + i3, --k4, j4 + j3);
                                        blockpos$mutableblockpos.func_181079_c((chunk.field_76635_g << 4) + i4 + i3, k4, (chunk.field_76647_h << 4) + j4 + j3);
                                    } while (iblockstate.func_185909_g((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) == MaterialColor.field_151660_b && k4 > 0);
                                    if (k4 > 0 && !iblockstate.func_204520_s().func_206888_e()) {
                                        IBlockState iblockstate1;
                                        int l4 = k4 - 1;
                                        do {
                                            iblockstate1 = chunk.func_186032_a(i4 + i3, l4--, j4 + j3);
                                            ++k3;
                                        } while (l4 > 0 && !iblockstate1.func_204520_s().func_206888_e());
                                        iblockstate = this.func_211698_a(worldIn, iblockstate, (BlockPos)blockpos$mutableblockpos);
                                    }
                                }
                                data.func_204268_a((IBlockReader)worldIn, (chunk.field_76635_g << 4) + i4 + i3, (chunk.field_76647_h << 4) + j4 + j3);
                                d1 += (double)k4 / (double)(i * i);
                                multiset.add((Object)iblockstate.func_185909_g((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos));
                            }
                        }
                    }
                    k3 /= i * i;
                    double d2 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4;
                    int i5 = 1;
                    if (d2 > 0.6) {
                        i5 = 2;
                    }
                    if (d2 < -0.6) {
                        i5 = 0;
                    }
                    if ((materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.field_151660_b)) == MaterialColor.field_151662_n) {
                        d2 = (double)k3 * 0.1 + (double)(k1 + l1 & 1) * 0.2;
                        i5 = 1;
                        if (d2 < 0.5) {
                            i5 = 2;
                        }
                        if (d2 > 0.9) {
                            i5 = 0;
                        }
                    }
                    d0 = d1;
                    if (l1 < 0 || i2 * i2 + j2 * j2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0 || (b0 = data.field_76198_e[k1 + l1 * 128]) == (b1 = (byte)(materialcolor.field_76290_q * 4 + i5))) continue;
                    data.field_76198_e[k1 + l1 * 128] = b1;
                    data.func_176053_a(k1, l1);
                    flag = true;
                }
            }
        }
    }

    private IBlockState func_211698_a(World p_211698_1_, IBlockState p_211698_2_, BlockPos p_211698_3_) {
        IFluidState ifluidstate = p_211698_2_.func_204520_s();
        return !ifluidstate.func_206888_e() && !Block.func_208061_a(p_211698_2_.func_196952_d((IBlockReader)p_211698_1_, p_211698_3_), EnumFacing.UP) ? ifluidstate.func_206883_i() : p_211698_2_;
    }

    private static boolean func_195954_a(Biome[] p_195954_0_, int p_195954_1_, int p_195954_2_, int p_195954_3_) {
        return p_195954_0_[p_195954_2_ * p_195954_1_ + p_195954_3_ * p_195954_1_ * 128 * p_195954_1_].func_185355_j() >= 0.0f;
    }

    public static void func_190905_a(World worldIn, ItemStack map) {
        MapData mapdata = ItemMap.func_195950_a(map, worldIn);
        if (mapdata != null && worldIn.field_73011_w.func_186058_p() == mapdata.field_76200_c) {
            int i = 1 << mapdata.field_76197_d;
            int j = mapdata.field_76201_a;
            int k = mapdata.field_76199_b;
            Biome[] abiome = worldIn.func_72863_F().func_201711_g().func_202090_b().func_201537_a((j / i - 64) * i, (k / i - 64) * i, 128 * i, 128 * i, false);
            for (int l = 0; l < 128; ++l) {
                for (int i1 = 0; i1 < 128; ++i1) {
                    if (l <= 0 || i1 <= 0 || l >= 127 || i1 >= 127) continue;
                    Biome biome = abiome[l * i + i1 * i * 128 * i];
                    int j1 = 8;
                    if (ItemMap.func_195954_a(abiome, i, l - 1, i1 - 1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l - 1, i1 + 1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l - 1, i1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l + 1, i1 - 1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l + 1, i1 + 1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l + 1, i1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l, i1 - 1)) {
                        --j1;
                    }
                    if (ItemMap.func_195954_a(abiome, i, l, i1 + 1)) {
                        --j1;
                    }
                    int k1 = 3;
                    MaterialColor materialcolor = MaterialColor.field_151660_b;
                    if (biome.func_185355_j() < 0.0f) {
                        materialcolor = MaterialColor.field_151676_q;
                        if (j1 > 7 && i1 % 2 == 0) {
                            k1 = (l + (int)(MathHelper.func_76126_a((float)((float)i1 + 0.0f)) * 7.0f)) / 8 % 5;
                            if (k1 == 3) {
                                k1 = 1;
                            } else if (k1 == 4) {
                                k1 = 0;
                            }
                        } else if (j1 > 7) {
                            materialcolor = MaterialColor.field_151660_b;
                        } else if (j1 > 5) {
                            k1 = 1;
                        } else if (j1 > 3) {
                            k1 = 0;
                        } else if (j1 > 1) {
                            k1 = 0;
                        }
                    } else if (j1 > 0) {
                        materialcolor = MaterialColor.field_151650_B;
                        k1 = j1 > 3 ? 1 : 3;
                    }
                    if (materialcolor == MaterialColor.field_151660_b) continue;
                    mapdata.field_76198_e[l + i1 * 128] = (byte)(materialcolor.field_76290_q * 4 + k1);
                    mapdata.func_176053_a(l, i1);
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            MapData mapdata = ItemMap.func_195950_a(stack, worldIn);
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                mapdata.func_76191_a(entityplayer, stack);
            }
            if (isSelected || entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack) {
                this.func_77872_a(worldIn, entityIn, mapdata);
            }
        }
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        return ItemMap.func_195950_a(stack, worldIn).func_176052_a(stack, (IBlockReader)worldIn, player);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("map_scale_direction", 99)) {
            ItemMap.func_185063_a(stack, worldIn, nbttagcompound.func_74762_e("map_scale_direction"));
            nbttagcompound.func_82580_o("map_scale_direction");
        }
    }

    protected static void func_185063_a(ItemStack p_185063_0_, World p_185063_1_, int p_185063_2_) {
        MapData mapdata = ItemMap.func_195950_a(p_185063_0_, p_185063_1_);
        if (mapdata != null) {
            ItemMap.func_195951_a(p_185063_0_, p_185063_1_, mapdata.field_76201_a, mapdata.field_76199_b, MathHelper.func_76125_a((int)(mapdata.field_76197_d + p_185063_2_), (int)0, (int)4), mapdata.field_186210_e, mapdata.field_191096_f, mapdata.field_76200_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            MapData mapdata;
            MapData mapData = mapdata = worldIn == null ? null : ItemMap.func_195950_a(stack, worldIn);
            if (mapdata != null) {
                tooltip.add(new TextComponentTranslation("filled_map.id", ItemMap.func_195949_f(stack)).func_211708_a(TextFormatting.GRAY));
                tooltip.add(new TextComponentTranslation("filled_map.scale", 1 << mapdata.field_76197_d).func_211708_a(TextFormatting.GRAY));
                tooltip.add(new TextComponentTranslation("filled_map.level", mapdata.field_76197_d, 4).func_211708_a(TextFormatting.GRAY));
            } else {
                tooltip.add(new TextComponentTranslation("filled_map.unknown", new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_190907_h(ItemStack p_190907_0_) {
        NBTTagCompound nbttagcompound = p_190907_0_.func_179543_a("display");
        if (nbttagcompound != null && nbttagcompound.func_150297_b("MapColor", 99)) {
            int i = nbttagcompound.func_74762_e("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }

    public EnumActionResult func_195939_a(ItemUseContext p_195939_1_) {
        IBlockState iblockstate = p_195939_1_.func_195991_k().func_180495_p(p_195939_1_.func_195995_a());
        if (iblockstate.func_203425_a(BlockTags.field_202897_p)) {
            if (!p_195939_1_.field_196006_g.field_72995_K) {
                MapData mapdata = ItemMap.func_195950_a(p_195939_1_.func_195996_i(), p_195939_1_.func_195991_k());
                mapdata.func_204269_a(p_195939_1_.func_195991_k(), p_195939_1_.func_195995_a());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_195939_a(p_195939_1_);
    }
}

