/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.IRegistry;

public class RecipeItemHelper {
    public final Int2IntMap field_194124_a = new Int2IntOpenHashMap();

    public void func_195932_a(ItemStack p_195932_1_) {
        if (!(p_195932_1_.func_77951_h() || p_195932_1_.func_77948_v() || p_195932_1_.func_82837_s())) {
            this.func_194112_a(p_195932_1_);
        }
    }

    public void func_194112_a(ItemStack stack) {
        this.accountStack(stack, -1);
    }

    public void accountStack(ItemStack stack, int forceCount) {
        if (!stack.func_190926_b()) {
            int i = RecipeItemHelper.func_194113_b(stack);
            int j = forceCount == -1 ? stack.func_190916_E() : forceCount;
            this.func_194117_b(i, j);
        }
    }

    public static int func_194113_b(ItemStack stack) {
        return IRegistry.field_212630_s.func_148757_b(stack.func_77973_b());
    }

    public boolean func_194120_a(int packedItem) {
        return this.field_194124_a.get(packedItem) > 0;
    }

    public int func_194122_a(int packedItem, int maximum) {
        int i = this.field_194124_a.get(packedItem);
        if (i >= maximum) {
            this.field_194124_a.put(packedItem, i - maximum);
            return packedItem;
        }
        return 0;
    }

    private void func_194117_b(int packedItem, int amount) {
        this.field_194124_a.put(packedItem, this.field_194124_a.get(packedItem) + amount);
    }

    public boolean func_194116_a(IRecipe recipe, @Nullable IntList packedItemList) {
        return this.func_194118_a(recipe, packedItemList, 1);
    }

    public boolean func_194118_a(IRecipe recipe, @Nullable IntList packedItemList, int maxAmount) {
        return new RecipePicker(recipe).func_194092_a(maxAmount, packedItemList);
    }

    public int func_194114_b(IRecipe recipe, @Nullable IntList packedItemList) {
        return this.func_194121_a(recipe, Integer.MAX_VALUE, packedItemList);
    }

    public int func_194121_a(IRecipe recipe, int maxAmount, @Nullable IntList packedItemList) {
        return new RecipePicker(recipe).func_194102_b(maxAmount, packedItemList);
    }

    public static ItemStack func_194115_b(int packedItem) {
        return packedItem == 0 ? ItemStack.field_190927_a : new ItemStack(Item.func_150899_d(packedItem));
    }

    public void func_194119_a() {
        this.field_194124_a.clear();
    }

    class RecipePicker {
        private final IRecipe field_194105_b;
        private final List<Ingredient> field_194106_c = Lists.newArrayList();
        private final int field_194107_d;
        private final int[] field_194108_e;
        private final int field_194109_f;
        private final BitSet field_194110_g;
        private final IntList field_194111_h = new IntArrayList();

        public RecipePicker(IRecipe recipeIn) {
            this.field_194105_b = recipeIn;
            this.field_194106_c.addAll((Collection<Ingredient>)recipeIn.func_192400_c());
            this.field_194106_c.removeIf(Ingredient::func_203189_d);
            this.field_194107_d = this.field_194106_c.size();
            this.field_194108_e = this.func_194097_a();
            this.field_194109_f = this.field_194108_e.length;
            this.field_194110_g = new BitSet(this.field_194107_d + this.field_194109_f + this.field_194107_d + this.field_194107_d * this.field_194109_f);
            for (int i = 0; i < this.field_194106_c.size(); ++i) {
                IntList intlist = this.field_194106_c.get(i).func_194139_b();
                for (int j = 0; j < this.field_194109_f; ++j) {
                    if (!intlist.contains(this.field_194108_e[j])) continue;
                    this.field_194110_g.set(this.func_194095_d(true, j, i));
                }
            }
        }

        public boolean func_194092_a(int maxAmount, @Nullable IntList listIn) {
            boolean flag1;
            if (maxAmount <= 0) {
                return true;
            }
            int i = 0;
            while (this.func_194098_a(maxAmount)) {
                RecipeItemHelper.this.func_194122_a(this.field_194108_e[this.field_194111_h.getInt(0)], maxAmount);
                int j = this.field_194111_h.size() - 1;
                this.func_194096_c(this.field_194111_h.getInt(j));
                for (int k = 0; k < j; ++k) {
                    this.func_194089_c((k & 1) == 0, this.field_194111_h.get(k), this.field_194111_h.get(k + 1));
                }
                this.field_194111_h.clear();
                this.field_194110_g.clear(0, this.field_194107_d + this.field_194109_f);
                ++i;
            }
            boolean flag = i == this.field_194107_d;
            boolean bl = flag1 = flag && listIn != null;
            if (flag1) {
                listIn.clear();
            }
            this.field_194110_g.clear(0, this.field_194107_d + this.field_194109_f + this.field_194107_d);
            int l = 0;
            NonNullList<Ingredient> list = this.field_194105_b.func_192400_c();
            for (int i1 = 0; i1 < list.size(); ++i1) {
                if (flag1 && ((Ingredient)list.get(i1)).func_203189_d()) {
                    listIn.add(0);
                    continue;
                }
                for (int j1 = 0; j1 < this.field_194109_f; ++j1) {
                    if (!this.func_194100_b(false, l, j1)) continue;
                    this.func_194089_c(true, j1, l);
                    RecipeItemHelper.this.func_194117_b(this.field_194108_e[j1], maxAmount);
                    if (!flag1) continue;
                    listIn.add(this.field_194108_e[j1]);
                }
                ++l;
            }
            return flag;
        }

        private int[] func_194097_a() {
            IntAVLTreeSet intcollection = new IntAVLTreeSet();
            for (Ingredient ingredient : this.field_194106_c) {
                intcollection.addAll((IntCollection)ingredient.func_194139_b());
            }
            IntIterator intiterator = intcollection.iterator();
            while (intiterator.hasNext()) {
                if (RecipeItemHelper.this.func_194120_a(intiterator.nextInt())) continue;
                intiterator.remove();
            }
            return intcollection.toIntArray();
        }

        private boolean func_194098_a(int amount) {
            int i = this.field_194109_f;
            for (int j = 0; j < i; ++j) {
                if (RecipeItemHelper.this.field_194124_a.get(this.field_194108_e[j]) < amount) continue;
                this.func_194088_a(false, j);
                while (!this.field_194111_h.isEmpty()) {
                    int k1;
                    int k = this.field_194111_h.size();
                    boolean flag = (k & 1) == 1;
                    int l = this.field_194111_h.getInt(k - 1);
                    if (!flag && !this.func_194091_b(l)) break;
                    int i1 = flag ? this.field_194107_d : i;
                    for (int j1 = 0; j1 < i1; ++j1) {
                        if (this.func_194101_b(flag, j1) || !this.func_194093_a(flag, l, j1) || !this.func_194100_b(flag, l, j1)) continue;
                        this.func_194088_a(flag, j1);
                        break;
                    }
                    if ((k1 = this.field_194111_h.size()) != k) continue;
                    this.field_194111_h.removeInt(k1 - 1);
                }
                if (this.field_194111_h.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean func_194091_b(int p_194091_1_) {
            return this.field_194110_g.get(this.func_194094_d(p_194091_1_));
        }

        private void func_194096_c(int p_194096_1_) {
            this.field_194110_g.set(this.func_194094_d(p_194096_1_));
        }

        private int func_194094_d(int p_194094_1_) {
            return this.field_194107_d + this.field_194109_f + p_194094_1_;
        }

        private boolean func_194093_a(boolean p_194093_1_, int p_194093_2_, int p_194093_3_) {
            return this.field_194110_g.get(this.func_194095_d(p_194093_1_, p_194093_2_, p_194093_3_));
        }

        private boolean func_194100_b(boolean p_194100_1_, int p_194100_2_, int p_194100_3_) {
            return p_194100_1_ != this.field_194110_g.get(1 + this.func_194095_d(p_194100_1_, p_194100_2_, p_194100_3_));
        }

        private void func_194089_c(boolean p_194089_1_, int p_194089_2_, int p_194089_3_) {
            this.field_194110_g.flip(1 + this.func_194095_d(p_194089_1_, p_194089_2_, p_194089_3_));
        }

        private int func_194095_d(boolean p_194095_1_, int p_194095_2_, int p_194095_3_) {
            int i = p_194095_1_ ? p_194095_2_ * this.field_194107_d + p_194095_3_ : p_194095_3_ * this.field_194107_d + p_194095_2_;
            return this.field_194107_d + this.field_194109_f + this.field_194107_d + 2 * i;
        }

        private void func_194088_a(boolean p_194088_1_, int p_194088_2_) {
            this.field_194110_g.set(this.func_194099_c(p_194088_1_, p_194088_2_));
            this.field_194111_h.add(p_194088_2_);
        }

        private boolean func_194101_b(boolean p_194101_1_, int p_194101_2_) {
            return this.field_194110_g.get(this.func_194099_c(p_194101_1_, p_194101_2_));
        }

        private int func_194099_c(boolean p_194099_1_, int p_194099_2_) {
            return (p_194099_1_ ? 0 : this.field_194107_d) + p_194099_2_;
        }

        public int func_194102_b(int p_194102_1_, @Nullable IntList list) {
            int i = 0;
            int j = Math.min(p_194102_1_, this.func_194090_b()) + 1;
            while (true) {
                int k;
                if (this.func_194092_a(k = (i + j) / 2, null)) {
                    if (j - i <= 1) {
                        if (k > 0) {
                            this.func_194092_a(k, list);
                        }
                        return k;
                    }
                    i = k;
                    continue;
                }
                j = k;
            }
        }

        private int func_194090_b() {
            int i = Integer.MAX_VALUE;
            for (Ingredient ingredient : this.field_194106_c) {
                int j = 0;
                IntListIterator intListIterator = ingredient.func_194139_b().iterator();
                while (intListIterator.hasNext()) {
                    int k = (Integer)intListIterator.next();
                    j = Math.max(j, RecipeItemHelper.this.field_194124_a.get(k));
                }
                if (i <= 0) continue;
                i = Math.min(i, j);
            }
            return i;
        }
    }
}

