/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import net.minecraft.client.network.NetHandlerHandshakeMemory;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.INetHandler;
import net.minecraft.network.LegacyPingHandler;
import net.minecraft.network.NetHandlerHandshakeTCP;
import net.minecraft.network.NettyPacketDecoder;
import net.minecraft.network.NettyPacketEncoder;
import net.minecraft.network.NettyVarint21FrameDecoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkSystem {
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("forge.readTimeout", "30"));
    private static final Logger field_151275_b = LogManager.getLogger();
    public static final LazyLoadBase<NioEventLoopGroup> field_151276_c = new LazyLoadBase(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).setThreadFactory((ThreadFactory)SidedThreadGroups.SERVER).build()));
    public static final LazyLoadBase<EpollEventLoopGroup> field_181141_b = new LazyLoadBase(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).setThreadFactory((ThreadFactory)SidedThreadGroups.SERVER).build()));
    private final MinecraftServer field_151273_d;
    public volatile boolean field_151277_a;
    private final List<ChannelFuture> field_151274_e = Collections.synchronizedList(Lists.newArrayList());
    private final List<NetworkManager> field_151272_f = Collections.synchronizedList(Lists.newArrayList());

    public NetworkSystem(MinecraftServer server) {
        this.field_151273_d = server;
        this.field_151277_a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_151265_a(@Nullable InetAddress address, int port) throws IOException {
        if (address instanceof Inet6Address) {
            System.setProperty("java.net.preferIPv4Stack", "false");
        }
        List<ChannelFuture> list = this.field_151274_e;
        synchronized (list) {
            LazyLoadBase<NioEventLoopGroup> lazyloadbase;
            Class<NioServerSocketChannel> oclass;
            if (Epoll.isAvailable() && this.field_151273_d.func_181035_ah()) {
                oclass = EpollServerSocketChannel.class;
                lazyloadbase = field_181141_b;
                field_151275_b.info("Using epoll channel type");
            } else {
                oclass = NioServerSocketChannel.class;
                lazyloadbase = field_151276_c;
                field_151275_b.info("Using default channel type");
            }
            this.field_151274_e.add(((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(oclass)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel p_initChannel_1_) throws Exception {
                    try {
                        p_initChannel_1_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    p_initChannel_1_.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(READ_TIMEOUT)).addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(NetworkSystem.this)).addLast("splitter", (ChannelHandler)new NettyVarint21FrameDecoder()).addLast("decoder", (ChannelHandler)new NettyPacketDecoder(EnumPacketDirection.SERVERBOUND)).addLast("prepender", (ChannelHandler)new NettyVarint21FrameEncoder()).addLast("encoder", (ChannelHandler)new NettyPacketEncoder(EnumPacketDirection.CLIENTBOUND));
                    NetworkManager networkmanager = new NetworkManager(EnumPacketDirection.SERVERBOUND);
                    NetworkSystem.this.field_151272_f.add(networkmanager);
                    p_initChannel_1_.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
                    networkmanager.func_150719_a((INetHandler)new NetHandlerHandshakeTCP(NetworkSystem.this.field_151273_d, networkmanager));
                }
            }).group((EventLoopGroup)lazyloadbase.func_179281_c()).localAddress(address, port)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public SocketAddress func_151270_a() {
        ChannelFuture channelfuture;
        List<ChannelFuture> list = this.field_151274_e;
        synchronized (list) {
            channelfuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel p_initChannel_1_) throws Exception {
                    NetworkManager networkmanager = new NetworkManager(EnumPacketDirection.SERVERBOUND);
                    networkmanager.func_150719_a((INetHandler)new NetHandlerHandshakeMemory(NetworkSystem.this.field_151273_d, networkmanager));
                    NetworkSystem.this.field_151272_f.add(networkmanager);
                    p_initChannel_1_.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
                }
            }).group((EventLoopGroup)field_151276_c.func_179281_c()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.field_151274_e.add(channelfuture);
        }
        return channelfuture.channel().localAddress();
    }

    public void func_151268_b() {
        this.field_151277_a = false;
        for (ChannelFuture channelfuture : this.field_151274_e) {
            try {
                channelfuture.channel().close().sync();
            }
            catch (InterruptedException var4) {
                field_151275_b.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_151269_c() {
        List<NetworkManager> list = this.field_151272_f;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_151272_f.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.func_179291_h()) continue;
                if (networkmanager.func_150724_d()) {
                    try {
                        networkmanager.func_74428_b();
                    }
                    catch (Exception exception) {
                        if (networkmanager.func_150731_c()) {
                            CrashReport crashreport = CrashReport.func_85055_a(exception, "Ticking memory connection");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Ticking connection");
                            crashreportcategory.func_189529_a("Connection", (ICrashReportDetail<String>)((ICrashReportDetail)() -> networkmanager.toString()));
                            throw new ReportedException(crashreport);
                        }
                        field_151275_b.warn("Failed to handle packet for {}", (Object)networkmanager.func_74430_c(), (Object)exception);
                        TextComponentString itextcomponent = new TextComponentString("Internal server error");
                        networkmanager.func_201058_a((Packet<?>)new SPacketDisconnect((ITextComponent)itextcomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> NetworkSystem.lambda$tick$2(networkmanager, (ITextComponent)itextcomponent, arg_0)));
                        networkmanager.func_150721_g();
                    }
                    continue;
                }
                iterator.remove();
                networkmanager.func_179293_l();
            }
        }
    }

    public MinecraftServer func_151267_d() {
        return this.field_151273_d;
    }

    private static /* synthetic */ void lambda$tick$2(NetworkManager networkmanager, ITextComponent itextcomponent, Future p_210474_2_) throws Exception {
        networkmanager.func_150718_a(itextcomponent);
    }
}

