/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataManager {
    private static final Logger field_190303_a = LogManager.getLogger();
    private static final Map<Class<? extends Entity>, Integer> field_187232_a = Maps.newHashMap();
    private final Entity field_187233_b;
    private final Map<Integer, DataEntry<?>> field_187234_c = Maps.newHashMap();
    private final ReadWriteLock field_187235_d = new ReentrantReadWriteLock();
    private boolean field_187236_e = true;
    private boolean field_187237_f;

    public EntityDataManager(Entity entityIn) {
        this.field_187233_b = entityIn;
    }

    public static <T> DataParameter<T> func_187226_a(Class<? extends Entity> clazz, DataSerializer<T> serializer) {
        int j;
        try {
            Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
            if (!oclass.equals(clazz)) {
                if (field_190303_a.isDebugEnabled()) {
                    field_190303_a.warn("defineId called for: {} from {}", clazz, oclass, (Object)new RuntimeException());
                } else {
                    field_190303_a.warn("defineId called for: {} from {}", clazz, oclass);
                }
            }
        }
        catch (ClassNotFoundException oclass) {
            // empty catch block
        }
        if (field_187232_a.containsKey(clazz)) {
            j = field_187232_a.get(clazz) + 1;
        } else {
            int i = 0;
            Class<? extends Entity> oclass1 = clazz;
            while (oclass1 != Entity.class) {
                if (!field_187232_a.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i = field_187232_a.get(oclass1) + 1;
                break;
            }
            j = i;
        }
        if (j > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j + "! (Max is " + 254 + ")");
        }
        field_187232_a.put(clazz, j);
        return serializer.func_187161_a(j);
    }

    public <T> void func_187214_a(DataParameter<T> key, T value) {
        int i = key.func_187155_a();
        if (i > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is " + 254 + ")");
        }
        if (this.field_187234_c.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        if (DataSerializers.func_187188_b(key.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + key.func_187156_b() + " for " + i + "!");
        }
        this.func_187222_c(key, value);
    }

    private <T> void func_187222_c(DataParameter<T> key, T value) {
        DataEntry<T> dataentry = new DataEntry<T>(key, value);
        this.field_187235_d.writeLock().lock();
        this.field_187234_c.put(key.func_187155_a(), dataentry);
        this.field_187236_e = false;
        this.field_187235_d.writeLock().unlock();
    }

    private <T> DataEntry<T> func_187219_c(DataParameter<T> key) {
        DataEntry<?> dataentry;
        this.field_187235_d.readLock().lock();
        try {
            dataentry = this.field_187234_c.get(key.func_187155_a());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synched entity data");
            crashreportcategory.func_71507_a("Data ID", key);
            throw new ReportedException(crashreport);
        }
        this.field_187235_d.readLock().unlock();
        return dataentry;
    }

    public <T> T func_187225_a(DataParameter<T> key) {
        return this.func_187219_c(key).func_187206_b();
    }

    public <T> void func_187227_b(DataParameter<T> key, T value) {
        DataEntry<T> dataentry = this.func_187219_c(key);
        if (ObjectUtils.notEqual(value, dataentry.func_187206_b())) {
            dataentry.func_187210_a(value);
            this.field_187233_b.func_184206_a(key);
            dataentry.func_187208_a(true);
            this.field_187237_f = true;
        }
    }

    public boolean func_187223_a() {
        return this.field_187237_f;
    }

    public static void func_187229_a(List<DataEntry<?>> entriesIn, PacketBuffer buf) throws IOException {
        if (entriesIn != null) {
            int j = entriesIn.size();
            for (int i = 0; i < j; ++i) {
                EntityDataManager.func_187220_a(buf, entriesIn.get(i));
            }
        }
        buf.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187221_b() {
        ArrayList list = null;
        if (this.field_187237_f) {
            this.field_187235_d.readLock().lock();
            for (DataEntry<?> dataentry : this.field_187234_c.values()) {
                if (!dataentry.func_187209_c()) continue;
                dataentry.func_187208_a(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(dataentry.func_192735_d());
            }
            this.field_187235_d.readLock().unlock();
        }
        this.field_187237_f = false;
        return list;
    }

    public void func_187216_a(PacketBuffer buf) throws IOException {
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataentry : this.field_187234_c.values()) {
            EntityDataManager.func_187220_a(buf, dataentry);
        }
        this.field_187235_d.readLock().unlock();
        buf.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187231_c() {
        ArrayList list = null;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataentry : this.field_187234_c.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(dataentry.func_192735_d());
        }
        this.field_187235_d.readLock().unlock();
        return list;
    }

    private static <T> void func_187220_a(PacketBuffer buf, DataEntry<T> entry) throws IOException {
        DataParameter<T> dataparameter = entry.func_187205_a();
        int i = DataSerializers.func_187188_b(dataparameter.func_187156_b());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + dataparameter.func_187156_b());
        }
        buf.writeByte(dataparameter.func_187155_a());
        buf.func_150787_b(i);
        dataparameter.func_187156_b().func_187160_a(buf, entry.func_187206_b());
    }

    @Nullable
    public static List<DataEntry<?>> func_187215_b(PacketBuffer buf) throws IOException {
        short i;
        ArrayList list = null;
        while ((i = buf.readUnsignedByte()) != 255) {
            int j;
            DataSerializer<?> dataserializer;
            if (list == null) {
                list = Lists.newArrayList();
            }
            if ((dataserializer = DataSerializers.func_187190_a(j = buf.func_150792_a())) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            list.add(EntityDataManager.func_198167_a(buf, i, dataserializer));
        }
        return list;
    }

    private static <T> DataEntry<T> func_198167_a(PacketBuffer p_198167_0_, int p_198167_1_, DataSerializer<T> p_198167_2_) {
        return new DataEntry<Object>(p_198167_2_.func_187161_a(p_198167_1_), p_198167_2_.func_187159_a(p_198167_0_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_187218_a(List<DataEntry<?>> entriesIn) {
        this.field_187235_d.writeLock().lock();
        for (DataEntry<?> dataentry : entriesIn) {
            DataEntry<?> dataentry1 = this.field_187234_c.get(dataentry.func_187205_a().func_187155_a());
            if (dataentry1 == null) continue;
            this.func_187224_a(dataentry1, dataentry);
            this.field_187233_b.func_184206_a(dataentry.func_187205_a());
        }
        this.field_187235_d.writeLock().unlock();
        this.field_187237_f = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T> void func_187224_a(DataEntry<T> target, DataEntry<?> source) {
        target.func_187210_a(source.func_187206_b());
    }

    public boolean func_187228_d() {
        return this.field_187236_e;
    }

    public void func_187230_e() {
        this.field_187237_f = false;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataentry : this.field_187234_c.values()) {
            dataentry.func_187208_a(false);
        }
        this.field_187235_d.readLock().unlock();
    }

    public static class DataEntry<T> {
        private final DataParameter<T> field_187211_a;
        private T field_187212_b;
        private boolean field_187213_c;

        public DataEntry(DataParameter<T> keyIn, T valueIn) {
            this.field_187211_a = keyIn;
            this.field_187212_b = valueIn;
            this.field_187213_c = true;
        }

        public DataParameter<T> func_187205_a() {
            return this.field_187211_a;
        }

        public void func_187210_a(T valueIn) {
            this.field_187212_b = valueIn;
        }

        public T func_187206_b() {
            return this.field_187212_b;
        }

        public boolean func_187209_c() {
            return this.field_187213_c;
        }

        public void func_187208_a(boolean dirtyIn) {
            this.field_187213_c = dirtyIn;
        }

        public DataEntry<T> func_192735_d() {
            return new DataEntry<Object>(this.field_187211_a, this.field_187211_a.func_187156_b().func_192717_a(this.field_187212_b));
        }
    }
}

