/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class WalkNodeProcessor
extends NodeProcessor {
    protected float field_176183_h;
    protected EntityLiving currentEntity;

    public void func_186315_a(IBlockReader sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.field_176183_h = mob.func_184643_a(PathNodeType.WATER);
    }

    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.field_176183_h);
        super.func_176163_a();
    }

    public PathPoint func_186318_b() {
        int i;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            i = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), i, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            while (block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++i, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            }
            --i;
        } else if (this.field_186326_b.field_70122_E) {
            i = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_196958_f() || this.field_176169_a.func_180495_p(blockpos).func_196957_g(this.field_176169_a, blockpos, PathType.LAND)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            i = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
        PathNodeType pathnodetype1 = this.func_186331_a(this.field_186326_b, blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
        if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.func_186329_a(this.field_186326_b, blockpos1);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        return this.func_176159_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.func_186331_a(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        double d0 = WalkNodeProcessor.func_197682_a(this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c));
        PathPoint pathpoint = this.func_186332_a(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.func_186332_a(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.func_186332_a(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.func_186332_a(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint3;
        }
        boolean flag = pathpoint3 == null || pathpoint3.field_186287_m == PathNodeType.OPEN || pathpoint3.field_186286_l != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186286_l != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.field_186287_m == PathNodeType.OPEN || pathpoint2.field_186286_l != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.field_186287_m == PathNodeType.OPEN || pathpoint1.field_186286_l != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.func_186332_a(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.func_186332_a(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.func_186332_a(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.func_186332_a(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    @Nullable
    private PathPoint func_186332_a(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        double d3;
        double d2;
        AxisAlignedBB axisalignedbb;
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = WalkNodeProcessor.func_197682_a(this.field_176169_a, blockpos);
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.func_186331_a(this.field_186326_b, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (pathpoint == null && p_186332_4_ > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.func_186332_a(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f && !this.field_186326_b.field_70170_p.func_195586_b(null, axisalignedbb = new AxisAlignedBB((d2 = (double)(x - facing.func_82601_c()) + 0.5) - d1, (double)y + 0.001, (d3 = (double)(z - facing.func_82599_e()) + 0.5) - d1, d2 + d1, (double)this.field_186326_b.field_70131_O + WalkNodeProcessor.func_197682_a(this.field_176169_a, blockpos.func_177984_a()) - 0.002, d3 + d1))) {
            pathpoint = null;
        }
        if (pathnodetype == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.func_186331_a(this.field_186326_b, x, y - 1, z) != PathNodeType.WATER) {
                return pathpoint;
            }
            while (y > 0) {
                if ((pathnodetype = this.func_186331_a(this.field_186326_b, x, --y, z)) != PathNodeType.WATER) {
                    return pathpoint;
                }
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = pathnodetype;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, this.field_186326_b.func_184643_a(pathnodetype));
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_195586_b(null, axisalignedbb1)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.func_186331_a(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            while (y > 0 && pathnodetype == PathNodeType.OPEN) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                pathnodetype = this.func_186331_a(this.field_186326_b, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = pathnodetype;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    public static double func_197682_a(IBlockReader p_197682_0_, BlockPos p_197682_1_) {
        BlockPos blockpos = p_197682_1_.func_177977_b();
        VoxelShape voxelshape = p_197682_0_.func_180495_p(blockpos).func_196952_d(p_197682_0_, blockpos);
        return (double)blockpos.func_177956_o() + (voxelshape.func_197766_b() ? 0.0 : voxelshape.func_197758_c(EnumFacing.Axis.Y));
    }

    public PathNodeType func_186319_a(IBlockReader blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        double d0 = (double)entitylivingIn.field_70130_N / 2.0;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        this.currentEntity = entitylivingIn;
        pathnodetype = this.func_193577_a(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, enumset, pathnodetype, blockpos);
        this.currentEntity = entitylivingIn;
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype1 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype2 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype2) < 0.0f) {
                return pathnodetype2;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype2) >= entitylivingIn.func_184643_a(pathnodetype1))) continue;
            pathnodetype1 = pathnodetype2;
        }
        if (pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype1) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype1;
    }

    public PathNodeType func_193577_a(IBlockReader p_193577_1_, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> p_193577_10_, PathNodeType p_193577_11_, BlockPos p_193577_12_) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype = this.func_186330_a(p_193577_1_, l, i1, j1);
                    if (pathnodetype == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoorsIn && canEnterDoorsIn) {
                        pathnodetype = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype == PathNodeType.RAIL && !(p_193577_1_.func_180495_p(p_193577_12_).func_177230_c() instanceof BlockRailBase) && !(p_193577_1_.func_180495_p(p_193577_12_.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                        pathnodetype = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        p_193577_11_ = pathnodetype;
                    }
                    p_193577_10_.add(pathnodetype);
                }
            }
        }
        return p_193577_11_;
    }

    private PathNodeType func_186329_a(EntityLiving entitylivingIn, BlockPos pos) {
        return this.func_186331_a(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private PathNodeType func_186331_a(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        PathNodeType pathnodetype = this.func_189553_b(blockaccessIn, x, y, z);
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            Block block = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.func_189553_b(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
        }
        pathnodetype = this.func_193578_a(blockaccessIn, x, y, z, pathnodetype);
        return pathnodetype;
    }

    public PathNodeType func_193578_a(IBlockReader p_193578_1_, int p_193578_2_, int p_193578_3_, int p_193578_4_, PathNodeType p_193578_5_) {
        if (p_193578_5_ == PathNodeType.WALKABLE) {
            try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) continue;
                        IBlockState state = p_193578_1_.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(i + p_193578_2_, p_193578_3_, j + p_193578_4_));
                        Block block = state.func_177230_c();
                        PathNodeType type = block.getAiPathNodeType(state, p_193578_1_, (BlockPos)blockpos$pooledmutableblockpos, this.currentEntity);
                        if (block == Blocks.field_150434_aF || type == PathNodeType.DAMAGE_CACTUS) {
                            p_193578_5_ = PathNodeType.DANGER_CACTUS;
                            continue;
                        }
                        if (block == Blocks.field_150480_ab || type == PathNodeType.DAMAGE_FIRE) {
                            p_193578_5_ = PathNodeType.DANGER_FIRE;
                            continue;
                        }
                        if (type != PathNodeType.DAMAGE_OTHER) continue;
                        p_193578_5_ = PathNodeType.DAMAGE_OTHER;
                    }
                }
            }
        }
        return p_193578_5_;
    }

    protected PathNodeType func_189553_b(IBlockReader p_189553_1_, int p_189553_2_, int p_189553_3_, int p_189553_4_) {
        BlockPos blockpos = new BlockPos(p_189553_2_, p_189553_3_, p_189553_4_);
        IBlockState iblockstate = p_189553_1_.func_180495_p(blockpos);
        PathNodeType type = iblockstate.getAiPathNodeType(p_189553_1_, blockpos, this.currentEntity);
        if (type != null) {
            return type;
        }
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        if (iblockstate.isAir(p_189553_1_, blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!block.func_203417_a(BlockTags.field_212185_E) && block != Blocks.field_196651_dG) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof BlockDoor && ((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof BlockRailBase) {
                return PathNodeType.RAIL;
            }
            if (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue())) {
                IFluidState ifluidstate = p_189553_1_.func_204610_c(blockpos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return iblockstate.func_196957_g(p_189553_1_, blockpos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

