/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomBossEvents;
import net.minecraft.server.ServerEula;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerDemo;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements IThreadListener,
ISnooperInfo,
ICommandSource,
Runnable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    private final ISaveFormat field_71310_m;
    private final Snooper field_71307_n = new Snooper("server", (ISnooperInfo)this, Util.func_211177_b());
    private final File field_71308_o;
    private final List<ITickable> field_71322_p = Lists.newArrayList();
    public final Profiler field_71304_b = new Profiler();
    private final NetworkSystem field_147144_o;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    private final Map<DimensionType, WorldServer> field_71305_c = Maps.newIdentityHashMap();
    private PlayerList field_71318_t;
    private boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private ITextComponent field_71302_d;
    private int field_71303_e;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    protected final Map<DimensionType, long[]> field_71312_k = Maps.newIdentityHashMap();
    private KeyPair field_71292_I;
    private String field_71293_J;
    private String field_71294_K;
    @OnlyIn(value=Dist.CLIENT)
    private String field_71287_L;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private boolean field_71296_Q;
    private long field_71299_R;
    private ITextComponent field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;
    private final YggdrasilAuthenticationService field_152364_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    public final Queue<FutureTask<?>> field_175589_i = Queues.newConcurrentLinkedQueue();
    private Thread field_175590_aa;
    protected long field_211151_aa = Util.func_211177_b();
    @OnlyIn(value=Dist.CLIENT)
    private boolean field_184111_ab;
    private final IReloadableResourceManager field_195576_ac = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
    private final ResourcePackList<ResourcePackInfo> field_195577_ad = new ResourcePackList(ResourcePackInfo::new);
    private FolderPackFinder field_195578_ae;
    private final Commands field_195579_af;
    private final RecipeManager field_199530_ag = new RecipeManager();
    private final NetworkTagManager field_199736_ah = new NetworkTagManager();
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    private final CustomBossEvents field_201301_aj = new CustomBossEvents(this);
    private final LootTableManager field_200256_aj = new LootTableManager();
    private final AdvancementManager field_200257_ak = new AdvancementManager();
    private final FunctionManager field_200258_al = new FunctionManager(this);
    private boolean field_205745_an;
    private boolean field_212205_ao;
    private float field_211152_ao;

    public MinecraftServer(@Nullable File anvilFileIn, Proxy serverProxyIn, DataFixer dataFixerIn, Commands commandManagerIn, YggdrasilAuthenticationService authServiceIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepoIn, PlayerProfileCache profileCacheIn) {
        this.field_110456_c = serverProxyIn;
        this.field_195579_af = commandManagerIn;
        this.field_152364_T = authServiceIn;
        this.field_147143_S = sessionServiceIn;
        this.field_152365_W = profileRepoIn;
        this.field_152366_X = profileCacheIn;
        this.field_71308_o = anvilFileIn;
        this.field_147144_o = anvilFileIn == null ? null : new NetworkSystem(this);
        this.field_71310_m = anvilFileIn == null ? null : new AnvilSaveConverter(anvilFileIn.toPath(), anvilFileIn.toPath().resolve("../backups"), dataFixerIn);
        this.field_184112_s = dataFixerIn;
        this.field_195576_ac.func_199006_a((IResourceManagerReloadListener)this.field_199736_ah);
        this.field_195576_ac.func_199006_a((IResourceManagerReloadListener)((Object)this.field_199530_ag));
        this.field_195576_ac.func_199006_a((IResourceManagerReloadListener)this.field_200256_aj);
        this.field_195576_ac.func_199006_a((IResourceManagerReloadListener)this.field_200258_al);
        this.field_195576_ac.func_199006_a((IResourceManagerReloadListener)this.field_200257_ak);
    }

    public abstract boolean func_71197_b() throws IOException;

    public void func_71237_c(String worldNameIn) {
        if (this.func_71254_M().func_75801_b(worldNameIn)) {
            field_147145_h.info("Converting map!");
            this.func_200245_b((ITextComponent)new TextComponentTranslation("menu.convertingLevel", new Object[0]));
            this.func_71254_M().func_75805_a(worldNameIn, new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                public void func_200210_a(ITextComponent component) {
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_200211_b(ITextComponent component) {
                }

                public void func_73718_a(int progress) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)progress);
                    }
                }

                @OnlyIn(value=Dist.CLIENT)
                public void func_146586_a() {
                }

                public void func_200209_c(ITextComponent component) {
                }
            });
        }
        if (this.field_212205_ao) {
            field_147145_h.info("Forcing world upgrade!");
            WorldInfo worldinfo = this.func_71254_M().func_75803_c(this.func_71270_I());
            if (worldinfo != null) {
                WorldOptimizer worldoptimizer = new WorldOptimizer(this.func_71270_I(), this.func_71254_M(), worldinfo);
                ITextComponent itextcomponent = null;
                while (!worldoptimizer.func_212218_b()) {
                    int i;
                    ITextComponent itextcomponent1 = worldoptimizer.func_212215_m();
                    if (itextcomponent != itextcomponent1) {
                        itextcomponent = itextcomponent1;
                        field_147145_h.info(worldoptimizer.func_212215_m().getString());
                    }
                    if ((i = worldoptimizer.func_212211_j()) > 0) {
                        int j = worldoptimizer.func_212208_k() + worldoptimizer.func_212209_l();
                        field_147145_h.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)((float)j / (float)i * 100.0f)), (Object)j, (Object)i);
                    }
                    if (this.func_71241_aa()) {
                        worldoptimizer.func_212217_a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void func_200245_b(ITextComponent userMessageIn) {
        this.field_71298_S = userMessageIn;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public synchronized ITextComponent func_200253_h_() {
        return this.field_71298_S;
    }

    public void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        WorldSettings worldsettings;
        this.func_71237_c(saveName);
        this.func_200245_b((ITextComponent)new TextComponentTranslation("menu.loadingLevel", new Object[0]));
        ISaveHandler isavehandler = this.func_71254_M().func_197715_a(saveName, this);
        this.func_175584_a(this.func_71270_I(), isavehandler);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null) {
            if (this.func_71242_L()) {
                worldsettings = WorldServerDemo.field_73071_a;
            } else {
                worldsettings = new WorldSettings(seed, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), type);
                worldsettings.func_205390_a(generatorOptions);
                if (this.field_71289_N) {
                    worldsettings.func_77159_a();
                }
            }
            worldinfo = new WorldInfo(worldsettings, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
            worldsettings = new WorldSettings(worldinfo);
        }
        this.func_195560_a(isavehandler.func_75765_b(), worldinfo);
        WorldSavedDataStorage worldsaveddatastorage = new WorldSavedDataStorage(isavehandler);
        this.func_212369_a(isavehandler, worldsaveddatastorage, worldinfo, worldsettings);
        this.func_147139_a(this.func_147135_j());
        this.func_71222_d(worldsaveddatastorage);
    }

    public void func_212369_a(ISaveHandler p_212369_1_, WorldSavedDataStorage p_212369_2_, WorldInfo p_212369_3_, WorldSettings p_212369_4_) {
        if (this.func_71242_L()) {
            this.field_71305_c.put(DimensionType.OVERWORLD, new WorldServerDemo(this, p_212369_1_, p_212369_2_, p_212369_3_, DimensionType.OVERWORLD, this.field_71304_b).func_212251_i__());
        } else {
            this.field_71305_c.put(DimensionType.OVERWORLD, new WorldServer(this, p_212369_1_, p_212369_2_, p_212369_3_, DimensionType.OVERWORLD, this.field_71304_b).func_212251_i__());
        }
        WorldServer worldserver = this.func_71218_a(DimensionType.OVERWORLD);
        worldserver.func_72963_a(p_212369_4_);
        worldserver.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(this, worldserver));
        if (!this.func_71264_H()) {
            worldserver.func_72912_H().func_76060_a(this.func_71265_f());
        }
        for (DimensionType dim : DimensionType.func_212681_b()) {
            WorldServer world = worldserver;
            if (dim != DimensionType.OVERWORLD) {
                world = new WorldServerMulti(this, p_212369_1_, dim, worldserver, this.field_71304_b).func_212251_i__();
                this.field_71305_c.put(dim, world);
                world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(this, world));
                if (!this.func_71264_H()) {
                    world.func_72912_H().func_76060_a(this.func_71265_f());
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)world));
        }
        this.func_184103_al().func_212504_a(worldserver);
        if (p_212369_3_.func_201357_P() != null) {
            this.func_201300_aS().func_201381_a(p_212369_3_.func_201357_P());
        }
    }

    public void func_195560_a(File p_195560_1_, WorldInfo p_195560_2_) {
        this.field_195577_ad.func_198982_a((IPackFinder)new ServerPackFinder());
        this.field_195578_ae = new FolderPackFinder(new File(p_195560_1_, "datapacks"));
        this.field_195577_ad.func_198982_a((IPackFinder)this.field_195578_ae);
        this.field_195577_ad.func_198983_a();
        ArrayList list = Lists.newArrayList();
        for (String s : p_195560_2_.func_197720_O()) {
            ResourcePackInfo resourcepackinfo = this.field_195577_ad.func_198981_a(s);
            if (resourcepackinfo != null) {
                list.add(resourcepackinfo);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)s);
        }
        this.field_195577_ad.func_198985_a((Collection)list);
        this.func_195568_a(p_195560_2_);
    }

    public void func_71222_d(WorldSavedDataStorage p_71222_1_) {
        int i = 16;
        int j = 4;
        int k = 12;
        int l = 192;
        int i1 = 625;
        this.func_200245_b((ITextComponent)new TextComponentTranslation("menu.generatingTerrain", new Object[0]));
        WorldServer worldserver = this.func_71218_a(DimensionType.OVERWORLD);
        field_147145_h.info("Preparing start region for dimension " + DimensionType.func_212678_a(worldserver.field_73011_w.func_186058_p()));
        BlockPos blockpos = worldserver.func_175694_M();
        ArrayList list = Lists.newArrayList();
        Set set = Sets.newConcurrentHashSet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int j1 = -192; j1 <= 192 && this.func_71278_l(); j1 += 16) {
            for (int k1 = -192; k1 <= 192 && this.func_71278_l(); k1 += 16) {
                list.add(new ChunkPos(blockpos.func_177958_n() + j1 >> 4, blockpos.func_177952_p() + k1 >> 4));
            }
            CompletableFuture<ChunkPrimer> completablefuture = worldserver.func_72863_F().func_201720_a(list, p_201701_1_ -> set.add(p_201701_1_.func_76632_l()));
            while (!completablefuture.isDone()) {
                try {
                    completablefuture.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedexception) {
                    throw new RuntimeException(interruptedexception);
                }
                catch (ExecutionException executionexception) {
                    if (executionexception.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)executionexception.getCause();
                    }
                    throw new RuntimeException(executionexception.getCause());
                }
                catch (TimeoutException var22) {
                    this.func_200250_a((ITextComponent)new TextComponentTranslation("menu.preparingSpawn", new Object[0]), set.size() * 100 / 625);
                }
            }
            this.func_200250_a((ITextComponent)new TextComponentTranslation("menu.preparingSpawn", new Object[0]), set.size() * 100 / 625);
        }
        field_147145_h.info("Time elapsed: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        for (DimensionType dimensiontype : DimensionType.func_212681_b()) {
            ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)p_71222_1_.func_212426_a(dimensiontype, ForcedChunksSaveData::new, "chunks");
            if (forcedchunkssavedata == null) continue;
            WorldServer worldserver1 = this.func_71218_a(dimensiontype);
            LongIterator longiterator = forcedchunkssavedata.func_212438_a().iterator();
            while (longiterator.hasNext()) {
                this.func_200250_a((ITextComponent)new TextComponentTranslation("menu.loadingForcedChunks", new Object[]{dimensiontype}), forcedchunkssavedata.func_212438_a().size() * 100 / 625);
                long l1 = longiterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(l1);
                worldserver1.func_72863_F().func_186025_d(chunkpos.field_77276_a, chunkpos.field_77275_b, true, true);
            }
        }
        this.func_71243_i();
    }

    public void func_175584_a(String worldNameIn, ISaveHandler saveHandlerIn) {
        File file1 = new File(saveHandlerIn.func_75765_b(), "resources.zip");
        if (file1.isFile()) {
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(worldNameIn, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException var5) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)worldNameIn);
            }
        }
    }

    public abstract boolean func_71225_e();

    public abstract GameType func_71265_f();

    public abstract EnumDifficulty func_147135_j();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    public abstract boolean func_195569_l();

    protected void func_200250_a(ITextComponent currentTaskIn, int percentDoneIn) {
        this.field_71302_d = currentTaskIn;
        this.field_71303_e = percentDoneIn;
        field_147145_h.info("{}: {}%", (Object)currentTaskIn.getString(), (Object)percentDoneIn);
    }

    protected void func_71243_i() {
        this.field_71302_d = null;
        this.field_71303_e = 0;
    }

    public void func_71267_a(boolean isSilent) {
        for (WorldServer worldserver : this.func_212370_w()) {
            if (worldserver == null) continue;
            if (!isSilent) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)worldserver.func_72912_H().func_76065_j(), (Object)DimensionType.func_212678_a(worldserver.field_73011_w.func_186058_p()));
            }
            try {
                worldserver.func_73044_a(true, null);
            }
            catch (SessionLockException sessionlockexception) {
                field_147145_h.warn(sessionlockexception.getMessage());
            }
        }
    }

    public void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (WorldServer worldserver : this.func_212370_w()) {
            if (worldserver == null) continue;
            worldserver.field_73058_d = false;
        }
        this.func_71267_a(false);
        for (WorldServer worldserver1 : this.func_212370_w()) {
            if (worldserver1 == null) continue;
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)worldserver1));
            worldserver1.close();
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String host) {
        this.field_71320_r = host;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m() {
        this.field_71317_u = false;
    }

    private boolean func_212379_aT() {
        return Util.func_211177_b() < this.field_211151_aa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.func_71197_b()) {
                ServerLifecycleHooks.handleServerStarted((MinecraftServer)this);
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a((ITextComponent)new TextComponentString(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version("1.13.2", 404));
                this.func_184107_a(this.field_147147_p);
                while (this.field_71317_u) {
                    long i = Util.func_211177_b() - this.field_211151_aa;
                    if (i > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        long j = i / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)i, (Object)j);
                        this.field_211151_aa += j * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.func_71217_p(this::func_212379_aT);
                    this.field_211151_aa += 50L;
                    while (this.func_212379_aT()) {
                        Thread.sleep(1L);
                    }
                    this.field_71296_Q = true;
                }
                ServerLifecycleHooks.handleServerStopping((MinecraftServer)this);
                ServerLifecycleHooks.expectServerStopped();
            } else {
                ServerLifecycleHooks.expectServerStopped();
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable1) {
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            ServerLifecycleHooks.expectServerStopped();
            this.func_71228_a(crashreport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                ServerLifecycleHooks.handleServerStopped((MinecraftServer)this);
                this.func_71240_o();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184107_a(ServerStatusResponse response) {
        File file1 = this.func_71209_f("server-icon.png");
        if (!file1.exists()) {
            file1 = this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
        }
        if (file1.isFile()) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                BufferedImage bufferedimage = ImageIO.read(file1);
                Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedimage, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
                ByteBuffer bytebuffer = Base64.getEncoder().encode(bytebuf.nioBuffer());
                response.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(bytebuffer));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                bytebuf.release();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184106_y() {
        this.field_184111_ab = this.field_184111_ab || this.func_184109_z().isFile();
        return this.field_184111_ab;
    }

    @OnlyIn(value=Dist.CLIENT)
    public File func_184109_z() {
        return this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
    }

    public File func_71238_n() {
        return new File(".");
    }

    public void func_71228_a(CrashReport report) {
    }

    public void func_71240_o() {
    }

    public void func_71217_p(BooleanSupplier p_71217_1_) {
        long i = Util.func_211178_c();
        BasicEventHooks.onPreServerTick();
        ++this.field_71315_w;
        if (this.field_71295_T) {
            this.field_71295_T = false;
            this.field_71304_b.func_199095_a(this.field_71315_w);
        }
        this.field_71304_b.func_76320_a("root");
        this.func_71190_q(p_71217_1_);
        if (i - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = i;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] agameprofile = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int j = MathHelper.func_76136_a((Random)this.field_147146_q, (int)0, (int)(this.func_71233_x() - agameprofile.length));
            for (int k = 0; k < agameprofile.length; ++k) {
                agameprofile[k] = this.field_71318_t.func_181057_v().get(j + k).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(agameprofile));
            this.field_147147_p.func_151318_b().func_151330_a(agameprofile);
            this.field_147147_p.invalidateJson();
        }
        if (this.field_71315_w % 900 == 0) {
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_71267_a(true);
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l = Util.func_211178_c() - i;
        this.field_71311_j[this.field_71315_w % 100] = l;
        long l2 = l;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)l2 / 1000000.0f * 0.19999999f;
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76319_b();
        BasicEventHooks.onPostServerTick();
    }

    public void func_71190_q(BooleanSupplier p_71190_1_) {
        FutureTask<?> futuretask;
        this.field_71304_b.func_76320_a("jobs");
        while ((futuretask = this.field_175589_i.poll()) != null) {
            Util.func_181617_a(futuretask, (Logger)field_147145_h);
        }
        this.field_71304_b.func_76318_c("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_76318_c("levels");
        for (WorldServer worldserver : this.func_212370_w()) {
            long i = Util.func_211178_c();
            if (worldserver.field_73011_w.func_186058_p() == DimensionType.OVERWORLD || this.func_71255_r()) {
                this.field_71304_b.func_194340_a(() -> "dim-" + worldserver.field_73011_w.func_186058_p().func_186068_a());
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a((Packet<?>)new SPacketTimeUpdate(worldserver.func_82737_E(), worldserver.func_72820_D(), worldserver.func_82736_K().func_82766_b("doDaylightCycle")), worldserver.field_73011_w.func_186058_p());
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                BasicEventHooks.onPreWorldTick((World)worldserver);
                try {
                    worldserver.func_72835_b(p_71190_1_);
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Exception ticking world");
                    worldserver.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldserver.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a(throwable, "Exception ticking world entities");
                    worldserver.func_72914_a(crashreport1);
                    throw new ReportedException(crashreport1);
                }
                BasicEventHooks.onPostWorldTick((World)worldserver);
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                worldserver.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            this.field_71312_k.computeIfAbsent((DimensionType)worldserver.field_73011_w.func_186058_p(), (Function<DimensionType, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateTimeLightAndEntities$2(net.minecraft.world.dimension.DimensionType ), (Lnet/minecraft/world/dimension/DimensionType;)[J)())[this.field_71315_w % 100] = Util.func_211178_c() - i;
        }
        this.field_71304_b.func_76318_c("dim_unloading");
        DimensionManager.unloadWorlds((MinecraftServer)this, (this.field_71315_w % 200 == 0 ? 1 : 0) != 0);
        this.field_71304_b.func_76318_c("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int j = 0; j < this.field_71322_p.size(); ++j) {
            this.field_71322_p.get(j).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(ITickable tickable) {
        this.field_71322_p.add(tickable);
    }

    public static void main(String[] p_main_0_) {
        ServerEula eula = new ServerEula(new File("eula.txt"));
        if (!eula.func_154346_a()) {
            field_147145_h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
            eula.func_154348_b();
            return;
        }
        Bootstrap.func_151354_b();
        try {
            boolean flag = true;
            String s = null;
            String s1 = ".";
            String s2 = null;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            int i = -1;
            for (int j = 0; j < p_main_0_.length; ++j) {
                String s3 = p_main_0_[j];
                String s4 = j == p_main_0_.length - 1 ? null : p_main_0_[j + 1];
                boolean flag4 = false;
                if (!"nogui".equals(s3) && !"--nogui".equals(s3)) {
                    if ("--port".equals(s3) && s4 != null) {
                        flag4 = true;
                        try {
                            i = Integer.parseInt(s4);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("--singleplayer".equals(s3) && s4 != null) {
                        flag4 = true;
                        s = s4;
                    } else if ("--universe".equals(s3) && s4 != null) {
                        flag4 = true;
                        s1 = s4;
                    } else if ("--world".equals(s3) && s4 != null) {
                        flag4 = true;
                        s2 = s4;
                    } else if ("--demo".equals(s3)) {
                        flag1 = true;
                    } else if ("--bonusChest".equals(s3)) {
                        flag2 = true;
                    } else if ("--forceUpgrade".equals(s3)) {
                        flag3 = true;
                    }
                } else {
                    flag = false;
                }
                if (!flag4) continue;
                ++j;
            }
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(s1, field_152367_a.getName()));
            final DedicatedServer dedicatedserver = new DedicatedServer(new File(s1), DataFixesManager.func_210901_a(), yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache);
            if (s != null) {
                dedicatedserver.func_71224_l(s);
            }
            if (s2 != null) {
                dedicatedserver.func_71261_m(s2);
            }
            if (i >= 0) {
                dedicatedserver.func_71208_b(i);
            }
            if (flag1) {
                dedicatedserver.func_71204_b(true);
            }
            if (flag2) {
                dedicatedserver.func_71194_c(true);
            }
            if (flag && !GraphicsEnvironment.isHeadless()) {
                dedicatedserver.func_120011_ar();
            }
            if (flag3) {
                dedicatedserver.func_212204_b(true);
            }
            dedicatedserver.func_71256_s();
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.func_71260_j();
                }
            };
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147145_h));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception) {
            field_147145_h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void func_212204_b(boolean forceWorldUpgradeIn) {
        this.field_212205_ao = forceWorldUpgradeIn;
    }

    public void func_71256_s() {
        this.field_175590_aa = new Thread((ThreadGroup)SidedThreadGroups.SERVER, this, "Server thread");
        this.field_175590_aa.setUncaughtExceptionHandler((p_195574_0_, p_195574_1_) -> field_147145_h.error((Object)p_195574_1_));
        this.field_175590_aa.start();
    }

    public File func_71209_f(String fileName) {
        return new File(this.func_71238_n(), fileName);
    }

    public void func_71244_g(String msg) {
        field_147145_h.info(msg);
    }

    public void func_71236_h(String msg) {
        field_147145_h.warn(msg);
    }

    public WorldServer func_71218_a(DimensionType dimension) {
        return DimensionManager.getWorld((MinecraftServer)this, (DimensionType)dimension, (boolean)true, (boolean)true);
    }

    public Iterable<WorldServer> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return "1.13.2";
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String msg) {
        field_147145_h.error(msg);
    }

    public void func_71198_k(String msg) {
        if (this.func_71239_B()) {
            field_147145_h.info(msg);
        }
    }

    public String getServerModName() {
        return BrandingControl.getServerBranding();
    }

    public CrashReport func_71230_b(CrashReport report) {
        report.func_85056_g().func_189529_a("Profiler Position", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71304_b.func_199094_a() ? this.field_71304_b.func_76322_c() : "N/A (disabled)"));
        if (this.field_71318_t != null) {
            report.func_85056_g().func_189529_a("Player Count", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v()));
        }
        report.func_85056_g().func_189529_a("Data Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (ResourcePackInfo resourcepackinfo : this.field_195577_ad.func_198980_d()) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(resourcepackinfo.func_195790_f());
                if (resourcepackinfo.func_195791_d().func_198968_a()) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        }));
        return report;
    }

    public boolean func_175578_N() {
        return this.field_71308_o != null;
    }

    public void func_145747_a(ITextComponent component) {
        field_147145_h.info(component.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int port) {
        this.field_71319_s = port;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String owner) {
        this.field_71293_J = owner;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    public void func_71261_m(String name) {
        this.field_71294_K = name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_71246_n(String worldNameIn) {
        this.field_71287_L = worldNameIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_71221_J() {
        return this.field_71287_L;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(EnumDifficulty difficulty) {
        for (WorldServer worldserver : this.func_212370_w()) {
            if (worldserver.func_72912_H().func_76093_s()) {
                worldserver.func_72912_H().func_176144_a(EnumDifficulty.HARD);
                worldserver.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldserver.func_72912_H().func_176144_a(difficulty);
                worldserver.func_72891_a(worldserver.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
                continue;
            }
            worldserver.func_72912_H().func_176144_a(difficulty);
            worldserver.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
    }

    public boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean demo) {
        this.field_71288_M = demo;
    }

    public void func_71194_c(boolean enable) {
        this.field_71289_N = enable;
    }

    public ISaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String url, String hash) {
        this.field_147141_M = url;
        this.field_175588_P = hash;
    }

    public void func_70000_a(Snooper playerSnooper) {
        playerSnooper.func_152768_a("whitelist_enabled", (Object)false);
        playerSnooper.func_152768_a("whitelist_count", (Object)0);
        if (this.field_71318_t != null) {
            playerSnooper.func_152768_a("players_current", (Object)this.func_71233_x());
            playerSnooper.func_152768_a("players_max", (Object)this.func_71275_y());
            playerSnooper.func_152768_a("players_seen", (Object)this.field_71318_t.func_72373_m().length);
        }
        playerSnooper.func_152768_a("uses_auth", (Object)this.field_71325_x);
        playerSnooper.func_152768_a("gui_state", (Object)(this.func_71279_ae() ? "enabled" : "disabled"));
        playerSnooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - playerSnooper.func_130105_g()) / 60L * 1000L));
        playerSnooper.func_152768_a("avg_tick_ms", (Object)((int)(MathHelper.func_76127_a((long[])this.field_71311_j) * 1.0E-6)));
        int i = 0;
        for (WorldServer worldserver : this.func_212370_w()) {
            if (worldserver == null) continue;
            WorldInfo worldinfo = worldserver.func_72912_H();
            playerSnooper.func_152768_a("world[" + i + "][dimension]", (Object)worldserver.field_73011_w.func_186058_p());
            playerSnooper.func_152768_a("world[" + i + "][mode]", (Object)worldinfo.func_76077_q());
            playerSnooper.func_152768_a("world[" + i + "][difficulty]", (Object)worldserver.func_175659_aa());
            playerSnooper.func_152768_a("world[" + i + "][hardcore]", (Object)worldinfo.func_76093_s());
            playerSnooper.func_152768_a("world[" + i + "][generator_name]", (Object)worldinfo.func_76067_t().func_211888_a());
            playerSnooper.func_152768_a("world[" + i + "][generator_version]", (Object)worldinfo.func_76067_t().func_77131_c());
            playerSnooper.func_152768_a("world[" + i + "][height]", (Object)this.field_71280_D);
            playerSnooper.func_152768_a("world[" + i + "][chunks_loaded]", (Object)worldserver.func_72863_F().func_73152_e());
            ++i;
        }
        playerSnooper.func_152768_a("worlds", (Object)i);
    }

    public boolean func_70002_Q() {
        return true;
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean online) {
        this.field_71325_x = online;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean p_190517_1_) {
        this.field_190519_A = p_190517_1_;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean spawnAnimals) {
        this.field_71324_y = spawnAnimals;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public abstract boolean func_181035_ah();

    public void func_71257_f(boolean spawnNpcs) {
        this.field_71323_z = spawnNpcs;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean allowPvp) {
        this.field_71284_A = allowPvp;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean allow) {
        this.field_71285_B = allow;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String motdIn) {
        this.field_71286_C = motdIn;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int maxBuildHeight) {
        this.field_71280_D = maxBuildHeight;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList list) {
        this.field_71318_t = list;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameMode) {
        for (WorldServer worldserver : this.func_212370_w()) {
            worldserver.func_72912_H().func_76060_a(gameMode);
        }
    }

    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_71200_ad() {
        return this.field_71296_Q;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Snooper func_80003_ah() {
        return this.field_71307_n;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return false;
    }

    public void func_104055_i(boolean force) {
        this.field_104057_T = force;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int idleTimeout) {
        this.field_143008_E = idleTimeout;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    public <V> ListenableFuture<V> func_175586_a(Callable<V> callable) {
        Validate.notNull(callable);
        if (!this.func_152345_ab() && !this.func_71241_aa()) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callable);
            this.field_175589_i.add((FutureTask<?>)listenablefuturetask);
            return listenablefuturetask;
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    public ListenableFuture<Object> func_152344_a(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return this.func_175586_a(Executors.callable(runnableToSchedule));
    }

    public boolean func_152345_ab() {
        return Thread.currentThread() == this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public Thread func_175583_aK() {
        return this.field_175590_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable WorldServer worldIn) {
        return worldIn != null ? worldIn.func_82736_K().func_180263_c("spawnRadius") : 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_200257_ak;
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public void func_193031_aM() {
        if (!this.func_152345_ab()) {
            this.func_152344_a(this::func_193031_aM);
        } else {
            this.func_184103_al().func_72389_g();
            this.field_195577_ad.func_198983_a();
            this.func_195568_a(this.func_71218_a(DimensionType.OVERWORLD).func_72912_H());
            this.func_184103_al().func_193244_w();
        }
    }

    private void func_195568_a(WorldInfo worldInfoIn) {
        ArrayList list = Lists.newArrayList((Iterable)this.field_195577_ad.func_198980_d());
        for (ResourcePackInfo resourcepackinfo : this.field_195577_ad.func_198978_b()) {
            if (worldInfoIn.func_197719_N().contains(resourcepackinfo.func_195790_f()) || list.contains(resourcepackinfo)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)resourcepackinfo.func_195790_f());
            resourcepackinfo.func_195792_i().func_198993_a(list, resourcepackinfo, p_200247_0_ -> p_200247_0_, false);
        }
        this.field_195577_ad.func_198985_a((Collection)list);
        ArrayList list1 = Lists.newArrayList();
        this.field_195577_ad.func_198980_d().forEach(p_200244_1_ -> list1.add(p_200244_1_.func_195796_e()));
        this.field_195576_ac.func_199005_a((List)list1);
        worldInfoIn.func_197720_O().clear();
        worldInfoIn.func_197719_N().clear();
        this.field_195577_ad.func_198980_d().forEach(p_195562_1_ -> worldInfoIn.func_197720_O().add(p_195562_1_.func_195790_f()));
        this.field_195577_ad.func_198978_b().forEach(p_200248_2_ -> {
            if (!this.field_195577_ad.func_198980_d().contains(p_200248_2_)) {
                worldInfoIn.func_197719_N().add(p_200248_2_.func_195790_f());
            }
        });
    }

    public void func_205743_a(CommandSource commandSourceIn) {
        PlayerList playerlist;
        UserListWhitelist userlistwhitelist;
        if (this.func_205744_aT() && (userlistwhitelist = (playerlist = commandSourceIn.func_197028_i().func_184103_al()).func_152599_k()).func_152689_b()) {
            for (EntityPlayerMP entityplayermp : Lists.newArrayList(playerlist.func_181057_v())) {
                if (userlistwhitelist.func_152705_a(entityplayermp.func_146103_bH())) continue;
                entityplayermp.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.not_whitelisted", new Object[0]));
            }
        }
    }

    public IReloadableResourceManager func_195570_aG() {
        return this.field_195576_ac;
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200246_aJ() {
        return this.field_71302_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_195566_aK() {
        return this.field_71303_e;
    }

    public Commands func_195571_aL() {
        return this.field_195579_af;
    }

    public CommandSource func_195573_aM() {
        return new CommandSource((ICommandSource)this, this.func_71218_a(DimensionType.OVERWORLD) == null ? Vec3d.field_186680_a : new Vec3d((Vec3i)this.func_71218_a(DimensionType.OVERWORLD).func_175694_M()), Vec2f.field_189974_a, this.func_71218_a(DimensionType.OVERWORLD), 4, "Server", (ITextComponent)new TextComponentString("Server"), this, (Entity)null);
    }

    public boolean func_195039_a() {
        return true;
    }

    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_199530_ag;
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_199736_ah;
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_200256_aj;
    }

    public GameRules func_200252_aR() {
        return this.func_71218_a(DimensionType.OVERWORLD).func_82736_K();
    }

    public CustomBossEvents func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean whitelistEnabledIn) {
        this.field_205745_an = whitelistEnabledIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile profile) {
        if (this.func_184103_al().func_152596_g(profile)) {
            UserListOpsEntry userlistopsentry = (UserListOpsEntry)this.func_184103_al().func_152603_m().func_152683_b((Object)profile);
            if (userlistopsentry != null) {
                return userlistopsentry.func_152644_a();
            }
            if (this.func_71264_H()) {
                if (this.func_71214_G().equals(profile.getName())) {
                    return 4;
                }
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    @Nullable
    public long[] getTickTime(DimensionType dim) {
        return this.field_71312_k.get((Object)dim);
    }

    @Deprecated
    public synchronized Map<DimensionType, WorldServer> forgeGetWorldMap() {
        return this.field_71305_c;
    }

    private static /* synthetic */ long[] lambda$updateTimeLightAndEntities$2(DimensionType p_212377_0_) {
        return new long[100];
    }
}

