/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketTagsList;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.network.play.server.SPacketUpdateRecipes;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File field_152613_a = new File("banned-players.json");
    public static final File field_152614_b = new File("banned-ips.json");
    public static final File field_152615_c = new File("ops.json");
    public static final File field_152616_d = new File("whitelist.json");
    private static final Logger field_148546_d = LogManager.getLogger();
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    private final List<EntityPlayerMP> field_72404_b = Lists.newArrayList();
    private final Map<UUID, EntityPlayerMP> field_177454_f = Maps.newHashMap();
    private final UserListBans field_72401_g = new UserListBans(field_152613_a);
    private final UserListIPBans field_72413_h = new UserListIPBans(field_152614_b);
    private final UserListOps field_72414_i = new UserListOps(field_152615_c);
    private final UserListWhitelist field_72411_j = new UserListWhitelist(field_152616_d);
    private final Map<UUID, StatisticsManagerServer> field_148547_k = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> field_192055_p = Maps.newHashMap();
    private IPlayerFileData field_72412_k;
    private boolean field_72409_l;
    protected int field_72405_c;
    private int field_72402_d;
    private GameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;

    public PlayerList(MinecraftServer server) {
        this.field_72400_f = server;
        this.func_152608_h().func_152686_a(true);
        this.func_72363_f().func_152686_a(true);
        this.field_72405_c = 8;
    }

    public void func_72355_a(NetworkManager netManager, EntityPlayerMP playerIn) {
        NBTTagCompound nbttagcompound1;
        Entity entity1;
        GameProfile gameprofile = playerIn.func_146103_bH();
        PlayerProfileCache playerprofilecache = this.field_72400_f.func_152358_ax();
        GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.func_152649_a(gameprofile);
        NBTTagCompound nbttagcompound = this.func_72380_a(playerIn);
        WorldServer playerWorld = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        if (playerWorld == null) {
            playerIn.field_71093_bK = DimensionType.OVERWORLD;
            playerWorld = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
            playerIn.func_70107_b(playerWorld.func_72912_H().func_76079_c(), playerWorld.func_72912_H().func_76075_d(), playerWorld.func_72912_H().func_76074_e());
        }
        playerIn.func_70029_a(playerWorld);
        playerIn.field_71134_c.func_73080_a((WorldServer)playerIn.field_70170_p);
        String s1 = "local";
        if (netManager.func_74430_c() != null) {
            s1 = netManager.func_74430_c().toString();
        }
        field_148546_d.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)playerIn.func_200200_C_().getString(), (Object)s1, (Object)playerIn.func_145782_y(), (Object)playerIn.field_70165_t, (Object)playerIn.field_70163_u, (Object)playerIn.field_70161_v);
        WorldServer worldserver = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        WorldInfo worldinfo = worldserver.func_72912_H();
        this.func_72381_a(playerIn, null, worldserver);
        NetHandlerPlayServer nethandlerplayserver = new NetHandlerPlayServer(this.field_72400_f, netManager, playerIn);
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketJoinGame(playerIn.func_145782_y(), playerIn.field_71134_c.func_73081_b(), worldinfo.func_76093_s(), worldserver.field_73011_w.func_186058_p(), worldserver.func_175659_aa(), this.func_72352_l(), worldinfo.func_76067_t(), worldserver.func_82736_K().func_82766_b("reducedDebugInfo")));
        nethandlerplayserver.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketServerDifficulty(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketPlayerAbilities(playerIn.field_71075_bZ));
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketHeldItemChange(playerIn.field_71071_by.field_70461_c));
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketUpdateRecipes(this.field_72400_f.func_199529_aN().func_199510_b()));
        nethandlerplayserver.func_147359_a((Packet<?>)new SPacketTagsList(this.field_72400_f.func_199731_aO()));
        this.func_187243_f(playerIn);
        playerIn.func_147099_x().func_150877_d();
        playerIn.func_192037_E().func_192826_c(playerIn);
        this.func_96456_a(worldserver.func_96441_U(), playerIn);
        this.field_72400_f.func_147132_au();
        TextComponentTranslation itextcomponent = playerIn.func_146103_bH().getName().equalsIgnoreCase(s) ? new TextComponentTranslation("multiplayer.player.joined", playerIn.func_145748_c_()) : new TextComponentTranslation("multiplayer.player.joined.renamed", playerIn.func_145748_c_(), s);
        this.func_148539_a(itextcomponent.func_211708_a(TextFormatting.YELLOW));
        this.func_72377_c(playerIn);
        nethandlerplayserver.func_147364_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, playerIn.field_70177_z, playerIn.field_70125_A);
        this.func_72354_b(playerIn, worldserver);
        if (!this.field_72400_f.func_147133_T().isEmpty()) {
            playerIn.func_175397_a(this.field_72400_f.func_147133_T(), this.field_72400_f.func_175581_ab());
        }
        for (PotionEffect potioneffect : playerIn.func_70651_bq()) {
            nethandlerplayserver.func_147359_a((Packet<?>)new SPacketEntityEffect(playerIn.func_145782_y(), potioneffect));
        }
        if (nbttagcompound != null && nbttagcompound.func_150297_b("RootVehicle", 10) && (entity1 = AnvilChunkLoader.func_186051_a((nbttagcompound1 = nbttagcompound.func_74775_l("RootVehicle")).func_74775_l("Entity"), worldserver, true)) != null) {
            UUID uuid = nbttagcompound1.func_186857_a("Attach");
            if (entity1.func_110124_au().equals(uuid)) {
                playerIn.func_184205_a(entity1, true);
            } else {
                for (Entity entity : entity1.func_184182_bu()) {
                    if (!entity.func_110124_au().equals(uuid)) continue;
                    playerIn.func_184205_a(entity, true);
                    break;
                }
            }
            if (!playerIn.func_184218_aH()) {
                field_148546_d.warn("Couldn't reattach entity to player");
                worldserver.func_72973_f(entity1);
                for (Entity entity2 : entity1.func_184182_bu()) {
                    worldserver.func_72973_f(entity2);
                }
            }
        }
        playerIn.func_71116_b();
        BasicEventHooks.firePlayerLoggedIn((EntityPlayer)playerIn);
    }

    protected void func_96456_a(ServerScoreboard scoreboardIn, EntityPlayerMP playerIn) {
        HashSet set = Sets.newHashSet();
        for (ScorePlayerTeam scoreplayerteam : scoreboardIn.func_96525_g()) {
            playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketTeams(scoreplayerteam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = scoreboardIn.func_96539_a(i);
            if (scoreobjective == null || set.contains(scoreobjective)) continue;
            for (Packet packet : scoreboardIn.func_96550_d(scoreobjective)) {
                playerIn.field_71135_a.func_147359_a(packet);
            }
            set.add(scoreobjective);
        }
    }

    public void func_212504_a(WorldServer p_212504_1_) {
        this.field_72412_k = p_212504_1_.func_72860_G().func_75756_e();
        p_212504_1_.func_175723_af().func_177737_a(new IBorderListener(){

            public void func_177694_a(WorldBorder border, double newSize) {
                PlayerList.this.func_148540_a((Packet<?>)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_SIZE));
            }

            public void func_177692_a(WorldBorder border, double oldSize, double newSize, long time) {
                PlayerList.this.func_148540_a((Packet<?>)new SPacketWorldBorder(border, SPacketWorldBorder.Action.LERP_SIZE));
            }

            public void func_177693_a(WorldBorder border, double x, double z) {
                PlayerList.this.func_148540_a((Packet<?>)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_CENTER));
            }

            public void func_177691_a(WorldBorder border, int newTime) {
                PlayerList.this.func_148540_a((Packet<?>)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_WARNING_TIME));
            }

            public void func_177690_b(WorldBorder border, int newDistance) {
                PlayerList.this.func_148540_a((Packet<?>)new SPacketWorldBorder(border, SPacketWorldBorder.Action.SET_WARNING_BLOCKS));
            }

            public void func_177696_b(WorldBorder border, double newAmount) {
            }

            public void func_177695_c(WorldBorder border, double newSize) {
            }
        });
    }

    public void func_72375_a(EntityPlayerMP playerIn, @Nullable WorldServer oldWorld) {
        WorldServer worldserver = playerIn.func_71121_q();
        if (oldWorld != null) {
            oldWorld.func_184164_w().func_72695_c(playerIn);
        }
        worldserver.func_184164_w().func_72683_a(playerIn);
        worldserver.func_72863_F().func_186025_d((int)playerIn.field_70165_t >> 4, (int)playerIn.field_70161_v >> 4, true, true);
        if (oldWorld != null) {
            CriteriaTriggers.field_193134_u.func_193143_a(playerIn, oldWorld.field_73011_w.func_186058_p(), worldserver.field_73011_w.func_186058_p());
            if (oldWorld.field_73011_w.func_186058_p() == DimensionType.NETHER && playerIn.field_70170_p.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && playerIn.func_193106_Q() != null) {
                CriteriaTriggers.field_193131_B.func_193168_a(playerIn, playerIn.func_193106_Q());
            }
        }
    }

    public int func_72372_a() {
        return PlayerChunkMap.func_72686_a((int)this.func_72395_o());
    }

    @Nullable
    public NBTTagCompound func_72380_a(EntityPlayerMP playerIn) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76072_h();
        if (playerIn.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G()) && nbttagcompound != null) {
            nbttagcompound1 = nbttagcompound;
            playerIn.func_70020_e(nbttagcompound);
            field_148546_d.debug("loading single player");
            ForgeEventFactory.firePlayerLoadingEvent((EntityPlayer)playerIn, (IPlayerFileData)this.field_72412_k, (String)playerIn.func_110124_au().toString());
        } else {
            nbttagcompound1 = this.field_72412_k.func_75752_b((EntityPlayer)playerIn);
        }
        return nbttagcompound1;
    }

    protected void func_72391_b(EntityPlayerMP playerIn) {
        PlayerAdvancements playeradvancements;
        if (playerIn.field_71135_a == null) {
            return;
        }
        this.field_72412_k.func_75753_a((EntityPlayer)playerIn);
        StatisticsManagerServer statisticsmanagerserver = this.field_148547_k.get(playerIn.func_110124_au());
        if (statisticsmanagerserver != null) {
            statisticsmanagerserver.func_150883_b();
        }
        if ((playeradvancements = this.field_192055_p.get(playerIn.func_110124_au())) != null) {
            playeradvancements.func_192749_b();
        }
    }

    public void func_72377_c(EntityPlayerMP playerIn) {
        this.field_72404_b.add(playerIn);
        this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        this.func_148540_a((Packet<?>)new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{playerIn}));
        WorldServer worldserver = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{this.field_72404_b.get(i)}));
        }
        ChunkIOExecutor.adjustPoolSize((int)this.func_72394_k());
        worldserver.func_72838_d(playerIn);
        this.func_72375_a(playerIn, null);
        this.field_72400_f.func_201300_aS().func_201383_a(playerIn);
    }

    public void func_72358_d(EntityPlayerMP playerIn) {
        playerIn.func_71121_q().func_184164_w().func_72685_d(playerIn);
    }

    public void func_72367_e(EntityPlayerMP playerIn) {
        Entity entity;
        BasicEventHooks.firePlayerLoggedOut((EntityPlayer)playerIn);
        WorldServer worldserver = playerIn.func_71121_q();
        playerIn.func_195066_a(StatList.field_75947_j);
        this.func_72391_b(playerIn);
        if (playerIn.func_184218_aH() && (entity = playerIn.func_184208_bv()).func_200601_bK()) {
            field_148546_d.debug("Removing player mount");
            playerIn.func_184210_p();
            worldserver.func_72973_f(entity);
            for (Entity entity1 : entity.func_184182_bu()) {
                worldserver.func_72973_f(entity1);
            }
            worldserver.func_72964_e(playerIn.field_70176_ah, playerIn.field_70164_aj).func_76630_e();
        }
        ChunkIOExecutor.adjustPoolSize((int)this.func_72394_k());
        worldserver.func_72900_e(playerIn);
        worldserver.func_184164_w().func_72695_c(playerIn);
        playerIn.func_192039_O().func_192745_a();
        this.field_72404_b.remove((Object)playerIn);
        this.field_72400_f.func_201300_aS().func_201382_b(playerIn);
        UUID uuid = playerIn.func_110124_au();
        EntityPlayerMP entityplayermp = this.field_177454_f.get(uuid);
        if (entityplayermp == playerIn) {
            this.field_177454_f.remove(uuid);
            this.field_148547_k.remove(uuid);
            this.field_192055_p.remove(uuid);
        }
        this.func_148540_a((Packet<?>)new SPacketPlayerListItem(SPacketPlayerListItem.Action.REMOVE_PLAYER, new EntityPlayerMP[]{playerIn}));
    }

    @Nullable
    public ITextComponent func_206258_a(SocketAddress p_206258_1_, GameProfile p_206258_2_) {
        if (this.field_72401_g.func_152702_a(p_206258_2_)) {
            UserListBansEntry userlistbansentry = (UserListBansEntry)this.field_72401_g.func_152683_b((Object)p_206258_2_);
            TextComponentTranslation itextcomponent1 = new TextComponentTranslation("multiplayer.disconnect.banned.reason", userlistbansentry.func_73686_f());
            if (userlistbansentry.func_73680_d() != null) {
                itextcomponent1.func_150257_a((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.banned.expiration", field_72403_e.format(userlistbansentry.func_73680_d())));
            }
            return itextcomponent1;
        }
        if (!this.func_152607_e(p_206258_2_)) {
            return new TextComponentTranslation("multiplayer.disconnect.not_whitelisted", new Object[0]);
        }
        if (this.field_72413_h.func_152708_a(p_206258_1_)) {
            UserListIPBansEntry userlistipbansentry = this.field_72413_h.func_152709_b(p_206258_1_);
            TextComponentTranslation itextcomponent = new TextComponentTranslation("multiplayer.disconnect.banned_ip.reason", userlistipbansentry.func_73686_f());
            if (userlistipbansentry.func_73680_d() != null) {
                itextcomponent.func_150257_a((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.banned_ip.expiration", field_72403_e.format(userlistipbansentry.func_73680_d())));
            }
            return itextcomponent;
        }
        return this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(p_206258_2_) ? new TextComponentTranslation("multiplayer.disconnect.server_full", new Object[0]) : null;
    }

    public EntityPlayerMP func_148545_a(GameProfile profile) {
        UUID uuid = EntityPlayer.func_146094_a(profile);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            Object entityplayermp = this.field_72404_b.get(i);
            if (!entityplayermp.func_110124_au().equals(uuid)) continue;
            list.add(entityplayermp);
        }
        EntityPlayerMP entityplayermp2 = this.field_177454_f.get(profile.getId());
        if (entityplayermp2 != null && !list.contains((Object)entityplayermp2)) {
            list.add(entityplayermp2);
        }
        for (EntityPlayerMP entityplayermp1 : list) {
            entityplayermp1.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.duplicate_login", new Object[0]));
        }
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager((World)this.field_72400_f.func_71218_a(DimensionType.OVERWORLD)) : new PlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD));
        return new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(DimensionType.OVERWORLD), profile, (PlayerInteractionManager)playerinteractionmanager);
    }

    public EntityPlayerMP func_72368_a(EntityPlayerMP playerIn, DimensionType dimension, boolean conqueredEnd) {
        WorldServer world = this.field_72400_f.func_71218_a(dimension);
        if (world == null) {
            dimension = playerIn.getSpawnDimension();
        } else if (!world.func_201675_m().func_76567_e()) {
            dimension = world.func_201675_m().getRespawnDimension(playerIn);
        }
        if (this.field_72400_f.func_71218_a(dimension) == null) {
            dimension = DimensionType.OVERWORLD;
        }
        playerIn.func_71121_q().func_73039_n().func_72787_a(playerIn);
        playerIn.func_71121_q().func_73039_n().func_72790_b(playerIn);
        playerIn.func_71121_q().func_184164_w().func_72695_c(playerIn);
        this.field_72404_b.remove((Object)playerIn);
        this.field_72400_f.func_71218_a(playerIn.field_71093_bK).removeEntityDangerously(playerIn, true);
        BlockPos blockpos = playerIn.getBedLocation(dimension);
        boolean flag = playerIn.isSpawnForced(dimension);
        playerIn.field_71093_bK = dimension;
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager((World)this.field_72400_f.func_71218_a(playerIn.field_71093_bK)) : new PlayerInteractionManager(this.field_72400_f.func_71218_a(playerIn.field_71093_bK));
        EntityPlayerMP entityplayermp = new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(playerIn.field_71093_bK), playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        entityplayermp.field_71135_a = playerIn.field_71135_a;
        entityplayermp.func_193104_a(playerIn, conqueredEnd);
        playerIn.remove(false);
        entityplayermp.field_71093_bK = dimension;
        entityplayermp.func_145769_d(playerIn.func_145782_y());
        entityplayermp.func_184819_a(playerIn.func_184591_cq());
        for (String s : playerIn.func_184216_O()) {
            entityplayermp.func_184211_a(s);
        }
        WorldServer worldserver = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        this.func_72381_a(entityplayermp, playerIn, worldserver);
        if (blockpos != null) {
            BlockPos blockpos1 = EntityPlayer.func_180467_a((IBlockReader)this.field_72400_f.func_71218_a(playerIn.field_71093_bK), blockpos, flag);
            if (blockpos1 != null) {
                entityplayermp.func_70012_b((float)blockpos1.func_177958_n() + 0.5f, (float)blockpos1.func_177956_o() + 0.1f, (float)blockpos1.func_177952_p() + 0.5f, 0.0f, 0.0f);
                entityplayermp.setSpawnPoint(blockpos, flag, playerIn.field_71093_bK);
            } else {
                entityplayermp.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(0, 0.0f));
            }
        }
        worldserver.func_72863_F().func_186025_d((int)entityplayermp.field_70165_t >> 4, (int)entityplayermp.field_70161_v >> 4, true, true);
        while (!worldserver.func_195586_b(entityplayermp, entityplayermp.func_174813_aQ()) && entityplayermp.field_70163_u < 256.0) {
            entityplayermp.func_70107_b(entityplayermp.field_70165_t, entityplayermp.field_70163_u + 1.0, entityplayermp.field_70161_v);
        }
        entityplayermp.field_71135_a.func_147359_a((Packet<?>)new SPacketRespawn(entityplayermp.field_71093_bK, world.func_175659_aa(), world.func_72912_H().func_76067_t(), entityplayermp.field_71134_c.func_73081_b()));
        BlockPos blockpos2 = worldserver.func_175694_M();
        entityplayermp.field_71135_a.func_147364_a(entityplayermp.field_70165_t, entityplayermp.field_70163_u, entityplayermp.field_70161_v, entityplayermp.field_70177_z, entityplayermp.field_70125_A);
        entityplayermp.field_71135_a.func_147359_a((Packet<?>)new SPacketSpawnPosition(blockpos2));
        entityplayermp.field_71135_a.func_147359_a((Packet<?>)new SPacketSetExperience(entityplayermp.field_71106_cc, entityplayermp.field_71067_cb, entityplayermp.field_71068_ca));
        this.func_72354_b(entityplayermp, worldserver);
        this.func_187243_f(entityplayermp);
        worldserver.func_184164_w().func_72683_a(entityplayermp);
        worldserver.func_72838_d(entityplayermp);
        this.field_72404_b.add(entityplayermp);
        this.field_177454_f.put(entityplayermp.func_110124_au(), entityplayermp);
        entityplayermp.func_71116_b();
        entityplayermp.func_70606_j(entityplayermp.func_110143_aJ());
        BasicEventHooks.firePlayerRespawnEvent((EntityPlayer)entityplayermp, (boolean)conqueredEnd);
        return entityplayermp;
    }

    public void func_187243_f(EntityPlayerMP player) {
        GameProfile gameprofile = player.func_146103_bH();
        int i = this.field_72400_f.func_211833_a(gameprofile);
        this.func_187245_a(player, i);
    }

    public void func_187242_a(EntityPlayerMP player, DimensionType dimensionIn) {
        this.changePlayerDimension(player, dimensionIn, this.field_72400_f.func_71218_a(dimensionIn).func_85176_s());
    }

    public void changePlayerDimension(EntityPlayerMP player, DimensionType dimensionIn, ITeleporter teleporter) {
        DimensionType dimensiontype = player.field_71093_bK;
        WorldServer worldserver = this.field_72400_f.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimensionIn;
        WorldServer worldserver1 = this.field_72400_f.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet<?>)new SPacketRespawn(player.field_71093_bK, worldserver1.func_175659_aa(), worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        this.func_187243_f(player);
        worldserver.removeEntityDangerously(player, true);
        player.revive();
        this.transferEntityToWorld(player, dimensiontype, worldserver, worldserver1, teleporter);
        this.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        player.field_71135_a.func_147359_a((Packet<?>)new SPacketPlayerAbilities(player.field_71075_bZ));
        this.func_72354_b(player, worldserver1);
        this.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        AttributeMap attributemap = (AttributeMap)player.func_110140_aT();
        Collection watchedAttribs = attributemap.func_111160_c();
        if (!watchedAttribs.isEmpty()) {
            player.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityProperties(player.func_145782_y(), watchedAttribs));
        }
        BasicEventHooks.firePlayerChangedDimensionEvent((EntityPlayer)player, (DimensionType)dimensiontype, (DimensionType)dimensionIn);
    }

    public void func_82448_a(Entity entityIn, DimensionType lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn) {
        this.transferEntityToWorld(entityIn, lastDimension, oldWorldIn, toWorldIn, toWorldIn.func_85176_s());
    }

    public void transferEntityToWorld(Entity entityIn, DimensionType lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn, ITeleporter teleporter) {
        double moveFactor = oldWorldIn.func_201675_m().getMovementFactor() / toWorldIn.func_201675_m().getMovementFactor();
        double d0 = MathHelper.func_151237_a((double)(entityIn.field_70165_t * moveFactor), (double)(toWorldIn.func_175723_af().func_177726_b() + 16.0), (double)(toWorldIn.func_175723_af().func_177728_d() - 16.0));
        double d1 = MathHelper.func_151237_a((double)(entityIn.field_70161_v * moveFactor), (double)(toWorldIn.func_175723_af().func_177736_c() + 16.0), (double)(toWorldIn.func_175723_af().func_177733_e() - 16.0));
        double d2 = 8.0;
        float f = entityIn.field_70177_z;
        oldWorldIn.field_72984_F.func_76320_a("moving");
        if (entityIn.field_71093_bK == DimensionType.THE_END && teleporter.isVanilla()) {
            BlockPos blockpos = lastDimension == DimensionType.THE_END ? toWorldIn.func_175694_M() : toWorldIn.func_180504_m();
            d0 = blockpos.func_177958_n();
            entityIn.field_70163_u = blockpos.func_177956_o();
            d1 = blockpos.func_177952_p();
            entityIn.func_70012_b(d0, entityIn.field_70163_u, d1, 90.0f, 0.0f);
            if (entityIn.func_70089_S()) {
                oldWorldIn.func_72866_a(entityIn, false);
            }
        }
        oldWorldIn.field_72984_F.func_76319_b();
        if (lastDimension != DimensionType.THE_END || !teleporter.isVanilla()) {
            oldWorldIn.field_72984_F.func_76320_a("placing");
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            if (entityIn.func_70089_S()) {
                entityIn.func_70012_b(d0, entityIn.field_70163_u, d1, entityIn.field_70177_z, entityIn.field_70125_A);
                toWorldIn.func_72866_a(entityIn, false);
                teleporter.placeEntity((World)toWorldIn, entityIn, f);
                toWorldIn.func_72838_d(entityIn);
                toWorldIn.func_72866_a(entityIn, false);
            }
            oldWorldIn.field_72984_F.func_76319_b();
        }
        entityIn.func_70029_a(toWorldIn);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.func_148540_a((Packet<?>)new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_LATENCY, this.field_72404_b));
            this.field_72408_o = 0;
        }
    }

    public void func_148540_a(Packet<?> packetIn) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_148537_a(Packet<?> packetIn, DimensionType dimension) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityplayermp = this.field_72404_b.get(i);
            if (entityplayermp.field_71093_bK != dimension) continue;
            entityplayermp.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_177453_a(EntityPlayer player, ITextComponent message) {
        Team team = player.func_96124_cp();
        if (team != null) {
            for (String s : team.func_96670_d()) {
                EntityPlayerMP entityplayermp = this.func_152612_a(s);
                if (entityplayermp == null || entityplayermp == player) continue;
                entityplayermp.func_145747_a(message);
            }
        }
    }

    public void func_177452_b(EntityPlayer player, ITextComponent message) {
        Team team = player.func_96124_cp();
        if (team == null) {
            this.func_148539_a(message);
        } else {
            for (int i = 0; i < this.field_72404_b.size(); ++i) {
                EntityPlayerMP entityplayermp = this.field_72404_b.get(i);
                if (entityplayermp.func_96124_cp() == team) continue;
                entityplayermp.func_145747_a(message);
            }
        }
    }

    public String[] func_72369_d() {
        String[] astring = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            astring[i] = this.field_72404_b.get(i).func_146103_bH().getName();
        }
        return astring;
    }

    public UserListBans func_152608_h() {
        return this.field_72401_g;
    }

    public UserListIPBans func_72363_f() {
        return this.field_72413_h;
    }

    public void func_152605_a(GameProfile profile) {
        this.field_72414_i.func_152687_a((UserListEntry)new UserListOpsEntry(profile, this.field_72400_f.func_110455_j(), this.field_72414_i.func_183026_b(profile)));
        EntityPlayerMP entityplayermp = this.func_177451_a(profile.getId());
        if (entityplayermp != null) {
            this.func_187243_f(entityplayermp);
        }
    }

    public void func_152610_b(GameProfile profile) {
        this.field_72414_i.func_152684_c((Object)profile);
        EntityPlayerMP entityplayermp = this.func_177451_a(profile.getId());
        if (entityplayermp != null) {
            this.func_187243_f(entityplayermp);
        }
    }

    private void func_187245_a(EntityPlayerMP player, int permLevel) {
        if (player.field_71135_a != null) {
            byte b0 = permLevel <= 0 ? (byte)24 : (permLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permLevel)));
            player.field_71135_a.func_147359_a((Packet<?>)new SPacketEntityStatus((Entity)player, b0));
        }
        this.field_72400_f.func_195571_aL().func_197051_a(player);
    }

    public boolean func_152607_e(GameProfile profile) {
        return !this.field_72409_l || this.field_72414_i.func_152692_d((Object)profile) || this.field_72411_j.func_152692_d((Object)profile);
    }

    public boolean func_152596_g(GameProfile profile) {
        return this.field_72414_i.func_152692_d((Object)profile) || this.field_72400_f.func_71264_H() && this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76086_u() && this.field_72400_f.func_71214_G().equalsIgnoreCase(profile.getName()) || this.field_72407_n;
    }

    @Nullable
    public EntityPlayerMP func_152612_a(String username) {
        for (EntityPlayerMP entityplayermp : this.field_72404_b) {
            if (!entityplayermp.func_146103_bH().getName().equalsIgnoreCase(username)) continue;
            return entityplayermp;
        }
        return null;
    }

    public void func_148543_a(@Nullable EntityPlayer except, double x, double y, double z, double radius, DimensionType dimension, Packet<?> packetIn) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            double d2;
            double d1;
            double d0;
            EntityPlayerMP entityplayermp = this.field_72404_b.get(i);
            if (entityplayermp == except || entityplayermp.field_71093_bK != dimension || !((d0 = x - entityplayermp.field_70165_t) * d0 + (d1 = y - entityplayermp.field_70163_u) * d1 + (d2 = z - entityplayermp.field_70161_v) * d2 < radius * radius)) continue;
            entityplayermp.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b(this.field_72404_b.get(i));
        }
    }

    public UserListWhitelist func_152599_k() {
        return this.field_72411_j;
    }

    public String[] func_152598_l() {
        return this.field_72411_j.func_152685_a();
    }

    public UserListOps func_152603_m() {
        return this.field_72414_i;
    }

    public String[] func_152606_n() {
        return this.field_72414_i.func_152685_a();
    }

    public void func_187244_a() {
    }

    public void func_72354_b(EntityPlayerMP playerIn, WorldServer worldIn) {
        WorldBorder worldborder = this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_175723_af();
        playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketWorldBorder(worldborder, SPacketWorldBorder.Action.INITIALIZE));
        playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketTimeUpdate(worldIn.func_82737_E(), worldIn.func_72820_D(), worldIn.func_82736_K().func_82766_b("doDaylightCycle")));
        BlockPos blockpos = worldIn.func_175694_M();
        playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketSpawnPosition(blockpos));
        if (worldIn.func_72896_J()) {
            playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(1, 0.0f));
            playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(7, worldIn.func_72867_j(1.0f)));
            playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketChangeGameState(8, worldIn.func_72819_i(1.0f)));
        }
    }

    public void func_72385_f(EntityPlayerMP playerIn) {
        playerIn.func_71120_a(playerIn.field_71069_bz);
        playerIn.func_71118_n();
        playerIn.field_71135_a.func_147359_a((Packet<?>)new SPacketHeldItemChange(playerIn.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public String[] func_72373_m() {
        return this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75756_e().func_75754_f();
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean whitelistEnabled) {
        this.field_72409_l = whitelistEnabled;
    }

    public List<EntityPlayerMP> func_72382_j(String address) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayerMP entityplayermp : this.field_72404_b) {
            if (!entityplayermp.func_71114_r().equals(address)) continue;
            list.add(entityplayermp);
        }
        return list;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public NBTTagCompound func_72378_q() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_152604_a(GameType gameModeIn) {
        this.field_72410_m = gameModeIn;
    }

    private void func_72381_a(EntityPlayerMP target, EntityPlayerMP source, IWorld worldIn) {
        if (source != null) {
            target.field_71134_c.func_73076_a(source.field_71134_c.func_73081_b());
        } else if (this.field_72410_m != null) {
            target.field_71134_c.func_73076_a(this.field_72410_m);
        }
        target.field_71134_c.func_73077_b(worldIn.func_72912_H().func_76077_q());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72387_b(boolean p_72387_1_) {
        this.field_72407_n = p_72387_1_;
    }

    public void func_72392_r() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.server_shutdown", new Object[0]));
        }
    }

    public void func_148544_a(ITextComponent component, boolean isSystem) {
        this.field_72400_f.func_145747_a(component);
        ChatType chattype = isSystem ? ChatType.SYSTEM : ChatType.CHAT;
        this.func_148540_a((Packet<?>)new SPacketChat(component, chattype));
    }

    public void func_148539_a(ITextComponent component) {
        this.func_148544_a(component, true);
    }

    public StatisticsManagerServer func_152602_a(EntityPlayer playerIn) {
        StatisticsManagerServer statisticsmanagerserver;
        UUID uuid = playerIn.func_110124_au();
        StatisticsManagerServer statisticsManagerServer = statisticsmanagerserver = uuid == null ? null : this.field_148547_k.get(uuid);
        if (statisticsmanagerserver == null) {
            File file3;
            File file1 = new File(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "stats");
            File file2 = new File(file1, uuid + ".json");
            if (!file2.exists() && (file3 = new File(file1, playerIn.func_200200_C_().getString() + ".json")).exists() && file3.isFile()) {
                file3.renameTo(file2);
            }
            statisticsmanagerserver = new StatisticsManagerServer(this.field_72400_f, file2);
            this.field_148547_k.put(uuid, statisticsmanagerserver);
        }
        return statisticsmanagerserver;
    }

    public PlayerAdvancements func_192054_h(EntityPlayerMP p_192054_1_) {
        UUID uuid = p_192054_1_.func_110124_au();
        PlayerAdvancements playeradvancements = this.field_192055_p.get(uuid);
        if (playeradvancements == null) {
            File file1 = new File(this.field_72400_f.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "advancements");
            File file2 = new File(file1, uuid + ".json");
            playeradvancements = new PlayerAdvancements(this.field_72400_f, file2, p_192054_1_);
            this.field_192055_p.put(uuid, playeradvancements);
        }
        playeradvancements.func_192739_a(p_192054_1_);
        return playeradvancements;
    }

    public void func_152611_a(int distance) {
        this.field_72402_d = distance;
        for (WorldServer worldserver : this.field_72400_f.func_212370_w()) {
            if (worldserver == null) continue;
            worldserver.func_184164_w().func_152622_a(distance);
            worldserver.func_73039_n().func_187252_a(distance);
        }
    }

    public List<EntityPlayerMP> func_181057_v() {
        return this.field_72404_b;
    }

    @Nullable
    public EntityPlayerMP func_177451_a(UUID playerUUID) {
        return this.field_177454_f.get(playerUUID);
    }

    public boolean func_183023_f(GameProfile profile) {
        return false;
    }

    public void func_193244_w() {
        for (PlayerAdvancements playeradvancements : this.field_192055_p.values()) {
            playeradvancements.func_193766_b();
        }
        this.func_148540_a((Packet<?>)new SPacketTagsList(this.field_72400_f.func_199731_aO()));
        SPacketUpdateRecipes spacketupdaterecipes = new SPacketUpdateRecipes(this.field_72400_f.func_199529_aN().func_199510_b());
        for (EntityPlayerMP entityplayermp : this.field_72404_b) {
            entityplayermp.field_71135_a.func_147359_a((Packet<?>)spacketupdaterecipes);
            entityplayermp.func_192037_E().func_192826_c(entityplayermp);
        }
    }

    public boolean func_206257_x() {
        return this.field_72407_n;
    }
}

