/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;

public class Tag<T> {
    private final ResourceLocation field_199888_a;
    private final Set<T> field_199889_b;
    private final Collection<ITagEntry<T>> field_200150_c;

    public Tag(ResourceLocation resourceLocationIn) {
        this.field_199888_a = resourceLocationIn;
        this.field_199889_b = Collections.emptySet();
        this.field_200150_c = Collections.emptyList();
    }

    public Tag(ResourceLocation resourceLocationIn, Collection<ITagEntry<T>> entriesIn, boolean preserveOrder) {
        this.field_199888_a = resourceLocationIn;
        this.field_199889_b = preserveOrder ? Sets.newLinkedHashSet() : Sets.newHashSet();
        this.field_200150_c = entriesIn;
        for (ITagEntry<T> itagentry : entriesIn) {
            itagentry.func_200162_a(this.field_199889_b);
        }
    }

    public JsonObject func_200571_a(Function<T, ResourceLocation> getNameForObject) {
        JsonObject jsonobject = new JsonObject();
        JsonArray jsonarray = new JsonArray();
        for (ITagEntry<T> itagentry : this.field_200150_c) {
            itagentry.func_200576_a(jsonarray, getNameForObject);
        }
        jsonobject.addProperty("replace", Boolean.valueOf(false));
        jsonobject.add("values", (JsonElement)jsonarray);
        return jsonobject;
    }

    public boolean func_199685_a_(T itemIn) {
        return this.field_199889_b.contains(itemIn);
    }

    public Collection<T> func_199885_a() {
        return this.field_199889_b;
    }

    public Collection<ITagEntry<T>> func_200570_b() {
        return this.field_200150_c;
    }

    public T func_205596_a(Random random) {
        ArrayList list = Lists.newArrayList(this.func_199885_a());
        return (T)list.get(random.nextInt(list.size()));
    }

    public ResourceLocation func_199886_b() {
        return this.field_199888_a;
    }

    public static class TagEntry<T>
    implements ITagEntry<T> {
        @Nullable
        private final ResourceLocation field_200163_a;
        @Nullable
        private Tag<T> field_200164_b;

        public TagEntry(ResourceLocation resourceLocationIn) {
            this.field_200163_a = resourceLocationIn;
        }

        public TagEntry(Tag<T> tagIn) {
            this.field_200163_a = tagIn.func_199886_b();
            this.field_200164_b = tagIn;
        }

        @Override
        public boolean func_200161_a(Function<ResourceLocation, Tag<T>> resourceLocationToTag) {
            if (this.field_200164_b == null) {
                this.field_200164_b = resourceLocationToTag.apply(this.field_200163_a);
            }
            return this.field_200164_b != null;
        }

        @Override
        public void func_200162_a(Collection<T> itemsIn) {
            if (this.field_200164_b == null) {
                throw new IllegalStateException("Cannot build unresolved tag entry");
            }
            itemsIn.addAll(this.field_200164_b.func_199885_a());
        }

        public ResourceLocation func_200577_a() {
            if (this.field_200164_b != null) {
                return this.field_200164_b.func_199886_b();
            }
            if (this.field_200163_a != null) {
                return this.field_200163_a;
            }
            throw new IllegalStateException("Cannot serialize an anonymous tag to json!");
        }

        @Override
        public void func_200576_a(JsonArray array, Function<T, ResourceLocation> getNameForObject) {
            array.add("#" + this.func_200577_a());
        }

        public int hashCode() {
            return Objects.hashCode(this.field_200163_a);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TagEntry && Objects.equals(this.field_200163_a, ((TagEntry)o).field_200163_a);
        }
    }

    public static class ListEntry<T>
    implements ITagEntry<T> {
        private final Collection<T> field_200165_a;

        public ListEntry(Collection<T> taggedItemsIn) {
            this.field_200165_a = taggedItemsIn;
        }

        @Override
        public void func_200162_a(Collection<T> itemsIn) {
            itemsIn.addAll(this.field_200165_a);
        }

        @Override
        public void func_200576_a(JsonArray array, Function<T, ResourceLocation> getNameForObject) {
            for (T t : this.field_200165_a) {
                ResourceLocation resourcelocation = getNameForObject.apply(t);
                if (resourcelocation == null) {
                    throw new IllegalStateException("Unable to serialize an anonymous value to json!");
                }
                array.add(resourcelocation.toString());
            }
        }

        public Collection<T> func_200578_a() {
            return this.field_200165_a;
        }

        public int hashCode() {
            return this.field_200165_a.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ListEntry && this.field_200165_a.equals(((ListEntry)o).field_200165_a);
        }
    }

    public static interface ITagEntry<T> {
        default public boolean func_200161_a(Function<ResourceLocation, Tag<T>> resourceLocationToTag) {
            return true;
        }

        public void func_200162_a(Collection<T> var1);

        public void func_200576_a(JsonArray var1, Function<T, ResourceLocation> var2);
    }

    public static class Builder<T> {
        private final Set<ITagEntry<T>> field_200052_a = Sets.newLinkedHashSet();
        private boolean field_200053_b;

        public static <T> Builder<T> func_200047_a() {
            return new Builder<T>();
        }

        public Builder<T> func_200575_a(ITagEntry<T> entry) {
            this.field_200052_a.add(entry);
            return this;
        }

        public Builder<T> func_200048_a(T itemIn) {
            this.field_200052_a.add(new ListEntry<T>(Collections.singleton(itemIn)));
            return this;
        }

        @SafeVarargs
        public final Builder<T> func_200573_a(T ... itemsIn) {
            this.field_200052_a.add(new ListEntry(Lists.newArrayList((Object[])itemsIn)));
            return this;
        }

        public Builder<T> func_200046_a(Collection<T> itemsIn) {
            this.field_200052_a.add(new ListEntry<T>(itemsIn));
            return this;
        }

        public Builder<T> func_200159_a(ResourceLocation resourceLocationIn) {
            this.field_200052_a.add(new TagEntry(resourceLocationIn));
            return this;
        }

        public Builder<T> func_200574_a(Tag<T> tagIn) {
            this.field_200052_a.add(new TagEntry<T>(tagIn));
            return this;
        }

        public Builder<T> func_200045_a(boolean preserveOrderIn) {
            this.field_200053_b = preserveOrderIn;
            return this;
        }

        public boolean func_200160_a(Function<ResourceLocation, Tag<T>> resourceLocationToTag) {
            for (ITagEntry<T> itagentry : this.field_200052_a) {
                if (itagentry.func_200161_a(resourceLocationToTag)) continue;
                return false;
            }
            return true;
        }

        public Tag<T> func_200051_a(ResourceLocation resourceLocationIn) {
            return new Tag<T>(resourceLocationIn, this.field_200052_a, this.field_200053_b);
        }

        public Builder<T> func_200158_a(Predicate<ResourceLocation> isValueKnownPredicate, Function<ResourceLocation, T> objectGetter, JsonObject json) {
            JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"values");
            if (JsonUtils.func_151209_a((JsonObject)json, (String)"replace", (boolean)false)) {
                this.field_200052_a.clear();
            }
            for (JsonElement jsonelement : jsonarray) {
                String s = JsonUtils.func_151206_a((JsonElement)jsonelement, (String)"value");
                if (!s.startsWith("#")) {
                    ResourceLocation resourcelocation = new ResourceLocation(s);
                    T t = objectGetter.apply(resourcelocation);
                    if (t == null || !isValueKnownPredicate.test(resourcelocation)) {
                        throw new JsonParseException("Unknown value '" + resourcelocation + "'");
                    }
                    this.func_200048_a(t);
                    continue;
                }
                this.func_200159_a(new ResourceLocation(s.substring(1)));
            }
            ForgeHooks.deserializeTagAdditions((Builder)this, isValueKnownPredicate, objectGetter, (JsonObject)json);
            return this;
        }

        public Builder<T> remove(ITagEntry<T> e) {
            this.field_200052_a.remove(e);
            return this;
        }
    }
}

