/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.border;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.border.EnumBorderStatus;
import net.minecraft.world.border.IBorderListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldBorder {
    private final List<IBorderListener> field_177758_a = Lists.newArrayList();
    private double field_177763_i = 0.2;
    private double field_177760_j = 5.0;
    private int field_177761_k = 15;
    private int field_177759_l = 5;
    private double field_177756_b;
    private double field_177757_c;
    private int field_177762_h = 29999984;
    private IBorderInfo field_212674_i = new StationaryBorderInfo(6.0E7);

    public boolean func_177746_a(BlockPos pos) {
        return (double)(pos.func_177958_n() + 1) > this.func_177726_b() && (double)pos.func_177958_n() < this.func_177728_d() && (double)(pos.func_177952_p() + 1) > this.func_177736_c() && (double)pos.func_177952_p() < this.func_177733_e();
    }

    public boolean func_177730_a(ChunkPos range) {
        return (double)range.func_180332_e() > this.func_177726_b() && (double)range.func_180334_c() < this.func_177728_d() && (double)range.func_180330_f() > this.func_177736_c() && (double)range.func_180333_d() < this.func_177733_e();
    }

    public boolean func_177743_a(AxisAlignedBB bb) {
        return bb.field_72336_d > this.func_177726_b() && bb.field_72340_a < this.func_177728_d() && bb.field_72334_f > this.func_177736_c() && bb.field_72339_c < this.func_177733_e();
    }

    public double func_177745_a(Entity entityIn) {
        return this.func_177729_b(entityIn.field_70165_t, entityIn.field_70161_v);
    }

    public double func_177729_b(double x, double z) {
        double d0 = z - this.func_177736_c();
        double d1 = this.func_177733_e() - z;
        double d2 = x - this.func_177726_b();
        double d3 = this.func_177728_d() - x;
        double d4 = Math.min(d2, d3);
        d4 = Math.min(d4, d0);
        return Math.min(d4, d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumBorderStatus func_177734_a() {
        return this.field_212674_i.func_212655_i();
    }

    public double func_177726_b() {
        return this.field_212674_i.func_212658_a();
    }

    public double func_177736_c() {
        return this.field_212674_i.func_212656_c();
    }

    public double func_177728_d() {
        return this.field_212674_i.func_212654_b();
    }

    public double func_177733_e() {
        return this.field_212674_i.func_212648_d();
    }

    public double func_177731_f() {
        return this.field_177756_b;
    }

    public double func_177721_g() {
        return this.field_177757_c;
    }

    public void func_177739_c(double x, double z) {
        this.field_177756_b = x;
        this.field_177757_c = z;
        this.field_212674_i.func_212653_k();
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177693_a(this, x, z);
        }
    }

    public double func_177741_h() {
        return this.field_212674_i.func_212647_e();
    }

    public long func_177732_i() {
        return this.field_212674_i.func_212657_g();
    }

    public double func_177751_j() {
        return this.field_212674_i.func_212650_h();
    }

    public void func_177750_a(double newSize) {
        this.field_212674_i = new StationaryBorderInfo(newSize);
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177694_a(this, newSize);
        }
    }

    public void func_177738_a(double oldSize, double newSize, long time) {
        this.field_212674_i = oldSize != newSize ? new MovingBorderInfo(oldSize, newSize, time) : new StationaryBorderInfo(newSize);
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177692_a(this, oldSize, newSize, time);
        }
    }

    protected List<IBorderListener> func_177735_k() {
        return Lists.newArrayList(this.field_177758_a);
    }

    public void func_177737_a(IBorderListener listener) {
        this.field_177758_a.add(listener);
    }

    public void removeListener(IBorderListener listener) {
        this.field_177758_a.remove(listener);
    }

    public void func_177725_a(int size) {
        this.field_177762_h = size;
        this.field_212674_i.func_212652_j();
    }

    public int func_177722_l() {
        return this.field_177762_h;
    }

    public double func_177742_m() {
        return this.field_177760_j;
    }

    public void func_177724_b(double bufferSize) {
        this.field_177760_j = bufferSize;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177695_c(this, bufferSize);
        }
    }

    public double func_177727_n() {
        return this.field_177763_i;
    }

    public void func_177744_c(double newAmount) {
        this.field_177763_i = newAmount;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177696_b(this, newAmount);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177749_o() {
        return this.field_212674_i.func_212649_f();
    }

    public int func_177740_p() {
        return this.field_177761_k;
    }

    public void func_177723_b(int warningTime) {
        this.field_177761_k = warningTime;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177691_a(this, warningTime);
        }
    }

    public int func_177748_q() {
        return this.field_177759_l;
    }

    public void func_177747_c(int warningDistance) {
        this.field_177759_l = warningDistance;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177690_b(this, warningDistance);
        }
    }

    public void func_212673_r() {
        this.field_212674_i = this.field_212674_i.func_212651_l();
    }

    class StationaryBorderInfo
    implements IBorderInfo {
        private final double field_212667_b;
        private double field_212668_c;
        private double field_212669_d;
        private double field_212670_e;
        private double field_212671_f;

        public StationaryBorderInfo(double p_i49837_2_) {
            this.field_212667_b = p_i49837_2_;
            this.func_212665_m();
        }

        @Override
        public double func_212658_a() {
            return this.field_212668_c;
        }

        @Override
        public double func_212654_b() {
            return this.field_212670_e;
        }

        @Override
        public double func_212656_c() {
            return this.field_212669_d;
        }

        @Override
        public double func_212648_d() {
            return this.field_212671_f;
        }

        @Override
        public double func_212647_e() {
            return this.field_212667_b;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public EnumBorderStatus func_212655_i() {
            return EnumBorderStatus.STATIONARY;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return 0.0;
        }

        @Override
        public long func_212657_g() {
            return 0L;
        }

        @Override
        public double func_212650_h() {
            return this.field_212667_b;
        }

        private void func_212665_m() {
            this.field_212668_c = Math.max(WorldBorder.this.func_177731_f() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212669_d = Math.max(WorldBorder.this.func_177721_g() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212670_e = Math.min(WorldBorder.this.func_177731_f() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
            this.field_212671_f = Math.min(WorldBorder.this.func_177721_g() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public void func_212652_j() {
            this.func_212665_m();
        }

        @Override
        public void func_212653_k() {
            this.func_212665_m();
        }

        @Override
        public IBorderInfo func_212651_l() {
            return this;
        }
    }

    class MovingBorderInfo
    implements IBorderInfo {
        private final double field_212660_b;
        private final double field_212661_c;
        private final long field_212662_d;
        private final long field_212663_e;
        private final double field_212664_f;

        private MovingBorderInfo(double p_i49838_2_, double p_i49838_4_, long p_i49838_6_) {
            this.field_212660_b = p_i49838_2_;
            this.field_212661_c = p_i49838_4_;
            this.field_212664_f = p_i49838_6_;
            this.field_212663_e = Util.func_211177_b();
            this.field_212662_d = this.field_212663_e + p_i49838_6_;
        }

        @Override
        public double func_212658_a() {
            return Math.max(WorldBorder.this.func_177731_f() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212656_c() {
            return Math.max(WorldBorder.this.func_177721_g() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212654_b() {
            return Math.min(WorldBorder.this.func_177731_f() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212648_d() {
            return Math.min(WorldBorder.this.func_177721_g() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212647_e() {
            double d0 = (double)(Util.func_211177_b() - this.field_212663_e) / this.field_212664_f;
            return d0 < 1.0 ? this.field_212660_b + (this.field_212661_c - this.field_212660_b) * d0 : this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return Math.abs(this.field_212660_b - this.field_212661_c) / (double)(this.field_212662_d - this.field_212663_e);
        }

        @Override
        public long func_212657_g() {
            return this.field_212662_d - Util.func_211177_b();
        }

        @Override
        public double func_212650_h() {
            return this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public EnumBorderStatus func_212655_i() {
            return this.field_212661_c < this.field_212660_b ? EnumBorderStatus.SHRINKING : EnumBorderStatus.GROWING;
        }

        @Override
        public void func_212653_k() {
        }

        @Override
        public void func_212652_j() {
        }

        @Override
        public IBorderInfo func_212651_l() {
            IBorderInfo iBorderInfo;
            if (this.func_212657_g() <= 0L) {
                WorldBorder worldBorder = WorldBorder.this;
                worldBorder.getClass();
                iBorderInfo = worldBorder.new StationaryBorderInfo(this.field_212661_c);
            } else {
                iBorderInfo = this;
            }
            return iBorderInfo;
        }
    }

    static interface IBorderInfo {
        public double func_212658_a();

        public double func_212654_b();

        public double func_212656_c();

        public double func_212648_d();

        public double func_212647_e();

        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f();

        public long func_212657_g();

        public double func_212650_h();

        @OnlyIn(value=Dist.CLIENT)
        public EnumBorderStatus func_212655_i();

        public void func_212652_j();

        public void func_212653_k();

        public IBorderInfo func_212651_l();
    }
}

