/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.end.DragonSpawnState;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndCrystalTowerFeature;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.EndSpikes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger field_186107_a = LogManager.getLogger();
    private static final Predicate<Entity> field_186108_b = EntitySelectors.field_94557_a.and(EntitySelectors.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final BossInfoServer field_186109_c = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation("entity.minecraft.ender_dragon", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final WorldServer field_186110_d;
    private final List<Integer> field_186111_e = Lists.newArrayList();
    private final BlockPattern field_186112_f;
    private int field_186113_g;
    private int field_186114_h;
    private int field_186115_i;
    private int field_186116_j;
    private boolean field_186117_k;
    private boolean field_186118_l;
    private UUID field_186119_m;
    private boolean field_186120_n = true;
    private BlockPos field_186121_o;
    private DragonSpawnState field_186122_p;
    private int field_186123_q;
    private List<EntityEnderCrystal> field_186124_r;

    public DragonFightManager(WorldServer worldIn, NBTTagCompound compound) {
        this.field_186110_d = worldIn;
        if (compound.func_150297_b("DragonKilled", 99)) {
            if (compound.func_186855_b("DragonUUID")) {
                this.field_186119_m = compound.func_186857_a("DragonUUID");
            }
            this.field_186117_k = compound.func_74767_n("DragonKilled");
            this.field_186118_l = compound.func_74767_n("PreviouslyKilled");
            boolean bl = this.field_186120_n = !compound.func_74767_n("LegacyScanPerformed");
            if (compound.func_74767_n("IsRespawning")) {
                this.field_186122_p = DragonSpawnState.START;
            }
            if (compound.func_150297_b("ExitPortalLocation", 10)) {
                this.field_186121_o = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.field_186117_k = true;
            this.field_186118_l = true;
        }
        if (compound.func_150297_b("Gateways", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Gateways", 3);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                this.field_186111_e.add(nbttaglist.func_186858_c(i));
            }
        } else {
            this.field_186111_e.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.field_186111_e, new Random(worldIn.func_72905_C()));
        }
        this.field_186112_f = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h))).func_177661_b();
    }

    public NBTTagCompound func_186088_a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (this.field_186119_m != null) {
            nbttagcompound.func_186854_a("DragonUUID", this.field_186119_m);
        }
        nbttagcompound.func_74757_a("DragonKilled", this.field_186117_k);
        nbttagcompound.func_74757_a("PreviouslyKilled", this.field_186118_l);
        nbttagcompound.func_74757_a("LegacyScanPerformed", !this.field_186120_n);
        if (this.field_186121_o != null) {
            nbttagcompound.func_74782_a("ExitPortalLocation", NBTUtil.func_186859_a((BlockPos)this.field_186121_o));
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : this.field_186111_e) {
            nbttaglist.add((INBTBase)new NBTTagInt(i));
        }
        nbttagcompound.func_74782_a("Gateways", (INBTBase)nbttaglist);
        return nbttagcompound;
    }

    public void func_186105_b() {
        this.field_186109_c.func_186758_d(!this.field_186117_k);
        if (++this.field_186116_j >= 20) {
            this.func_186100_j();
            this.field_186116_j = 0;
        }
        LoadManager dragonfightmanager$loadmanager = new LoadManager();
        if (!this.field_186109_c.func_186757_c().isEmpty()) {
            if (this.field_186120_n && dragonfightmanager$loadmanager.func_210824_a()) {
                this.func_210827_g();
                this.field_186120_n = false;
            }
            if (this.field_186122_p != null) {
                if (this.field_186124_r == null && dragonfightmanager$loadmanager.func_210824_a()) {
                    this.field_186122_p = null;
                    this.func_186106_e();
                }
                this.field_186122_p.func_186079_a(this.field_186110_d, this, this.field_186124_r, this.field_186123_q++, this.field_186121_o);
            }
            if (!this.field_186117_k) {
                if ((this.field_186119_m == null || ++this.field_186113_g >= 1200) && dragonfightmanager$loadmanager.func_210824_a()) {
                    this.func_210828_h();
                    this.field_186113_g = 0;
                }
                if (++this.field_186115_i >= 100 && dragonfightmanager$loadmanager.func_210824_a()) {
                    this.func_186101_k();
                    this.field_186115_i = 0;
                }
            }
        }
    }

    private void func_210827_g() {
        field_186107_a.info("Scanning for legacy world dragon fight...");
        boolean flag = this.func_186104_g();
        if (flag) {
            field_186107_a.info("Found that the dragon has been killed in this world already.");
            this.field_186118_l = true;
        } else {
            field_186107_a.info("Found that the dragon has not yet been killed in this world.");
            this.field_186118_l = false;
            this.func_186094_a(false);
        }
        List<EntityDragon> list = this.field_186110_d.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
        if (list.isEmpty()) {
            this.field_186117_k = true;
        } else {
            EntityDragon entitydragon = list.get(0);
            this.field_186119_m = entitydragon.func_110124_au();
            field_186107_a.info("Found that there's a dragon still alive ({})", (Object)entitydragon);
            this.field_186117_k = false;
            if (!flag) {
                field_186107_a.info("But we didn't have a portal, let's remove it.");
                entitydragon.func_70106_y();
                this.field_186119_m = null;
            }
        }
        if (!this.field_186118_l && this.field_186117_k) {
            this.field_186117_k = false;
        }
    }

    private void func_210828_h() {
        List<EntityDragon> list = this.field_186110_d.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
        if (list.isEmpty()) {
            field_186107_a.debug("Haven't seen the dragon, respawning it");
            this.func_192445_m();
        } else {
            field_186107_a.debug("Haven't seen our dragon, but found another one to use.");
            this.field_186119_m = list.get(0).func_110124_au();
        }
    }

    protected void func_186095_a(DragonSpawnState state) {
        if (this.field_186122_p == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.field_186123_q = 0;
        if (state == DragonSpawnState.END) {
            this.field_186122_p = null;
            this.field_186117_k = false;
            EntityDragon entitydragon = this.func_192445_m();
            for (EntityPlayerMP entityplayermp : this.field_186109_c.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp, (Entity)entitydragon);
            }
        } else {
            this.field_186122_p = state;
        }
    }

    private boolean func_186104_g() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_72964_e(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof TileEntityEndPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper func_186091_h() {
        int k;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_72964_e(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper blockpattern$patternhelper;
                    if (!(tileentity instanceof TileEntityEndPortal) || (blockpattern$patternhelper = this.field_186112_f.func_177681_a((IWorldReaderBase)this.field_186110_d, tileentity.func_174877_v())) == null) continue;
                    BlockPos blockpos = blockpattern$patternhelper.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.field_186121_o == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.field_186121_o = blockpos;
                    }
                    return blockpattern$patternhelper;
                }
            }
        }
        for (int l = k = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o(); l >= 0; --l) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.field_186112_f.func_177681_a((IWorldReaderBase)this.field_186110_d, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), l, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.field_186121_o == null) {
                this.field_186121_o = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }

    private boolean func_210832_a(int p_210832_1_, int p_210832_2_, int p_210832_3_, int p_210832_4_) {
        if (this.func_210830_b(p_210832_1_, p_210832_2_, p_210832_3_, p_210832_4_)) {
            return true;
        }
        this.func_210831_c(p_210832_1_, p_210832_2_, p_210832_3_, p_210832_4_);
        return false;
    }

    private boolean func_210830_b(int p_210830_1_, int p_210830_2_, int p_210830_3_, int p_210830_4_) {
        boolean flag = true;
        for (int i = p_210830_1_; i <= p_210830_2_; ++i) {
            for (int j = p_210830_3_; j <= p_210830_4_; ++j) {
                Chunk chunk = this.field_186110_d.func_72964_e(i, j);
                flag &= chunk.func_201589_g() == ChunkStatus.POSTPROCESSED;
            }
        }
        return flag;
    }

    private void func_210831_c(int p_210831_1_, int p_210831_2_, int p_210831_3_, int p_210831_4_) {
        for (int i = p_210831_1_ - 1; i <= p_210831_2_ + 1; ++i) {
            this.field_186110_d.func_72964_e(i, p_210831_3_ - 1);
            this.field_186110_d.func_72964_e(i, p_210831_4_ + 1);
        }
        for (int j = p_210831_3_ - 1; j <= p_210831_4_ + 1; ++j) {
            this.field_186110_d.func_72964_e(p_210831_1_ - 1, j);
            this.field_186110_d.func_72964_e(p_210831_2_ + 1, j);
        }
    }

    private void func_186100_j() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayerMP entityPlayerMP : this.field_186110_d.func_175661_b(EntityPlayerMP.class, field_186108_b)) {
            this.field_186109_c.func_186760_a(entityPlayerMP);
            set.add(entityPlayerMP);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.field_186109_c.func_186757_c());
        set1.removeAll(set);
        for (EntityPlayerMP entityplayermp1 : set1) {
            this.field_186109_c.func_186761_b(entityplayermp1);
        }
    }

    private void func_186101_k() {
        this.field_186115_i = 0;
        this.field_186114_h = 0;
        for (EndCrystalTowerFeature.EndSpike endcrystaltowerfeature$endspike : EndSpikes.func_202466_a((IWorld)this.field_186110_d)) {
            this.field_186114_h += this.field_186110_d.func_72872_a(EntityEnderCrystal.class, endcrystaltowerfeature$endspike.func_186153_f()).size();
        }
        field_186107_a.debug("Found {} end crystals still alive", (Object)this.field_186114_h);
    }

    public void func_186096_a(EntityDragon dragon) {
        if (dragon.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(0.0f);
            this.field_186109_c.func_186758_d(false);
            this.func_186094_a(true);
            this.func_186097_l();
            if (!this.field_186118_l) {
                this.field_186110_d.func_175656_a(this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.field_186118_l = true;
            this.field_186117_k = true;
        }
    }

    private void func_186097_l() {
        if (!this.field_186111_e.isEmpty()) {
            int i = this.field_186111_e.remove(this.field_186111_e.size() - 1);
            int j = (int)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            int k = (int)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            this.func_186089_a(new BlockPos(j, 75, k));
        }
    }

    private void func_186089_a(BlockPos pos) {
        this.field_186110_d.func_175718_b(3000, pos, 0);
        Feature.field_202299_as.func_212245_a(this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), pos, new EndGatewayConfig(false));
    }

    private void func_186094_a(boolean active) {
        EndPodiumFeature endpodiumfeature = new EndPodiumFeature(active);
        if (this.field_186121_o == null) {
            this.field_186121_o = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a).func_177977_b();
            while (this.field_186110_d.func_180495_p(this.field_186121_o).func_177230_c() == Blocks.field_150357_h && this.field_186121_o.func_177956_o() > this.field_186110_d.func_181545_F()) {
                this.field_186121_o = this.field_186121_o.func_177977_b();
            }
        }
        endpodiumfeature.func_212245_a((IWorld)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), this.field_186121_o, IFeatureConfig.field_202429_e);
    }

    private EntityDragon func_192445_m() {
        this.field_186110_d.func_175726_f(new BlockPos(0, 128, 0));
        EntityDragon entitydragon = new EntityDragon(this.field_186110_d);
        entitydragon.func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        entitydragon.func_70012_b(0.0, 128.0, 0.0, this.field_186110_d.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.field_186110_d.func_72838_d(entitydragon);
        this.field_186119_m = entitydragon.func_110124_au();
        return entitydragon;
    }

    public void func_186099_b(EntityDragon dragonIn) {
        if (dragonIn.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(dragonIn.func_110143_aJ() / dragonIn.func_110138_aP());
            this.field_186113_g = 0;
            if (dragonIn.func_145818_k_()) {
                this.field_186109_c.func_186739_a(dragonIn.func_145748_c_());
            }
        }
    }

    public int func_186092_c() {
        return this.field_186114_h;
    }

    public void func_186090_a(EntityEnderCrystal crystal, DamageSource dmgSrc) {
        if (this.field_186122_p != null && this.field_186124_r.contains(crystal)) {
            field_186107_a.debug("Aborting respawn sequence");
            this.field_186122_p = null;
            this.field_186123_q = 0;
            this.func_186087_f();
            this.func_186094_a(true);
        } else {
            this.func_186101_k();
            Entity entity = this.field_186110_d.func_175733_a(this.field_186119_m);
            if (entity instanceof EntityDragon) {
                ((EntityDragon)entity).func_184672_a(crystal, new BlockPos((Entity)crystal), dmgSrc);
            }
        }
    }

    public boolean func_186102_d() {
        return this.field_186118_l;
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPos blockpos = this.field_186121_o;
            if (blockpos == null) {
                field_186107_a.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper blockpattern$patternhelper = this.func_186091_h();
                if (blockpattern$patternhelper == null) {
                    field_186107_a.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    field_186107_a.debug("Found the exit portal & temporarily using it.");
                }
                blockpos = this.field_186121_o;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.func_177981_b(1);
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                List<EntityEnderCrystal> list = this.field_186110_d.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB(blockpos1.func_177967_a(enumfacing, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            field_186107_a.debug("Found all crystals, respawning dragon.");
            this.func_186093_a(list1);
        }
    }

    private void func_186093_a(List<EntityEnderCrystal> crystalsIn) {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPattern.PatternHelper blockpattern$patternhelper = this.func_186091_h();
            while (blockpattern$patternhelper != null) {
                for (int i = 0; i < this.field_186112_f.func_177684_c(); ++i) {
                    for (int j = 0; j < this.field_186112_f.func_177685_b(); ++j) {
                        for (int k = 0; k < this.field_186112_f.func_185922_a(); ++k) {
                            BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, k);
                            if (blockworldstate.func_177509_a().func_177230_c() != Blocks.field_150357_h && blockworldstate.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.field_186110_d.func_175656_a(blockworldstate.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                blockpattern$patternhelper = this.func_186091_h();
            }
            this.field_186122_p = DragonSpawnState.START;
            this.field_186123_q = 0;
            this.func_186094_a(false);
            this.field_186124_r = crystalsIn;
        }
    }

    public void func_186087_f() {
        for (EndCrystalTowerFeature.EndSpike endcrystaltowerfeature$endspike : EndSpikes.func_202466_a((IWorld)this.field_186110_d)) {
            for (EntityEnderCrystal entityendercrystal : this.field_186110_d.func_72872_a(EntityEnderCrystal.class, endcrystaltowerfeature$endspike.func_186153_f())) {
                entityendercrystal.func_184224_h(false);
                entityendercrystal.func_184516_a((BlockPos)null);
            }
        }
    }

    public void addPlayer(EntityPlayerMP player) {
        this.field_186109_c.func_186760_a(player);
    }

    public void removePlayer(EntityPlayerMP player) {
        this.field_186109_c.func_186761_b(player);
    }

    static enum LoadState {
        UNKNOWN,
        NOT_LOADED,
        LOADED;

    }

    class LoadManager {
        private LoadState field_210826_b = LoadState.UNKNOWN;

        private LoadManager() {
        }

        private boolean func_210824_a() {
            if (this.field_210826_b == LoadState.UNKNOWN) {
                this.field_210826_b = DragonFightManager.this.func_210832_a(-8, 8, -8, 8) ? LoadState.LOADED : LoadState.NOT_LOADED;
            }
            return this.field_210826_b == LoadState.LOADED;
        }
    }
}

