/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegion
implements IWorld {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final ChunkPrimer[] field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_201687_d;
    private final int field_201688_e;
    private final World field_201689_f;
    private final long field_201690_g;
    private final int field_201691_h;
    private final WorldInfo field_201692_i;
    private final Random field_201693_j;
    private final Dimension field_201694_k;
    private final IChunkGenSettings field_201695_l;
    private final ITickList<Block> field_205336_m = new WorldGenTickList(p_205335_1_ -> this.func_205771_y((BlockPos)p_205335_1_).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList(p_205334_1_ -> this.func_205771_y((BlockPos)p_205334_1_).func_212247_j());

    public WorldGenRegion(ChunkPrimer[] chunkPrimersIn, int sizeXIn, int sizeZIn, int mainChunkXIn, int mainChunkZIn, World worldIn) {
        this.field_201684_a = chunkPrimersIn;
        this.field_201685_b = mainChunkXIn;
        this.field_201686_c = mainChunkZIn;
        this.field_201687_d = sizeXIn;
        this.field_201688_e = sizeZIn;
        this.field_201689_f = worldIn;
        this.field_201690_g = worldIn.func_72905_C();
        this.field_201695_l = worldIn.func_72863_F().func_201711_g().func_201496_a_();
        this.field_201691_h = worldIn.func_181545_F();
        this.field_201692_i = worldIn.func_72912_H();
        this.field_201693_j = worldIn.func_201674_k();
        this.field_201694_k = worldIn.func_201675_m();
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    public boolean func_201678_a(int chunkX, int chunkZ) {
        ChunkPrimer ichunk = this.field_201684_a[0];
        ChunkPrimer ichunk1 = this.field_201684_a[this.field_201684_a.length - 1];
        return chunkX >= ichunk.func_76632_l().field_77276_a && chunkX <= ichunk1.func_76632_l().field_77276_a && chunkZ >= ichunk.func_76632_l().field_77275_b && chunkZ <= ichunk1.func_76632_l().field_77275_b;
    }

    @Override
    public IChunk func_72964_e(int chunkX, int chunkZ) {
        if (this.func_201678_a(chunkX, chunkZ)) {
            int i = chunkX - this.field_201684_a[0].func_76632_l().field_77276_a;
            int j = chunkZ - this.field_201684_a[0].func_76632_l().field_77275_b;
            return this.field_201684_a[i + j * this.field_201687_d];
        }
        ChunkPrimer ichunk = this.field_201684_a[0];
        ChunkPrimer ichunk1 = this.field_201684_a[this.field_201684_a.length - 1];
        field_208303_a.error("Requested chunk : {} {}", (Object)chunkX, (Object)chunkZ);
        field_208303_a.error("Region bounds : {} {} | {} {}", (Object)ichunk.func_76632_l().field_77276_a, (Object)ichunk.func_76632_l().field_77275_b, (Object)ichunk1.func_76632_l().field_77276_a, (Object)ichunk1.func_76632_l().field_77275_b);
        throw new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", chunkX, chunkZ));
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.func_205771_y(pos).func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.func_205771_y(pos).func_204610_c(pos);
    }

    @Nullable
    public EntityPlayer func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        return null;
    }

    public int func_175657_ab() {
        return 0;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        Biome biome = this.func_205771_y(pos).func_201590_e()[pos.func_177958_n() & 0xF | (pos.func_177952_p() & 0xF) << 4];
        if (biome == null) {
            throw new RuntimeException(String.format("Biome is null @ %s", pos));
        }
        return biome;
    }

    public int func_175642_b(EnumLightType type, BlockPos pos) {
        IChunk ichunk = this.func_205771_y(pos);
        return ichunk.func_201587_a(type, pos, this.func_201675_m().func_191066_m());
    }

    public int func_201669_a(BlockPos pos, int amount) {
        return this.func_205771_y(pos).func_201586_a(pos, amount, this.func_201675_m().func_191066_m());
    }

    public boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return this.func_201678_a(x, z);
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        IBlockState iblockstate = this.func_180495_p(pos);
        if (iblockstate.func_196958_f()) {
            return false;
        }
        if (dropBlock) {
            iblockstate.func_196949_c(this.field_201689_f, pos, 0);
        }
        return this.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public boolean func_175678_i(BlockPos pos) {
        return this.func_205771_y(pos).func_177444_d(pos);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IChunk ichunk = this.func_205771_y(pos);
        TileEntity tileentity = ichunk.func_175625_s(pos);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunk.func_201579_g(pos);
        if (nbttagcompound != null && (tileentity = "DUMMY".equals(nbttagcompound.func_74779_i("id")) ? this.func_180495_p(pos).createTileEntity((IBlockReader)this.field_201689_f) : TileEntity.func_203403_c(nbttagcompound)) != null) {
            ichunk.func_177426_a(pos, tileentity);
            return tileentity;
        }
        if (ichunk.func_180495_p(pos).hasTileEntity()) {
            field_208303_a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        IChunk ichunk = this.func_205771_y(pos);
        IBlockState iblockstate = ichunk.func_177436_a(pos, newState, false);
        Block block = newState.func_177230_c();
        if (newState.hasTileEntity()) {
            if (ichunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                ichunk.func_177426_a(pos, newState.createTileEntity((IBlockReader)this));
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("x", pos.func_177958_n());
                nbttagcompound.func_74768_a("y", pos.func_177956_o());
                nbttagcompound.func_74768_a("z", pos.func_177952_p());
                nbttagcompound.func_74778_a("id", "DUMMY");
                ichunk.func_201591_a(nbttagcompound);
            }
        } else if (iblockstate != null && iblockstate.hasTileEntity()) {
            ichunk.func_177425_e(pos);
        }
        if (newState.func_202065_c((IBlockReader)this, pos)) {
            this.func_201683_l(pos);
        }
        return true;
    }

    private void func_201683_l(BlockPos pos) {
        this.func_205771_y(pos).func_201594_d(pos);
    }

    public boolean func_72838_d(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        this.func_72964_e(i, j).func_76612_a(entityIn);
        return true;
    }

    public boolean func_175698_g(BlockPos pos) {
        return this.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public void func_175653_a(EnumLightType type, BlockPos pos, int lightValue) {
        this.func_205771_y(pos).func_201580_a(type, this.field_201694_k.func_191066_m(), pos, lightValue);
    }

    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return true;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d() {
        return false;
    }

    @Override
    @Deprecated
    public World func_201672_e() {
        return this.field_201689_f;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos pos) {
        if (!this.func_201678_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_130001_d());
    }

    @Nullable
    public WorldSavedDataStorage func_175693_T() {
        return this.field_201689_f.func_175693_T();
    }

    @Override
    public IChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    @Override
    public ISaveHandler func_72860_G() {
        return this.field_201689_f.func_72860_G();
    }

    @Override
    public long func_72905_C() {
        return this.field_201690_g;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    public int func_181545_F() {
        return this.field_201691_h;
    }

    @Override
    public Random func_201674_k() {
        return this.field_201693_j;
    }

    @Override
    public void func_195592_c(BlockPos pos, Block blockIn) {
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.func_72964_e(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1;
    }

    @Override
    public void func_184133_a(@Nullable EntityPlayer player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    @Override
    public BlockPos func_175694_M() {
        return this.field_201689_f.func_175694_M();
    }

    public Dimension func_201675_m() {
        return this.field_201694_k;
    }
}

