/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BirchTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState field_181629_a = Blocks.field_196619_M.func_176223_P();
    private static final IBlockState field_181630_b = Blocks.field_196647_Y.func_176223_P();
    private final boolean field_150531_a;

    public BirchTreeFeature(boolean notify, boolean useExtraRandomHeightIn) {
        super(notify);
        this.field_150531_a = useExtraRandomHeightIn;
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + 5;
        if (this.field_150531_a) {
            i += rand.nextInt(7);
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_201672_e().func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_201672_e().func_72800_K()) {
                            if (this.canGrowInto((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            boolean isSoil = worldIn.func_180495_p(position.func_177977_b()).canSustainPlant((IBlockReader)worldIn, position.func_177977_b(), EnumFacing.UP, (BlockSapling)Blocks.field_196674_t);
            if (isSoil && position.func_177956_o() < worldIn.func_201672_e().func_72800_K() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + i);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = position.func_177958_n() - l2; i3 <= position.func_177958_n() + l2; ++i3) {
                        int j1 = i3 - position.func_177958_n();
                        for (int k1 = position.func_177952_p() - l2; k1 <= position.func_177952_p() + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState iblockstate;
                            int l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(iblockstate = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).isAir((IBlockReader)worldIn, blockpos) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                            this.func_202278_a(worldIn, blockpos, field_181630_b);
                        }
                    }
                }
                for (int j2 = 0; j2 < i; ++j2) {
                    IBlockState iblockstate1 = worldIn.func_180495_p(position.func_177981_b(j2));
                    if (!iblockstate1.isAir((IBlockReader)worldIn, position.func_177981_b(j2)) && !iblockstate1.func_203425_a(BlockTags.field_206952_E)) continue;
                    this.func_208520_a(changedBlocks, worldIn, position.func_177981_b(j2), field_181629_a);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

