/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SwampTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState field_181648_a = Blocks.field_196617_K.func_176223_P();
    private static final IBlockState field_181649_b = Blocks.field_196642_W.func_176223_P();

    public SwampTreeFeature() {
        super(false);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(4) + 5;
        while (worldIn.func_204610_c(position.func_177977_b()).func_206884_a(FluidTags.field_206959_a)) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_201672_e().func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_201672_e().func_72800_K()) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.isAir((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) || iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                            if (block == Blocks.field_150355_j) {
                                if (j <= position.func_177956_o()) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (worldIn.func_180495_p(position.func_177977_b()).canSustainPlant((IBlockReader)worldIn, position.func_177977_b(), EnumFacing.UP, (BlockSapling)Blocks.field_196674_t) && position.func_177956_o() < worldIn.func_201672_e().func_72800_K() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int k1 = position.func_177956_o() - 3 + i; k1 <= position.func_177956_o() + i; ++k1) {
                    int j2 = k1 - (position.func_177956_o() + i);
                    int l2 = 2 - j2 / 2;
                    for (int j3 = position.func_177958_n() - l2; j3 <= position.func_177958_n() + l2; ++j3) {
                        int k3 = j3 - position.func_177958_n();
                        for (int i4 = position.func_177952_p() - l2; i4 <= position.func_177952_p() + l2; ++i4) {
                            BlockPos blockpos;
                            int j1 = i4 - position.func_177952_p();
                            if (Math.abs(k3) == l2 && Math.abs(j1) == l2 && (rand.nextInt(2) == 0 || j2 == 0) || !worldIn.func_180495_p(blockpos = new BlockPos(j3, k1, i4)).canBeReplacedByLeaves(worldIn, blockpos)) continue;
                            this.func_202278_a(worldIn, blockpos, field_181649_b);
                        }
                    }
                }
                for (int l1 = 0; l1 < i; ++l1) {
                    IBlockState iblockstate1 = worldIn.func_180495_p(position.func_177981_b(l1));
                    Block block2 = iblockstate1.func_177230_c();
                    if (!iblockstate1.isAir((IBlockReader)worldIn, position.func_177981_b(l1)) && !iblockstate1.func_203425_a(BlockTags.field_206952_E) && block2 != Blocks.field_150355_j) continue;
                    this.func_208520_a(changedBlocks, worldIn, position.func_177981_b(l1), field_181648_a);
                }
                for (int i2 = position.func_177956_o() - 3 + i; i2 <= position.func_177956_o() + i; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + i);
                    int i3 = 2 - k2 / 2;
                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                    for (int l3 = position.func_177958_n() - i3; l3 <= position.func_177958_n() + i3; ++l3) {
                        for (int j4 = position.func_177952_p() - i3; j4 <= position.func_177952_p() + i3; ++j4) {
                            blockpos$mutableblockpos1.func_181079_c(l3, i2, j4);
                            if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_203425_a(BlockTags.field_206952_E)) continue;
                            BlockPos blockpos3 = blockpos$mutableblockpos1.func_177976_e();
                            BlockPos blockpos4 = blockpos$mutableblockpos1.func_177974_f();
                            BlockPos blockpos1 = blockpos$mutableblockpos1.func_177978_c();
                            BlockPos blockpos2 = blockpos$mutableblockpos1.func_177968_d();
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos3)) {
                                this.func_181647_a(worldIn, blockpos3, BlockVine.field_176278_M);
                            }
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos4)) {
                                this.func_181647_a(worldIn, blockpos4, BlockVine.field_176280_O);
                            }
                            if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos1)) {
                                this.func_181647_a(worldIn, blockpos1, BlockVine.field_176279_N);
                            }
                            if (rand.nextInt(4) != 0 || !worldIn.func_175623_d(blockpos2)) continue;
                            this.func_181647_a(worldIn, blockpos2, BlockVine.field_176273_b);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_181647_a(IWorld worldIn, BlockPos pos, BooleanProperty prop) {
        IBlockState iblockstate = (IBlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)prop, Boolean.valueOf(true));
        this.func_202278_a(worldIn, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_202278_a(worldIn, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }
}

