/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class TreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState field_181653_a = Blocks.field_196617_K.func_176223_P();
    private static final IBlockState field_181654_b = Blocks.field_196642_W.func_176223_P();
    protected final int field_76533_a;
    private final boolean field_76531_b;
    private final IBlockState field_76532_c;
    private final IBlockState field_76530_d;
    protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

    public TreeFeature(boolean p_i2027_1_) {
        this(p_i2027_1_, 4, field_181653_a, field_181654_b, false);
    }

    public TreeFeature(boolean notify, int minTreeHeightIn, IBlockState woodMeta, IBlockState p_i46446_4_, boolean growVines) {
        super(notify);
        this.field_76533_a = minTreeHeightIn;
        this.field_76532_c = woodMeta;
        this.field_76530_d = p_i46446_4_;
        this.field_76531_b = growVines;
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = this.func_208534_a(rand);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_201672_e().func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_201672_e().func_72800_K()) {
                            if (this.canGrowInto((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (worldIn.func_180495_p(position.func_177977_b()).canSustainPlant((IBlockReader)worldIn, position.func_177977_b(), EnumFacing.UP, (BlockSapling)Blocks.field_196674_t) && position.func_177956_o() < worldIn.func_201672_e().func_72800_K() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int k2 = 3;
                boolean l2 = false;
                for (int i3 = position.func_177956_o() - 3 + i; i3 <= position.func_177956_o() + i; ++i3) {
                    int i4 = i3 - (position.func_177956_o() + i);
                    int j1 = 1 - i4 / 2;
                    for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        int l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0)) continue;
                            BlockPos blockpos = new BlockPos(k1, i3, i2);
                            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                            Material material = iblockstate.func_185904_a();
                            if (!iblockstate.canBeReplacedByLeaves(worldIn, blockpos) && material != Material.field_151582_l) continue;
                            this.func_202278_a(worldIn, blockpos, this.field_76530_d);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    IBlockState iblockstate1 = worldIn.func_180495_p(position.func_177981_b(j3));
                    Material material1 = iblockstate1.func_185904_a();
                    if (!iblockstate1.canBeReplacedByLeaves(worldIn, position.func_177981_b(j3)) && material1 != Material.field_151582_l) continue;
                    this.func_208520_a(changedBlocks, worldIn, position.func_177981_b(j3), this.field_76532_c);
                    if (!this.field_76531_b || j3 <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(-1, j3, 0))) {
                        this.func_181651_a(worldIn, position.func_177982_a(-1, j3, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(1, j3, 0))) {
                        this.func_181651_a(worldIn, position.func_177982_a(1, j3, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(0, j3, -1))) {
                        this.func_181651_a(worldIn, position.func_177982_a(0, j3, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(position.func_177982_a(0, j3, 1))) continue;
                    this.func_181651_a(worldIn, position.func_177982_a(0, j3, 1), BlockVine.field_176273_b);
                }
                if (this.field_76531_b) {
                    for (int k3 = position.func_177956_o() - 3 + i; k3 <= position.func_177956_o() + i; ++k3) {
                        int j4 = k3 - (position.func_177956_o() + i);
                        int k4 = 2 - j4 / 2;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                        for (int l4 = position.func_177958_n() - k4; l4 <= position.func_177958_n() + k4; ++l4) {
                            for (int i5 = position.func_177952_p() - k4; i5 <= position.func_177952_p() + k4; ++i5) {
                                blockpos$mutableblockpos1.func_181079_c(l4, k3, i5);
                                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_203425_a(BlockTags.field_206952_E)) continue;
                                BlockPos blockpos1 = blockpos$mutableblockpos1.func_177976_e();
                                BlockPos blockpos2 = blockpos$mutableblockpos1.func_177974_f();
                                BlockPos blockpos3 = blockpos$mutableblockpos1.func_177978_c();
                                BlockPos blockpos4 = blockpos$mutableblockpos1.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos1)) {
                                    this.func_181650_b(worldIn, blockpos1, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos2)) {
                                    this.func_181650_b(worldIn, blockpos2, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos3)) {
                                    this.func_181650_b(worldIn, blockpos3, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_175623_d(blockpos4)) continue;
                                this.func_181650_b(worldIn, blockpos4, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && i > 5) {
                        for (int l3 = 0; l3 < 2; ++l3) {
                            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - l3) != 0) continue;
                                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                                this.func_181652_a(worldIn, rand.nextInt(3), position.func_177982_a(enumfacing1.func_82601_c(), i - 5 + l3, enumfacing1.func_82599_e()), enumfacing);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected int func_208534_a(Random p_208534_1_) {
        return this.field_76533_a + p_208534_1_.nextInt(3);
    }

    private void func_181652_a(IWorld worldIn, int p_181652_2_, BlockPos pos, EnumFacing side) {
        this.func_202278_a(worldIn, pos, (IBlockState)((IBlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((IProperty)BlockCocoa.field_176501_a, Integer.valueOf(p_181652_2_))).func_206870_a((IProperty)BlockCocoa.field_185512_D, (Comparable)((Object)side)));
    }

    private void func_181651_a(IWorld worldIn, BlockPos pos, BooleanProperty prop) {
        this.func_202278_a(worldIn, pos, (IBlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)prop, Boolean.valueOf(true)));
    }

    private void func_181650_b(IWorld worldIn, BlockPos pos, BooleanProperty prop) {
        this.func_181651_a(worldIn, pos, prop);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_181651_a(worldIn, blockpos, prop);
            blockpos = blockpos.func_177977_b();
        }
    }

    public TreeFeature setSapling(IPlantable sapling) {
        this.sapling = sapling;
        return this;
    }
}

