/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlassPane;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagePieces {
    public static void func_143016_a() {
        StructureIO.func_143031_a(House1.class, (String)"ViBH");
        StructureIO.func_143031_a(Field1.class, (String)"ViDF");
        StructureIO.func_143031_a(Field2.class, (String)"ViF");
        StructureIO.func_143031_a(Torch.class, (String)"ViL");
        StructureIO.func_143031_a(Hall.class, (String)"ViPH");
        StructureIO.func_143031_a(House4Garden.class, (String)"ViSH");
        StructureIO.func_143031_a(WoodHut.class, (String)"ViSmH");
        StructureIO.func_143031_a(Church.class, (String)"ViST");
        StructureIO.func_143031_a(House2.class, (String)"ViS");
        StructureIO.func_143031_a(Start.class, (String)"ViStart");
        StructureIO.func_143031_a(Path.class, (String)"ViSR");
        StructureIO.func_143031_a(House3.class, (String)"ViTRH");
        StructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List<PieceWeight> func_75084_a(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + size), (int)(4 + size))));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        VillagerRegistry.addExtraVillageComponents((List)list, (Random)random, (int)size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).field_75087_d != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int func_75079_a(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight villagepieces$pieceweight : p_75079_0_) {
            if (villagepieces$pieceweight.field_75087_d > 0 && villagepieces$pieceweight.field_75089_c < villagepieces$pieceweight.field_75087_d) {
                flag = true;
            }
            i += villagepieces$pieceweight.field_75088_b;
        }
        return flag ? i : -1;
    }

    private static Village func_176065_a(Start start, PieceWeight weight, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        Class<? extends Village> oclass = weight.field_75090_a;
        Village villagepieces$village = null;
        villagepieces$village = oclass == House4Garden.class ? House4Garden.func_175858_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == Church.class ? Church.func_175854_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == House1.class ? House1.func_175850_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == WoodHut.class ? WoodHut.func_175853_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == Hall.class ? Hall.func_175857_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == Field1.class ? Field1.func_175851_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == Field2.class ? Field2.func_175852_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == House2.class ? House2.func_175855_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : (oclass == House3.class ? House3.func_175849_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType) : VillagerRegistry.getVillageComponent((PieceWeight)weight, (Start)start, structureComponents, (Random)rand, (int)structureMinX, (int)structureMinY, (int)structureMinZ, (EnumFacing)facing, (int)componentType)))))))));
        return villagepieces$village;
    }

    private static Village func_176067_c(Start start, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        int i = VillagePieces.func_75079_a(start.field_74931_h);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight villagepieces$pieceweight : start.field_74931_h) {
                if ((k -= villagepieces$pieceweight.field_75088_b) >= 0) continue;
                if (!villagepieces$pieceweight.func_75085_a(componentType) || villagepieces$pieceweight == start.field_74926_d && start.field_74931_h.size() > 1) continue block0;
                Village villagepieces$village = VillagePieces.func_176065_a(start, villagepieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (villagepieces$village == null) continue;
                ++villagepieces$pieceweight.field_75089_c;
                start.field_74926_d = villagepieces$pieceweight;
                if (!villagepieces$pieceweight.func_75086_a()) {
                    start.field_74931_h.remove(villagepieces$pieceweight);
                }
                return villagepieces$village;
            }
        }
        MutableBoundingBox mutableboundingbox = Torch.func_175856_a(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        if (mutableboundingbox != null) {
            return new Torch(start, componentType, rand, mutableboundingbox, facing);
        }
        return null;
    }

    private static StructurePiece func_176066_d(Start start, List<StructurePiece> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurepiece = VillagePieces.func_176067_c(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurepiece != null) {
                structureComponents.add(structurepiece);
                start.field_74932_i.add(structurepiece);
                return structurepiece;
            }
            return null;
        }
        return null;
    }

    private static StructurePiece func_176069_e(Start start, List<StructurePiece> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.field_74928_c) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            MutableBoundingBox mutableboundingbox = Path.func_175848_a(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (mutableboundingbox != null && mutableboundingbox.field_78895_b > 10) {
                Path structurepiece = new Path(start, p_176069_7_, rand, mutableboundingbox, facing);
                p_176069_1_.add(structurepiece);
                start.field_74930_j.add(structurepiece);
                return structurepiece;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean field_74909_b;
        private int field_74910_c;

        public WoodHut() {
        }

        public WoodHut(Start start, int type, Random rand, MutableBoundingBox structurebb, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = structurebb;
            this.field_74909_b = rand.nextBoolean();
            this.field_74910_c = rand.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.field_74910_c);
            tagCompound.func_74757_a("C", this.field_74909_b);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_74910_c = tagCompound.func_74762_e("T");
            this.field_74909_b = tagCompound.func_74767_n("C");
        }

        public static WoodHut func_175853_a(Start start, List<StructurePiece> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return WoodHut.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175853_1_, mutableboundingbox) == null ? new WoodHut(start, p_175853_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate3 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            IBlockState iblockstate4 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            if (this.field_74909_b) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 3, 2, 2, structureBoundingBoxIn);
            if (this.field_74910_c > 0) {
                this.func_175811_a(worldIn, (IBlockState)((IBlockState)iblockstate4.func_206870_a((IProperty)BlockFence.field_196409_a, Boolean.valueOf(true))).func_206870_a((IProperty)(this.field_74910_c == 1 ? BlockFence.field_196414_y : BlockFence.field_196411_b), Boolean.valueOf(true)), this.field_74910_c, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_196663_cq.func_176223_P(), this.field_74910_c, 2, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a((IBlockReader)worldIn, 1, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 1, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate2, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, i, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new MutableBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1) : new MutableBoundingBox(x, 64, z, x + 6 - 1, 78, z + 6 - 1);
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 3, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.field_150355_j.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 15, 1, 4, 15, 4, iblockstate, iblockstate, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(worldIn, iblockstate, j, 11, i, structureBoundingBoxIn);
                    this.func_74871_b(worldIn, j, 12, i, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructurePiece {
        protected int field_143015_k = -1;
        private int field_74896_a;
        protected Type field_189928_h;
        protected boolean field_189929_i;
        protected Start startPiece;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.field_189928_h = start.field_189928_h;
                this.field_189929_i = start.field_189929_i;
                this.startPiece = start;
            }
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.field_143015_k);
            tagCompound.func_74768_a("VCount", this.field_74896_a);
            tagCompound.func_74774_a("Type", (byte)this.field_189928_h.func_202604_a());
            tagCompound.func_74757_a("Zombie", this.field_189929_i);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.field_143015_k = tagCompound.func_74762_e("HPos");
            this.field_74896_a = tagCompound.func_74762_e("VCount");
            this.field_189928_h = Type.func_202603_a(tagCompound.func_74771_c("Type"));
            if (tagCompound.func_74767_n("Desert")) {
                this.field_189928_h = Type.SANDSTONE;
            }
            this.field_189929_i = tagCompound.func_74767_n("Zombie");
        }

        @Nullable
        protected StructurePiece func_74891_a(Start start, List<StructurePiece> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74894_b(Start start, List<StructurePiece> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePieces.func_176066_d(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int func_74889_b(IWorld worldIn, MutableBoundingBox structurebb) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).func_177956_o();
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean func_74895_a(MutableBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void func_74893_a(IWorld worldIn, MutableBoundingBox structurebb, int x, int y, int z, int count) {
            if (this.field_74896_a < count) {
                int l;
                int k;
                int j;
                for (int i = this.field_74896_a; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.field_74896_a;
                    if (this.field_189929_i) {
                        EntityZombieVillager entityzombievillager = new EntityZombieVillager(worldIn.func_201672_e());
                        entityzombievillager.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombievillager.func_204210_a(worldIn.func_175649_E(new BlockPos((Entity)((Object)entityzombievillager))), null, null);
                        entityzombievillager.setProfession(this.chooseForgeProfession(i, (VillagerRegistry.VillagerProfession)VillagerRegistry.FARMER.orElseThrow(() -> new IllegalStateException("Farmer profession not initialized?"))));
                        entityzombievillager.func_110163_bv();
                        worldIn.func_72838_d((Entity)((Object)entityzombievillager));
                        continue;
                    }
                    EntityVillager entityvillager = new EntityVillager(worldIn.func_201672_e());
                    entityvillager.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    VillagerRegistry.setRandomProfession((EntityVillager)entityvillager, (Random)worldIn.func_201674_k());
                    entityvillager.setProfession(this.chooseForgeProfession(i, entityvillager.getProfessionForge()));
                    entityvillager.func_190672_a(worldIn.func_175649_E(new BlockPos((Entity)((Object)entityvillager))), null, null, false);
                    worldIn.func_72838_d((Entity)((Object)entityvillager));
                }
            }
        }

        @Deprecated
        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            return VillagerRegistry.getById((int)this.func_180779_c(count, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof)));
        }

        protected IBlockState func_175847_a(IBlockState blockstateIn) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, blockstateIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            Block block = blockstateIn.func_177230_c();
            if (this.field_189928_h == Type.SANDSTONE) {
                if (block.func_203417_a(BlockTags.field_200031_h) || block == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196585_ak.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (IBlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196667_cs.func_176223_P();
                }
            } else if (this.field_189928_h == Type.SPRUCE) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (IBlockState)Blocks.field_196618_L.func_176223_P().func_206870_a((IProperty)BlockLog.field_176298_M, blockstateIn.func_177229_b((IProperty)BlockLog.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196664_o.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196665_cr.func_176223_P();
                }
            } else if (this.field_189928_h == Type.ACACIA) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (IBlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((IProperty)BlockLog.field_176298_M, blockstateIn.func_177229_b((IProperty)BlockLog.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196670_r.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150400_ck.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_150347_e) {
                    return (IBlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((IProperty)BlockLog.field_176298_M, (Comparable)((Object)EnumFacing.Axis.Y));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196671_cu.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected BlockDoor func_189925_i() {
            if (this.field_189928_h == Type.ACACIA) {
                return (BlockDoor)Blocks.field_180410_as;
            }
            return this.field_189928_h == Type.SPRUCE ? (BlockDoor)Blocks.field_180414_ap : (BlockDoor)Blocks.field_180413_ao;
        }

        protected void func_189927_a(IWorld p_189927_1_, MutableBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, EnumFacing p_189927_7_) {
            if (!this.field_189929_i) {
                this.func_189915_a(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, EnumFacing.NORTH, this.func_189925_i());
            }
        }

        protected void func_189926_a(IWorld p_189926_1_, EnumFacing p_189926_2_, int p_189926_3_, int p_189926_4_, int p_189926_5_, MutableBoundingBox p_189926_6_) {
            if (!this.field_189929_i) {
                this.func_175811_a(p_189926_1_, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)BlockTorchWall.field_196532_a, (Comparable)((Object)p_189926_2_)), p_189926_3_, p_189926_4_, p_189926_5_, p_189926_6_);
            }
        }

        @Override
        protected void func_175808_b(IWorld worldIn, IBlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
            IBlockState iblockstate = this.func_175847_a(blockstateIn);
            super.func_175808_b(worldIn, iblockstate, x, y, z, boundingboxIn);
        }

        protected void func_202579_a(Type p_202579_1_) {
            this.field_189928_h = p_202579_1_;
        }
    }

    public static enum Type {
        OAK(0),
        SANDSTONE(1),
        ACACIA(2),
        SPRUCE(3);

        private final int field_202605_e;

        private Type(int p_i48768_3_) {
            this.field_202605_e = p_i48768_3_;
        }

        public int func_202604_a() {
            return this.field_202605_e;
        }

        public static Type func_202603_a(int p_202603_0_) {
            Type[] avillagepieces$type = Type.values();
            return p_202603_0_ >= 0 && p_202603_0_ < avillagepieces$type.length ? avillagepieces$type[p_202603_0_] : OAK;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int p_i45568_2_, Random rand, MutableBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static MutableBoundingBox func_175856_a(Start start, List<StructurePiece> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing facing) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructurePiece.func_74883_a(p_175856_1_, mutableboundingbox) != null ? null : mutableboundingbox;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_196602_ba.func_176223_P(), 1, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 2, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 1, 3, 1, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 0, 3, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 1, 3, -1, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Start
    extends Well {
        public int field_74928_c;
        public PieceWeight field_74926_d;
        public List<PieceWeight> field_74931_h;
        public List<StructurePiece> field_74932_i = Lists.newArrayList();
        public List<StructurePiece> field_74930_j = Lists.newArrayList();
        @Nullable
        public Biome biome;

        public Start() {
        }

        public Start(int p_i48769_1_, Random p_i48769_2_, int p_i48769_3_, int p_i48769_4_, List<PieceWeight> p_i48769_5_, VillageConfig p_i48769_6_) {
            this(p_i48769_1_, p_i48769_2_, p_i48769_3_, p_i48769_4_, p_i48769_5_, p_i48769_6_, null);
        }

        public Start(int p_i48769_1_, Random p_i48769_2_, int p_i48769_3_, int p_i48769_4_, List<PieceWeight> p_i48769_5_, VillageConfig p_i48769_6_, Biome biome) {
            super(null, 0, p_i48769_2_, p_i48769_3_, p_i48769_4_);
            this.field_74931_h = p_i48769_5_;
            this.field_74928_c = p_i48769_6_.field_202461_a;
            this.field_189928_h = p_i48769_6_.field_202462_b;
            this.func_202579_a(this.field_189928_h);
            this.field_189929_i = p_i48769_2_.nextInt(50) == 0;
            this.biome = biome;
            this.startPiece = this;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> field_75090_a;
        public final int field_75088_b;
        public int field_75089_c;
        public int field_75087_d;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.field_75090_a = p_i2098_1_;
            this.field_75088_b = p_i2098_2_;
            this.field_75087_d = p_i2098_3_;
        }

        public boolean func_75085_a(int componentType) {
            return this.field_75087_d == 0 || this.field_75089_c < this.field_75087_d;
        }

        public boolean func_75086_a() {
            return this.field_75087_d == 0 || this.field_75089_c < this.field_75087_d;
        }
    }

    public static class Path
    extends Road {
        private int field_74934_a;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, MutableBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.field_74934_a = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.field_74934_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_74934_a = tagCompound.func_74762_e("Length");
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.field_74934_a - 8; i += 2 + rand.nextInt(5)) {
                StructurePiece structurepiece = this.func_74891_a((Start)componentIn, listIn, rand, 0, i);
                if (structurepiece == null) continue;
                i += Math.max(structurepiece.field_74887_e.func_78883_b(), structurepiece.field_74887_e.func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.field_74934_a - 8; j += 2 + rand.nextInt(5)) {
                StructurePiece structurepiece1 = this.func_74894_b((Start)componentIn, listIn, rand, 0, j);
                if (structurepiece1 == null) continue;
                j += Math.max(structurepiece1.field_74887_e.func_78883_b(), structurepiece1.field_74887_e.func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        VillagePieces.func_176069_e((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static MutableBoundingBox func_175848_a(Start start, List<StructurePiece> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructurePiece.func_74883_a(p_175848_1_, mutableboundingbox) != null) continue;
                return mutableboundingbox;
            }
            return null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            IBlockState iblockstate = this.func_175847_a(Blocks.field_185774_da.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate2 = this.func_175847_a(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate3 = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            this.field_74887_e.field_78895_b = 1000;
            this.field_74887_e.field_78894_e = 0;
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    blockpos$mutableblockpos.func_181079_c(i, 64, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    int k = worldIn.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, blockpos$mutableblockpos.func_177958_n(), blockpos$mutableblockpos.func_177952_p());
                    blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos.func_177958_n(), k, blockpos$mutableblockpos.func_177952_p()).func_189536_c(EnumFacing.DOWN);
                    if (blockpos$mutableblockpos.func_177956_o() < worldIn.func_181545_F()) {
                        blockpos$mutableblockpos.func_185336_p(worldIn.func_181545_F() - 1);
                    }
                    while (blockpos$mutableblockpos.func_177956_o() >= worldIn.func_181545_F() - 1) {
                        IBlockState iblockstate4 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                        Block block = iblockstate4.func_177230_c();
                        if (block == Blocks.field_196658_i && worldIn.func_175623_d(blockpos$mutableblockpos.func_177984_a())) {
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, iblockstate, 2);
                            break;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d()) {
                            worldIn.func_180501_a(new BlockPos((Vec3i)blockpos$mutableblockpos), iblockstate1, 2);
                            break;
                        }
                        if (block == Blocks.field_150354_m || block == Blocks.field_196611_F || block == Blocks.field_150322_A || block == Blocks.field_196583_aj || block == Blocks.field_196585_ak || block == Blocks.field_180395_cM || block == Blocks.field_196583_aj || block == Blocks.field_196585_ak) {
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, iblockstate2, 2);
                            worldIn.func_180501_a(blockpos$mutableblockpos.func_177977_b(), iblockstate3, 2);
                            break;
                        }
                        blockpos$mutableblockpos.func_189536_c(EnumFacing.DOWN);
                    }
                    this.field_74887_e.field_78895_b = Math.min(this.field_74887_e.field_78895_b, blockpos$mutableblockpos.func_177956_o());
                    this.field_74887_e.field_78894_e = Math.max(this.field_74887_e.field_78894_e, blockpos$mutableblockpos.func_177956_o());
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean field_74913_b;

        public House4Garden() {
        }

        public House4Garden(Start start, int p_i45566_2_, Random rand, MutableBoundingBox p_i45566_4_, EnumFacing facing) {
            super(start, p_i45566_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45566_4_;
            this.field_74913_b = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Terrace", this.field_74913_b);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_74913_b = tagCompound.func_74767_n("Terrace");
        }

        public static House4Garden func_175858_a(Start start, List<StructurePiece> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing facing, int p_175858_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructurePiece.func_74883_a(p_175858_1_, mutableboundingbox) != null ? null : new House4Garden(start, p_175858_7_, rand, mutableboundingbox, facing);
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate3 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            IBlockState iblockstate4 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 0, structureBoundingBoxIn);
            if (this.func_175807_a((IBlockReader)worldIn, 2, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate2, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.field_74913_b) {
                boolean i = false;
                int j = 4;
                for (int k = 0; k <= 4; ++k) {
                    for (int l = 0; l <= 4; ++l) {
                        boolean flag1;
                        boolean flag = k == 0 || k == 4;
                        boolean bl = flag1 = l == 0 || l == 4;
                        if (!flag && !flag1) continue;
                        boolean flag2 = k == 0 || k == 4;
                        boolean flag3 = l == 0 || l == 4;
                        IBlockState iblockstate5 = (IBlockState)((IBlockState)((IBlockState)((IBlockState)iblockstate4.func_206870_a((IProperty)BlockFence.field_196413_c, Boolean.valueOf(flag2 && l != 0))).func_206870_a((IProperty)BlockFence.field_196409_a, Boolean.valueOf(flag2 && l != 4))).func_206870_a((IProperty)BlockFence.field_196414_y, Boolean.valueOf(flag3 && k != 0))).func_206870_a((IProperty)BlockFence.field_196411_b, Boolean.valueOf(flag3 && k != 4));
                        this.func_175811_a(worldIn, iblockstate5, k, 5, l, structureBoundingBoxIn);
                    }
                }
            }
            if (this.field_74913_b) {
                IBlockState iblockstate6 = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)BlockLadder.field_176382_a, (Comparable)((Object)EnumFacing.SOUTH));
                this.func_175811_a(worldIn, iblockstate6, 3, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate6, 3, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate6, 3, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate6, 3, 4, 3, structureBoundingBoxIn);
            }
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int j1 = 0; j1 < 5; ++j1) {
                    this.func_74871_b(worldIn, j1, 6, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j1, -1, i1, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int type, Random rand, MutableBoundingBox p_i45561_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 func_175849_a(Start start, List<StructurePiece> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing facing, int p_175849_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return House3.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175849_1_, mutableboundingbox) == null ? new House3(start, p_175849_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.SOUTH)));
            IBlockState iblockstate3 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.EAST)));
            IBlockState iblockstate4 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.WEST)));
            IBlockState iblockstate5 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate6 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 4, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(worldIn, iblockstate5, k, 2 + k, 7 - k, structureBoundingBoxIn);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(worldIn, iblockstate10, k, 2 + k, k1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 6, 6, 4, structureBoundingBoxIn);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(worldIn, iblockstate9, l, 12 - l, l1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a((IBlockReader)worldIn, 2, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.func_74871_b(worldIn, i2, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i2, -1, i1, structureBoundingBoxIn);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.func_74871_b(worldIn, j2, 7, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j2, -1, j1, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }
    }

    public static class House2
    extends Village {
        private boolean field_74917_c;

        public House2() {
        }

        public House2(Start start, int type, Random rand, MutableBoundingBox p_i45563_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45563_4_;
        }

        public static House2 func_175855_a(Start start, List<StructurePiece> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing facing, int p_175855_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return House2.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175855_1_, mutableboundingbox) == null ? new House2(start, p_175855_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.field_74917_c);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_74917_c = tagCompound.func_74767_n("Chest");
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150347_e.func_176223_P();
            IBlockState iblockstate1 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.WEST)));
            IBlockState iblockstate3 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate4 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate5 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            IBlockState iblockstate6 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate3, 3, 3, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)BlockPane.field_196409_a, Boolean.valueOf(true))).func_206870_a((IProperty)BlockPane.field_196413_c, Boolean.valueOf(true)), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)BlockPane.field_196409_a, Boolean.valueOf(true)), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((IProperty)BlockFurnace.field_176447_a, (Comparable)((Object)EnumFacing.SOUTH)), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((IProperty)BlockFurnace.field_176447_a, (Comparable)((Object)EnumFacing.SOUTH)), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((IProperty)BlockSlab.field_196505_a, (Comparable)SlabType.DOUBLE), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_196663_cq.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 1, 4, structureBoundingBoxIn);
            if (!this.field_74917_c && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.field_74917_c = true;
                this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 5, 1, 5, LootTableList.field_186423_e);
            }
            for (int i = 6; i <= 8; ++i) {
                if (!this.func_175807_a((IBlockReader)worldIn, i, 0, -1, structureBoundingBoxIn).func_196958_f() || this.func_175807_a((IBlockReader)worldIn, i, -1, -1, structureBoundingBoxIn).func_196958_f()) continue;
                this.func_175811_a(worldIn, iblockstate4, i, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, i, -1, -1, structureBoundingBoxIn).func_177230_c() != Blocks.field_185774_da) continue;
                this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), i, -1, -1, structureBoundingBoxIn);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, Random rand, MutableBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 func_175850_a(Start start, List<StructurePiece> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175850_1_, mutableboundingbox) == null ? new House1(start, p_175850_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.SOUTH)));
            IBlockState iblockstate3 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.EAST)));
            IBlockState iblockstate4 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate5 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate6 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_196663_cq.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_196663_cq.func_176223_P(), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a((IBlockReader)worldIn, 1, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 1, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start start, int type, Random rand, MutableBoundingBox p_i45567_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45567_4_;
        }

        public static Hall func_175857_a(Start start, List<StructurePiece> p_175857_1_, Random rand, int p_175857_3_, int p_175857_4_, int p_175857_5_, EnumFacing facing, int p_175857_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)facing);
            return Hall.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175857_1_, mutableboundingbox) == null ? new Hall(start, p_175857_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            IBlockState iblockstate1 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.SOUTH)));
            IBlockState iblockstate3 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.WEST)));
            IBlockState iblockstate4 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            IBlockState iblockstate5 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            IBlockState iblockstate6 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 0, 6, structureBoundingBoxIn);
            IBlockState iblockstate7 = (IBlockState)((IBlockState)iblockstate6.func_206870_a((IProperty)BlockFence.field_196409_a, Boolean.valueOf(true))).func_206870_a((IProperty)BlockFence.field_196413_c, Boolean.valueOf(true));
            IBlockState iblockstate8 = (IBlockState)((IBlockState)iblockstate6.func_206870_a((IProperty)BlockFence.field_196414_y, Boolean.valueOf(true))).func_206870_a((IProperty)BlockFence.field_196411_b, Boolean.valueOf(true));
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 1, 9, iblockstate7, iblockstate7, false);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)iblockstate6.func_206870_a((IProperty)BlockFence.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockFence.field_196411_b, Boolean.valueOf(true)), 2, 1, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 6, 8, 1, 9, iblockstate7, iblockstate7, false);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)iblockstate6.func_206870_a((IProperty)BlockFence.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockFence.field_196414_y, Boolean.valueOf(true)), 8, 1, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 10, 7, 1, 10, iblockstate8, iblockstate8, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 7, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 3, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 3, structureBoundingBoxIn);
            IBlockState iblockstate9 = iblockstate1;
            IBlockState iblockstate10 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate9, j, 4 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate10, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_196663_cq.func_176223_P(), 2, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 1, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate9, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 3, structureBoundingBoxIn);
            IBlockState iblockstate11 = (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((IProperty)BlockSlab.field_196505_a, (Comparable)SlabType.DOUBLE);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 1, 7, 0, 3, iblockstate11, iblockstate11, false);
            this.func_175811_a(worldIn, iblockstate11, 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate11, 6, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a((IBlockReader)worldIn, 2, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate9, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 6, 3, 4, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 6, 1, 5, EnumFacing.SOUTH);
            for (int l = 0; l < 5; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 7, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return villagersSpawnedIn == 0 ? 4 : super.func_180779_c(villagersSpawnedIn, currentVillagerProfession);
        }
    }

    public static class Field2
    extends Village {
        private IBlockState field_82675_b;
        private IBlockState field_82676_c;

        public Field2() {
        }

        public Field2(Start start, int p_i45569_2_, Random rand, MutableBoundingBox p_i45569_4_, EnumFacing facing) {
            super(start, p_i45569_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45569_4_;
            this.field_82675_b = Field2.func_197529_b(rand);
            this.field_82676_c = Field2.func_197529_b(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74782_a("CA", NBTUtil.func_190009_a((IBlockState)this.field_82675_b));
            tagCompound.func_74782_a("CB", NBTUtil.func_190009_a((IBlockState)this.field_82676_c));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_82675_b = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CA"));
            this.field_82676_c = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CB"));
        }

        private static IBlockState func_197529_b(Random p_197529_0_) {
            switch (p_197529_0_.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM.func_176223_P();
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN.func_176223_P();
                }
                case 4: {
                    return Blocks.field_185773_cZ.func_176223_P();
                }
            }
            return Blocks.field_150464_aj.func_176223_P();
        }

        public static Field2 func_175852_a(Start start, List<StructurePiece> p_175852_1_, Random rand, int p_175852_3_, int p_175852_4_, int p_175852_5_, EnumFacing facing, int p_175852_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)facing);
            return Field2.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175852_1_, mutableboundingbox) == null ? new Field2(start, p_175852_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 5, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 5, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                BlockCrops blockcrops = (BlockCrops)this.field_82675_b.func_177230_c();
                int j = blockcrops.func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82675_b.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j))), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82675_b.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j))), 2, 1, i, structureBoundingBoxIn);
                blockcrops = (BlockCrops)this.field_82676_c.func_177230_c();
                int l = blockcrops.func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82676_c.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l))), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82676_c.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l))), 5, 1, i, structureBoundingBoxIn);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.func_74871_b(worldIn, k1, 4, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), k1, -1, j1, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private IBlockState field_82679_b;
        private IBlockState field_82680_c;
        private IBlockState field_82678_d;
        private IBlockState field_82681_h;

        public Field1() {
        }

        public Field1(Start start, int type, Random rand, MutableBoundingBox p_i45570_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45570_4_;
            this.field_82679_b = Field2.func_197529_b(rand);
            this.field_82680_c = Field2.func_197529_b(rand);
            this.field_82678_d = Field2.func_197529_b(rand);
            this.field_82681_h = Field2.func_197529_b(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74782_a("CA", NBTUtil.func_190009_a((IBlockState)this.field_82679_b));
            tagCompound.func_74782_a("CB", NBTUtil.func_190009_a((IBlockState)this.field_82680_c));
            tagCompound.func_74782_a("CC", NBTUtil.func_190009_a((IBlockState)this.field_82678_d));
            tagCompound.func_74782_a("CD", NBTUtil.func_190009_a((IBlockState)this.field_82681_h));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.field_82679_b = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CA"));
            this.field_82680_c = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CB"));
            this.field_82678_d = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CC"));
            this.field_82681_h = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("CD"));
            if (!(this.field_82679_b.func_177230_c() instanceof BlockCrops)) {
                this.field_82679_b = Blocks.field_150464_aj.func_176223_P();
            }
            if (!(this.field_82680_c.func_177230_c() instanceof BlockCrops)) {
                this.field_82680_c = Blocks.field_150459_bM.func_176223_P();
            }
            if (!(this.field_82678_d.func_177230_c() instanceof BlockCrops)) {
                this.field_82678_d = Blocks.field_150469_bN.func_176223_P();
            }
            if (!(this.field_82681_h.func_177230_c() instanceof BlockCrops)) {
                this.field_82681_h = Blocks.field_185773_cZ.func_176223_P();
            }
        }

        public static Field1 func_175851_a(Start start, List<StructurePiece> p_175851_1_, Random rand, int p_175851_3_, int p_175851_4_, int p_175851_5_, EnumFacing facing, int p_175851_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
            return Field1.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175851_1_, mutableboundingbox) == null ? new Field1(start, p_175851_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                BlockCrops blockcrops = (BlockCrops)this.field_82679_b.func_177230_c();
                int j = blockcrops.func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82679_b.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j))), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82679_b.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j))), 2, 1, i, structureBoundingBoxIn);
                blockcrops = (BlockCrops)this.field_82680_c.func_177230_c();
                int l = blockcrops.func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82680_c.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l))), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82680_c.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l))), 5, 1, i, structureBoundingBoxIn);
                blockcrops = (BlockCrops)this.field_82678_d.func_177230_c();
                int j1 = blockcrops.func_185526_g();
                int k1 = j1 / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82678_d.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1))), 7, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82678_d.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1))), 8, 1, i, structureBoundingBoxIn);
                blockcrops = (BlockCrops)this.field_82681_h.func_177230_c();
                int l1 = blockcrops.func_185526_g();
                int i2 = l1 / 3;
                this.func_175811_a(worldIn, (IBlockState)this.field_82681_h.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1))), 10, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (IBlockState)this.field_82681_h.func_206870_a((IProperty)blockcrops.func_185524_e(), Integer.valueOf(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1))), 11, 1, i, structureBoundingBoxIn);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.func_74871_b(worldIn, k2, 4, j2, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), k2, -1, j2, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start start, int type, Random rand, MutableBoundingBox p_i45564_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45564_4_;
        }

        public static Church func_175854_a(Start start, List<StructurePiece> p_175854_1_, Random rand, int p_175854_3_, int p_175854_4_, int p_175854_5_, EnumFacing facing, int p_175854_7_) {
            MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)facing);
            return Church.func_74895_a(mutableboundingbox) && StructurePiece.func_74883_a(p_175854_1_, mutableboundingbox) == null ? new Church(start, p_175854_7_, rand, mutableboundingbox, facing) : null;
        }

        @Override
        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150347_e.func_176223_P();
            IBlockState iblockstate1 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.NORTH)));
            IBlockState iblockstate2 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.WEST)));
            IBlockState iblockstate3 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((IProperty)BlockStairs.field_176309_a, (Comparable)((Object)EnumFacing.EAST)));
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 3, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 3, 10, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 4, 0, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 4, 4, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 8, 3, 4, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 4, 3, 10, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 5, 3, 5, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, iblockstate, 0, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 0, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196413_c, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196409_a, Boolean.valueOf(true)), 4, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((IProperty)BlockGlassPane.field_196411_b, Boolean.valueOf(true))).func_206870_a((IProperty)BlockGlassPane.field_196414_y, Boolean.valueOf(true)), 2, 3, 8, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.SOUTH, 2, 4, 7, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.EAST, 1, 4, 6, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.WEST, 3, 4, 6, structureBoundingBoxIn);
            this.func_189926_a(worldIn, EnumFacing.NORTH, 2, 4, 5, structureBoundingBoxIn);
            IBlockState iblockstate4 = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)BlockLadder.field_176382_a, (Comparable)((Object)EnumFacing.WEST));
            for (int i = 1; i <= 9; ++i) {
                this.func_175811_a(worldIn, iblockstate4, 3, i, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a((IBlockReader)worldIn, 2, 0, -1, structureBoundingBoxIn).func_196958_f() && !this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_196958_f()) {
                this.func_175811_a(worldIn, iblockstate1, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a((IBlockReader)worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 12, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }
}

