/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import com.google.common.collect.ImmutableList;
import java.util.function.LongFunction;
import net.minecraft.init.Biomes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IContextExtended;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerMixOceans;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.eventbus.api.Event;

public class LayerUtil {
    protected static final int field_203632_a = IRegistry.field_212624_m.func_148757_b(Biomes.field_203614_T);
    protected static final int field_203633_b = IRegistry.field_212624_m.func_148757_b(Biomes.field_203615_U);
    protected static final int field_202832_c = IRegistry.field_212624_m.func_148757_b(Biomes.field_76771_b);
    protected static final int field_203634_d = IRegistry.field_212624_m.func_148757_b(Biomes.field_203616_V);
    protected static final int field_202831_b = IRegistry.field_212624_m.func_148757_b(Biomes.field_76776_l);
    protected static final int field_203635_f = IRegistry.field_212624_m.func_148757_b(Biomes.field_203617_W);
    protected static final int field_203636_g = IRegistry.field_212624_m.func_148757_b(Biomes.field_203618_X);
    protected static final int field_202830_a = IRegistry.field_212624_m.func_148757_b(Biomes.field_150575_M);
    protected static final int field_203637_i = IRegistry.field_212624_m.func_148757_b(Biomes.field_203619_Y);
    protected static final int field_203638_j = IRegistry.field_212624_m.func_148757_b(Biomes.field_203620_Z);

    public static <T extends IArea, C extends IContextExtended<T>> IAreaFactory<T> func_202829_a(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IContextExtended)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IContextExtended<T>> ImmutableList<IAreaFactory<T>> func_202828_a(WorldType worldTypeIn, OverworldGenSettings settings, LongFunction<C> contextFactory) {
        int i;
        IAreaFactory<T> iareafactory = GenLayerIsland.INSTANCE.func_202823_a((IContextExtended)contextFactory.apply(1L));
        iareafactory = GenLayerZoom.FUZZY.func_202713_a((IContextExtended)contextFactory.apply(2000L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2001L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(50L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(70L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerRemoveTooMuchOcean.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        IAreaFactory<T> iareafactory1 = OceanLayer.INSTANCE.func_202823_a((IContextExtended)contextFactory.apply(2L));
        iareafactory1 = LayerUtil.func_202829_a(2001L, (IAreaTransformer1)GenLayerZoom.NORMAL, iareafactory1, 6, contextFactory);
        iareafactory = GenLayerAddSnow.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerEdge.CoolWarm.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerEdge.HeatIce.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerEdge.Special.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2002L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(2003L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerAddMushroomIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(5L), (IAreaFactory)iareafactory);
        iareafactory = GenLayerDeepOcean.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, iareafactory, 0, contextFactory);
        int j = i = 4;
        if (settings != null) {
            i = settings.func_202200_j();
            j = settings.func_202198_k();
        }
        if (worldTypeIn == WorldType.field_77135_d) {
            i = 6;
        }
        i = LayerUtil.getModdedBiomeSize(worldTypeIn, i);
        IAreaFactory lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, iareafactory, 0, contextFactory);
        lvt_7_1_ = GenLayerRiverInit.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(100L), lvt_7_1_);
        IAreaFactory lvt_8_1_ = worldTypeIn.getBiomeLayer(iareafactory, settings, contextFactory);
        IAreaFactory<T> lvt_9_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_8_1_ = GenLayerHills.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(1000L), lvt_8_1_, lvt_9_1_);
        lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_7_1_ = LayerUtil.func_202829_a(1000L, (IAreaTransformer1)GenLayerZoom.NORMAL, lvt_7_1_, j, contextFactory);
        lvt_7_1_ = GenLayerRiver.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1L), lvt_7_1_);
        lvt_7_1_ = GenLayerSmooth.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), lvt_7_1_);
        lvt_8_1_ = GenLayerRareBiome.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1001L), lvt_8_1_);
        for (int k = 0; k < i; ++k) {
            lvt_8_1_ = GenLayerZoom.NORMAL.func_202713_a((IContextExtended)contextFactory.apply(1000 + k), lvt_8_1_);
            if (k == 0) {
                lvt_8_1_ = GenLayerAddIsland.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(3L), lvt_8_1_);
            }
            if (k != 1 && i != 1) continue;
            lvt_8_1_ = GenLayerShore.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), lvt_8_1_);
        }
        lvt_8_1_ = GenLayerSmooth.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(1000L), lvt_8_1_);
        lvt_8_1_ = GenLayerRiverMix.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(100L), lvt_8_1_, lvt_7_1_);
        lvt_8_1_ = GenLayerMixOceans.INSTANCE.func_202707_a((IContextExtended)contextFactory.apply(100L), lvt_8_1_, iareafactory1);
        IAreaFactory iareafactory5 = GenLayerVoronoiZoom.INSTANCE.func_202713_a((IContextExtended)contextFactory.apply(10L), lvt_8_1_);
        return ImmutableList.of((Object)lvt_8_1_, (Object)iareafactory5, (Object)lvt_8_1_);
    }

    public static GenLayer[] func_202824_a(long seed, WorldType typeIn, OverworldGenSettings settings) {
        boolean i = true;
        int[] aint = new int[1];
        ImmutableList immutablelist = LayerUtil.func_202828_a(typeIn, settings, p_202825_3_ -> {
            aint[0] = aint[0] + 1;
            return new LazyAreaLayerContext(1, aint[0], seed, p_202825_3_);
        });
        GenLayer genlayer = new GenLayer((IAreaFactory)immutablelist.get(0));
        GenLayer genlayer1 = new GenLayer((IAreaFactory)immutablelist.get(1));
        GenLayer genlayer2 = new GenLayer((IAreaFactory)immutablelist.get(2));
        return new GenLayer[]{genlayer, genlayer1, genlayer2};
    }

    public static boolean func_202826_a(int p_202826_0_, int p_202826_1_) {
        if (p_202826_0_ == p_202826_1_) {
            return true;
        }
        Biome biome = IRegistry.field_212624_m.func_148754_a(p_202826_0_);
        Biome biome1 = IRegistry.field_212624_m.func_148754_a(p_202826_1_);
        if (biome != null && biome1 != null) {
            if (biome != Biomes.field_150607_aa && biome != Biomes.field_150608_ab) {
                if (biome.func_201856_r() != Biome.Category.NONE && biome1.func_201856_r() != Biome.Category.NONE && biome.func_201856_r() == biome1.func_201856_r()) {
                    return true;
                }
                return biome == biome1;
            }
            return biome1 == Biomes.field_150607_aa || biome1 == Biomes.field_150608_ab;
        }
        return false;
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewSize();
    }

    protected static boolean func_202827_a(int biomeIn) {
        return biomeIn == field_203632_a || biomeIn == field_203633_b || biomeIn == field_202832_c || biomeIn == field_203634_d || biomeIn == field_202831_b || biomeIn == field_203635_f || biomeIn == field_203636_g || biomeIn == field_202830_a || biomeIn == field_203637_i || biomeIn == field_203638_j;
    }

    protected static boolean func_203631_b(int biomeIn) {
        return biomeIn == field_203632_a || biomeIn == field_203633_b || biomeIn == field_202832_c || biomeIn == field_203634_d || biomeIn == field_202831_b;
    }
}

