/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ExpiringMap;
import net.minecraft.util.ITaskType;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.Scheduler;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.SessionLockException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtoChunkScheduler
extends Scheduler<ChunkPos, ChunkStatus, ChunkPrimer> {
    private static final Logger field_202873_b = LogManager.getLogger();
    private final World field_202874_c;
    private final IChunkGenerator<?> field_202875_d;
    private final IChunkLoader field_202876_e;
    private final IThreadListener field_202877_f;
    private final Long2ObjectMap<Scheduler.FutureWrapper> field_202878_g = new ExpiringMap<Scheduler.FutureWrapper>(8192, 5000){

        protected boolean func_205609_a_(Scheduler.FutureWrapper element) {
            ChunkPrimer chunkprimer = (ChunkPrimer)element.func_202917_a();
            return !chunkprimer.func_205748_B() && !chunkprimer.func_201593_f();
        }
    };

    public ProtoChunkScheduler(int concurrency, World worldIn, IChunkGenerator<?> chunkGeneratorIn, IChunkLoader chunkLoaderIn, IThreadListener threadListenerIn) {
        super("WorldGen", concurrency, (ITaskType)ChunkStatus.FINALIZED, () -> new EnumMap(ChunkStatus.class), () -> new EnumMap(ChunkStatus.class));
        this.field_202874_c = worldIn;
        this.field_202875_d = chunkGeneratorIn;
        this.field_202876_e = chunkLoaderIn;
        this.field_202877_f = threadListenerIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Scheduler.FutureWrapper func_212252_a_(ChunkPos p_212252_1_, boolean p_212252_2_) {
        IChunkLoader iChunkLoader = this.field_202876_e;
        synchronized (iChunkLoader) {
            return p_212252_2_ ? (Scheduler.FutureWrapper)this.field_202878_g.computeIfAbsent(p_212252_1_.func_201841_a(), p_212539_2_ -> {
                ChunkPrimer chunkprimer;
                try {
                    chunkprimer = this.field_202876_e.func_202152_b((IWorld)this.field_202874_c, p_212252_1_.field_77276_a, p_212252_1_.field_77275_b, p_212538_0_ -> {});
                }
                catch (ReportedException reportedexception) {
                    throw reportedexception;
                }
                catch (Exception exception) {
                    field_202873_b.error("Couldn't load protochunk", (Throwable)exception);
                    chunkprimer = null;
                }
                if (chunkprimer != null) {
                    chunkprimer.func_177432_b(this.field_202874_c.func_82737_E());
                    return new Scheduler.FutureWrapper((Scheduler)this, (Object)p_212252_1_, (Object)chunkprimer, (ITaskType)chunkprimer.func_201589_g());
                }
                return new Scheduler.FutureWrapper((Scheduler)this, (Object)p_212252_1_, (Object)new ChunkPrimer(p_212252_1_, UpgradeData.field_196994_a), (ITaskType)ChunkStatus.EMPTY);
            }) : (Scheduler.FutureWrapper)this.field_202878_g.get(p_212252_1_.func_201841_a());
        }
    }

    protected ChunkPrimer func_201493_a_(ChunkPos key, ChunkStatus taskType, Map<ChunkPos, ChunkPrimer> providingMap) {
        return taskType.func_202126_a(this.field_202874_c, this.field_202875_d, providingMap, key.field_77276_a, key.field_77275_b);
    }

    protected Scheduler.FutureWrapper func_205606_a_(ChunkPos pos, Scheduler.FutureWrapper futureWrapperIn) {
        ((ChunkPrimer)futureWrapperIn.func_202917_a()).func_205747_a(1);
        return futureWrapperIn;
    }

    protected void func_205607_b_(ChunkPos key, Scheduler.FutureWrapper futureWrapper) {
        ((ChunkPrimer)futureWrapper.func_202917_a()).func_205747_a(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_208484_a(BooleanSupplier p_208484_1_) {
        IChunkLoader iChunkLoader = this.field_202876_e;
        synchronized (iChunkLoader) {
            for (Scheduler.FutureWrapper scheduler : this.field_202878_g.values()) {
                ChunkPrimer chunkprimer = (ChunkPrimer)scheduler.func_202917_a();
                if (chunkprimer.func_201593_f() && chunkprimer.func_201589_g().func_202129_d() == ChunkStatus.Type.PROTOCHUNK) {
                    try {
                        chunkprimer.func_177432_b(this.field_202874_c.func_82737_E());
                        this.field_202876_e.func_75816_a(this.field_202874_c, (IChunk)chunkprimer);
                        chunkprimer.func_177427_f(false);
                    }
                    catch (IOException ioexception) {
                        field_202873_b.error("Couldn't save chunk", (Throwable)ioexception);
                    }
                    catch (SessionLockException sessionlockexception) {
                        field_202873_b.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionlockexception);
                    }
                }
                if (p_208484_1_.getAsBoolean()) continue;
                return;
            }
        }
    }
}

