/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.DummyWorldSaveData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger field_212776_a = LogManager.getLogger();
    private final DimensionType field_212777_b;
    private Map<String, WorldSavedData> field_212778_c = Maps.newHashMap();
    private final Object2IntMap<String> field_212779_d = new Object2IntOpenHashMap();
    @Nullable
    private final ISaveHandler field_212780_e;

    public DimensionSavedDataManager(DimensionType p_i49854_1_, @Nullable ISaveHandler p_i49854_2_) {
        this.field_212777_b = p_i49854_1_;
        this.field_212780_e = p_i49854_2_;
        this.field_212779_d.defaultReturnValue(-1);
    }

    @Nullable
    public <T extends WorldSavedData> T func_201067_a(Function<String, T> factory, String name) {
        WorldSavedData worldsaveddata = this.field_212778_c.get(name);
        if (worldsaveddata == DummyWorldSaveData.DUMMY) {
            return null;
        }
        if (worldsaveddata == null && this.field_212780_e != null) {
            try {
                File file1 = this.field_212780_e.func_212423_a(this.field_212777_b, name);
                if (file1 == null || !file1.exists()) {
                    this.field_212778_c.put(name, (WorldSavedData)DummyWorldSaveData.DUMMY);
                    return null;
                }
                worldsaveddata = (WorldSavedData)factory.apply(name);
                worldsaveddata.func_76184_a(DimensionSavedDataManager.func_212774_a(this.field_212780_e, this.field_212777_b, name, 1631).func_74775_l("data"));
                this.field_212778_c.put(name, worldsaveddata);
            }
            catch (Exception exception) {
                field_212776_a.error("Error loading saved data: {}", (Object)name, (Object)exception);
            }
        }
        return (T)worldsaveddata;
    }

    public void func_75745_a(String dataIdentifier, WorldSavedData data) {
        this.field_212778_c.put(dataIdentifier, data);
    }

    public void func_75746_b() {
        try {
            this.field_212779_d.clear();
            if (this.field_212780_e == null) {
                return;
            }
            File file1 = this.field_212780_e.func_212423_a(this.field_212777_b, "idcounts");
            if (file1 != null && file1.exists()) {
                DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74794_a(datainputstream);
                datainputstream.close();
                for (String s : nbttagcompound.func_150296_c()) {
                    if (!nbttagcompound.func_150297_b(s, 99)) continue;
                    this.field_212779_d.put((Object)s, nbttagcompound.func_74762_e(s));
                }
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Could not load aux values", (Throwable)exception);
        }
    }

    public int func_75743_a(String key) {
        int i = this.field_212779_d.getInt((Object)key) + 1;
        this.field_212779_d.put((Object)key, i);
        if (this.field_212780_e == null) {
            return i;
        }
        try {
            File file1 = this.field_212780_e.func_212423_a(this.field_212777_b, "idcounts");
            if (file1 != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                for (Object2IntMap.Entry entry : this.field_212779_d.object2IntEntrySet()) {
                    nbttagcompound.func_74768_a((String)entry.getKey(), entry.getIntValue());
                }
                DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
                CompressedStreamTools.func_74800_a(nbttagcompound, dataoutputstream);
                dataoutputstream.close();
            }
        }
        catch (Exception exception) {
            field_212776_a.error("Could not get free aux value {}", (Object)key, (Object)exception);
        }
        return i;
    }

    public static NBTTagCompound func_212774_a(ISaveHandler p_212774_0_, DimensionType p_212774_1_, String p_212774_2_, int p_212774_3_) throws IOException {
        NBTTagCompound nbttagcompound1;
        File file1 = p_212774_0_.func_212423_a(p_212774_1_, p_212774_2_);
        try (FileInputStream fileinputstream = new FileInputStream(file1);){
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a(fileinputstream);
            int i = nbttagcompound.func_150297_b("DataVersion", 99) ? nbttagcompound.func_74762_e("DataVersion") : 1343;
            nbttagcompound1 = NBTUtil.func_210821_a((DataFixer)p_212774_0_.func_197718_i(), (DSL.TypeReference)DataFixTypes.SAVED_DATA, (NBTTagCompound)nbttagcompound, (int)i, (int)p_212774_3_);
        }
        return nbttagcompound1;
    }

    public void func_212775_b() {
        if (this.field_212780_e != null) {
            for (WorldSavedData worldsaveddata : this.field_212778_c.values()) {
                if (!worldsaveddata.func_76188_b()) continue;
                this.func_75747_a(worldsaveddata);
                worldsaveddata.func_76186_a(false);
            }
        }
    }

    private void func_75747_a(WorldSavedData data) {
        if (this.field_212780_e != null) {
            try {
                File file1 = this.field_212780_e.func_212423_a(this.field_212777_b, data.func_195925_e());
                if (file1 != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.func_74782_a("data", data.func_189551_b(new NBTTagCompound()));
                    nbttagcompound.func_74768_a("DataVersion", 1631);
                    FileOutputStream fileoutputstream = new FileOutputStream(file1);
                    CompressedStreamTools.func_74799_a(nbttagcompound, fileoutputstream);
                    fileoutputstream.close();
                }
            }
            catch (Exception exception) {
                field_212776_a.error("Could not save data {}", (Object)data, (Object)exception);
            }
        }
    }
}

