/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.WorldPersistenceHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveHandler
implements ISaveHandler,
IPlayerFileData {
    private static final Logger field_151478_a = LogManager.getLogger();
    private final File field_75770_b;
    public final File field_75771_c;
    private final long field_75769_e = Util.func_211177_b();
    private final String field_75767_f;
    private final TemplateManager field_186342_h;
    protected final DataFixer field_186341_a;

    public SaveHandler(File p_i49566_1_, String p_i49566_2_, @Nullable MinecraftServer p_i49566_3_, DataFixer p_i49566_4_) {
        this.field_186341_a = p_i49566_4_;
        this.field_75770_b = new File(p_i49566_1_, p_i49566_2_);
        this.field_75770_b.mkdirs();
        this.field_75771_c = new File(this.field_75770_b, "playerdata");
        this.field_75767_f = p_i49566_2_;
        if (p_i49566_3_ != null) {
            this.field_75771_c.mkdirs();
            this.field_186342_h = new TemplateManager(p_i49566_3_, this.field_75770_b, p_i49566_4_);
        } else {
            this.field_186342_h = null;
        }
        this.func_75766_h();
    }

    private void func_75766_h() {
        try {
            File file1 = new File(this.field_75770_b, "session.lock");
            try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));){
                dataoutputstream.writeLong(this.field_75769_e);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.field_75770_b;
    }

    public void func_75762_c() throws SessionLockException {
        try {
            File file1 = new File(this.field_75770_b, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));){
                if (datainputstream.readLong() != this.field_75769_e) {
                    throw new SessionLockException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException var7) {
            throw new SessionLockException("Failed to check session lock, aborting");
        }
    }

    public IChunkLoader func_75763_a(Dimension provider) {
        throw new RuntimeException("Old Chunk Storage is no longer supported.");
    }

    @Nullable
    public WorldInfo func_75757_d() {
        WorldInfo worldinfo;
        File file1 = new File(this.field_75770_b, "level.dat");
        if (file1.exists() && (worldinfo = SaveFormatOld.getWorldData(file1, this.field_186341_a, this)) != null) {
            return worldinfo;
        }
        file1 = new File(this.field_75770_b, "level.dat_old");
        return file1.exists() ? SaveFormatOld.getWorldData(file1, this.field_186341_a, this) : null;
    }

    public void func_75755_a(WorldInfo worldInformation, @Nullable NBTTagCompound tagCompound) {
        NBTTagCompound nbttagcompound = worldInformation.func_76082_a(tagCompound);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74782_a("Data", nbttagcompound);
        WorldPersistenceHooks.handleWorldDataSave((SaveHandler)this, (WorldInfo)worldInformation, (NBTTagCompound)nbttagcompound1);
        try {
            File file1 = new File(this.field_75770_b, "level.dat_new");
            File file2 = new File(this.field_75770_b, "level.dat_old");
            File file3 = new File(this.field_75770_b, "level.dat");
            CompressedStreamTools.func_74799_a(nbttagcompound1, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void func_75761_a(WorldInfo worldInformation) {
        this.func_75755_a(worldInformation, null);
    }

    public void func_75753_a(EntityPlayer player) {
        try {
            NBTTagCompound nbttagcompound = player.func_189511_e(new NBTTagCompound());
            File file1 = new File(this.field_75771_c, player.func_189512_bd() + ".dat.tmp");
            File file2 = new File(this.field_75771_c, player.func_189512_bd() + ".dat");
            CompressedStreamTools.func_74799_a(nbttagcompound, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
            ForgeEventFactory.firePlayerSavingEvent((EntityPlayer)player, (File)this.field_75771_c, (String)player.func_110124_au().toString());
        }
        catch (Exception var5) {
            field_151478_a.warn("Failed to save player data for {}", (Object)player.func_200200_C_().getString());
        }
    }

    @Nullable
    public NBTTagCompound func_75752_b(EntityPlayer player) {
        NBTTagCompound nbttagcompound = null;
        try {
            File file1 = new File(this.field_75771_c, player.func_189512_bd() + ".dat");
            if (file1.exists() && file1.isFile()) {
                nbttagcompound = CompressedStreamTools.func_74796_a(new FileInputStream(file1));
            }
        }
        catch (Exception var4) {
            field_151478_a.warn("Failed to load player data for {}", (Object)player.func_200200_C_().getString());
        }
        if (nbttagcompound != null) {
            int i = nbttagcompound.func_150297_b("DataVersion", 3) ? nbttagcompound.func_74762_e("DataVersion") : -1;
            player.func_70020_e(NBTUtil.func_210822_a((DataFixer)this.field_186341_a, (DSL.TypeReference)DataFixTypes.PLAYER, (NBTTagCompound)nbttagcompound, (int)i));
        }
        ForgeEventFactory.firePlayerLoadingEvent((EntityPlayer)player, (File)this.field_75771_c, (String)player.func_110124_au().toString());
        return nbttagcompound;
    }

    public IPlayerFileData func_75756_e() {
        return this;
    }

    public String[] func_75754_f() {
        String[] astring = this.field_75771_c.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    public void func_75759_a() {
    }

    public File func_212423_a(DimensionType p_212423_1_, String p_212423_2_) {
        File file1 = new File(p_212423_1_.func_212679_a(this.field_75770_b), "data");
        file1.mkdirs();
        return new File(file1, p_212423_2_ + ".dat");
    }

    public TemplateManager func_186340_h() {
        return this.field_186342_h;
    }

    public DataFixer func_197718_i() {
        return this.field_186341_a;
    }

    public NBTTagCompound getPlayerNBT(EntityPlayerMP player) {
        try {
            File file1 = new File(this.field_75771_c, player.func_189512_bd() + ".dat");
            if (file1.exists() && file1.isFile()) {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a(new FileInputStream(file1));
                if (nbt != null) {
                    nbt = NBTUtil.func_210822_a((DataFixer)this.field_186341_a, (DSL.TypeReference)DataFixTypes.PLAYER, (NBTTagCompound)nbt, (int)(nbt.func_150297_b("DataVersion", 3) ? nbt.func_74762_e("DataVersion") : -1));
                }
                return nbt;
            }
        }
        catch (Exception exception) {
            field_151478_a.warn("Failed to load player data for " + player.func_200200_C_());
        }
        return null;
    }
}

