/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Random;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.EntityHasScore;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;

public class LootConditionManager {
    private static final Map<ResourceLocation, LootCondition.Serializer<?>> field_186642_a = Maps.newHashMap();
    private static final Map<Class<? extends LootCondition>, LootCondition.Serializer<?>> field_186643_b = Maps.newHashMap();

    public static <T extends LootCondition> void func_186639_a(LootCondition.Serializer<? extends T> condition) {
        ResourceLocation resourcelocation = condition.func_186602_a();
        Class oclass = condition.func_186604_b();
        if (field_186642_a.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("Can't re-register item condition name " + resourcelocation);
        }
        if (field_186643_b.containsKey(oclass)) {
            throw new IllegalArgumentException("Can't re-register item condition class " + oclass.getName());
        }
        field_186642_a.put(resourcelocation, condition);
        field_186643_b.put(oclass, condition);
    }

    public static boolean testAllConditions(@Nullable Iterable<LootCondition> conditions, Random rand, LootContext context) {
        return conditions == null || StreamSupport.stream(conditions.spliterator(), false).allMatch(c -> c.func_186618_a(rand, context));
    }

    public static boolean func_186638_a(@Nullable LootCondition[] conditions, Random rand, LootContext context) {
        if (conditions == null) {
            return true;
        }
        for (LootCondition lootcondition : conditions) {
            if (lootcondition.func_186618_a(rand, context)) continue;
            return false;
        }
        return true;
    }

    public static LootCondition.Serializer<?> func_186641_a(ResourceLocation location) {
        LootCondition.Serializer<?> serializer = field_186642_a.get(location);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition '" + location + "'");
        }
        return serializer;
    }

    public static <T extends LootCondition> LootCondition.Serializer<T> func_186640_a(T conditionClass) {
        LootCondition.Serializer<?> serializer = field_186643_b.get(conditionClass.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition " + conditionClass);
        }
        return serializer;
    }

    static {
        LootConditionManager.func_186639_a(new RandomChance.Serializer());
        LootConditionManager.func_186639_a(new RandomChanceWithLooting.Serializer());
        LootConditionManager.func_186639_a(new EntityHasProperty.Serializer());
        LootConditionManager.func_186639_a(new KilledByPlayer.Serializer());
        LootConditionManager.func_186639_a(new EntityHasScore.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootCondition>,
    JsonSerializer<LootCondition> {
        public LootCondition deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            LootCondition.Serializer<?> serializer;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"condition");
            ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"condition"));
            try {
                serializer = LootConditionManager.func_186641_a(resourcelocation);
            }
            catch (IllegalArgumentException var8) {
                throw new JsonSyntaxException("Unknown condition '" + resourcelocation + "'");
            }
            return serializer.func_186603_b(jsonobject, p_deserialize_3_);
        }

        public JsonElement serialize(LootCondition p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            LootCondition.Serializer<LootCondition> serializer = LootConditionManager.func_186640_a(p_serialize_1_);
            JsonObject jsonobject = new JsonObject();
            serializer.func_186605_a(jsonobject, p_serialize_1_, p_serialize_3_);
            jsonobject.addProperty("condition", serializer.func_186602_a().toString());
            return jsonobject;
        }
    }
}

