/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class RandomChanceWithLooting
implements LootCondition {
    private final float field_186627_a;
    private final float field_186628_b;

    public RandomChanceWithLooting(float chanceIn, float lootingMultiplierIn) {
        this.field_186627_a = chanceIn;
        this.field_186628_b = lootingMultiplierIn;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        int i = context.getLootingModifier();
        return rand.nextFloat() < this.field_186627_a + (float)i * this.field_186628_b;
    }

    public static class Serializer
    extends LootCondition.Serializer<RandomChanceWithLooting> {
        protected Serializer() {
            super(new ResourceLocation("random_chance_with_looting"), RandomChanceWithLooting.class);
        }

        public void func_186605_a(JsonObject json, RandomChanceWithLooting value, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(value.field_186627_a));
            json.addProperty("looting_multiplier", (Number)Float.valueOf(value.field_186628_b));
        }

        public RandomChanceWithLooting func_186603_b(JsonObject json, JsonDeserializationContext context) {
            return new RandomChanceWithLooting(JsonUtils.func_151217_k((JsonObject)json, (String)"chance"), JsonUtils.func_151217_k((JsonObject)json, (String)"looting_multiplier"));
        }
    }
}

