/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketAdvancementInfo;
import net.minecraft.network.play.server.SPacketSelectAdvancementsTab;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerAdvancements {
    private static final Logger field_192753_a = LogManager.getLogger();
    private static final Gson field_192754_b = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.Serializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
    private static final TypeToken<Map<ResourceLocation, AdvancementProgress>> field_192755_c = new TypeToken<Map<ResourceLocation, AdvancementProgress>>(){};
    private final MinecraftServer field_192756_d;
    private final File field_192757_e;
    private final Map<Advancement, AdvancementProgress> field_192758_f = Maps.newLinkedHashMap();
    private final Set<Advancement> field_192759_g = Sets.newLinkedHashSet();
    private final Set<Advancement> field_192760_h = Sets.newLinkedHashSet();
    private final Set<Advancement> field_192761_i = Sets.newLinkedHashSet();
    private EntityPlayerMP field_192762_j;
    @Nullable
    private Advancement field_194221_k;
    private boolean field_192763_k = true;

    public PlayerAdvancements(MinecraftServer minecraftServer, File file, EntityPlayerMP entityPlayerMP) {
        this.field_192756_d = minecraftServer;
        this.field_192757_e = file;
        this.field_192762_j = entityPlayerMP;
        this.func_192740_f();
    }

    public void func_192739_a(EntityPlayerMP entityPlayerMP) {
        this.field_192762_j = entityPlayerMP;
    }

    public void func_192745_a() {
        for (ICriterionTrigger<?> iCriterionTrigger : CriteriaTriggers.func_192120_a()) {
            iCriterionTrigger.func_192167_a(this);
        }
    }

    public void func_193766_b() {
        this.func_192745_a();
        this.field_192758_f.clear();
        this.field_192759_g.clear();
        this.field_192760_h.clear();
        this.field_192761_i.clear();
        this.field_192763_k = true;
        this.field_194221_k = null;
        this.func_192740_f();
    }

    private void func_192751_c() {
        for (Advancement advancement : this.field_192756_d.func_191949_aK().func_195438_b()) {
            this.func_193764_b(advancement);
        }
    }

    private void func_192752_d() {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<Advancement, AdvancementProgress> \u26032 : this.field_192758_f.entrySet()) {
            if (!\u26032.getValue().func_192105_a()) continue;
            arrayList.add(\u26032.getKey());
            this.field_192761_i.add((Advancement)\u26032.getKey());
        }
        for (Map.Entry<Advancement, AdvancementProgress> \u26032 : arrayList) {
            this.func_192742_b((Advancement)((Object)\u26032));
        }
    }

    private void func_192748_e() {
        for (Advancement advancement : this.field_192756_d.func_191949_aK().func_195438_b()) {
            if (!advancement.func_192073_f().isEmpty()) continue;
            this.func_192750_a(advancement, "");
            advancement.func_192072_d().func_192113_a(this.field_192762_j);
        }
    }

    private void func_192740_f() {
        if (this.field_192757_e.isFile()) {
            try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(Files.toString((File)this.field_192757_e, (Charset)StandardCharsets.UTF_8)));){
                jsonReader.setLenient(false);
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)jsonReader));
                if (!dynamic.get("DataVersion").flatMap(Dynamic::getNumberValue).isPresent()) {
                    dynamic = dynamic.set("DataVersion", dynamic.createInt(1343));
                }
                dynamic = this.field_192756_d.func_195563_aC().update((DSL.TypeReference)DataFixTypes.ADVANCEMENTS, dynamic, dynamic.getInt("DataVersion"), 1631);
                dynamic = dynamic.remove("DataVersion");
                Map \u26032 = (Map)field_192754_b.getAdapter(field_192755_c).fromJsonTree((JsonElement)dynamic.getValue());
                if (\u26032 == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                Stream<Map.Entry> \u26033 = \u26032.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue));
                for (Map.Entry entry : \u26033.collect(Collectors.toList())) {
                    Advancement advancement = this.field_192756_d.func_191949_aK().func_192778_a((ResourceLocation)entry.getKey());
                    if (advancement == null) {
                        field_192753_a.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", entry.getKey(), (Object)this.field_192757_e);
                        continue;
                    }
                    this.func_192743_a(advancement, (AdvancementProgress)entry.getValue());
                }
            }
            catch (JsonParseException jsonParseException) {
                field_192753_a.error("Couldn't parse player advancements in {}", (Object)this.field_192757_e, (Object)jsonParseException);
            }
            catch (IOException iOException) {
                field_192753_a.error("Couldn't access player advancements in {}", (Object)this.field_192757_e, (Object)iOException);
            }
        }
        this.func_192748_e();
        this.func_192752_d();
        this.func_192751_c();
    }

    public void func_192749_b() {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<Advancement, AdvancementProgress> entry : this.field_192758_f.entrySet()) {
            AdvancementProgress advancementProgress = entry.getValue();
            if (!advancementProgress.func_192108_b()) continue;
            hashMap.put(entry.getKey().func_192067_g(), advancementProgress);
        }
        if (this.field_192757_e.getParentFile() != null) {
            this.field_192757_e.getParentFile().mkdirs();
        }
        try {
            Files.write((CharSequence)field_192754_b.toJson((Object)hashMap), (File)this.field_192757_e, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            field_192753_a.error("Couldn't save player advancements to {}", (Object)this.field_192757_e, (Object)iOException);
        }
    }

    public boolean func_192750_a(Advancement advancement, String string) {
        boolean bl = false;
        AdvancementProgress \u26032 = this.func_192747_a(advancement);
        \u2603 = \u26032.func_192105_a();
        if (\u26032.func_192109_a(string)) {
            this.func_193765_c(advancement);
            this.field_192761_i.add(advancement);
            bl = true;
            if (!\u2603 && \u26032.func_192105_a()) {
                advancement.func_192072_d().func_192113_a(this.field_192762_j);
                if (advancement.func_192068_c() != null && advancement.func_192068_c().func_193220_i() && this.field_192762_j.field_70170_p.func_82736_K().func_82766_b("announceAdvancements")) {
                    this.field_192756_d.func_184103_al().func_148539_a(new TextComponentTranslation("chat.type.advancement." + advancement.func_192068_c().func_192291_d().func_192307_a(), this.field_192762_j.func_145748_c_(), advancement.func_193123_j()));
                }
            }
        }
        if (\u26032.func_192105_a()) {
            this.func_192742_b(advancement);
        }
        return bl;
    }

    public boolean func_192744_b(Advancement advancement, String string) {
        boolean bl = false;
        AdvancementProgress \u26032 = this.func_192747_a(advancement);
        if (\u26032.func_192101_b(string)) {
            this.func_193764_b(advancement);
            this.field_192761_i.add(advancement);
            bl = true;
        }
        if (!\u26032.func_192108_b()) {
            this.func_192742_b(advancement);
        }
        return bl;
    }

    private void func_193764_b(Advancement advancement) {
        AdvancementProgress advancementProgress = this.func_192747_a(advancement);
        if (advancementProgress.func_192105_a()) {
            return;
        }
        for (Map.Entry<String, Criterion> entry : advancement.func_192073_f().entrySet()) {
            CriterionProgress criterionProgress = advancementProgress.func_192106_c(entry.getKey());
            if (criterionProgress == null || criterionProgress.func_192151_a() || (\u2603 = entry.getValue().func_192143_a()) == null || (\u2603 = CriteriaTriggers.func_192119_a(\u2603.func_192244_a())) == null) continue;
            \u2603.func_192165_a(this, new ICriterionTrigger.Listener<ICriterionInstance>(\u2603, advancement, entry.getKey()));
        }
    }

    private void func_193765_c(Advancement advancement) {
        AdvancementProgress advancementProgress = this.func_192747_a(advancement);
        for (Map.Entry<String, Criterion> entry : advancement.func_192073_f().entrySet()) {
            CriterionProgress criterionProgress = advancementProgress.func_192106_c(entry.getKey());
            if (criterionProgress == null || !criterionProgress.func_192151_a() && !advancementProgress.func_192105_a() || (\u2603 = entry.getValue().func_192143_a()) == null || (\u2603 = CriteriaTriggers.func_192119_a(\u2603.func_192244_a())) == null) continue;
            \u2603.func_192164_b(this, new ICriterionTrigger.Listener<ICriterionInstance>(\u2603, advancement, entry.getKey()));
        }
    }

    public void func_192741_b(EntityPlayerMP entityPlayerMP) {
        if (this.field_192763_k || !this.field_192760_h.isEmpty() || !this.field_192761_i.isEmpty()) {
            HashMap hashMap = Maps.newHashMap();
            LinkedHashSet \u26032 = Sets.newLinkedHashSet();
            LinkedHashSet \u26033 = Sets.newLinkedHashSet();
            for (Advancement advancement : this.field_192761_i) {
                if (!this.field_192759_g.contains(advancement)) continue;
                hashMap.put(advancement.func_192067_g(), this.field_192758_f.get(advancement));
            }
            for (Advancement advancement : this.field_192760_h) {
                if (this.field_192759_g.contains(advancement)) {
                    \u26032.add(advancement);
                    continue;
                }
                \u26033.add(advancement.func_192067_g());
            }
            if (this.field_192763_k || !hashMap.isEmpty() || !\u26032.isEmpty() || !\u26033.isEmpty()) {
                entityPlayerMP.field_71135_a.func_147359_a(new SPacketAdvancementInfo(this.field_192763_k, \u26032, \u26033, hashMap));
                this.field_192760_h.clear();
                this.field_192761_i.clear();
            }
        }
        this.field_192763_k = false;
    }

    public void func_194220_a(@Nullable Advancement advancement) {
        \u2603 = this.field_194221_k;
        this.field_194221_k = advancement != null && advancement.func_192070_b() == null && advancement.func_192068_c() != null ? advancement : null;
        if (\u2603 != this.field_194221_k) {
            this.field_192762_j.field_71135_a.func_147359_a(new SPacketSelectAdvancementsTab(this.field_194221_k == null ? null : this.field_194221_k.func_192067_g()));
        }
    }

    public AdvancementProgress func_192747_a(Advancement advancement) {
        AdvancementProgress advancementProgress = this.field_192758_f.get(advancement);
        if (advancementProgress == null) {
            advancementProgress = new AdvancementProgress();
            this.func_192743_a(advancement, advancementProgress);
        }
        return advancementProgress;
    }

    private void func_192743_a(Advancement advancement, AdvancementProgress advancementProgress) {
        advancementProgress.func_192099_a(advancement.func_192073_f(), advancement.func_192074_h());
        this.field_192758_f.put(advancement, advancementProgress);
    }

    private void func_192742_b(Advancement advancement) {
        boolean bl = this.func_192738_c(advancement);
        \u2603 = this.field_192759_g.contains(advancement);
        if (bl && !\u2603) {
            this.field_192759_g.add(advancement);
            this.field_192760_h.add(advancement);
            if (this.field_192758_f.containsKey(advancement)) {
                this.field_192761_i.add(advancement);
            }
        } else if (!bl && \u2603) {
            this.field_192759_g.remove(advancement);
            this.field_192760_h.add(advancement);
        }
        if (bl != \u2603 && advancement.func_192070_b() != null) {
            this.func_192742_b(advancement.func_192070_b());
        }
        for (Advancement advancement2 : advancement.func_192069_e()) {
            this.func_192742_b(advancement2);
        }
    }

    private boolean func_192738_c(Advancement advancement) {
        for (int n = 0; advancement != null && n <= 2; advancement = advancement.func_192070_b(), ++n) {
            if (n == 0 && this.func_192746_d(advancement)) {
                return true;
            }
            if (advancement.func_192068_c() == null) {
                return false;
            }
            AdvancementProgress advancementProgress = this.func_192747_a(advancement);
            if (advancementProgress.func_192105_a()) {
                return true;
            }
            if (!advancement.func_192068_c().func_193224_j()) continue;
            return false;
        }
        return false;
    }

    private boolean func_192746_d(Advancement advancement) {
        AdvancementProgress advancementProgress = this.func_192747_a(advancement);
        if (advancementProgress.func_192105_a()) {
            return true;
        }
        for (Advancement advancement2 : advancement.func_192069_e()) {
            if (!this.func_192746_d(advancement2)) continue;
            return true;
        }
        return false;
    }
}

