/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDaylightDetector
extends BlockContainer {
    public static final IntegerProperty field_176436_a = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty field_196320_b = BlockStateProperties.field_208188_o;
    protected static final VoxelShape field_196321_c = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);

    public BlockDaylightDetector(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176436_a, 0)).func_206870_a(field_196320_b, false));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196321_c;
    }

    @Override
    public int func_180656_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        return iBlockState.func_177229_b(field_176436_a);
    }

    public static void func_196319_d(IBlockState iBlockState, World world, BlockPos blockPos) {
        if (!world.field_73011_w.func_191066_m()) {
            return;
        }
        int \u26034 = world.func_175642_b(EnumLightType.SKY, blockPos) - world.func_175657_ab();
        float \u26032 = world.func_72929_e(1.0f);
        boolean \u26033 = iBlockState.func_177229_b(field_196320_b);
        if (\u26033) {
            \u26034 = 15 - \u26034;
        } else if (\u26034 > 0) {
            float f = \u26032 < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            \u26032 += (f - \u26032) * 0.2f;
            \u26034 = Math.round((float)\u26034 * MathHelper.func_76134_b(\u26032));
        }
        \u26034 = MathHelper.func_76125_a(\u26034, 0, 15);
        if (iBlockState.func_177229_b(field_176436_a) != \u26034) {
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176436_a, \u26034), 3);
        }
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState2, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        IBlockState iBlockState2;
        if (entityPlayer.func_175142_cm()) {
            if (world.field_72995_K) {
                return true;
            }
            IBlockState iBlockState3 = (IBlockState)iBlockState2.func_177231_a(field_196320_b);
            world.func_180501_a(blockPos, iBlockState3, 4);
            BlockDaylightDetector.func_196319_d(iBlockState3, world, blockPos);
            return true;
        }
        return super.func_196250_a(iBlockState2, world, blockPos, entityPlayer, enumHand, enumFacing, f, f2, f3);
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean func_149744_f(IBlockState iBlockState) {
        return true;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new TileEntityDaylightDetector();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176436_a, field_196320_b);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        if (enumFacing == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

