/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.EndDimension;

public class BlockFire
extends Block {
    public static final IntegerProperty field_176543_a = BlockStateProperties.field_208171_X;
    public static final BooleanProperty field_176545_N = BlockSixWay.field_196488_a;
    public static final BooleanProperty field_176546_O = BlockSixWay.field_196490_b;
    public static final BooleanProperty field_176541_P = BlockSixWay.field_196492_c;
    public static final BooleanProperty field_176539_Q = BlockSixWay.field_196495_y;
    public static final BooleanProperty field_176542_R = BlockSixWay.field_196496_z;
    private static final Map<EnumFacing, BooleanProperty> field_196449_B = BlockSixWay.field_196491_B.entrySet().stream().filter(entry -> entry.getKey() != EnumFacing.DOWN).collect(Util.func_199749_a());
    private final Object2IntMap<Block> field_149849_a = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> field_149848_b = new Object2IntOpenHashMap();

    protected BlockFire(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176543_a, 0)).func_206870_a(field_176545_N, false)).func_206870_a(field_176546_O, false)).func_206870_a(field_176541_P, false)).func_206870_a(field_176539_Q, false)).func_206870_a(field_176542_R, false));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (this.func_196260_a(iBlockState, iWorld, blockPos)) {
            return (IBlockState)this.func_196448_a(iWorld, blockPos).func_206870_a(field_176543_a, iBlockState.func_177229_b(field_176543_a));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return this.func_196448_a(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a());
    }

    public IBlockState func_196448_a(IBlockReader iBlockReader, BlockPos blockPos) {
        IBlockState \u26032;
        IBlockState iBlockState = iBlockReader.func_180495_p(blockPos.func_177977_b());
        if (iBlockState.func_185896_q() || this.func_196446_i(iBlockState)) {
            return this.func_176223_P();
        }
        \u26032 = this.func_176223_P();
        for (EnumFacing enumFacing : EnumFacing.values()) {
            BooleanProperty booleanProperty = field_196449_B.get(enumFacing);
            if (booleanProperty == null) continue;
            \u26032 = (IBlockState)\u26032.func_206870_a(booleanProperty, this.func_196446_i(iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing))));
        }
        return \u26032;
    }

    @Override
    public boolean func_196260_a(IBlockState iBlockState, IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        return iWorldReaderBase.func_180495_p(blockPos.func_177977_b()).func_185896_q() || this.func_196447_a(iWorldReaderBase, blockPos);
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public int func_196264_a(IBlockState iBlockState, Random random) {
        return 0;
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return 30;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState2, World world2, BlockPos blockPos, Random random) {
        boolean bl;
        if (!world2.func_82736_K().func_82766_b("doFireTick")) {
            return;
        }
        if (!iBlockState2.func_196955_c(world2, blockPos)) {
            world2.func_175698_g(blockPos);
        }
        Block block = world2.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        boolean \u26032 = world2.field_73011_w instanceof EndDimension && block == Blocks.field_150357_h || block == Blocks.field_150424_aL || block == Blocks.field_196814_hQ;
        int \u26033 = iBlockState2.func_177229_b(field_176543_a);
        if (!\u26032 && world2.func_72896_J() && this.func_176537_d(world2, blockPos) && random.nextFloat() < 0.2f + (float)\u26033 * 0.03f) {
            world2.func_175698_g(blockPos);
            return;
        }
        int \u26034 = Math.min(15, \u26033 + random.nextInt(3) / 2);
        if (\u26033 != \u26034) {
            IBlockState iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176543_a, \u26034);
            world2.func_180501_a(blockPos, iBlockState2, 4);
        }
        if (!\u26032) {
            World world2;
            world2.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world2) + random.nextInt(10));
            if (!this.func_196447_a(world2, blockPos)) {
                if (!world2.func_180495_p(blockPos.func_177977_b()).func_185896_q() || \u26033 > 3) {
                    world2.func_175698_g(blockPos);
                }
                return;
            }
            if (\u26033 == 15 && random.nextInt(4) == 0 && !this.func_196446_i(world2.func_180495_p(blockPos.func_177977_b()))) {
                world2.func_175698_g(blockPos);
                return;
            }
        }
        int \u26035 = (bl = world2.func_180502_D(blockPos)) ? -50 : 0;
        this.func_176536_a(world2, blockPos.func_177974_f(), 300 + \u26035, random, \u26033);
        this.func_176536_a(world2, blockPos.func_177976_e(), 300 + \u26035, random, \u26033);
        this.func_176536_a(world2, blockPos.func_177977_b(), 250 + \u26035, random, \u26033);
        this.func_176536_a(world2, blockPos.func_177984_a(), 250 + \u26035, random, \u26033);
        this.func_176536_a(world2, blockPos.func_177978_c(), 300 + \u26035, random, \u26033);
        this.func_176536_a(world2, blockPos.func_177968_d(), 300 + \u26035, random, \u26033);
        BlockPos.MutableBlockPos \u26036 = new BlockPos.MutableBlockPos();
        for (int i = -1; i <= 1; ++i) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                for (\u2603 = -1; \u2603 <= 4; ++\u2603) {
                    if (i == 0 && \u2603 == 0 && \u2603 == 0) continue;
                    \u2603 = 100;
                    if (\u2603 > 1) {
                        \u2603 += (\u2603 - 1) * 100;
                    }
                    \u26036.func_189533_g(blockPos).func_196234_d(i, \u2603, \u2603);
                    \u2603 = this.func_176538_m(world2, \u26036);
                    if (\u2603 <= 0) continue;
                    \u2603 = (\u2603 + 40 + world2.func_175659_aa().func_151525_a() * 7) / (\u26033 + 30);
                    if (bl) {
                        \u2603 /= 2;
                    }
                    if (\u2603 <= 0 || random.nextInt(\u2603) > \u2603 || world2.func_72896_J() && this.func_176537_d(world2, \u26036)) continue;
                    \u2603 = Math.min(15, \u26033 + random.nextInt(5) / 4);
                    world2.func_180501_a(\u26036, (IBlockState)this.func_196448_a(world2, \u26036).func_206870_a(field_176543_a, \u2603), 3);
                }
            }
        }
    }

    protected boolean func_176537_d(World world, BlockPos blockPos) {
        return world.func_175727_C(blockPos) || world.func_175727_C(blockPos.func_177976_e()) || world.func_175727_C(blockPos.func_177974_f()) || world.func_175727_C(blockPos.func_177978_c()) || world.func_175727_C(blockPos.func_177968_d());
    }

    private int func_176532_c(Block block) {
        return this.field_149848_b.getInt((Object)block);
    }

    private int func_176534_d(Block block) {
        return this.field_149849_a.getInt((Object)block);
    }

    private void func_176536_a(World world2, BlockPos blockPos, int n, Random random, int n2) {
        \u2603 = this.func_176532_c(world2.func_180495_p(blockPos).func_177230_c());
        if (random.nextInt(n) < \u2603) {
            IBlockState iBlockState = world2.func_180495_p(blockPos);
            if (random.nextInt(n2 + 10) < 5 && !world2.func_175727_C(blockPos)) {
                int n3 = Math.min(n2 + random.nextInt(5) / 4, 15);
                world2.func_180501_a(blockPos, (IBlockState)this.func_196448_a(world2, blockPos).func_206870_a(field_176543_a, n3), 3);
            } else {
                World world2;
                world2.func_175698_g(blockPos);
            }
            Block \u26032 = iBlockState.func_177230_c();
            if (\u26032 instanceof BlockTNT) {
                ((BlockTNT)\u26032).func_196534_a(world2, blockPos);
            }
        }
    }

    private boolean func_196447_a(IBlockReader iBlockReader, BlockPos blockPos) {
        for (EnumFacing enumFacing : EnumFacing.values()) {
            if (!this.func_196446_i(iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing)))) continue;
            return true;
        }
        return false;
    }

    private int func_176538_m(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        if (!iWorldReaderBase.func_175623_d(blockPos)) {
            return 0;
        }
        int n = 0;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            n = Math.max(this.func_176534_d(iWorldReaderBase.func_180495_p(blockPos.func_177972_a(enumFacing)).func_177230_c()), n);
        }
        return n;
    }

    @Override
    public boolean func_149703_v() {
        return false;
    }

    public boolean func_196446_i(IBlockState iBlockState) {
        return this.func_176534_d(iBlockState.func_177230_c()) > 0;
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (iBlockState2.func_177230_c() == iBlockState.func_177230_c()) {
            return;
        }
        if ((world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD || world.field_73011_w.func_186058_p() == DimensionType.NETHER) && ((BlockPortal)Blocks.field_150427_aO).func_176548_d(world, blockPos)) {
            return;
        }
        if (!iBlockState.func_196955_c(world, blockPos)) {
            world.func_175698_g(blockPos);
            return;
        }
        world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176543_a, field_176545_N, field_176546_O, field_176541_P, field_176539_Q, field_176542_R);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180686_a(Block block, int n, int n2) {
        this.field_149849_a.put((Object)block, n);
        this.field_149848_b.put((Object)block, n2);
    }

    public static void func_149843_e() {
        BlockFire blockFire = (BlockFire)Blocks.field_150480_ab;
        blockFire.func_180686_a(Blocks.field_196662_n, 5, 20);
        blockFire.func_180686_a(Blocks.field_196664_o, 5, 20);
        blockFire.func_180686_a(Blocks.field_196666_p, 5, 20);
        blockFire.func_180686_a(Blocks.field_196668_q, 5, 20);
        blockFire.func_180686_a(Blocks.field_196670_r, 5, 20);
        blockFire.func_180686_a(Blocks.field_196672_s, 5, 20);
        blockFire.func_180686_a(Blocks.field_196622_bq, 5, 20);
        blockFire.func_180686_a(Blocks.field_196624_br, 5, 20);
        blockFire.func_180686_a(Blocks.field_196627_bs, 5, 20);
        blockFire.func_180686_a(Blocks.field_196630_bt, 5, 20);
        blockFire.func_180686_a(Blocks.field_196632_bu, 5, 20);
        blockFire.func_180686_a(Blocks.field_196635_bv, 5, 20);
        blockFire.func_180686_a(Blocks.field_180390_bo, 5, 20);
        blockFire.func_180686_a(Blocks.field_180391_bp, 5, 20);
        blockFire.func_180686_a(Blocks.field_180392_bq, 5, 20);
        blockFire.func_180686_a(Blocks.field_180386_br, 5, 20);
        blockFire.func_180686_a(Blocks.field_180385_bs, 5, 20);
        blockFire.func_180686_a(Blocks.field_180387_bt, 5, 20);
        blockFire.func_180686_a(Blocks.field_180407_aO, 5, 20);
        blockFire.func_180686_a(Blocks.field_180408_aP, 5, 20);
        blockFire.func_180686_a(Blocks.field_180404_aQ, 5, 20);
        blockFire.func_180686_a(Blocks.field_180403_aR, 5, 20);
        blockFire.func_180686_a(Blocks.field_180406_aS, 5, 20);
        blockFire.func_180686_a(Blocks.field_180405_aT, 5, 20);
        blockFire.func_180686_a(Blocks.field_150476_ad, 5, 20);
        blockFire.func_180686_a(Blocks.field_150487_bG, 5, 20);
        blockFire.func_180686_a(Blocks.field_150485_bF, 5, 20);
        blockFire.func_180686_a(Blocks.field_150481_bH, 5, 20);
        blockFire.func_180686_a(Blocks.field_150400_ck, 5, 20);
        blockFire.func_180686_a(Blocks.field_150401_cl, 5, 20);
        blockFire.func_180686_a(Blocks.field_196617_K, 5, 5);
        blockFire.func_180686_a(Blocks.field_196618_L, 5, 5);
        blockFire.func_180686_a(Blocks.field_196619_M, 5, 5);
        blockFire.func_180686_a(Blocks.field_196620_N, 5, 5);
        blockFire.func_180686_a(Blocks.field_196621_O, 5, 5);
        blockFire.func_180686_a(Blocks.field_196623_P, 5, 5);
        blockFire.func_180686_a(Blocks.field_203204_R, 5, 5);
        blockFire.func_180686_a(Blocks.field_203205_S, 5, 5);
        blockFire.func_180686_a(Blocks.field_203206_T, 5, 5);
        blockFire.func_180686_a(Blocks.field_203207_U, 5, 5);
        blockFire.func_180686_a(Blocks.field_203208_V, 5, 5);
        blockFire.func_180686_a(Blocks.field_203209_W, 5, 5);
        blockFire.func_180686_a(Blocks.field_209389_ab, 5, 5);
        blockFire.func_180686_a(Blocks.field_209390_ac, 5, 5);
        blockFire.func_180686_a(Blocks.field_209391_ad, 5, 5);
        blockFire.func_180686_a(Blocks.field_209392_ae, 5, 5);
        blockFire.func_180686_a(Blocks.field_209393_af, 5, 5);
        blockFire.func_180686_a(Blocks.field_209394_ag, 5, 5);
        blockFire.func_180686_a(Blocks.field_196626_Q, 5, 5);
        blockFire.func_180686_a(Blocks.field_196629_R, 5, 5);
        blockFire.func_180686_a(Blocks.field_196631_S, 5, 5);
        blockFire.func_180686_a(Blocks.field_196634_T, 5, 5);
        blockFire.func_180686_a(Blocks.field_196637_U, 5, 5);
        blockFire.func_180686_a(Blocks.field_196639_V, 5, 5);
        blockFire.func_180686_a(Blocks.field_196642_W, 30, 60);
        blockFire.func_180686_a(Blocks.field_196645_X, 30, 60);
        blockFire.func_180686_a(Blocks.field_196647_Y, 30, 60);
        blockFire.func_180686_a(Blocks.field_196648_Z, 30, 60);
        blockFire.func_180686_a(Blocks.field_196572_aa, 30, 60);
        blockFire.func_180686_a(Blocks.field_196574_ab, 30, 60);
        blockFire.func_180686_a(Blocks.field_150342_X, 30, 20);
        blockFire.func_180686_a(Blocks.field_150335_W, 15, 100);
        blockFire.func_180686_a(Blocks.field_150349_c, 60, 100);
        blockFire.func_180686_a(Blocks.field_196554_aH, 60, 100);
        blockFire.func_180686_a(Blocks.field_196555_aI, 60, 100);
        blockFire.func_180686_a(Blocks.field_196800_gd, 60, 100);
        blockFire.func_180686_a(Blocks.field_196801_ge, 60, 100);
        blockFire.func_180686_a(Blocks.field_196802_gf, 60, 100);
        blockFire.func_180686_a(Blocks.field_196803_gg, 60, 100);
        blockFire.func_180686_a(Blocks.field_196804_gh, 60, 100);
        blockFire.func_180686_a(Blocks.field_196805_gi, 60, 100);
        blockFire.func_180686_a(Blocks.field_196605_bc, 60, 100);
        blockFire.func_180686_a(Blocks.field_196606_bd, 60, 100);
        blockFire.func_180686_a(Blocks.field_196607_be, 60, 100);
        blockFire.func_180686_a(Blocks.field_196609_bf, 60, 100);
        blockFire.func_180686_a(Blocks.field_196610_bg, 60, 100);
        blockFire.func_180686_a(Blocks.field_196612_bh, 60, 100);
        blockFire.func_180686_a(Blocks.field_196613_bi, 60, 100);
        blockFire.func_180686_a(Blocks.field_196614_bj, 60, 100);
        blockFire.func_180686_a(Blocks.field_196615_bk, 60, 100);
        blockFire.func_180686_a(Blocks.field_196616_bl, 60, 100);
        blockFire.func_180686_a(Blocks.field_196556_aL, 30, 60);
        blockFire.func_180686_a(Blocks.field_196557_aM, 30, 60);
        blockFire.func_180686_a(Blocks.field_196558_aN, 30, 60);
        blockFire.func_180686_a(Blocks.field_196559_aO, 30, 60);
        blockFire.func_180686_a(Blocks.field_196560_aP, 30, 60);
        blockFire.func_180686_a(Blocks.field_196561_aQ, 30, 60);
        blockFire.func_180686_a(Blocks.field_196562_aR, 30, 60);
        blockFire.func_180686_a(Blocks.field_196563_aS, 30, 60);
        blockFire.func_180686_a(Blocks.field_196564_aT, 30, 60);
        blockFire.func_180686_a(Blocks.field_196565_aU, 30, 60);
        blockFire.func_180686_a(Blocks.field_196566_aV, 30, 60);
        blockFire.func_180686_a(Blocks.field_196567_aW, 30, 60);
        blockFire.func_180686_a(Blocks.field_196568_aX, 30, 60);
        blockFire.func_180686_a(Blocks.field_196569_aY, 30, 60);
        blockFire.func_180686_a(Blocks.field_196570_aZ, 30, 60);
        blockFire.func_180686_a(Blocks.field_196602_ba, 30, 60);
        blockFire.func_180686_a(Blocks.field_150395_bd, 15, 100);
        blockFire.func_180686_a(Blocks.field_150402_ci, 5, 5);
        blockFire.func_180686_a(Blocks.field_150407_cf, 60, 20);
        blockFire.func_180686_a(Blocks.field_196724_fH, 60, 20);
        blockFire.func_180686_a(Blocks.field_196725_fI, 60, 20);
        blockFire.func_180686_a(Blocks.field_196727_fJ, 60, 20);
        blockFire.func_180686_a(Blocks.field_196729_fK, 60, 20);
        blockFire.func_180686_a(Blocks.field_196731_fL, 60, 20);
        blockFire.func_180686_a(Blocks.field_196733_fM, 60, 20);
        blockFire.func_180686_a(Blocks.field_196735_fN, 60, 20);
        blockFire.func_180686_a(Blocks.field_196737_fO, 60, 20);
        blockFire.func_180686_a(Blocks.field_196739_fP, 60, 20);
        blockFire.func_180686_a(Blocks.field_196741_fQ, 60, 20);
        blockFire.func_180686_a(Blocks.field_196743_fR, 60, 20);
        blockFire.func_180686_a(Blocks.field_196745_fS, 60, 20);
        blockFire.func_180686_a(Blocks.field_196747_fT, 60, 20);
        blockFire.func_180686_a(Blocks.field_196749_fU, 60, 20);
        blockFire.func_180686_a(Blocks.field_196751_fV, 60, 20);
        blockFire.func_180686_a(Blocks.field_196753_fW, 60, 20);
        blockFire.func_180686_a(Blocks.field_203216_jz, 30, 60);
    }
}

