/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.state.pattern;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.pattern.IBlockMatcherReaderAware;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class ReaderAwareMatchers {
    public static <T> IBlockMatcherReaderAware<T> func_202084_a(IBlockMatcherReaderAware<T> iBlockMatcherReaderAware) {
        return new NotMatcher<T>(iBlockMatcherReaderAware);
    }

    public static <T> IBlockMatcherReaderAware<T> func_202083_b(IBlockMatcherReaderAware<? super T> ... iBlockMatcherReaderAwareArray) {
        return new OrMatcher(ReaderAwareMatchers.func_202086_a(iBlockMatcherReaderAwareArray));
    }

    private static <T> List<T> func_202086_a(T ... TArray) {
        return ReaderAwareMatchers.func_202085_c(Arrays.asList(TArray));
    }

    private static <T> List<T> func_202085_c(Iterable<T> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        for (T t : iterable) {
            arrayList.add(Preconditions.checkNotNull(t));
        }
        return arrayList;
    }

    static class OrMatcher<T>
    implements IBlockMatcherReaderAware<T> {
        private final List<? extends IBlockMatcherReaderAware<? super T>> field_202076_a;

        private OrMatcher(List<? extends IBlockMatcherReaderAware<? super T>> list) {
            this.field_202076_a = list;
        }

        @Override
        public boolean test(@Nullable T t, IBlockReader iBlockReader, BlockPos blockPos) {
            for (int i = 0; i < this.field_202076_a.size(); ++i) {
                if (!this.field_202076_a.get(i).test(t, iBlockReader, blockPos)) continue;
                return true;
            }
            return false;
        }
    }

    static class NotMatcher<T>
    implements IBlockMatcherReaderAware<T> {
        private final IBlockMatcherReaderAware<T> field_202075_a;

        NotMatcher(IBlockMatcherReaderAware<T> iBlockMatcherReaderAware) {
            this.field_202075_a = (IBlockMatcherReaderAware)Preconditions.checkNotNull(iBlockMatcherReaderAware);
        }

        @Override
        public boolean test(@Nullable T t, IBlockReader iBlockReader, BlockPos blockPos) {
            return !this.field_202075_a.test(t, iBlockReader, blockPos);
        }
    }
}

