/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.scoreboard.Score;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;

public class OperationArgument
implements ArgumentType<IOperation> {
    private static final Collection<String> field_201319_a = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType field_197185_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("arguments.operation.invalid", new Object[0]));
    private static final SimpleCommandExceptionType field_197186_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("arguments.operation.div0", new Object[0]));

    public static OperationArgument func_197184_a() {
        return new OperationArgument();
    }

    public static IOperation func_197179_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return (IOperation)commandContext.getArgument(string, IOperation.class);
    }

    public IOperation parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead()) {
            int n = stringReader.getCursor();
            while (stringReader.canRead() && stringReader.peek() != ' ') {
                stringReader.skip();
            }
            return OperationArgument.func_197177_a(stringReader.getString().substring(n, stringReader.getCursor()));
        }
        throw field_197185_a.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return ISuggestionProvider.func_197008_a(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return field_201319_a;
    }

    private static IOperation func_197177_a(String string) throws CommandSyntaxException {
        if (string.equals("><")) {
            return (score, score2) -> {
                int n = score.func_96652_c();
                score.func_96647_c(score2.func_96652_c());
                score2.func_96647_c(n);
            };
        }
        return OperationArgument.func_197182_b(string);
    }

    private static Operation func_197182_b(String string) throws CommandSyntaxException {
        switch (string) {
            case "=": {
                return (n, n2) -> n2;
            }
            case "+=": {
                return (n, n2) -> n + n2;
            }
            case "-=": {
                return (n, n2) -> n - n2;
            }
            case "*=": {
                return (n, n2) -> n * n2;
            }
            case "/=": {
                return (n, n2) -> {
                    if (n2 == 0) {
                        throw field_197186_b.create();
                    }
                    return MathHelper.func_76137_a(n, n2);
                };
            }
            case "%=": {
                return (n, n2) -> {
                    if (n2 == 0) {
                        throw field_197186_b.create();
                    }
                    return MathHelper.func_180184_b(n, n2);
                };
            }
            case "<": {
                return Math::min;
            }
            case ">": {
                return Math::max;
            }
        }
        throw field_197185_a.create();
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    static interface Operation
    extends IOperation {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(Score score, Score score2) throws CommandSyntaxException {
            score.func_96647_c(this.apply(score.func_96652_c(), score2.func_96652_c()));
        }
    }

    @FunctionalInterface
    public static interface IOperation {
        public void apply(Score var1, Score var2) throws CommandSyntaxException;
    }
}

