/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.server.management.UserListWhitelistEntry;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;

public class WhitelistCommand {
    private static final SimpleCommandExceptionType field_198887_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.whitelist.alreadyOn", new Object[0]));
    private static final SimpleCommandExceptionType field_198888_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.whitelist.alreadyOff", new Object[0]));
    private static final SimpleCommandExceptionType field_198889_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.whitelist.add.failed", new Object[0]));
    private static final SimpleCommandExceptionType field_198890_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.whitelist.remove.failed", new Object[0]));

    public static void func_198873_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("whitelist").requires(commandSource -> commandSource.func_197034_c(3))).then(Commands.func_197057_a("on").executes(commandContext -> WhitelistCommand.func_198884_b((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("off").executes(commandContext -> WhitelistCommand.func_198885_c((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("list").executes(commandContext -> WhitelistCommand.func_198886_d((CommandSource)commandContext.getSource())))).then(Commands.func_197057_a("add").then(Commands.func_197056_a("targets", GameProfileArgument.func_197108_a()).suggests((commandContext, suggestionsBuilder) -> {
            PlayerList playerList = ((CommandSource)commandContext.getSource()).func_197028_i().func_184103_al();
            return ISuggestionProvider.func_197013_a(playerList.func_181057_v().stream().filter(entityPlayerMP -> !playerList.func_152599_k().func_152705_a(entityPlayerMP.func_146103_bH())).map(entityPlayerMP -> entityPlayerMP.func_146103_bH().getName()), suggestionsBuilder);
        }).executes(commandContext -> WhitelistCommand.func_198880_a((CommandSource)commandContext.getSource(), GameProfileArgument.func_197109_a((CommandContext<CommandSource>)commandContext, "targets")))))).then(Commands.func_197057_a("remove").then(Commands.func_197056_a("targets", GameProfileArgument.func_197108_a()).suggests((commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197008_a(((CommandSource)commandContext.getSource()).func_197028_i().func_184103_al().func_152598_l(), suggestionsBuilder)).executes(commandContext -> WhitelistCommand.func_198876_b((CommandSource)commandContext.getSource(), GameProfileArgument.func_197109_a((CommandContext<CommandSource>)commandContext, "targets")))))).then(Commands.func_197057_a("reload").executes(commandContext -> WhitelistCommand.func_198883_a((CommandSource)commandContext.getSource()))));
    }

    private static int func_198883_a(CommandSource commandSource) {
        commandSource.func_197028_i().func_184103_al().func_187244_a();
        commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.reloaded", new Object[0]), true);
        commandSource.func_197028_i().func_205743_a(commandSource);
        return 1;
    }

    private static int func_198880_a(CommandSource commandSource, Collection<GameProfile> collection) throws CommandSyntaxException {
        UserListWhitelist userListWhitelist = commandSource.func_197028_i().func_184103_al().func_152599_k();
        int \u26032 = 0;
        for (GameProfile gameProfile : collection) {
            if (userListWhitelist.func_152705_a(gameProfile)) continue;
            UserListWhitelistEntry userListWhitelistEntry = new UserListWhitelistEntry(gameProfile);
            userListWhitelist.func_152687_a(userListWhitelistEntry);
            commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.add.success", TextComponentUtils.func_197679_a(gameProfile)), true);
            ++\u26032;
        }
        if (\u26032 == 0) {
            throw field_198889_c.create();
        }
        return \u26032;
    }

    private static int func_198876_b(CommandSource commandSource2, Collection<GameProfile> collection) throws CommandSyntaxException {
        CommandSource commandSource2;
        UserListWhitelist userListWhitelist = commandSource2.func_197028_i().func_184103_al().func_152599_k();
        int \u26032 = 0;
        for (GameProfile gameProfile : collection) {
            if (!userListWhitelist.func_152705_a(gameProfile)) continue;
            UserListWhitelistEntry userListWhitelistEntry = new UserListWhitelistEntry(gameProfile);
            userListWhitelist.func_199042_b(userListWhitelistEntry);
            commandSource2.func_197030_a(new TextComponentTranslation("commands.whitelist.remove.success", TextComponentUtils.func_197679_a(gameProfile)), true);
            ++\u26032;
        }
        if (\u26032 == 0) {
            throw field_198890_d.create();
        }
        commandSource2.func_197028_i().func_205743_a(commandSource2);
        return \u26032;
    }

    private static int func_198884_b(CommandSource commandSource) throws CommandSyntaxException {
        PlayerList playerList = commandSource.func_197028_i().func_184103_al();
        if (playerList.func_72383_n()) {
            throw field_198887_a.create();
        }
        playerList.func_72371_a(true);
        commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.enabled", new Object[0]), true);
        commandSource.func_197028_i().func_205743_a(commandSource);
        return 1;
    }

    private static int func_198885_c(CommandSource commandSource) throws CommandSyntaxException {
        PlayerList playerList = commandSource.func_197028_i().func_184103_al();
        if (!playerList.func_72383_n()) {
            throw field_198888_b.create();
        }
        playerList.func_72371_a(false);
        commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.disabled", new Object[0]), true);
        return 1;
    }

    private static int func_198886_d(CommandSource commandSource) {
        CharSequence[] charSequenceArray = commandSource.func_197028_i().func_184103_al().func_152598_l();
        if (charSequenceArray.length == 0) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.none", new Object[0]), false);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation("commands.whitelist.list", charSequenceArray.length, String.join((CharSequence)", ", charSequenceArray)), false);
        }
        return charSequenceArray.length;
    }
}

