/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SNBTToNBTConverter
implements IDataProvider {
    private static final Logger field_200424_a = LogManager.getLogger();
    private final DataGenerator field_200425_b;

    public SNBTToNBTConverter(DataGenerator dataGenerator) {
        this.field_200425_b = dataGenerator;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) throws IOException {
        Path path2 = this.field_200425_b.func_200391_b();
        for (Path path4 : this.field_200425_b.func_200389_a()) {
            Files.walk(path4, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".snbt")).forEach(path3 -> this.func_208314_a(directoryCache, (Path)path3, this.func_200423_a(path4, (Path)path3), path2));
        }
    }

    @Override
    public String func_200397_b() {
        return "SNBT -> NBT";
    }

    private String func_200423_a(Path path, Path path2) {
        String string = path.relativize(path2).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private void func_208314_a(DirectoryCache directoryCache2, Path path, String string, Path path2) {
        try {
            \u2603 = path2.resolve(string + ".nbt");
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                DirectoryCache directoryCache2;
                String string2 = IOUtils.toString((Reader)bufferedReader);
                \u2603 = field_208307_a.hashUnencodedChars((CharSequence)string2).toString();
                if (!Objects.equals(directoryCache2.func_208323_a(\u2603), \u2603) || !Files.exists(\u2603, new LinkOption[0])) {
                    Files.createDirectories(\u2603.getParent(), new FileAttribute[0]);
                    try (OutputStream outputStream = Files.newOutputStream(\u2603, new OpenOption[0]);){
                        CompressedStreamTools.func_74799_a(JsonToNBT.func_180713_a(string2), outputStream);
                    }
                }
                directoryCache2.func_208316_a(\u2603, \u2603);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {} as it's invalid SNBT", (Object)string, (Object)path, (Object)commandSyntaxException);
        }
        catch (IOException iOException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {}", (Object)string, (Object)path, (Object)iOException);
        }
    }
}

