/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements IDataProvider {
    private static final Logger field_200436_d = LogManager.getLogger();
    private static final Gson field_200437_e = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200433_a;
    protected final IRegistry<T> field_200435_c;
    protected final Map<Tag<T>, Tag.Builder<T>> field_200434_b = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator dataGenerator, IRegistry<T> iRegistry) {
        this.field_200433_a = dataGenerator;
        this.field_200435_c = iRegistry;
    }

    protected abstract void func_200432_c();

    @Override
    public void func_200398_a(DirectoryCache directoryCache2) throws IOException {
        this.field_200434_b.clear();
        this.func_200432_c();
        TagCollection<Object> tagCollection = new TagCollection<Object>(resourceLocation -> false, resourceLocation -> null, "", false, "generated");
        for (Map.Entry<Tag<T>, Tag.Builder<T>> entry : this.field_200434_b.entrySet()) {
            ResourceLocation resourceLocation2 = entry.getKey().func_199886_b();
            if (!entry.getValue().func_200160_a(tagCollection::func_199910_a)) {
                throw new UnsupportedOperationException("Unsupported referencing of tags!");
            }
            Tag<Object> \u26032 = entry.getValue().func_200051_a(resourceLocation2);
            JsonObject \u26033 = \u26032.func_200571_a(this.field_200435_c::func_177774_c);
            Path \u26034 = this.func_200431_a(resourceLocation2);
            tagCollection.func_199912_a(\u26032);
            this.func_200429_a(tagCollection);
            try {
                DirectoryCache directoryCache2;
                String string = field_200437_e.toJson((JsonElement)\u26033);
                \u2603 = field_208307_a.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(directoryCache2.func_208323_a(\u26034), \u2603) || !Files.exists(\u26034, new LinkOption[0])) {
                    Files.createDirectories(\u26034.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(\u26034, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                directoryCache2.func_208316_a(\u26034, \u2603);
            }
            catch (IOException iOException) {
                field_200436_d.error("Couldn't save tags to {}", (Object)\u26034, (Object)iOException);
            }
        }
    }

    protected abstract void func_200429_a(TagCollection<T> var1);

    protected abstract Path func_200431_a(ResourceLocation var1);

    protected Tag.Builder<T> func_200426_a(Tag<T> tag2) {
        return this.field_200434_b.computeIfAbsent(tag2, tag -> Tag.Builder.func_200047_a());
    }
}

