/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.INameable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;

public abstract class EntityMinecart
extends Entity
implements INameable {
    private static final DataParameter<Integer> field_184265_a = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184266_b = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184267_c = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184268_d = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184269_e = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184270_f = EntityDataManager.func_187226_a(EntityMinecart.class, DataSerializers.field_187198_h);
    private boolean field_70499_f;
    private static final int[][][] field_70500_g = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int field_70510_h;
    private double field_70511_i;
    private double field_70509_j;
    private double field_70514_an;
    private double field_70512_ao;
    private double field_70513_ap;

    protected EntityMinecart(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.7f);
    }

    protected EntityMinecart(EntityType<?> entityType, World world, double d, double d2, double d3) {
        this(entityType, world);
        this.func_70107_b(d, d2, d3);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
    }

    public static EntityMinecart func_184263_a(World world, double d, double d2, double d3, Type type) {
        switch (type) {
            case CHEST: {
                return new EntityMinecartChest(world, d, d2, d3);
            }
            case FURNACE: {
                return new EntityMinecartFurnace(world, d, d2, d3);
            }
            case TNT: {
                return new EntityMinecartTNT(world, d, d2, d3);
            }
            case SPAWNER: {
                return new EntityMinecartMobSpawner(world, d, d2, d3);
            }
            case HOPPER: {
                return new EntityMinecartHopper(world, d, d2, d3);
            }
            case COMMAND_BLOCK: {
                return new EntityMinecartCommandBlock(world, d, d2, d3);
            }
        }
        return new EntityMinecartEmpty(world, d, d2, d3);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184265_a, 0);
        this.field_70180_af.func_187214_a(field_184266_b, 1);
        this.field_70180_af.func_187214_a(field_184267_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184268_d, Block.func_196246_j(Blocks.field_150350_a.func_176223_P()));
        this.field_70180_af.func_187214_a(field_184269_e, 6);
        this.field_70180_af.func_187214_a(field_184270_f, false);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity.func_70104_M()) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + f * 10.0f);
        boolean bl = \u2603 = damageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
        if (\u2603 || this.func_70491_i() > 40.0f) {
            this.func_184226_ay();
            if (!\u2603 || this.func_145818_k_()) {
                this.func_94095_a(damageSource);
            } else {
                this.func_70106_y();
            }
        }
        return true;
    }

    public void func_94095_a(DamageSource damageSource) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemStack = new ItemStack(Items.field_151143_au);
            if (this.func_145818_k_()) {
                itemStack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemStack);
        }
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public EnumFacing func_184172_bi() {
        return this.field_70499_f ? this.func_174811_aO().func_176734_d().func_176746_e() : this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        int n;
        int \u26032;
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer minecraftServer = this.field_70170_p.func_73046_m();
            \u26032 = this.func_82145_z();
            if (this.field_71087_bX) {
                if (minecraftServer.func_71255_r()) {
                    if (!this.func_184218_aH() && this.field_82153_h++ >= \u26032) {
                        this.field_82153_h = \u26032;
                        this.field_71088_bW = this.func_82147_ab();
                        DimensionType dimensionType = this.field_70170_p.field_73011_w.func_186058_p() == DimensionType.NETHER ? DimensionType.OVERWORLD : DimensionType.NETHER;
                        this.func_212321_a(dimensionType);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70510_h > 0) {
                double d = this.field_70165_t + (this.field_70511_i - this.field_70165_t) / (double)this.field_70510_h;
                \u2603 = this.field_70163_u + (this.field_70509_j - this.field_70163_u) / (double)this.field_70510_h;
                \u2603 = this.field_70161_v + (this.field_70514_an - this.field_70161_v) / (double)this.field_70510_h;
                \u2603 = MathHelper.func_76138_g(this.field_70512_ao - (double)this.field_70177_z);
                this.field_70177_z = (float)((double)this.field_70177_z + \u2603 / (double)this.field_70510_h);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70513_ap - (double)this.field_70125_A) / (double)this.field_70510_h);
                --this.field_70510_h;
                this.func_70107_b(d, \u2603, \u2603);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos(n = MathHelper.func_76128_c(this.field_70165_t), (\u26032 = MathHelper.func_76128_c(this.field_70163_u)) - 1, \u2603 = MathHelper.func_76128_c(this.field_70161_v))).func_203425_a(BlockTags.field_203437_y)) {
            --\u26032;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(\u2603 = new BlockPos(n, \u26032, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            this.func_180460_a(\u2603, \u2603);
            if (\u2603.func_177230_c() == Blocks.field_150408_cc) {
                this.func_96095_a(n, \u26032, \u2603, \u2603.func_177229_b(BlockRailPowered.field_176569_M));
            }
        } else {
            this.func_180459_n();
        }
        this.func_145775_I();
        this.field_70125_A = 0.0f;
        double \u26033 = this.field_70169_q - this.field_70165_t;
        double \u26034 = this.field_70166_s - this.field_70161_v;
        if (\u26033 * \u26033 + \u26034 * \u26034 > 0.001) {
            this.field_70177_z = (float)(MathHelper.func_181159_b(\u26034, \u26033) * 180.0 / Math.PI);
            if (this.field_70499_f) {
                this.field_70177_z += 180.0f;
            }
        }
        if ((\u2603 = (double)MathHelper.func_76142_g(this.field_70177_z - this.field_70126_B)) < -170.0 || \u2603 >= 170.0) {
            this.field_70177_z += 180.0f;
            this.field_70499_f = !this.field_70499_f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.func_184264_v() == Type.RIDEABLE && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.01) {
            List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f), EntitySelectors.func_200823_a(this));
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = list.get(i);
                    if (entity instanceof EntityPlayer || entity instanceof EntityIronGolem || entity instanceof EntityMinecart || this.func_184207_aI() || entity.func_184218_aH()) {
                        entity.func_70108_f(this);
                        continue;
                    }
                    entity.func_184220_m(this);
                }
            }
        } else {
            for (Entity entity : this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f))) {
                if (this.func_184196_w(entity) || !entity.func_70104_M() || !(entity instanceof EntityMinecart)) continue;
                entity.func_70108_f(this);
            }
        }
        this.func_70072_I();
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public void func_96095_a(int n, int n2, int n3, boolean bl) {
    }

    protected void func_180459_n() {
        double d = this.func_174898_m();
        this.field_70159_w = MathHelper.func_151237_a(this.field_70159_w, -d, d);
        this.field_70179_y = MathHelper.func_151237_a(this.field_70179_y, -d, d);
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= (double)0.95f;
            this.field_70181_x *= (double)0.95f;
            this.field_70179_y *= (double)0.95f;
        }
    }

    protected void func_180460_a(BlockPos blockPos, IBlockState iBlockState) {
        double d;
        this.field_70143_R = 0.0f;
        Vec3d vec3d = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70163_u = blockPos.func_177956_o();
        boolean \u26032 = false;
        boolean \u26033 = false;
        BlockRailBase \u26034 = (BlockRailBase)iBlockState.func_177230_c();
        if (\u26034 == Blocks.field_196552_aC) {
            \u26032 = iBlockState.func_177229_b(BlockRailPowered.field_176569_M);
            \u26033 = !\u26032;
        }
        double \u26035 = 0.0078125;
        RailShape \u26036 = iBlockState.func_177229_b(\u26034.func_176560_l());
        switch (\u26036) {
            case ASCENDING_EAST: {
                this.field_70159_w -= 0.0078125;
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.field_70159_w += 0.0078125;
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.field_70179_y += 0.0078125;
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.field_70179_y -= 0.0078125;
                this.field_70163_u += 1.0;
            }
        }
        int[][] \u26037 = field_70500_g[\u26036.func_208091_a()];
        double \u26038 = \u26037[1][0] - \u26037[0][0];
        double \u26039 = \u26037[1][2] - \u26037[0][2];
        double \u260310 = Math.sqrt(\u26038 * \u26038 + \u26039 * \u26039);
        double \u260311 = this.field_70159_w * \u26038 + this.field_70179_y * \u26039;
        if (\u260311 < 0.0) {
            \u26038 = -\u26038;
            \u26039 = -\u26039;
        }
        if ((d = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 2.0) {
            d = 2.0;
        }
        this.field_70159_w = d * \u26038 / \u260310;
        this.field_70179_y = d * \u26039 / \u260310;
        Entity entity = \u2603 = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (\u2603 instanceof EntityPlayer && (\u2603 = (double)((EntityPlayer)\u2603).field_191988_bg) > 0.0) {
            \u2603 = -Math.sin(\u2603.field_70177_z * ((float)Math.PI / 180));
            \u2603 = Math.cos(\u2603.field_70177_z * ((float)Math.PI / 180));
            \u2603 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
            if (\u2603 < 0.01) {
                this.field_70159_w += \u2603 * 0.1;
                this.field_70179_y += \u2603 * 0.1;
                \u26033 = false;
            }
        }
        if (\u26033) {
            \u2603 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (\u2603 < 0.03) {
                this.field_70159_w *= 0.0;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.0;
            } else {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.5;
            }
        }
        \u2603 = (double)blockPos.func_177958_n() + 0.5 + (double)\u26037[0][0] * 0.5;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (double)\u26037[0][2] * 0.5;
        \u2603 = (double)blockPos.func_177958_n() + 0.5 + (double)\u26037[1][0] * 0.5;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (double)\u26037[1][2] * 0.5;
        \u26038 = \u2603 - \u2603;
        \u26039 = \u2603 - \u2603;
        if (\u26038 == 0.0) {
            this.field_70165_t = (double)blockPos.func_177958_n() + 0.5;
            \u2603 = this.field_70161_v - (double)blockPos.func_177952_p();
        } else if (\u26039 == 0.0) {
            this.field_70161_v = (double)blockPos.func_177952_p() + 0.5;
            \u2603 = this.field_70165_t - (double)blockPos.func_177958_n();
        } else {
            \u2603 = this.field_70165_t - \u2603;
            \u2603 = this.field_70161_v - \u2603;
            \u2603 = (\u2603 * \u26038 + \u2603 * \u26039) * 2.0;
        }
        this.field_70165_t = \u2603 + \u26038 * \u2603;
        this.field_70161_v = \u2603 + \u26039 * \u2603;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        \u2603 = this.field_70159_w;
        \u2603 = this.field_70179_y;
        if (this.func_184207_aI()) {
            \u2603 *= 0.75;
            \u2603 *= 0.75;
        }
        \u2603 = this.func_174898_m();
        \u2603 = MathHelper.func_151237_a(\u2603, -\u2603, \u2603);
        \u2603 = MathHelper.func_151237_a(\u2603, -\u2603, \u2603);
        this.func_70091_d(MoverType.SELF, \u2603, 0.0, \u2603);
        if (\u26037[0][1] != 0 && MathHelper.func_76128_c(this.field_70165_t) - blockPos.func_177958_n() == \u26037[0][0] && MathHelper.func_76128_c(this.field_70161_v) - blockPos.func_177952_p() == \u26037[0][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)\u26037[0][1], this.field_70161_v);
        } else if (\u26037[1][1] != 0 && MathHelper.func_76128_c(this.field_70165_t) - blockPos.func_177958_n() == \u26037[1][0] && MathHelper.func_76128_c(this.field_70161_v) - blockPos.func_177952_p() == \u26037[1][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)\u26037[1][1], this.field_70161_v);
        }
        this.func_94101_h();
        Vec3d \u260312 = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (\u260312 != null && vec3d != null) {
            \u2603 = (vec3d.field_72448_b - \u260312.field_72448_b) * 0.05;
            d = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d > 0.0) {
                this.field_70159_w = this.field_70159_w / d * (d + \u2603);
                this.field_70179_y = this.field_70179_y / d * (d + \u2603);
            }
            this.func_70107_b(this.field_70165_t, \u260312.field_72448_b, this.field_70161_v);
        }
        int \u260313 = MathHelper.func_76128_c(this.field_70165_t);
        int \u260314 = MathHelper.func_76128_c(this.field_70161_v);
        if (\u260313 != blockPos.func_177958_n() || \u260314 != blockPos.func_177952_p()) {
            d = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70159_w = d * (double)(\u260313 - blockPos.func_177958_n());
            this.field_70179_y = d * (double)(\u260314 - blockPos.func_177952_p());
        }
        if (\u26032) {
            \u2603 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (\u2603 > 0.01) {
                \u2603 = 0.06;
                this.field_70159_w += this.field_70159_w / \u2603 * 0.06;
                this.field_70179_y += this.field_70179_y / \u2603 * 0.06;
            } else if (\u26036 == RailShape.EAST_WEST) {
                if (this.field_70170_p.func_180495_p(blockPos.func_177976_e()).func_185915_l()) {
                    this.field_70159_w = 0.02;
                } else if (this.field_70170_p.func_180495_p(blockPos.func_177974_f()).func_185915_l()) {
                    this.field_70159_w = -0.02;
                }
            } else if (\u26036 == RailShape.NORTH_SOUTH) {
                if (this.field_70170_p.func_180495_p(blockPos.func_177978_c()).func_185915_l()) {
                    this.field_70179_y = 0.02;
                } else if (this.field_70170_p.func_180495_p(blockPos.func_177968_d()).func_185915_l()) {
                    this.field_70179_y = -0.02;
                }
            }
        }
    }

    protected void func_94101_h() {
        if (this.func_184207_aI()) {
            this.field_70159_w *= (double)0.997f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.997f;
        } else {
            this.field_70159_w *= (double)0.96f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.96f;
        }
    }

    @Override
    public void func_70107_b(double d, double d2, double d3) {
        this.field_70165_t = d;
        this.field_70163_u = d2;
        this.field_70161_v = d3;
        float f = this.field_70130_N / 2.0f;
        \u2603 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(d - (double)f, d2, d3 - (double)f, d + (double)f, d2 + (double)\u2603, d3 + (double)f));
    }

    @Nullable
    public Vec3d func_70489_a(double d4, double d2, double d3) {
        int n = MathHelper.func_76128_c(d4);
        if (this.field_70170_p.func_180495_p(new BlockPos(n, (\u2603 = MathHelper.func_76128_c(d2)) - 1, \u2603 = MathHelper.func_76128_c(d3))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            double d4;
            double d5;
            RailShape railShape = \u2603.func_177229_b(((BlockRailBase)\u2603.func_177230_c()).func_176560_l());
            int[][] \u26032 = field_70500_g[railShape.func_208091_a()];
            double \u26033 = (double)n + 0.5 + (double)\u26032[0][0] * 0.5;
            double \u26034 = (double)\u2603 + 0.0625 + (double)\u26032[0][1] * 0.5;
            double \u26035 = (double)\u2603 + 0.5 + (double)\u26032[0][2] * 0.5;
            double \u26036 = (double)n + 0.5 + (double)\u26032[1][0] * 0.5;
            double \u26037 = (double)\u2603 + 0.0625 + (double)\u26032[1][1] * 0.5;
            double \u26038 = (double)\u2603 + 0.5 + (double)\u26032[1][2] * 0.5;
            double \u26039 = \u26036 - \u26033;
            double \u260310 = (\u26037 - \u26034) * 2.0;
            double \u260311 = \u26038 - \u26035;
            if (\u26039 == 0.0) {
                d5 = d3 - (double)\u2603;
            } else if (\u260311 == 0.0) {
                d5 = d4 - (double)n;
            } else {
                \u2603 = d4 - \u26033;
                \u2603 = d3 - \u26035;
                d5 = (\u2603 * \u26039 + \u2603 * \u260311) * 2.0;
            }
            d4 = \u26033 + \u26039 * d5;
            d2 = \u26034 + \u260310 * d5;
            d3 = \u26035 + \u260311 * d5;
            if (\u260310 < 0.0) {
                d2 += 1.0;
            }
            if (\u260310 > 0.0) {
                d2 += 0.5;
            }
            return new Vec3d(d4, d2, d3);
        }
        return null;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74767_n("CustomDisplayTile")) {
            this.func_174899_a(NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("DisplayState")));
            this.func_94086_l(nBTTagCompound.func_74762_e("DisplayOffset"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nBTTagCompound) {
        if (this.func_94100_s()) {
            nBTTagCompound.func_74757_a("CustomDisplayTile", true);
            nBTTagCompound.func_74782_a("DisplayState", NBTUtil.func_190009_a(this.func_174897_t()));
            nBTTagCompound.func_74768_a("DisplayOffset", this.func_94099_q());
        }
    }

    @Override
    public void func_70108_f(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.field_70145_X || this.field_70145_X) {
            return;
        }
        if (this.func_184196_w(entity)) {
            return;
        }
        double d = entity.field_70165_t - this.field_70165_t;
        \u2603 = entity.field_70161_v - this.field_70161_v;
        \u2603 = d * d + \u2603 * \u2603;
        if (\u2603 >= (double)1.0E-4f) {
            \u2603 = MathHelper.func_76133_a(\u2603);
            d /= \u2603;
            \u2603 /= \u2603;
            \u2603 = 1.0 / \u2603;
            if (\u2603 > 1.0) {
                \u2603 = 1.0;
            }
            d *= \u2603;
            \u2603 *= \u2603;
            d *= (double)0.1f;
            \u2603 *= (double)0.1f;
            d *= (double)(1.0f - this.field_70144_Y);
            \u2603 *= (double)(1.0f - this.field_70144_Y);
            d *= 0.5;
            \u2603 *= 0.5;
            if (entity instanceof EntityMinecart) {
                \u2603 = entity.field_70165_t - this.field_70165_t;
                \u2603 = entity.field_70161_v - this.field_70161_v;
                Vec3d vec3d = new Vec3d(\u2603, 0.0, \u2603).func_72432_b();
                double \u26032 = Math.abs(vec3d.func_72430_b(\u2603 = new Vec3d(MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)), 0.0, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180))).func_72432_b()));
                if (\u26032 < (double)0.8f) {
                    return;
                }
                double \u26033 = entity.field_70159_w + this.field_70159_w;
                double \u26034 = entity.field_70179_y + this.field_70179_y;
                if (((EntityMinecart)entity).func_184264_v() == Type.FURNACE && this.func_184264_v() != Type.FURNACE) {
                    this.field_70159_w *= (double)0.2f;
                    this.field_70179_y *= (double)0.2f;
                    this.func_70024_g(entity.field_70159_w - d, 0.0, entity.field_70179_y - \u2603);
                    entity.field_70159_w *= (double)0.95f;
                    entity.field_70179_y *= (double)0.95f;
                } else if (((EntityMinecart)entity).func_184264_v() != Type.FURNACE && this.func_184264_v() == Type.FURNACE) {
                    entity.field_70159_w *= (double)0.2f;
                    entity.field_70179_y *= (double)0.2f;
                    entity.func_70024_g(this.field_70159_w + d, 0.0, this.field_70179_y + \u2603);
                    this.field_70159_w *= (double)0.95f;
                    this.field_70179_y *= (double)0.95f;
                } else {
                    this.field_70159_w *= (double)0.2f;
                    this.field_70179_y *= (double)0.2f;
                    this.func_70024_g((\u26033 /= 2.0) - d, 0.0, (\u26034 /= 2.0) - \u2603);
                    entity.field_70159_w *= (double)0.2f;
                    entity.field_70179_y *= (double)0.2f;
                    entity.func_70024_g(\u26033 + d, 0.0, \u26034 + \u2603);
                }
            } else {
                this.func_70024_g(-d, 0.0, -\u2603);
                entity.func_70024_g(d / 4.0, 0.0, \u2603 / 4.0);
            }
        }
    }

    public void func_70492_c(float f) {
        this.field_70180_af.func_187227_b(field_184267_c, Float.valueOf(f));
    }

    public float func_70491_i() {
        return this.field_70180_af.func_187225_a(field_184267_c).floatValue();
    }

    public void func_70497_h(int n) {
        this.field_70180_af.func_187227_b(field_184265_a, n);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_187225_a(field_184265_a);
    }

    public void func_70494_i(int n) {
        this.field_70180_af.func_187227_b(field_184266_b, n);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_187225_a(field_184266_b);
    }

    public abstract Type func_184264_v();

    public IBlockState func_174897_t() {
        if (!this.func_94100_s()) {
            return this.func_180457_u();
        }
        return Block.func_196257_b(this.func_184212_Q().func_187225_a(field_184268_d));
    }

    public IBlockState func_180457_u() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public int func_94099_q() {
        if (!this.func_94100_s()) {
            return this.func_94085_r();
        }
        return this.func_184212_Q().func_187225_a(field_184269_e);
    }

    public int func_94085_r() {
        return 6;
    }

    public void func_174899_a(IBlockState iBlockState) {
        this.func_184212_Q().func_187227_b(field_184268_d, Block.func_196246_j(iBlockState));
        this.func_94096_e(true);
    }

    public void func_94086_l(int n) {
        this.func_184212_Q().func_187227_b(field_184269_e, n);
        this.func_94096_e(true);
    }

    public boolean func_94100_s() {
        return this.func_184212_Q().func_187225_a(field_184270_f);
    }

    public void func_94096_e(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184270_f, bl);
    }

    public static enum Type {
        RIDEABLE(0),
        CHEST(1),
        FURNACE(2),
        TNT(3),
        SPAWNER(4),
        HOPPER(5),
        COMMAND_BLOCK(6);

        private static final Type[] field_184965_h;
        private final int field_184966_i;

        private Type(int n2) {
            this.field_184966_i = n2;
        }

        public int func_184956_a() {
            return this.field_184966_i;
        }

        static {
            field_184965_h = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::func_184956_a)).toArray(Type[]::new);
        }
    }
}

