/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityEnderman
extends EntityMob {
    private static final UUID field_110192_bp = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier field_110193_bq = new AttributeModifier(field_110192_bp, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final DataParameter<Optional<IBlockState>> field_184718_bv = EntityDataManager.func_187226_a(EntityEnderman.class, DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> field_184719_bw = EntityDataManager.func_187226_a(EntityEnderman.class, DataSerializers.field_187198_h);
    private int field_184720_bx;
    private int field_184721_by;

    public EntityEnderman(World world) {
        super(EntityType.field_200803_q, world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, new EntityAIAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.field_70714_bg.func_75776_a(10, new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(11, new AITakeBlock(this));
        this.field_70715_bh.func_75776_a(1, new AIFindPlayer(this));
        this.field_70715_bh.func_75776_a(2, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityEndermite>(this, EntityEndermite.class, 10, true, false, EntityEndermite::func_175495_n));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase entityLivingBase) {
        super.func_70624_b(entityLivingBase);
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entityLivingBase == null) {
            this.field_184721_by = 0;
            this.field_70180_af.func_187227_b(field_184719_bw, false);
            iAttributeInstance.func_111124_b(field_110193_bq);
        } else {
            this.field_184721_by = this.field_70173_aa;
            this.field_70180_af.func_187227_b(field_184719_bw, true);
            if (!iAttributeInstance.func_180374_a(field_110193_bq)) {
                iAttributeInstance.func_111121_a(field_110193_bq);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184718_bv, Optional.empty());
        this.field_70180_af.func_187214_a(field_184719_bw, false);
    }

    public void func_184716_o() {
        if (this.field_70173_aa >= this.field_184720_bx + 400) {
            this.field_184720_bx = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184719_bw.equals(dataParameter) && this.func_70823_r() && this.field_70170_p.field_72995_K) {
            this.func_184716_o();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        IBlockState iBlockState = this.func_195405_dq();
        if (iBlockState != null) {
            nBTTagCompound.func_74782_a("carriedBlockState", NBTUtil.func_190009_a(iBlockState));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        IBlockState iBlockState = null;
        if (nBTTagCompound.func_150297_b("carriedBlockState", 10) && (iBlockState = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            iBlockState = null;
        }
        this.func_195406_b(iBlockState);
    }

    private boolean func_70821_d(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.field_71071_by.field_70460_b.get(3);
        if (itemStack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vec3d \u26032 = entityPlayer.func_70676_i(1.0f).func_72432_b();
        Vec3d \u26033 = new Vec3d(this.field_70165_t - entityPlayer.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e()), this.field_70161_v - entityPlayer.field_70161_v);
        double \u26034 = \u26033.func_72433_c();
        double \u26035 = \u26032.func_72430_b(\u26033 = \u26033.func_72432_b());
        if (\u26035 > 1.0 - 0.025 / \u26034) {
            return entityPlayer.func_70685_l(this);
        }
        return false;
    }

    @Override
    public float func_70047_e() {
        return 2.55f;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a(Particles.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        float f;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.field_184721_by + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175678_i(new BlockPos(this)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.func_70820_n();
        }
        super.func_70619_bc();
    }

    protected boolean func_70820_n() {
        double d = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        \u2603 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        \u2603 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.func_70825_j(d, \u2603, \u2603);
    }

    protected boolean func_70816_c(Entity entity) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double \u26032 = 16.0;
        double \u26033 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double \u26034 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double \u26035 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.func_70825_j(\u26033, \u26034, \u26035);
    }

    private boolean func_70825_j(double d, double d2, double d3) {
        boolean bl = this.func_184595_k(d, d2, d3);
        if (bl) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_70823_r() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187531_aU;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    @Override
    protected void func_82160_b(boolean bl, int n) {
        super.func_82160_b(bl, n);
        IBlockState iBlockState = this.func_195405_dq();
        if (iBlockState != null) {
            this.func_199703_a(iBlockState.func_177230_c());
        }
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186439_u;
    }

    public void func_195406_b(@Nullable IBlockState iBlockState) {
        this.field_70180_af.func_187227_b(field_184718_bv, Optional.ofNullable(iBlockState));
    }

    @Nullable
    public IBlockState func_195405_dq() {
        return this.field_70180_af.func_187225_a(field_184718_bv).orElse(null);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        if (damageSource2 instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        boolean \u26032 = super.func_70097_a(damageSource2, f);
        if (damageSource2.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.func_70820_n();
        }
        return \u26032;
    }

    public boolean func_70823_r() {
        return this.field_70180_af.func_187225_a(field_184719_bw);
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntityEnderman field_179473_a;

        public AITakeBlock(EntityEnderman entityEnderman) {
            this.field_179473_a = entityEnderman;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_179473_a.func_195405_dq() != null) {
                return false;
            }
            if (!this.field_179473_a.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            return this.field_179473_a.func_70681_au().nextInt(20) == 0;
        }

        @Override
        public void func_75246_d() {
            Random random = this.field_179473_a.func_70681_au();
            World \u26032 = this.field_179473_a.field_70170_p;
            int \u26033 = MathHelper.func_76128_c(this.field_179473_a.field_70165_t - 2.0 + random.nextDouble() * 4.0);
            int \u26034 = MathHelper.func_76128_c(this.field_179473_a.field_70163_u + random.nextDouble() * 3.0);
            int \u26035 = MathHelper.func_76128_c(this.field_179473_a.field_70161_v - 2.0 + random.nextDouble() * 4.0);
            BlockPos \u26036 = new BlockPos(\u26033, \u26034, \u26035);
            IBlockState \u26037 = \u26032.func_180495_p(\u26036);
            Block \u26038 = \u26037.func_177230_c();
            RayTraceResult \u26039 = \u26032.func_200259_a(new Vec3d((float)MathHelper.func_76128_c(this.field_179473_a.field_70165_t) + 0.5f, (float)\u26034 + 0.5f, (float)MathHelper.func_76128_c(this.field_179473_a.field_70161_v) + 0.5f), new Vec3d((float)\u26033 + 0.5f, (float)\u26034 + 0.5f, (float)\u26035 + 0.5f), RayTraceFluidMode.NEVER, true, false);
            boolean bl = \u2603 = \u26039 != null && \u26039.func_178782_a().equals(\u26036);
            if (\u26038.func_203417_a(BlockTags.field_201151_l) && \u2603) {
                this.field_179473_a.func_195406_b(\u26037);
                \u26032.func_175698_g(\u26036);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntityEnderman field_179475_a;

        public AIPlaceBlock(EntityEnderman entityEnderman) {
            this.field_179475_a = entityEnderman;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_179475_a.func_195405_dq() == null) {
                return false;
            }
            if (!this.field_179475_a.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            return this.field_179475_a.func_70681_au().nextInt(2000) == 0;
        }

        @Override
        public void func_75246_d() {
            Random random = this.field_179475_a.func_70681_au();
            World \u26032 = this.field_179475_a.field_70170_p;
            int \u26033 = MathHelper.func_76128_c(this.field_179475_a.field_70165_t - 1.0 + random.nextDouble() * 2.0);
            int \u26034 = MathHelper.func_76128_c(this.field_179475_a.field_70163_u + random.nextDouble() * 2.0);
            int \u26035 = MathHelper.func_76128_c(this.field_179475_a.field_70161_v - 1.0 + random.nextDouble() * 2.0);
            BlockPos \u26036 = new BlockPos(\u26033, \u26034, \u26035);
            IBlockState \u26037 = \u26032.func_180495_p(\u26036);
            IBlockState \u26038 = \u26032.func_180495_p(\u26036.func_177977_b());
            IBlockState \u26039 = this.field_179475_a.func_195405_dq();
            if (\u26039 != null && this.func_195924_a(\u26032, \u26036, \u26039, \u26037, \u26038)) {
                \u26032.func_180501_a(\u26036, \u26039, 3);
                this.field_179475_a.func_195406_b(null);
            }
        }

        private boolean func_195924_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, IBlockState iBlockState, IBlockState iBlockState2, IBlockState iBlockState3) {
            return iBlockState2.func_196958_f() && !iBlockState3.func_196958_f() && iBlockState3.func_185917_h() && iBlockState.func_196955_c(iWorldReaderBase, blockPos);
        }
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityEnderman field_179449_j;
        private EntityPlayer field_179448_g;
        private int field_179450_h;
        private int field_179451_i;

        public AIFindPlayer(EntityEnderman entityEnderman) {
            super((EntityCreature)entityEnderman, EntityPlayer.class, false);
            this.field_179449_j = entityEnderman;
        }

        @Override
        public boolean func_75250_a() {
            double d = this.func_111175_f();
            this.field_179448_g = this.field_179449_j.field_70170_p.func_184150_a(this.field_179449_j.field_70165_t, this.field_179449_j.field_70163_u, this.field_179449_j.field_70161_v, d, d, null, entityPlayer -> entityPlayer != null && this.field_179449_j.func_70821_d(entityPlayer));
            return this.field_179448_g != null;
        }

        @Override
        public void func_75249_e() {
            this.field_179450_h = 5;
            this.field_179451_i = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_179448_g = null;
            super.func_75251_c();
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_179448_g != null) {
                if (!this.field_179449_j.func_70821_d(this.field_179448_g)) {
                    return false;
                }
                this.field_179449_j.func_70625_a(this.field_179448_g, 10.0f, 10.0f);
                return true;
            }
            if (this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S()) {
                return true;
            }
            return super.func_75253_b();
        }

        @Override
        public void func_75246_d() {
            if (this.field_179448_g != null) {
                if (--this.field_179450_h <= 0) {
                    this.field_75309_a = this.field_179448_g;
                    this.field_179448_g = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.field_179449_j.func_70821_d((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e(this.field_179449_j) < 16.0) {
                            this.field_179449_j.func_70820_n();
                        }
                        this.field_179451_i = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e(this.field_179449_j) > 256.0 && this.field_179451_i++ >= 30 && this.field_179449_j.func_70816_c(this.field_75309_a)) {
                        this.field_179451_i = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

