/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySheep
extends EntityAnimal {
    private static final DataParameter<Byte> field_184774_bv = EntityDataManager.func_187226_a(EntitySheep.class, DataSerializers.field_187191_a);
    private final InventoryCrafting field_90016_e = new InventoryCrafting(new Container(){

        @Override
        public boolean func_75145_c(EntityPlayer entityPlayer) {
            return false;
        }
    }, 2, 1);
    private static final Map<EnumDyeColor, IItemProvider> field_200206_bz = Util.func_200696_a(Maps.newEnumMap(EnumDyeColor.class), enumMap -> {
        enumMap.put(EnumDyeColor.WHITE, Blocks.field_196556_aL);
        enumMap.put(EnumDyeColor.ORANGE, Blocks.field_196557_aM);
        enumMap.put(EnumDyeColor.MAGENTA, Blocks.field_196558_aN);
        enumMap.put(EnumDyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        enumMap.put(EnumDyeColor.YELLOW, Blocks.field_196560_aP);
        enumMap.put(EnumDyeColor.LIME, Blocks.field_196561_aQ);
        enumMap.put(EnumDyeColor.PINK, Blocks.field_196562_aR);
        enumMap.put(EnumDyeColor.GRAY, Blocks.field_196563_aS);
        enumMap.put(EnumDyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        enumMap.put(EnumDyeColor.CYAN, Blocks.field_196565_aU);
        enumMap.put(EnumDyeColor.PURPLE, Blocks.field_196566_aV);
        enumMap.put(EnumDyeColor.BLUE, Blocks.field_196567_aW);
        enumMap.put(EnumDyeColor.BROWN, Blocks.field_196568_aX);
        enumMap.put(EnumDyeColor.GREEN, Blocks.field_196569_aY);
        enumMap.put(EnumDyeColor.RED, Blocks.field_196570_aZ);
        enumMap.put(EnumDyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<EnumDyeColor, float[]> field_175514_bm = Maps.newEnumMap(Arrays.stream(EnumDyeColor.values()).collect(Collectors.toMap(enumDyeColor -> enumDyeColor, EntitySheep::func_192020_c)));
    private int field_70899_e;
    private EntityAIEatGrass field_146087_bs;

    private static float[] func_192020_c(EnumDyeColor enumDyeColor) {
        if (enumDyeColor == EnumDyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] fArray = enumDyeColor.func_193349_f();
        float \u26032 = 0.75f;
        return new float[]{fArray[0] * 0.75f, fArray[1] * 0.75f, fArray[2] * 0.75f};
    }

    public EntitySheep(World world) {
        super(EntityType.field_200737_ac, world);
        this.func_70105_a(0.9f, 1.3f);
    }

    @Override
    protected void func_184651_r() {
        this.field_146087_bs = new EntityAIEatGrass(this);
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIPanic(this, 1.25));
        this.field_70714_bg.func_75776_a(2, new EntityAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityAITempt((EntityCreature)this, 1.1, Ingredient.func_199804_a(Items.field_151015_O), false));
        this.field_70714_bg.func_75776_a(4, new EntityAIFollowParent(this, 1.1));
        this.field_70714_bg.func_75776_a(5, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(6, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
    }

    @Override
    protected void func_70619_bc() {
        this.field_70899_e = this.field_146087_bs.func_151499_f();
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70899_e = Math.max(0, this.field_70899_e - 1);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184774_bv, (byte)0);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return LootTableList.field_186403_K;
        }
        switch (this.func_175509_cj()) {
            default: {
                return LootTableList.field_186404_L;
            }
            case ORANGE: {
                return LootTableList.field_186405_M;
            }
            case MAGENTA: {
                return LootTableList.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTableList.field_186407_O;
            }
            case YELLOW: {
                return LootTableList.field_186408_P;
            }
            case LIME: {
                return LootTableList.field_186409_Q;
            }
            case PINK: {
                return LootTableList.field_186410_R;
            }
            case GRAY: {
                return LootTableList.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTableList.field_197738_Y;
            }
            case CYAN: {
                return LootTableList.field_186413_U;
            }
            case PURPLE: {
                return LootTableList.field_186414_V;
            }
            case BLUE: {
                return LootTableList.field_186415_W;
            }
            case BROWN: {
                return LootTableList.field_186416_X;
            }
            case GREEN: {
                return LootTableList.field_186417_Y;
            }
            case RED: {
                return LootTableList.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTableList.field_186376_aa;
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityPlayer2, EnumHand enumHand) {
        EntityPlayer entityPlayer2;
        ItemStack itemStack = entityPlayer2.func_184586_b(enumHand);
        if (itemStack.func_77973_b() == Items.field_151097_aZ && !this.func_70892_o() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70893_e(true);
                int n = 1 + this.field_70146_Z.nextInt(3);
                for (\u2603 = 0; \u2603 < n; ++\u2603) {
                    EntityItem entityItem = this.func_199702_a(field_200206_bz.get(this.func_175509_cj()), 1);
                    if (entityItem == null) continue;
                    entityItem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityItem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityItem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            itemStack.func_77972_a(1, entityPlayer2);
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        }
        return super.func_184645_a(entityPlayer2, enumHand);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Sheared", this.func_70892_o());
        nBTTagCompound.func_74774_a("Color", (byte)this.func_175509_cj().func_196059_a());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_70893_e(nBTTagCompound.func_74767_n("Sheared"));
        this.func_175512_b(EnumDyeColor.func_196056_a(nBTTagCompound.func_74771_c("Color")));
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187761_eI;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public EnumDyeColor func_175509_cj() {
        return EnumDyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184774_bv) & 0xF);
    }

    public void func_175512_b(EnumDyeColor enumDyeColor) {
        byte by = this.field_70180_af.func_187225_a(field_184774_bv);
        this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by & 0xF0 | enumDyeColor.func_196059_a() & 0xF));
    }

    public boolean func_70892_o() {
        return (this.field_70180_af.func_187225_a(field_184774_bv) & 0x10) != 0;
    }

    public void func_70893_e(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184774_bv);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(by & 0xFFFFFFEF));
        }
    }

    public static EnumDyeColor func_175510_a(Random random) {
        int n = random.nextInt(100);
        if (n < 5) {
            return EnumDyeColor.BLACK;
        }
        if (n < 10) {
            return EnumDyeColor.GRAY;
        }
        if (n < 15) {
            return EnumDyeColor.LIGHT_GRAY;
        }
        if (n < 18) {
            return EnumDyeColor.BROWN;
        }
        if (random.nextInt(500) == 0) {
            return EnumDyeColor.PINK;
        }
        return EnumDyeColor.WHITE;
    }

    @Override
    public EntitySheep func_90011_a(EntityAgeable entityAgeable) {
        EntitySheep entitySheep = (EntitySheep)entityAgeable;
        \u2603 = new EntitySheep(this.field_70170_p);
        \u2603.func_175512_b(this.func_175511_a(this, entitySheep));
        return \u2603;
    }

    @Override
    public void func_70615_aA() {
        this.func_70893_e(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        this.func_175512_b(EntitySheep.func_175510_a(this.field_70170_p.field_73012_v));
        return iEntityLivingData2;
    }

    private EnumDyeColor func_175511_a(EntityAnimal entityAnimal, EntityAnimal entityAnimal2) {
        EnumDyeColor enumDyeColor = ((EntitySheep)entityAnimal).func_175509_cj();
        \u2603 = ((EntitySheep)entityAnimal2).func_175509_cj();
        this.field_90016_e.func_70299_a(0, new ItemStack(ItemDye.func_195961_a(enumDyeColor)));
        this.field_90016_e.func_70299_a(1, new ItemStack(ItemDye.func_195961_a(\u2603)));
        ItemStack \u26032 = entityAnimal.field_70170_p.func_199532_z().func_199514_a(this.field_90016_e, ((EntitySheep)entityAnimal).field_70170_p);
        Item \u26033 = \u26032.func_77973_b();
        \u2603 = \u26033 instanceof ItemDye ? ((ItemDye)\u26033).func_195962_g() : (this.field_70170_p.field_73012_v.nextBoolean() ? enumDyeColor : \u2603);
        return \u2603;
    }

    @Override
    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    @Override
    public /* synthetic */ EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.func_90011_a(entityAgeable);
    }
}

