/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerInteract;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosestWithoutMoving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.loot.LootTableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityVillager
extends EntityAgeable
implements INpc,
IMerchant {
    private static final Logger field_190674_bx = LogManager.getLogger();
    private static final DataParameter<Integer> field_184752_bw = EntityDataManager.func_187226_a(EntityVillager.class, DataSerializers.field_187192_b);
    private int field_70955_e;
    private boolean field_70952_f;
    private boolean field_70953_g;
    private Village field_70954_d;
    @Nullable
    private EntityPlayer field_70962_h;
    @Nullable
    private MerchantRecipeList field_70963_i;
    private int field_70961_j;
    private boolean field_70959_by;
    private boolean field_175565_bs;
    private int field_70956_bz;
    private String field_82189_bL;
    private int field_175563_bv;
    private int field_175562_bw;
    private boolean field_82190_bM;
    private boolean field_175564_by;
    private final InventoryBasic field_175560_bz = new InventoryBasic(new TextComponentString("Items"), 8);
    private static final ITradeList[][][][] field_175561_bA = new ITradeList[][][][]{{{{new EmeraldForItems(Items.field_151015_O, new PriceInfo(18, 22)), new EmeraldForItems(Items.field_151174_bG, new PriceInfo(15, 19)), new EmeraldForItems(Items.field_151172_bF, new PriceInfo(15, 19)), new ListItemForEmeralds(Items.field_151025_P, new PriceInfo(-4, -2))}, {new EmeraldForItems(Blocks.field_150423_aK, new PriceInfo(8, 13)), new ListItemForEmeralds(Items.field_151158_bO, new PriceInfo(-3, -2))}, {new EmeraldForItems(Blocks.field_150440_ba, new PriceInfo(7, 12)), new ListItemForEmeralds(Items.field_151034_e, new PriceInfo(-7, -5))}, {new ListItemForEmeralds(Items.field_151106_aX, new PriceInfo(-10, -6)), new ListItemForEmeralds(Blocks.field_150414_aQ, new PriceInfo(1, 1))}}, {{new EmeraldForItems(Items.field_151007_F, new PriceInfo(15, 20)), new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ItemAndEmeraldToItem(Items.field_196086_aW, new PriceInfo(6, 6), Items.field_196102_ba, new PriceInfo(6, 6)), new ItemAndEmeraldToItem(Items.field_196087_aX, new PriceInfo(6, 6), Items.field_196104_bb, new PriceInfo(6, 6))}, {new ListEnchantedItemForEmeralds(Items.field_151112_aM, new PriceInfo(7, 8))}}, {{new EmeraldForItems(Blocks.field_196556_aL, new PriceInfo(16, 22)), new ListItemForEmeralds(Items.field_151097_aZ, new PriceInfo(3, 4))}, {new ListItemForEmeralds(new ItemStack(Blocks.field_196556_aL), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196557_aM), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196558_aN), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196559_aO), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196560_aP), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196561_aQ), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196562_aR), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196563_aS), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196564_aT), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196565_aU), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196566_aV), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196567_aW), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196568_aX), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196569_aY), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196570_aZ), new PriceInfo(1, 2)), new ListItemForEmeralds(new ItemStack(Blocks.field_196602_ba), new PriceInfo(1, 2))}}, {{new EmeraldForItems(Items.field_151007_F, new PriceInfo(15, 20)), new ListItemForEmeralds(Items.field_151032_g, new PriceInfo(-12, -8))}, {new ListItemForEmeralds(Items.field_151031_f, new PriceInfo(2, 3)), new ItemAndEmeraldToItem(Blocks.field_150351_n, new PriceInfo(10, 10), Items.field_151145_ak, new PriceInfo(6, 10))}}}, {{{new EmeraldForItems(Items.field_151121_aF, new PriceInfo(24, 36)), new ListEnchantedBookForEmeralds()}, {new EmeraldForItems(Items.field_151122_aG, new PriceInfo(8, 10)), new ListItemForEmeralds(Items.field_151111_aL, new PriceInfo(10, 12)), new ListItemForEmeralds(Blocks.field_150342_X, new PriceInfo(3, 4))}, {new EmeraldForItems(Items.field_151164_bB, new PriceInfo(2, 2)), new ListItemForEmeralds(Items.field_151113_aN, new PriceInfo(10, 12)), new ListItemForEmeralds(Blocks.field_150359_w, new PriceInfo(-5, -3))}, {new ListEnchantedBookForEmeralds()}, {new ListEnchantedBookForEmeralds()}, {new ListItemForEmeralds(Items.field_151057_cb, new PriceInfo(20, 22))}}, {{new EmeraldForItems(Items.field_151121_aF, new PriceInfo(24, 36))}, {new EmeraldForItems(Items.field_151111_aL, new PriceInfo(1, 1))}, {new ListItemForEmeralds(Items.field_151148_bJ, new PriceInfo(7, 11))}, {new TreasureMapForEmeralds(new PriceInfo(12, 20), "Monument", MapDecoration.Type.MONUMENT), new TreasureMapForEmeralds(new PriceInfo(16, 28), "Mansion", MapDecoration.Type.MANSION)}}}, {{{new EmeraldForItems(Items.field_151078_bh, new PriceInfo(36, 40)), new EmeraldForItems(Items.field_151043_k, new PriceInfo(8, 10))}, {new ListItemForEmeralds(Items.field_151137_ax, new PriceInfo(-4, -1)), new ListItemForEmeralds(new ItemStack(Items.field_196128_bn), new PriceInfo(-2, -1))}, {new ListItemForEmeralds(Items.field_151079_bi, new PriceInfo(4, 7)), new ListItemForEmeralds(Blocks.field_150426_aN, new PriceInfo(-3, -1))}, {new ListItemForEmeralds(Items.field_151062_by, new PriceInfo(3, 11))}}}, {{{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151028_Y, new PriceInfo(4, 6))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListItemForEmeralds(Items.field_151030_Z, new PriceInfo(10, 14))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151163_ad, new PriceInfo(16, 19))}, {new ListItemForEmeralds(Items.field_151029_X, new PriceInfo(5, 7)), new ListItemForEmeralds(Items.field_151022_W, new PriceInfo(9, 11)), new ListItemForEmeralds(Items.field_151020_U, new PriceInfo(5, 7)), new ListItemForEmeralds(Items.field_151023_V, new PriceInfo(11, 15))}}, {{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151036_c, new PriceInfo(6, 8))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListEnchantedItemForEmeralds(Items.field_151040_l, new PriceInfo(9, 10))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151048_u, new PriceInfo(12, 15)), new ListEnchantedItemForEmeralds(Items.field_151056_x, new PriceInfo(9, 12))}}, {{new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListEnchantedItemForEmeralds(Items.field_151037_a, new PriceInfo(5, 7))}, {new EmeraldForItems(Items.field_151042_j, new PriceInfo(7, 9)), new ListEnchantedItemForEmeralds(Items.field_151035_b, new PriceInfo(9, 11))}, {new EmeraldForItems(Items.field_151045_i, new PriceInfo(3, 4)), new ListEnchantedItemForEmeralds(Items.field_151046_w, new PriceInfo(12, 15))}}}, {{{new EmeraldForItems(Items.field_151147_al, new PriceInfo(14, 18)), new EmeraldForItems(Items.field_151076_bf, new PriceInfo(14, 18))}, {new EmeraldForItems(Items.field_151044_h, new PriceInfo(16, 24)), new ListItemForEmeralds(Items.field_151157_am, new PriceInfo(-7, -5)), new ListItemForEmeralds(Items.field_151077_bg, new PriceInfo(-8, -6))}}, {{new EmeraldForItems(Items.field_151116_aA, new PriceInfo(9, 12)), new ListItemForEmeralds(Items.field_151026_S, new PriceInfo(2, 4))}, {new ListEnchantedItemForEmeralds(Items.field_151027_R, new PriceInfo(7, 12))}, {new ListItemForEmeralds(Items.field_151141_av, new PriceInfo(8, 10))}}}, {new ITradeList[0][]}};

    public EntityVillager(World world) {
        this(world, 0);
    }

    public EntityVillager(World world, int n) {
        super(EntityType.field_200756_av, world);
        this.func_70938_b(n);
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntityZombie>(this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntityVex>(this, EntityVex.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, new EntityAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, new EntityAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, new EntityAIMoveIndoors(this));
        this.field_70714_bg.func_75776_a(3, new EntityAIRestrictOpenDoor(this));
        this.field_70714_bg.func_75776_a(4, new EntityAIOpenDoor(this, true));
        this.field_70714_bg.func_75776_a(5, new EntityAIMoveTowardsRestriction(this, 0.6));
        this.field_70714_bg.func_75776_a(6, new EntityAIVillagerMate(this));
        this.field_70714_bg.func_75776_a(7, new EntityAIFollowGolem(this));
        this.field_70714_bg.func_75776_a(9, new EntityAIWatchClosestWithoutMoving(this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, new EntityAIVillagerInteract(this));
        this.field_70714_bg.func_75776_a(9, new EntityAIWanderAvoidWater(this, 0.6));
        this.field_70714_bg.func_75776_a(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
    }

    private void func_175552_ct() {
        if (this.field_175564_by) {
            return;
        }
        this.field_175564_by = true;
        if (this.func_70631_g_()) {
            this.field_70714_bg.func_75776_a(8, new EntityAIPlay(this, 0.32));
        } else if (this.func_70946_n() == 0) {
            this.field_70714_bg.func_75776_a(6, new EntityAIHarvestFarmland(this, 0.6));
        }
    }

    @Override
    protected void func_175500_n() {
        if (this.func_70946_n() == 0) {
            this.field_70714_bg.func_75776_a(8, new EntityAIHarvestFarmland(this, 0.6));
        }
        super.func_175500_n();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    @Override
    protected void func_70619_bc() {
        if (--this.field_70955_e <= 0) {
            BlockPos blockPos = new BlockPos(this);
            this.field_70170_p.func_175714_ae().func_176060_a(blockPos);
            this.field_70955_e = 70 + this.field_70146_Z.nextInt(50);
            this.field_70954_d = this.field_70170_p.func_175714_ae().func_176056_a(blockPos, 32);
            if (this.field_70954_d == null) {
                this.func_110177_bN();
            } else {
                Object object = this.field_70954_d.func_180608_a();
                this.func_175449_a((BlockPos)object, this.field_70954_d.func_75568_b());
                if (this.field_82190_bM) {
                    this.field_82190_bM = false;
                    this.field_70954_d.func_82683_b(5);
                }
            }
        }
        if (!this.func_70940_q() && this.field_70961_j > 0) {
            --this.field_70961_j;
            if (this.field_70961_j <= 0) {
                if (this.field_70959_by) {
                    for (Object object : this.field_70963_i) {
                        if (!((MerchantRecipe)object).func_82784_g()) continue;
                        ((MerchantRecipe)object).func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.func_175554_cu();
                    this.field_70959_by = false;
                    if (this.field_70954_d != null && this.field_82189_bL != null) {
                        this.field_70170_p.func_72960_a(this, (byte)14);
                        this.field_70954_d.func_82688_a(this.field_82189_bL, 1);
                    }
                }
                this.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityPlayer, EnumHand enumHand) {
        ItemStack itemStack = entityPlayer.func_184586_b(enumHand);
        boolean bl = \u2603 = itemStack.func_77973_b() == Items.field_151057_cb;
        if (\u2603) {
            itemStack.func_111282_a(entityPlayer, this, enumHand);
            return true;
        }
        if (itemStack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_70940_q() && !this.func_70631_g_()) {
            if (this.field_70963_i == null) {
                this.func_175554_cu();
            }
            if (enumHand == EnumHand.MAIN_HAND) {
                entityPlayer.func_195066_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_70963_i.isEmpty()) {
                this.func_70932_a_(entityPlayer);
                entityPlayer.func_180472_a(this);
            } else if (this.field_70963_i.isEmpty()) {
                return super.func_184645_a(entityPlayer, enumHand);
            }
            return true;
        }
        return super.func_184645_a(entityPlayer, enumHand);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184752_bw, 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.func_70014_b(nBTTagCompound2);
        nBTTagCompound2.func_74768_a("Profession", this.func_70946_n());
        nBTTagCompound2.func_74768_a("Riches", this.field_70956_bz);
        nBTTagCompound2.func_74768_a("Career", this.field_175563_bv);
        nBTTagCompound2.func_74768_a("CareerLevel", this.field_175562_bw);
        nBTTagCompound2.func_74757_a("Willing", this.field_175565_bs);
        if (this.field_70963_i != null) {
            nBTTagCompound2.func_74782_a("Offers", this.field_70963_i.func_77202_a());
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_175560_bz.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            nBTTagList.add(itemStack.func_77955_b(new NBTTagCompound()));
        }
        nBTTagCompound2.func_74782_a("Inventory", nBTTagList);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        INBTBase \u26032;
        super.func_70037_a(nBTTagCompound2);
        this.func_70938_b(nBTTagCompound2.func_74762_e("Profession"));
        this.field_70956_bz = nBTTagCompound2.func_74762_e("Riches");
        this.field_175563_bv = nBTTagCompound2.func_74762_e("Career");
        this.field_175562_bw = nBTTagCompound2.func_74762_e("CareerLevel");
        this.field_175565_bs = nBTTagCompound2.func_74767_n("Willing");
        if (nBTTagCompound2.func_150297_b("Offers", 10)) {
            \u26032 = nBTTagCompound2.func_74775_l("Offers");
            this.field_70963_i = new MerchantRecipeList((NBTTagCompound)\u26032);
        }
        \u26032 = nBTTagCompound2.func_150295_c("Inventory", 10);
        for (int i = 0; i < ((NBTTagList)\u26032).size(); ++i) {
            ItemStack itemStack = ItemStack.func_199557_a(((NBTTagList)\u26032).func_150305_b(i));
            if (itemStack.func_190926_b()) continue;
            this.field_175560_bz.func_174894_a(itemStack);
        }
        this.func_98053_h(true);
        this.func_175552_ct();
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70940_q()) {
            return SoundEvents.field_187914_gn;
        }
        return SoundEvents.field_187910_gj;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187912_gl;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191184_at;
    }

    public void func_70938_b(int n) {
        this.field_70180_af.func_187227_b(field_184752_bw, n);
    }

    public int func_70946_n() {
        return Math.max(this.field_70180_af.func_187225_a(field_184752_bw) % 6, 0);
    }

    public boolean func_70941_o() {
        return this.field_70952_f;
    }

    public void func_70947_e(boolean bl) {
        this.field_70952_f = bl;
    }

    public void func_70939_f(boolean bl) {
        this.field_70953_g = bl;
    }

    public boolean func_70945_p() {
        return this.field_70953_g;
    }

    @Override
    public void func_70604_c(@Nullable EntityLivingBase entityLivingBase) {
        super.func_70604_c(entityLivingBase);
        if (this.field_70954_d != null && entityLivingBase != null) {
            this.field_70954_d.func_75575_a(entityLivingBase);
            if (entityLivingBase instanceof EntityPlayer) {
                int n = -1;
                if (this.func_70631_g_()) {
                    n = -3;
                }
                this.field_70954_d.func_82688_a(((EntityPlayer)entityLivingBase).func_146103_bH().getName(), n);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a(this, (byte)13);
                }
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource2) {
        DamageSource damageSource2;
        if (this.field_70954_d != null) {
            Entity entity = damageSource2.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.field_70954_d.func_82688_a(((EntityPlayer)entity).func_146103_bH().getName(), -2);
                } else if (entity instanceof IMob) {
                    this.field_70954_d.func_82692_h();
                }
            } else {
                EntityPlayer entityPlayer = this.field_70170_p.func_72890_a(this, 16.0);
                if (entityPlayer != null) {
                    this.field_70954_d.func_82692_h();
                }
            }
        }
        super.func_70645_a(damageSource2);
    }

    @Override
    public void func_70932_a_(@Nullable EntityPlayer entityPlayer) {
        this.field_70962_h = entityPlayer;
    }

    @Override
    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.field_70962_h;
    }

    public boolean func_70940_q() {
        return this.field_70962_h != null;
    }

    public boolean func_175550_n(boolean bl) {
        if (!this.field_175565_bs && bl && this.func_175553_cp()) {
            bl2 = false;
            for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
                boolean bl2;
                ItemStack itemStack = this.field_175560_bz.func_70301_a(i);
                if (!itemStack.func_190926_b()) {
                    if (itemStack.func_77973_b() == Items.field_151025_P && itemStack.func_190916_E() >= 3) {
                        bl2 = true;
                        this.field_175560_bz.func_70298_a(i, 3);
                    } else if ((itemStack.func_77973_b() == Items.field_151174_bG || itemStack.func_77973_b() == Items.field_151172_bF) && itemStack.func_190916_E() >= 12) {
                        bl2 = true;
                        this.field_175560_bz.func_70298_a(i, 12);
                    }
                }
                if (!bl2) continue;
                this.field_70170_p.func_72960_a(this, (byte)18);
                this.field_175565_bs = true;
                break;
            }
        }
        return this.field_175565_bs;
    }

    public void func_175549_o(boolean bl) {
        this.field_175565_bs = bl;
    }

    @Override
    public void func_70933_a(MerchantRecipe merchantRecipe) {
        merchantRecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int n = 3 + this.field_70146_Z.nextInt(4);
        if (merchantRecipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.field_70961_j = 40;
            this.field_70959_by = true;
            this.field_175565_bs = true;
            this.field_82189_bL = this.field_70962_h != null ? this.field_70962_h.func_146103_bH().getName() : null;
            n += 5;
        }
        if (merchantRecipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.field_70956_bz += merchantRecipe.func_77394_a().func_190916_E();
        }
        if (merchantRecipe.func_180322_j()) {
            this.field_70170_p.func_72838_d(new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, n));
        }
        if (this.field_70962_h instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192138_r.func_192234_a((EntityPlayerMP)this.field_70962_h, this, merchantRecipe.func_77397_d());
        }
    }

    @Override
    public void func_110297_a_(ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(itemStack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer entityPlayer) {
        if (this.field_70963_i == null) {
            this.func_175554_cu();
        }
        return this.field_70963_i;
    }

    private void func_175554_cu() {
        ITradeList[][][] iTradeListArray = field_175561_bA[this.func_70946_n()];
        if (this.field_175563_bv == 0 || this.field_175562_bw == 0) {
            this.field_175563_bv = this.field_70146_Z.nextInt(iTradeListArray.length) + 1;
            this.field_175562_bw = 1;
        } else {
            ++this.field_175562_bw;
        }
        if (this.field_70963_i == null) {
            this.field_70963_i = new MerchantRecipeList();
        }
        int \u26032 = this.field_175563_bv - 1;
        int \u26033 = this.field_175562_bw - 1;
        if (\u26032 < 0 || \u26032 >= iTradeListArray.length) {
            return;
        }
        ITradeList[][] \u26034 = iTradeListArray[\u26032];
        if (\u26033 >= 0 && \u26033 < \u26034.length) {
            for (ITradeList iTradeList : \u2603 = \u26034[\u26033]) {
                iTradeList.func_190888_a(this, this.field_70963_i, this.field_70146_Z);
            }
        }
    }

    @Override
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Override
    public BlockPos func_190671_u_() {
        return new BlockPos(this);
    }

    @Override
    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        ITextComponent \u26032 = this.func_200201_e();
        if (\u26032 != null) {
            return ScorePlayerTeam.func_200541_a(team, \u26032).func_211710_a(style -> style.func_150209_a(this.func_174823_aP()).func_179989_a(this.func_189512_bd()));
        }
        if (this.field_70963_i == null) {
            this.func_175554_cu();
        }
        String \u26033 = null;
        switch (this.func_70946_n()) {
            case 0: {
                if (this.field_175563_bv == 1) {
                    \u26033 = "farmer";
                    break;
                }
                if (this.field_175563_bv == 2) {
                    \u26033 = "fisherman";
                    break;
                }
                if (this.field_175563_bv == 3) {
                    \u26033 = "shepherd";
                    break;
                }
                if (this.field_175563_bv != 4) break;
                \u26033 = "fletcher";
                break;
            }
            case 1: {
                if (this.field_175563_bv == 1) {
                    \u26033 = "librarian";
                    break;
                }
                if (this.field_175563_bv != 2) break;
                \u26033 = "cartographer";
                break;
            }
            case 2: {
                \u26033 = "cleric";
                break;
            }
            case 3: {
                if (this.field_175563_bv == 1) {
                    \u26033 = "armorer";
                    break;
                }
                if (this.field_175563_bv == 2) {
                    \u26033 = "weapon_smith";
                    break;
                }
                if (this.field_175563_bv != 3) break;
                \u26033 = "tool_smith";
                break;
            }
            case 4: {
                if (this.field_175563_bv == 1) {
                    \u26033 = "butcher";
                    break;
                }
                if (this.field_175563_bv != 2) break;
                \u26033 = "leatherworker";
                break;
            }
            case 5: {
                \u26033 = "nitwit";
            }
        }
        if (\u26033 != null) {
            ITextComponent iTextComponent = new TextComponentTranslation(this.func_200600_R().func_210760_d() + '.' + \u26033, new Object[0]).func_211710_a(style -> style.func_150209_a(this.func_174823_aP()).func_179989_a(this.func_189512_bd()));
            if (team != null) {
                iTextComponent.func_211708_a(team.func_178775_l());
            }
            return iTextComponent;
        }
        return super.func_145748_c_();
    }

    @Override
    public float func_70047_e() {
        if (this.func_70631_g_()) {
            return 0.81f;
        }
        return 1.62f;
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData, @Nullable NBTTagCompound nBTTagCompound) {
        return this.func_190672_a(difficultyInstance, iEntityLivingData, nBTTagCompound, true);
    }

    public IEntityLivingData func_190672_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound, boolean bl) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        if (bl) {
            this.func_70938_b(this.field_70170_p.field_73012_v.nextInt(6));
        }
        this.func_175552_ct();
        this.func_175554_cu();
        return iEntityLivingData2;
    }

    public void func_82187_q() {
        this.field_82190_bM = true;
    }

    @Override
    public EntityVillager func_90011_a(EntityAgeable entityAgeable) {
        EntityVillager entityVillager = new EntityVillager(this.field_70170_p);
        entityVillager.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos(entityVillager)), null, null);
        return entityVillager;
    }

    @Override
    public boolean func_184652_a(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return;
        }
        EntityWitch entityWitch = new EntityWitch(this.field_70170_p);
        entityWitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        entityWitch.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos(entityWitch)), null, null);
        entityWitch.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            entityWitch.func_200203_b(this.func_200201_e());
            entityWitch.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d(entityWitch);
        this.func_70106_y();
    }

    public InventoryBasic func_175551_co() {
        return this.field_175560_bz;
    }

    @Override
    protected void func_175445_a(EntityItem entityItem) {
        ItemStack itemStack = entityItem.func_92059_d();
        Item \u26032 = itemStack.func_77973_b();
        if (this.func_175558_a(\u26032)) {
            \u2603 = this.field_175560_bz.func_174894_a(itemStack);
            if (\u2603.func_190926_b()) {
                entityItem.func_70106_y();
            } else {
                itemStack.func_190920_e(\u2603.func_190916_E());
            }
        }
    }

    private boolean func_175558_a(Item item) {
        return item == Items.field_151025_P || item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_151015_O || item == Items.field_151014_N || item == Items.field_185164_cV || item == Items.field_185163_cU;
    }

    public boolean func_175553_cp() {
        return this.func_175559_s(1);
    }

    public boolean func_175555_cq() {
        return this.func_175559_s(2);
    }

    public boolean func_175557_cr() {
        boolean bl;
        boolean bl2 = bl = this.func_70946_n() == 0;
        if (bl) {
            return !this.func_175559_s(5);
        }
        return !this.func_175559_s(1);
    }

    private boolean func_175559_s(int n) {
        boolean bl = this.func_70946_n() == 0;
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_175560_bz.func_70301_a(i);
            Item \u26032 = itemStack.func_77973_b();
            int \u26033 = itemStack.func_190916_E();
            if (\u26032 == Items.field_151025_P && \u26033 >= 3 * n || \u26032 == Items.field_151174_bG && \u26033 >= 12 * n || \u26032 == Items.field_151172_bF && \u26033 >= 12 * n || \u26032 == Items.field_185164_cV && \u26033 >= 12 * n) {
                return true;
            }
            if (!bl || \u26032 != Items.field_151015_O || \u26033 < 9 * n) continue;
            return true;
        }
        return false;
    }

    public boolean func_175556_cs() {
        for (int i = 0; i < this.field_175560_bz.func_70302_i_(); ++i) {
            Item item = this.field_175560_bz.func_70301_a(i).func_77973_b();
            if (item != Items.field_151014_N && item != Items.field_151174_bG && item != Items.field_151172_bF && item != Items.field_185163_cU) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (super.func_174820_d(n, itemStack)) {
            return true;
        }
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.field_175560_bz.func_70302_i_()) {
            this.field_175560_bz.func_70299_a(n2, itemStack);
            return true;
        }
        return false;
    }

    @Override
    public /* synthetic */ EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.func_90011_a(entityAgeable);
    }

    static class ItemAndEmeraldToItem
    implements ITradeList {
        public ItemStack field_199763_a;
        public PriceInfo field_179409_b;
        public ItemStack field_199764_c;
        public PriceInfo field_179408_d;

        public ItemAndEmeraldToItem(IItemProvider iItemProvider, PriceInfo priceInfo, Item item, PriceInfo priceInfo2) {
            this.field_199763_a = new ItemStack(iItemProvider);
            this.field_179409_b = priceInfo;
            this.field_199764_c = new ItemStack(item);
            this.field_179408_d = priceInfo2;
        }

        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            int n = this.field_179409_b.func_179412_a(random);
            \u2603 = this.field_179408_d.func_179412_a(random);
            merchantRecipeList.add(new MerchantRecipe(new ItemStack(this.field_199763_a.func_77973_b(), n), new ItemStack(Items.field_151166_bC), new ItemStack(this.field_199764_c.func_77973_b(), \u2603)));
        }
    }

    static class TreasureMapForEmeralds
    implements ITradeList {
        public PriceInfo field_190889_a;
        public String field_190890_b;
        public MapDecoration.Type field_190891_c;

        public TreasureMapForEmeralds(PriceInfo priceInfo, String string, MapDecoration.Type type) {
            this.field_190889_a = priceInfo;
            this.field_190890_b = string;
            this.field_190891_c = type;
        }

        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            int n = this.field_190889_a.func_179412_a(random);
            World \u26032 = iMerchant.func_190670_t_();
            BlockPos \u26033 = \u26032.func_211157_a(this.field_190890_b, iMerchant.func_190671_u_(), 100, true);
            if (\u26033 != null) {
                ItemStack itemStack = ItemMap.func_195952_a(\u26032, \u26033.func_177958_n(), \u26033.func_177952_p(), (byte)2, true, true);
                ItemMap.func_190905_a(\u26032, itemStack);
                MapData.func_191094_a(itemStack, \u26033, "+", this.field_190891_c);
                itemStack.func_200302_a(new TextComponentTranslation("filled_map." + this.field_190890_b.toLowerCase(Locale.ROOT), new Object[0]));
                merchantRecipeList.add(new MerchantRecipe(new ItemStack(Items.field_151166_bC, n), new ItemStack(Items.field_151111_aL), itemStack));
            }
        }
    }

    static class ListEnchantedBookForEmeralds
    implements ITradeList {
        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            Enchantment enchantment = IRegistry.field_212628_q.func_186801_a(random);
            int \u26032 = MathHelper.func_76136_a(random, enchantment.func_77319_d(), enchantment.func_77325_b());
            ItemStack \u26033 = ItemEnchantedBook.func_92111_a(new EnchantmentData(enchantment, \u26032));
            int \u26034 = 2 + random.nextInt(5 + \u26032 * 10) + 3 * \u26032;
            if (enchantment.func_185261_e()) {
                \u26034 *= 2;
            }
            if (\u26034 > 64) {
                \u26034 = 64;
            }
            merchantRecipeList.add(new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, \u26034), \u26033));
        }
    }

    static class ListEnchantedItemForEmeralds
    implements ITradeList {
        public ItemStack field_179407_a;
        public PriceInfo field_179406_b;

        public ListEnchantedItemForEmeralds(Item item, PriceInfo priceInfo) {
            this.field_179407_a = new ItemStack(item);
            this.field_179406_b = priceInfo;
        }

        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            int n = 1;
            if (this.field_179406_b != null) {
                n = this.field_179406_b.func_179412_a(random);
            }
            ItemStack \u26032 = new ItemStack(Items.field_151166_bC, n);
            ItemStack \u26033 = EnchantmentHelper.func_77504_a(random, new ItemStack(this.field_179407_a.func_77973_b()), 5 + random.nextInt(15), false);
            merchantRecipeList.add(new MerchantRecipe(\u26032, \u26033));
        }
    }

    static class ListItemForEmeralds
    implements ITradeList {
        public ItemStack field_179403_a;
        public PriceInfo field_179402_b;

        public ListItemForEmeralds(Block block, PriceInfo priceInfo) {
            this(new ItemStack(block), priceInfo);
        }

        public ListItemForEmeralds(Item item, PriceInfo priceInfo) {
            this(new ItemStack(item), priceInfo);
        }

        public ListItemForEmeralds(ItemStack itemStack, PriceInfo priceInfo) {
            this.field_179403_a = itemStack;
            this.field_179402_b = priceInfo;
        }

        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            ItemStack \u26033;
            ItemStack \u26032;
            int n = 1;
            if (this.field_179402_b != null) {
                n = this.field_179402_b.func_179412_a(random);
            }
            if (n < 0) {
                \u26032 = new ItemStack(Items.field_151166_bC);
                \u26033 = new ItemStack(this.field_179403_a.func_77973_b(), -n);
            } else {
                \u26032 = new ItemStack(Items.field_151166_bC, n);
                \u26033 = new ItemStack(this.field_179403_a.func_77973_b());
            }
            merchantRecipeList.add(new MerchantRecipe(\u26032, \u26033));
        }
    }

    static class EmeraldForItems
    implements ITradeList {
        public Item field_179405_a;
        public PriceInfo field_179404_b;

        public EmeraldForItems(IItemProvider iItemProvider, PriceInfo priceInfo) {
            this.field_179405_a = iItemProvider.func_199767_j();
            this.field_179404_b = priceInfo;
        }

        @Override
        public void func_190888_a(IMerchant iMerchant, MerchantRecipeList merchantRecipeList, Random random) {
            ItemStack itemStack = new ItemStack(this.field_179405_a, this.field_179404_b == null ? 1 : this.field_179404_b.func_179412_a(random));
            merchantRecipeList.add(new MerchantRecipe(itemStack, Items.field_151166_bC));
        }
    }

    static interface ITradeList {
        public void func_190888_a(IMerchant var1, MerchantRecipeList var2, Random var3);
    }

    static class PriceInfo
    extends Tuple<Integer, Integer> {
        public PriceInfo(int n, int n2) {
            super(n, n2);
            if (n2 < n) {
                field_190674_bx.warn("PriceRange({}, {}) invalid, {} smaller than {}", (Object)n, (Object)n2, (Object)n2, (Object)n);
            }
        }

        public int func_179412_a(Random random) {
            if ((Integer)this.func_76341_a() >= (Integer)this.func_76340_b()) {
                return (Integer)this.func_76341_a();
            }
            return (Integer)this.func_76341_a() + random.nextInt((Integer)this.func_76340_b() - (Integer)this.func_76341_a() + 1);
        }
    }
}

