/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketCamera;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketCloseWindow;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerLook;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.CooldownTrackerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.GameType;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.loot.ILootContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPlayerMP
extends EntityPlayer
implements IContainerListener {
    private static final Logger field_147102_bM = LogManager.getLogger();
    private String field_71148_cg = "en_US";
    public NetHandlerPlayServer field_71135_a;
    public final MinecraftServer field_71133_b;
    public final PlayerInteractionManager field_71134_c;
    public double field_71131_d;
    public double field_71132_e;
    private final List<Integer> field_71130_g = Lists.newLinkedList();
    private final PlayerAdvancements field_192042_bX;
    private final StatisticsManagerServer field_147103_bO;
    private float field_130068_bO = Float.MIN_VALUE;
    private int field_184852_bV = Integer.MIN_VALUE;
    private int field_184853_bW = Integer.MIN_VALUE;
    private int field_184854_bX = Integer.MIN_VALUE;
    private int field_184855_bY = Integer.MIN_VALUE;
    private int field_184856_bZ = Integer.MIN_VALUE;
    private float field_71149_ch = -1.0E8f;
    private int field_71146_ci = -99999999;
    private boolean field_71147_cj = true;
    private int field_71144_ck = -99999999;
    private int field_147101_bU = 60;
    private EntityPlayer.EnumChatVisibility field_71143_cn;
    private boolean field_71140_co = true;
    private long field_143005_bX = Util.func_211177_b();
    private Entity field_175401_bS;
    private boolean field_184851_cj;
    private boolean field_192040_cp;
    private final ServerRecipeBook field_192041_cq;
    private Vec3d field_193107_ct;
    private int field_193108_cu;
    private boolean field_193109_cv;
    private Vec3d field_193110_cw;
    private int field_71139_cq;
    public boolean field_71137_h;
    public int field_71138_i;
    public boolean field_71136_j;

    public EntityPlayerMP(MinecraftServer minecraftServer, WorldServer worldServer, GameProfile gameProfile, PlayerInteractionManager playerInteractionManager) {
        super(worldServer, gameProfile);
        playerInteractionManager.field_73090_b = this;
        this.field_71134_c = playerInteractionManager;
        this.field_71133_b = minecraftServer;
        this.field_192041_cq = new ServerRecipeBook(minecraftServer.func_199529_aN());
        this.field_147103_bO = minecraftServer.func_184103_al().func_152602_a(this);
        this.field_192042_bX = minecraftServer.func_184103_al().func_192054_h(this);
        this.field_70138_W = 1.0f;
        this.func_205734_a(worldServer);
    }

    private void func_205734_a(WorldServer worldServer) {
        BlockPos blockPos = worldServer.func_175694_M();
        if (worldServer.field_73011_w.func_191066_m() && worldServer.func_72912_H().func_76077_q() != GameType.ADVENTURE) {
            int n = Math.max(0, this.field_71133_b.func_184108_a(worldServer));
            \u2603 = MathHelper.func_76128_c(worldServer.func_175723_af().func_177729_b(blockPos.func_177958_n(), blockPos.func_177952_p()));
            if (\u2603 < n) {
                n = \u2603;
            }
            if (\u2603 <= 1) {
                n = 1;
            }
            \u2603 = (n * 2 + 1) * (n * 2 + 1);
            \u2603 = this.func_205735_q(\u2603);
            \u2603 = new Random().nextInt(\u2603);
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u2603 = (\u2603 + \u2603 * \u2603) % \u2603;
                \u2603 = \u2603 % (n * 2 + 1);
                \u2603 = \u2603 / (n * 2 + 1);
                BlockPos blockPos2 = worldServer.func_201675_m().func_206921_a(blockPos.func_177958_n() + \u2603 - n, blockPos.func_177952_p() + \u2603 - n, false);
                if (blockPos2 == null) continue;
                this.func_174828_a(blockPos2, 0.0f, 0.0f);
                if (!worldServer.func_195586_b(this, this.func_174813_aQ())) {
                    continue;
                }
                break;
            }
        } else {
            this.func_174828_a(blockPos, 0.0f, 0.0f);
            while (!worldServer.func_195586_b(this, this.func_174813_aQ()) && this.field_70163_u < 255.0) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
            }
        }
    }

    private int func_205735_q(int n) {
        return n <= 16 ? n - 1 : 17;
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        if (nBTTagCompound.func_150297_b("playerGameType", 99)) {
            if (this.func_184102_h().func_104056_am()) {
                this.field_71134_c.func_73076_a(this.func_184102_h().func_71265_f());
            } else {
                this.field_71134_c.func_73076_a(GameType.func_77146_a(nBTTagCompound.func_74762_e("playerGameType")));
            }
        }
        if (nBTTagCompound.func_150297_b("enteredNetherPosition", 10)) {
            \u2603 = nBTTagCompound.func_74775_l("enteredNetherPosition");
            this.field_193110_cw = new Vec3d(\u2603.func_74769_h("x"), \u2603.func_74769_h("y"), \u2603.func_74769_h("z"));
        }
        this.field_192040_cp = nBTTagCompound.func_74767_n("seenCredits");
        if (nBTTagCompound.func_150297_b("recipeBook", 10)) {
            this.field_192041_cq.func_192825_a(nBTTagCompound.func_74775_l("recipeBook"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        Object object;
        super.func_70014_b(nBTTagCompound2);
        nBTTagCompound2.func_74768_a("playerGameType", this.field_71134_c.func_73081_b().func_77148_a());
        nBTTagCompound2.func_74757_a("seenCredits", this.field_192040_cp);
        if (this.field_193110_cw != null) {
            object = new NBTTagCompound();
            ((NBTTagCompound)object).func_74780_a("x", this.field_193110_cw.field_72450_a);
            ((NBTTagCompound)object).func_74780_a("y", this.field_193110_cw.field_72448_b);
            ((NBTTagCompound)object).func_74780_a("z", this.field_193110_cw.field_72449_c);
            nBTTagCompound2.func_74782_a("enteredNetherPosition", (INBTBase)object);
        }
        object = this.func_184208_bv();
        Entity \u26032 = this.func_184187_bx();
        if (\u26032 != null && object != this && ((Entity)object).func_200601_bK()) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            \u2603 = new NBTTagCompound();
            ((Entity)object).func_70039_c(\u2603);
            nBTTagCompound3.func_186854_a("Attach", \u26032.func_110124_au());
            nBTTagCompound3.func_74782_a("Entity", \u2603);
            nBTTagCompound2.func_74782_a("RootVehicle", nBTTagCompound3);
        }
        nBTTagCompound2.func_74782_a("recipeBook", this.field_192041_cq.func_192824_e());
    }

    public void func_195394_a(int n) {
        float f = this.func_71050_bK();
        \u2603 = (f - 1.0f) / f;
        this.field_71106_cc = MathHelper.func_76131_a((float)n / f, 0.0f, \u2603);
        this.field_71144_ck = -1;
    }

    public void func_195399_b(int n) {
        this.field_71068_ca = n;
        this.field_71144_ck = -1;
    }

    @Override
    public void func_82242_a(int n) {
        super.func_82242_a(n);
        this.field_71144_ck = -1;
    }

    @Override
    public void func_192024_a(ItemStack itemStack, int n) {
        super.func_192024_a(itemStack, n);
        this.field_71144_ck = -1;
    }

    public void func_71116_b() {
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_152111_bt() {
        super.func_152111_bt();
        this.field_71135_a.func_147359_a(new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTER_COMBAT));
    }

    @Override
    public void func_152112_bu() {
        super.func_152112_bu();
        this.field_71135_a.func_147359_a(new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.END_COMBAT));
    }

    @Override
    protected void func_191955_a(IBlockState iBlockState) {
        CriteriaTriggers.field_192124_d.func_192193_a(this, iBlockState);
    }

    @Override
    protected CooldownTracker func_184815_l() {
        return new CooldownTrackerServer(this);
    }

    @Override
    public void func_70071_h_() {
        this.field_71134_c.func_73075_a();
        --this.field_147101_bU;
        if (this.field_70172_ad > 0) {
            --this.field_70172_ad;
        }
        this.field_71070_bA.func_75142_b();
        if (!this.field_70170_p.field_72995_K && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        while (!this.field_71130_g.isEmpty()) {
            int n = Math.min(this.field_71130_g.size(), Integer.MAX_VALUE);
            int[] \u26032 = new int[n];
            Iterator<Integer> \u26033 = this.field_71130_g.iterator();
            \u2603 = 0;
            while (\u26033.hasNext() && \u2603 < n) {
                \u26032[\u2603++] = \u26033.next();
                \u26033.remove();
            }
            this.field_71135_a.func_147359_a(new SPacketDestroyEntities(\u26032));
        }
        Entity entity = this.func_175398_C();
        if (entity != this) {
            if (entity.func_70089_S()) {
                this.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                this.field_71133_b.func_184103_al().func_72358_d(this);
                if (this.func_70093_af()) {
                    this.func_175399_e(this);
                }
            } else {
                this.func_175399_e(this);
            }
        }
        CriteriaTriggers.field_193135_v.func_193182_a(this);
        if (this.field_193107_ct != null) {
            CriteriaTriggers.field_193133_t.func_193162_a(this, this.field_193107_ct, this.field_70173_aa - this.field_193108_cu);
        }
        this.field_192042_bX.func_192741_b(this);
    }

    public void func_71127_g() {
        try {
            super.func_70071_h_();
            for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = this.field_71071_by.func_70301_a(i);
                if (!itemStack.func_77973_b().func_77643_m_() || (\u2603 = ((ItemMapBase)itemStack.func_77973_b()).func_150911_c(itemStack, this.field_70170_p, this)) == null) continue;
                this.field_71135_a.func_147359_a(\u2603);
            }
            if (this.func_110143_aJ() != this.field_71149_ch || this.field_71146_ci != this.field_71100_bB.func_75116_a() || this.field_71100_bB.func_75115_e() == 0.0f != this.field_71147_cj) {
                this.field_71135_a.func_147359_a(new SPacketUpdateHealth(this.func_110143_aJ(), this.field_71100_bB.func_75116_a(), this.field_71100_bB.func_75115_e()));
                this.field_71149_ch = this.func_110143_aJ();
                this.field_71146_ci = this.field_71100_bB.func_75116_a();
                boolean bl = this.field_71147_cj = this.field_71100_bB.func_75115_e() == 0.0f;
            }
            if (this.func_110143_aJ() + this.func_110139_bj() != this.field_130068_bO) {
                this.field_130068_bO = this.func_110143_aJ() + this.func_110139_bj();
                this.func_184849_a(ScoreCriteria.field_96638_f, MathHelper.func_76123_f(this.field_130068_bO));
            }
            if (this.field_71100_bB.func_75116_a() != this.field_184852_bV) {
                this.field_184852_bV = this.field_71100_bB.func_75116_a();
                this.func_184849_a(ScoreCriteria.field_186698_h, MathHelper.func_76123_f(this.field_184852_bV));
            }
            if (this.func_70086_ai() != this.field_184853_bW) {
                this.field_184853_bW = this.func_70086_ai();
                this.func_184849_a(ScoreCriteria.field_186699_i, MathHelper.func_76123_f(this.field_184853_bW));
            }
            if (this.func_70658_aO() != this.field_184854_bX) {
                this.field_184854_bX = this.func_70658_aO();
                this.func_184849_a(ScoreCriteria.field_186700_j, MathHelper.func_76123_f(this.field_184854_bX));
            }
            if (this.field_71067_cb != this.field_184856_bZ) {
                this.field_184856_bZ = this.field_71067_cb;
                this.func_184849_a(ScoreCriteria.field_186701_k, MathHelper.func_76123_f(this.field_184856_bZ));
            }
            if (this.field_71068_ca != this.field_184855_bY) {
                this.field_184855_bY = this.field_71068_ca;
                this.func_184849_a(ScoreCriteria.field_186702_l, MathHelper.func_76123_f(this.field_184855_bY));
            }
            if (this.field_71067_cb != this.field_71144_ck) {
                this.field_71144_ck = this.field_71067_cb;
                this.field_71135_a.func_147359_a(new SPacketSetExperience(this.field_71106_cc, this.field_71067_cb, this.field_71068_ca));
            }
            if (this.field_70173_aa % 20 == 0) {
                CriteriaTriggers.field_192135_o.func_192215_a(this);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking player");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Player being ticked");
            this.func_85029_a(\u26032);
            throw new ReportedException(crashReport);
        }
    }

    private void func_184849_a(ScoreCriteria scoreCriteria, int n) {
        this.func_96123_co().func_197893_a(scoreCriteria, this.func_195047_I_(), score -> score.func_96647_c(n));
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        boolean bl = this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
        if (bl) {
            Object object = this.func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a(new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, (ITextComponent)object), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> this.func_212356_a((ITextComponent)object, arg_0)));
            Team \u26032 = this.func_96124_cp();
            if (\u26032 == null || \u26032.func_178771_j() == Team.EnumVisible.ALWAYS) {
                this.field_71133_b.func_184103_al().func_148539_a((ITextComponent)object);
            } else if (\u26032.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                this.field_71133_b.func_184103_al().func_177453_a(this, (ITextComponent)object);
            } else if (\u26032.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                this.field_71133_b.func_184103_al().func_177452_b(this, (ITextComponent)object);
            }
        } else {
            this.field_71135_a.func_147359_a(new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (!this.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.func_175149_v()) {
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
        }
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        object = this.func_94060_bK();
        if (object != null) {
            this.func_71029_a(StatList.field_199091_i.func_199076_b(((Entity)object).func_200600_R()));
            ((Entity)object).func_191956_a(this, this.field_70744_aE, damageSource);
        }
        this.func_195066_a(StatList.field_188069_A);
        this.func_175145_a(StatList.field_199092_j.func_199076_b(StatList.field_188098_h));
        this.func_175145_a(StatList.field_199092_j.func_199076_b(StatList.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Override
    public void func_191956_a(Entity entity, int n, DamageSource damageSource) {
        if (entity == this) {
            return;
        }
        super.func_191956_a(entity, n, damageSource);
        this.func_85039_t(n);
        String string = this.func_195047_I_();
        \u2603 = entity.func_195047_I_();
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96640_e, string, Score::func_96648_a);
        if (entity instanceof EntityPlayer) {
            this.func_195066_a(StatList.field_75932_A);
            this.func_96123_co().func_197893_a(ScoreCriteria.field_96639_d, string, Score::func_96648_a);
        } else {
            this.func_195066_a(StatList.field_188070_B);
        }
        this.func_195398_a(string, \u2603, ScoreCriteria.field_197913_m);
        this.func_195398_a(\u2603, string, ScoreCriteria.field_197914_n);
        CriteriaTriggers.field_192122_b.func_192211_a(this, entity, damageSource);
    }

    private void func_195398_a(String string, String string2, ScoreCriteria[] scoreCriteriaArray) {
        ScorePlayerTeam scorePlayerTeam = this.func_96123_co().func_96509_i(string2);
        if (scorePlayerTeam != null && (\u2603 = scorePlayerTeam.func_178775_l().func_175746_b()) >= 0 && \u2603 < scoreCriteriaArray.length) {
            this.func_96123_co().func_197893_a(scoreCriteriaArray[\u2603], string, Score::func_96648_a);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        boolean bl = \u2603 = this.field_71133_b.func_71262_S() && this.func_175400_cq() && "fall".equals(damageSource2.field_76373_n);
        if (!\u2603 && this.field_147101_bU > 0 && damageSource2 != DamageSource.field_76380_i) {
            return false;
        }
        if (damageSource2 instanceof EntityDamageSource) {
            Entity entity = damageSource2.func_76346_g();
            if (entity instanceof EntityPlayer && !this.func_96122_a((EntityPlayer)entity)) {
                return false;
            }
            if (entity instanceof EntityArrow && (\u2603 = (\u2603 = (EntityArrow)entity).func_212360_k()) instanceof EntityPlayer && !this.func_96122_a((EntityPlayer)\u2603)) {
                return false;
            }
        }
        return super.func_70097_a(damageSource2, f);
    }

    @Override
    public boolean func_96122_a(EntityPlayer entityPlayer) {
        if (!this.func_175400_cq()) {
            return false;
        }
        return super.func_96122_a(entityPlayer);
    }

    private boolean func_175400_cq() {
        return this.field_71133_b.func_71219_W();
    }

    @Override
    @Nullable
    public Entity func_212321_a(DimensionType dimensionType) {
        this.field_184851_cj = true;
        if (this.field_71093_bK == DimensionType.OVERWORLD && dimensionType == DimensionType.NETHER) {
            this.field_193110_cw = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else if (this.field_71093_bK != DimensionType.NETHER && dimensionType != DimensionType.OVERWORLD) {
            this.field_193110_cw = null;
        }
        if (this.field_71093_bK == DimensionType.THE_END && dimensionType == DimensionType.THE_END) {
            this.field_70170_p.func_72900_e(this);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a(new SPacketChangeGameState(4, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return this;
        }
        if (this.field_71093_bK == DimensionType.OVERWORLD && dimensionType == DimensionType.THE_END) {
            dimensionType = DimensionType.THE_END;
        }
        this.field_71133_b.func_184103_al().func_187242_a(this, dimensionType);
        this.field_71135_a.func_147359_a(new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        return this;
    }

    @Override
    public boolean func_174827_a(EntityPlayerMP entityPlayerMP) {
        if (entityPlayerMP.func_175149_v()) {
            return this.func_175398_C() == this;
        }
        if (this.func_175149_v()) {
            return false;
        }
        return super.func_174827_a(entityPlayerMP);
    }

    private void func_147097_b(TileEntity tileEntity) {
        if (tileEntity != null && (\u2603 = tileEntity.func_189518_D_()) != null) {
            this.field_71135_a.func_147359_a(\u2603);
        }
    }

    @Override
    public void func_71001_a(Entity entity, int n) {
        super.func_71001_a(entity, n);
        this.field_71070_bA.func_75142_b();
    }

    @Override
    public EntityPlayer.SleepResult func_180469_a(BlockPos blockPos) {
        EntityPlayer.SleepResult sleepResult = super.func_180469_a(blockPos);
        if (sleepResult == EntityPlayer.SleepResult.OK) {
            this.func_195066_a(StatList.field_188064_ad);
            SPacketUseBed sPacketUseBed = new SPacketUseBed(this, blockPos);
            this.func_71121_q().func_73039_n().func_151247_a(this, sPacketUseBed);
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_71135_a.func_147359_a(sPacketUseBed);
            CriteriaTriggers.field_192136_p.func_192215_a(this);
        }
        return sleepResult;
    }

    @Override
    public void func_70999_a(boolean bl, boolean bl2, boolean bl3) {
        if (this.func_70608_bn()) {
            this.func_71121_q().func_73039_n().func_151248_b(this, new SPacketAnimation(this, 2));
        }
        super.func_70999_a(bl, bl2, bl3);
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_184205_a(Entity entity, boolean bl) {
        Entity entity2 = this.func_184187_bx();
        if (!super.func_184205_a(entity, bl)) {
            return false;
        }
        \u2603 = this.func_184187_bx();
        if (\u2603 != entity2 && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        \u2603 = this.func_184187_bx();
        if (\u2603 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource damageSource) {
        return super.func_180431_b(damageSource) || this.func_184850_K();
    }

    @Override
    protected void func_184231_a(double d, boolean bl, IBlockState iBlockState, BlockPos blockPos) {
    }

    @Override
    protected void func_184594_b(BlockPos blockPos) {
        if (!this.func_175149_v()) {
            super.func_184594_b(blockPos);
        }
    }

    public void func_71122_b(double d, boolean bl) {
        int n = MathHelper.func_76128_c(this.field_70165_t);
        BlockPos \u26032 = new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.field_70163_u - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.field_70161_v));
        IBlockState \u26033 = this.field_70170_p.func_180495_p(\u26032);
        if (\u26033.func_196958_f() && ((\u2603 = (\u2603 = this.field_70170_p.func_180495_p(\u2603 = \u26032.func_177977_b())).func_177230_c()) instanceof BlockFence || \u2603 instanceof BlockWall || \u2603 instanceof BlockFenceGate)) {
            \u26032 = \u2603;
            \u26033 = \u2603;
        }
        super.func_184231_a(d, bl, \u26033, \u26032);
    }

    @Override
    public void func_175141_a(TileEntitySign tileEntitySign) {
        tileEntitySign.func_145912_a(this);
        this.field_71135_a.func_147359_a(new SPacketSignEditorOpen(tileEntitySign.func_174877_v()));
    }

    private void func_71117_bO() {
        this.field_71139_cq = this.field_71139_cq % 100 + 1;
    }

    @Override
    public void func_180468_a(IInteractionObject iInteractionObject) {
        if (iInteractionObject instanceof ILootContainer && ((ILootContainer)((Object)iInteractionObject)).func_184276_b() != null && this.func_175149_v()) {
            this.func_146105_b(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
            return;
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a(new SPacketOpenWindow(this.field_71139_cq, iInteractionObject.func_174875_k(), iInteractionObject.func_145748_c_()));
        this.field_71070_bA = iInteractionObject.func_174876_a(this.field_71071_by, this);
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_71007_a(IInventory iInventory) {
        if (iInventory instanceof ILootContainer && ((ILootContainer)((Object)iInventory)).func_184276_b() != null && this.func_175149_v()) {
            this.func_146105_b(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
            return;
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        if (iInventory instanceof ILockableContainer && (\u2603 = (ILockableContainer)iInventory).func_174893_q_() && !this.func_175146_a(\u2603.func_174891_i()) && !this.func_175149_v()) {
            this.field_71135_a.func_147359_a(new SPacketChat(new TextComponentTranslation("container.isLocked", iInventory.func_145748_c_()), ChatType.GAME_INFO));
            this.field_71135_a.func_147359_a(new SPacketSoundEffect(SoundEvents.field_187654_U, SoundCategory.BLOCKS, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f));
            return;
        }
        this.func_71117_bO();
        if (iInventory instanceof IInteractionObject) {
            this.field_71135_a.func_147359_a(new SPacketOpenWindow(this.field_71139_cq, ((IInteractionObject)((Object)iInventory)).func_174875_k(), iInventory.func_145748_c_(), iInventory.func_70302_i_()));
            this.field_71070_bA = ((IInteractionObject)((Object)iInventory)).func_174876_a(this.field_71071_by, this);
        } else {
            this.field_71135_a.func_147359_a(new SPacketOpenWindow(this.field_71139_cq, "minecraft:container", iInventory.func_145748_c_(), iInventory.func_70302_i_()));
            this.field_71070_bA = new ContainerChest(this.field_71071_by, iInventory, this);
        }
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_180472_a(IMerchant iMerchant) {
        this.func_71117_bO();
        this.field_71070_bA = new ContainerMerchant(this.field_71071_by, iMerchant, this.field_70170_p);
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
        InventoryMerchant inventoryMerchant = ((ContainerMerchant)this.field_71070_bA).func_75174_d();
        ITextComponent \u26032 = iMerchant.func_145748_c_();
        this.field_71135_a.func_147359_a(new SPacketOpenWindow(this.field_71139_cq, "minecraft:villager", \u26032, inventoryMerchant.func_70302_i_()));
        MerchantRecipeList \u26033 = iMerchant.func_70934_b(this);
        if (\u26033 != null) {
            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
            packetBuffer.writeInt(this.field_71139_cq);
            \u26033.func_151391_a(packetBuffer);
            this.field_71135_a.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209910_a, packetBuffer));
        }
    }

    @Override
    public void func_184826_a(AbstractHorse abstractHorse, IInventory iInventory) {
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a(new SPacketOpenWindow(this.field_71139_cq, "EntityHorse", iInventory.func_145748_c_(), iInventory.func_70302_i_(), abstractHorse.func_145782_y()));
        this.field_71070_bA = new ContainerHorseInventory(this.field_71071_by, iInventory, abstractHorse, this);
        this.field_71070_bA.field_75152_c = this.field_71139_cq;
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_184814_a(ItemStack itemStack, EnumHand enumHand) {
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151164_bB) {
            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
            packetBuffer.func_179249_a(enumHand);
            this.field_71135_a.func_147359_a(new SPacketCustomPayload(SPacketCustomPayload.field_209912_c, packetBuffer));
        }
    }

    @Override
    public void func_184824_a(TileEntityCommandBlock tileEntityCommandBlock) {
        tileEntityCommandBlock.func_184252_d(true);
        this.func_147097_b(tileEntityCommandBlock);
    }

    @Override
    public void func_71111_a(Container container, int n, ItemStack itemStack) {
        if (container.func_75139_a(n) instanceof SlotCrafting) {
            return;
        }
        if (container == this.field_71069_bz) {
            CriteriaTriggers.field_192125_e.func_192208_a(this, this.field_71071_by);
        }
        if (this.field_71137_h) {
            return;
        }
        this.field_71135_a.func_147359_a(new SPacketSetSlot(container.field_75152_c, n, itemStack));
    }

    public void func_71120_a(Container container) {
        this.func_71110_a(container, container.func_75138_a());
    }

    @Override
    public void func_71110_a(Container container, NonNullList<ItemStack> nonNullList) {
        this.field_71135_a.func_147359_a(new SPacketWindowItems(container.field_75152_c, nonNullList));
        this.field_71135_a.func_147359_a(new SPacketSetSlot(-1, -1, this.field_71071_by.func_70445_o()));
    }

    @Override
    public void func_71112_a(Container container, int n, int n2) {
        this.field_71135_a.func_147359_a(new SPacketWindowProperty(container.field_75152_c, n, n2));
    }

    @Override
    public void func_175173_a(Container container, IInventory iInventory) {
        for (int i = 0; i < iInventory.func_174890_g(); ++i) {
            this.field_71135_a.func_147359_a(new SPacketWindowProperty(container.field_75152_c, i, iInventory.func_174887_a_(i)));
        }
    }

    @Override
    public void func_71053_j() {
        this.field_71135_a.func_147359_a(new SPacketCloseWindow(this.field_71070_bA.field_75152_c));
        this.func_71128_l();
    }

    public void func_71113_k() {
        if (this.field_71137_h) {
            return;
        }
        this.field_71135_a.func_147359_a(new SPacketSetSlot(-1, -1, this.field_71071_by.func_70445_o()));
    }

    public void func_71128_l() {
        this.field_71070_bA.func_75134_a(this);
        this.field_71070_bA = this.field_71069_bz;
    }

    public void func_110430_a(float f, float f2, boolean bl, boolean bl2) {
        if (this.func_184218_aH()) {
            if (f >= -1.0f && f <= 1.0f) {
                this.field_70702_br = f;
            }
            if (f2 >= -1.0f && f2 <= 1.0f) {
                this.field_191988_bg = f2;
            }
            this.field_70703_bu = bl;
            this.func_70095_a(bl2);
        }
    }

    @Override
    public void func_71064_a(Stat<?> stat, int n) {
        this.field_147103_bO.func_150871_b(this, stat, n);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), score -> score.func_96649_a(n));
    }

    @Override
    public void func_175145_a(Stat<?> stat) {
        this.field_147103_bO.func_150873_a(this, stat, 0);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), Score::func_197891_c);
    }

    @Override
    public int func_195065_a(Collection<IRecipe> collection) {
        return this.field_192041_cq.func_197926_a(collection, this);
    }

    @Override
    public void func_193102_a(ResourceLocation[] resourceLocationArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (ResourceLocation resourceLocation : resourceLocationArray) {
            IRecipe iRecipe = this.field_71133_b.func_199529_aN().func_199517_a(resourceLocation);
            if (iRecipe == null) continue;
            arrayList.add(iRecipe);
        }
        this.func_195065_a(arrayList);
    }

    @Override
    public int func_195069_b(Collection<IRecipe> collection) {
        return this.field_192041_cq.func_197925_b(collection, this);
    }

    @Override
    public void func_195068_e(int n) {
        super.func_195068_e(n);
        this.field_71144_ck = -1;
    }

    public void func_71123_m() {
        this.field_193109_cv = true;
        this.func_184226_ay();
        if (this.field_71083_bS) {
            this.func_70999_a(true, false, false);
        }
    }

    public boolean func_193105_t() {
        return this.field_193109_cv;
    }

    public void func_71118_n() {
        this.field_71149_ch = -1.0E8f;
    }

    @Override
    public void func_146105_b(ITextComponent iTextComponent, boolean bl) {
        this.field_71135_a.func_147359_a(new SPacketChat(iTextComponent, bl ? ChatType.GAME_INFO : ChatType.CHAT));
    }

    @Override
    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.field_71135_a.func_147359_a(new SPacketEntityStatus(this, 9));
            super.func_71036_o();
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type type, Vec3d vec3d) {
        super.func_200602_a(type, vec3d);
        this.field_71135_a.func_147359_a(new SPacketPlayerLook(type, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_200618_a(EntityAnchorArgument.Type type, Entity entity, EntityAnchorArgument.Type type2) {
        Vec3d vec3d = type2.func_201017_a(entity);
        super.func_200602_a(type, vec3d);
        this.field_71135_a.func_147359_a(new SPacketPlayerLook(type, entity, type2));
    }

    public void func_193104_a(EntityPlayerMP entityPlayerMP, boolean bl) {
        if (bl) {
            this.field_71071_by.func_70455_b(entityPlayerMP.field_71071_by);
            this.func_70606_j(entityPlayerMP.func_110143_aJ());
            this.field_71100_bB = entityPlayerMP.field_71100_bB;
            this.field_71068_ca = entityPlayerMP.field_71068_ca;
            this.field_71067_cb = entityPlayerMP.field_71067_cb;
            this.field_71106_cc = entityPlayerMP.field_71106_cc;
            this.func_85040_s(entityPlayerMP.func_71037_bA());
            this.field_181016_an = entityPlayerMP.field_181016_an;
            this.field_181017_ao = entityPlayerMP.field_181017_ao;
            this.field_181018_ap = entityPlayerMP.field_181018_ap;
        } else if (this.field_70170_p.func_82736_K().func_82766_b("keepInventory") || entityPlayerMP.func_175149_v()) {
            this.field_71071_by.func_70455_b(entityPlayerMP.field_71071_by);
            this.field_71068_ca = entityPlayerMP.field_71068_ca;
            this.field_71067_cb = entityPlayerMP.field_71067_cb;
            this.field_71106_cc = entityPlayerMP.field_71106_cc;
            this.func_85040_s(entityPlayerMP.func_71037_bA());
        }
        this.field_175152_f = entityPlayerMP.field_175152_f;
        this.field_71078_a = entityPlayerMP.field_71078_a;
        this.func_184212_Q().func_187227_b(field_184827_bp, entityPlayerMP.func_184212_Q().func_187225_a(field_184827_bp));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.field_192041_cq.func_193824_a(entityPlayerMP.field_192041_cq);
        this.field_71130_g.addAll(entityPlayerMP.field_71130_g);
        this.field_192040_cp = entityPlayerMP.field_192040_cp;
        this.field_193110_cw = entityPlayerMP.field_193110_cw;
        this.func_192029_h(entityPlayerMP.func_192023_dk());
        this.func_192031_i(entityPlayerMP.func_192025_dl());
    }

    @Override
    protected void func_70670_a(PotionEffect potionEffect) {
        super.func_70670_a(potionEffect);
        this.field_71135_a.func_147359_a(new SPacketEntityEffect(this.func_145782_y(), potionEffect));
        if (potionEffect.func_188419_a() == MobEffects.field_188424_y) {
            this.field_193108_cu = this.field_70173_aa;
            this.field_193107_ct = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70695_b(PotionEffect potionEffect, boolean bl) {
        super.func_70695_b(potionEffect, bl);
        this.field_71135_a.func_147359_a(new SPacketEntityEffect(this.func_145782_y(), potionEffect));
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70688_c(PotionEffect potionEffect) {
        super.func_70688_c(potionEffect);
        this.field_71135_a.func_147359_a(new SPacketRemoveEntityEffect(this.func_145782_y(), potionEffect.func_188419_a()));
        if (potionEffect.func_188419_a() == MobEffects.field_188424_y) {
            this.field_193107_ct = null;
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    public void func_70634_a(double d, double d2, double d3) {
        this.field_71135_a.func_147364_a(d, d2, d3, this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_71009_b(Entity entity) {
        this.func_71121_q().func_73039_n().func_151248_b(this, new SPacketAnimation(entity, 4));
    }

    @Override
    public void func_71047_c(Entity entity) {
        this.func_71121_q().func_73039_n().func_151248_b(this, new SPacketAnimation(entity, 5));
    }

    @Override
    public void func_71016_p() {
        if (this.field_71135_a == null) {
            return;
        }
        this.field_71135_a.func_147359_a(new SPacketPlayerAbilities(this.field_71075_bZ));
        this.func_175135_B();
    }

    public WorldServer func_71121_q() {
        return (WorldServer)this.field_70170_p;
    }

    @Override
    public void func_71033_a(GameType gameType) {
        this.field_71134_c.func_73076_a(gameType);
        this.field_71135_a.func_147359_a(new SPacketChangeGameState(3, gameType.func_77148_a()));
        if (gameType == GameType.SPECTATOR) {
            this.func_192030_dh();
            this.func_184210_p();
        } else {
            this.func_175399_e(this);
        }
        this.func_71016_p();
        this.func_175136_bO();
    }

    @Override
    public boolean func_175149_v() {
        return this.field_71134_c.func_73081_b() == GameType.SPECTATOR;
    }

    @Override
    public boolean func_184812_l_() {
        return this.field_71134_c.func_73081_b() == GameType.CREATIVE;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        this.func_195395_a(iTextComponent, ChatType.SYSTEM);
    }

    public void func_195395_a(ITextComponent iTextComponent, ChatType chatType) {
        this.field_71135_a.func_211148_a(new SPacketChat(iTextComponent, chatType), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
            if (!(future.isSuccess() || chatType != ChatType.GAME_INFO && chatType != ChatType.SYSTEM)) {
                int n = 256;
                String \u26032 = iTextComponent.func_212636_a(256);
                ITextComponent \u26033 = new TextComponentString(\u26032).func_211708_a(TextFormatting.YELLOW);
                this.field_71135_a.func_147359_a(new SPacketChat(new TextComponentTranslation("multiplayer.message_not_delivered", \u26033).func_211708_a(TextFormatting.RED), ChatType.SYSTEM));
            }
        }));
    }

    public String func_71114_r() {
        String string = this.field_71135_a.field_147371_a.func_74430_c().toString();
        string = string.substring(string.indexOf("/") + 1);
        string = string.substring(0, string.indexOf(":"));
        return string;
    }

    public void func_147100_a(CPacketClientSettings cPacketClientSettings) {
        this.field_71148_cg = cPacketClientSettings.func_149524_c();
        this.field_71143_cn = cPacketClientSettings.func_149523_e();
        this.field_71140_co = cPacketClientSettings.func_149520_f();
        this.func_184212_Q().func_187227_b(field_184827_bp, (byte)cPacketClientSettings.func_149521_d());
        this.func_184212_Q().func_187227_b(field_184828_bq, (byte)(cPacketClientSettings.func_186991_f() != EnumHandSide.LEFT ? 1 : 0));
    }

    public EntityPlayer.EnumChatVisibility func_147096_v() {
        return this.field_71143_cn;
    }

    public void func_175397_a(String string, String string2) {
        this.field_71135_a.func_147359_a(new SPacketResourcePackSend(string, string2));
    }

    @Override
    protected int func_184840_I() {
        return this.field_71133_b.func_211833_a(this.func_146103_bH());
    }

    public void func_143004_u() {
        this.field_143005_bX = Util.func_211177_b();
    }

    public StatisticsManagerServer func_147099_x() {
        return this.field_147103_bO;
    }

    public ServerRecipeBook func_192037_E() {
        return this.field_192041_cq;
    }

    public void func_152339_d(Entity entity) {
        if (entity instanceof EntityPlayer) {
            this.field_71135_a.func_147359_a(new SPacketDestroyEntities(entity.func_145782_y()));
        } else {
            this.field_71130_g.add(entity.func_145782_y());
        }
    }

    public void func_184848_d(Entity entity) {
        this.field_71130_g.remove((Object)entity.func_145782_y());
    }

    @Override
    protected void func_175135_B() {
        if (this.func_175149_v()) {
            this.func_175133_bi();
            this.func_82142_c(true);
        } else {
            super.func_175135_B();
        }
        this.func_71121_q().func_73039_n().func_180245_a(this);
    }

    public Entity func_175398_C() {
        return this.field_175401_bS == null ? this : this.field_175401_bS;
    }

    public void func_175399_e(Entity entity) {
        \u2603 = this.func_175398_C();
        Entity entity2 = this.field_175401_bS = entity == null ? this : entity;
        if (\u2603 != this.field_175401_bS) {
            this.field_71135_a.func_147359_a(new SPacketCamera(this.field_175401_bS));
            this.func_70634_a(this.field_175401_bS.field_70165_t, this.field_175401_bS.field_70163_u, this.field_175401_bS.field_70161_v);
        }
    }

    @Override
    protected void func_184173_H() {
        if (this.field_71088_bW > 0 && !this.field_184851_cj) {
            --this.field_71088_bW;
        }
    }

    @Override
    public void func_71059_n(Entity entity) {
        if (this.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            this.func_175399_e(entity);
        } else {
            super.func_71059_n(entity);
        }
    }

    public long func_154331_x() {
        return this.field_143005_bX;
    }

    @Nullable
    public ITextComponent func_175396_E() {
        return null;
    }

    @Override
    public void func_184609_a(EnumHand enumHand) {
        super.func_184609_a(enumHand);
        this.func_184821_cY();
    }

    public boolean func_184850_K() {
        return this.field_184851_cj;
    }

    public void func_184846_L() {
        this.field_184851_cj = false;
    }

    public void func_184847_M() {
        this.func_70052_a(7, true);
    }

    public void func_189103_N() {
        this.func_70052_a(7, true);
        this.func_70052_a(7, false);
    }

    public PlayerAdvancements func_192039_O() {
        return this.field_192042_bX;
    }

    @Nullable
    public Vec3d func_193106_Q() {
        return this.field_193110_cw;
    }

    public void func_200619_a(WorldServer worldServer, double d, double d2, double d3, float f, float f2) {
        this.func_175399_e(this);
        this.func_184210_p();
        if (worldServer == this.field_70170_p) {
            this.field_71135_a.func_147364_a(d, d2, d3, f, f2);
        } else {
            WorldServer worldServer2 = this.func_71121_q();
            this.field_71093_bK = worldServer.field_73011_w.func_186058_p();
            this.field_71135_a.func_147359_a(new SPacketRespawn(this.field_71093_bK, worldServer2.func_175659_aa(), worldServer2.func_72912_H().func_76067_t(), this.field_71134_c.func_73081_b()));
            this.field_71133_b.func_184103_al().func_187243_f(this);
            worldServer2.func_72973_f(this);
            this.field_70128_L = false;
            this.func_70012_b(d, d2, d3, f, f2);
            if (this.func_70089_S()) {
                worldServer2.func_72866_a(this, false);
                worldServer.func_72838_d(this);
                worldServer.func_72866_a(this, false);
            }
            this.func_70029_a(worldServer);
            this.field_71133_b.func_184103_al().func_72375_a(this, worldServer2);
            this.field_71135_a.func_147364_a(d, d2, d3, f, f2);
            this.field_71134_c.func_73080_a(worldServer);
            this.field_71133_b.func_184103_al().func_72354_b(this, worldServer);
            this.field_71133_b.func_184103_al().func_72385_f(this);
        }
    }

    private /* synthetic */ void func_212356_a(ITextComponent iTextComponent, Future future) throws Exception {
        if (!future.isSuccess()) {
            int n = 256;
            String \u26032 = iTextComponent.func_212636_a(256);
            TextComponentTranslation \u26033 = new TextComponentTranslation("death.attack.message_too_long", new TextComponentString(\u26032).func_211708_a(TextFormatting.YELLOW));
            ITextComponent \u26034 = new TextComponentTranslation("death.attack.even_more_magic", this.func_145748_c_()).func_211710_a(style -> style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, \u26033)));
            this.field_71135_a.func_147359_a(new SPacketCombatEvent(this.func_110142_aN(), SPacketCombatEvent.Event.ENTITY_DIED, \u26034));
        }
    }
}

