/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty field_207209_a = BlockStateProperties.field_208183_j;
    public static final IntegerProperty field_207210_b = BlockStateProperties.field_208131_af;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> field_212756_e = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            protected void rehash(int n) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });

    @Override
    protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
        builder.func_206894_a(field_207209_a);
    }

    @Override
    public Vec3d func_205564_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, IFluidState iFluidState) {
        double d = 0.0;
        \u2603 = 0.0;
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                \u26032.func_189533_g(blockPos).func_189536_c(enumFacing);
                Object object = iWorldReaderBase.func_204610_c(\u26032);
                if (!this.func_212189_g((IFluidState)object)) continue;
                float \u26033 = object.func_206885_f();
                float \u26034 = 0.0f;
                if (\u26033 == 0.0f) {
                    if (!iWorldReaderBase.func_180495_p(\u26032).func_185904_a().func_76230_c() && this.func_212189_g(\u2603 = iWorldReaderBase.func_204610_c(\u26032.func_177977_b())) && (\u26033 = \u2603.func_206885_f()) > 0.0f) {
                        \u26034 = iFluidState.func_206885_f() - (\u26033 - 0.8888889f);
                    }
                } else if (\u26033 > 0.0f) {
                    \u26034 = iFluidState.func_206885_f() - \u26033;
                }
                if (\u26034 == 0.0f) continue;
                d += (double)((float)enumFacing.func_82601_c() * \u26034);
                \u2603 += (double)((float)enumFacing.func_82599_e() * \u26034);
            }
            Vec3d vec3d = new Vec3d(d, 0.0, \u2603);
            if (iFluidState.func_177229_b(field_207209_a).booleanValue()) {
                for (Object object : EnumFacing.Plane.HORIZONTAL) {
                    \u26032.func_189533_g(blockPos).func_189536_c((EnumFacing)object);
                    if (!this.func_205573_a(iWorldReaderBase, \u26032, (EnumFacing)object) && !this.func_205573_a(iWorldReaderBase, \u26032.func_177984_a(), (EnumFacing)object)) continue;
                    vec3d = vec3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                    break;
                }
            }
            Vec3d vec3d2 = vec3d.func_72432_b();
            return vec3d2;
        }
    }

    private boolean func_212189_g(IFluidState iFluidState) {
        return iFluidState.func_206888_e() || iFluidState.func_206886_c().func_207187_a(this);
    }

    protected boolean func_205573_a(IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState = iBlockReader.func_180495_p(blockPos);
        Block \u26032 = iBlockState.func_177230_c();
        IFluidState \u26033 = iBlockReader.func_204610_c(blockPos);
        if (\u26033.func_206886_c().func_207187_a(this)) {
            return false;
        }
        if (enumFacing == EnumFacing.UP) {
            return true;
        }
        if (iBlockState.func_185904_a() == Material.field_151588_w) {
            return false;
        }
        boolean \u26034 = Block.func_193382_c(\u26032) || \u26032 instanceof BlockStairs;
        return !\u26034 && iBlockState.func_193401_d(iBlockReader, blockPos, enumFacing) == BlockFaceShape.SOLID;
    }

    protected void func_205575_a(IWorld iWorld, BlockPos blockPos, IFluidState iFluidState) {
        if (iFluidState.func_206888_e()) {
            return;
        }
        IBlockState iBlockState = iWorld.func_180495_p(blockPos);
        BlockPos \u26032 = blockPos.func_177977_b();
        \u2603 = iWorld.func_180495_p(\u26032);
        IFluidState \u26033 = this.func_205576_a(iWorld, \u26032, \u2603);
        if (this.func_205570_b(iWorld, blockPos, iBlockState, EnumFacing.DOWN, \u26032, \u2603, iWorld.func_204610_c(\u26032), \u26033.func_206886_c())) {
            this.func_205574_a(iWorld, \u26032, \u2603, EnumFacing.DOWN, \u26033);
            if (this.func_207936_a(iWorld, blockPos) >= 3) {
                this.func_207937_a(iWorld, blockPos, iFluidState, iBlockState);
            }
        } else if (iFluidState.func_206889_d() || !this.func_211759_a(iWorld, \u26033.func_206886_c(), blockPos, iBlockState, \u26032, \u2603)) {
            this.func_207937_a(iWorld, blockPos, iFluidState, iBlockState);
        }
    }

    private void func_207937_a(IWorld iWorld, BlockPos blockPos, IFluidState iFluidState, IBlockState iBlockState) {
        int n = iFluidState.func_206882_g() - this.func_204528_b(iWorld);
        if (iFluidState.func_177229_b(field_207209_a).booleanValue()) {
            n = 7;
        }
        if (n <= 0) {
            return;
        }
        Map<EnumFacing, IFluidState> \u26032 = this.func_205572_b(iWorld, blockPos, iBlockState);
        for (Map.Entry<EnumFacing, IFluidState> entry : \u26032.entrySet()) {
            EnumFacing enumFacing = entry.getKey();
            IFluidState \u26033 = entry.getValue();
            BlockPos \u26034 = blockPos.func_177972_a(enumFacing);
            if (!this.func_205570_b(iWorld, blockPos, iBlockState, enumFacing, \u26034, \u2603 = iWorld.func_180495_p(\u26034), iWorld.func_204610_c(\u26034), \u26033.func_206886_c())) continue;
            this.func_205574_a(iWorld, \u26034, \u2603, enumFacing, \u26033);
        }
    }

    protected IFluidState func_205576_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, IBlockState iBlockState) {
        Object object;
        int \u26033 = 0;
        \u2603 = 0;
        for (Object object2 : EnumFacing.Plane.HORIZONTAL) {
            object = blockPos.func_177972_a((EnumFacing)object2);
            IBlockState iBlockState2 = iWorldReaderBase.func_180495_p((BlockPos)object);
            IFluidState \u26032 = iBlockState2.func_204520_s();
            if (!\u26032.func_206886_c().func_207187_a(this) || !this.func_212751_a((EnumFacing)object2, iWorldReaderBase, blockPos, iBlockState, (BlockPos)object, iBlockState2)) continue;
            if (\u26032.func_206889_d()) {
                ++\u2603;
            }
            \u26033 = Math.max(\u26033, \u26032.func_206882_g());
        }
        if (this.func_205579_d() && \u2603 >= 2) {
            Object object3 = iWorldReaderBase.func_180495_p(blockPos.func_177977_b());
            object2 = object3.func_204520_s();
            if (object3.func_185904_a().func_76220_a() || this.func_211758_g((IFluidState)object2)) {
                return this.func_207204_a(false);
            }
        }
        if (!(object = (object2 = iWorldReaderBase.func_180495_p((BlockPos)(object3 = blockPos.func_177984_a()))).func_204520_s()).func_206888_e() && object.func_206886_c().func_207187_a(this) && this.func_212751_a(EnumFacing.UP, iWorldReaderBase, blockPos, iBlockState, (BlockPos)object3, (IBlockState)object2)) {
            return this.func_207207_a(8, true);
        }
        int \u26034 = \u26033 - this.func_204528_b(iWorldReaderBase);
        if (\u26034 <= 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return this.func_207207_a(\u26034, false);
    }

    private boolean func_212751_a(EnumFacing enumFacing, IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, BlockPos blockPos2, IBlockState iBlockState2) {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2ByteLinkedOpenHashMap = iBlockState.func_177230_c().func_208619_r() || iBlockState2.func_177230_c().func_208619_r() ? null : field_212756_e.get();
        if (object2ByteLinkedOpenHashMap != null) {
            Block.RenderSideCacheKey renderSideCacheKey = new Block.RenderSideCacheKey(iBlockState, iBlockState2, enumFacing);
            byte \u26032 = object2ByteLinkedOpenHashMap.getAndMoveToFirst((Object)renderSideCacheKey);
            if (\u26032 != 127) {
                return \u26032 != 0;
            }
        } else {
            renderSideCacheKey = null;
        }
        boolean bl = \u2603 = !VoxelShapes.func_204642_b(\u2603 = iBlockState.func_196952_d(iBlockReader, blockPos), \u2603 = iBlockState2.func_196952_d(iBlockReader, blockPos2), enumFacing);
        if (object2ByteLinkedOpenHashMap != null) {
            if (object2ByteLinkedOpenHashMap.size() == 200) {
                object2ByteLinkedOpenHashMap.removeLastByte();
            }
            object2ByteLinkedOpenHashMap.putAndMoveToFirst((Object)renderSideCacheKey, (byte)(\u2603 ? 1 : 0));
        }
        return \u2603;
    }

    public abstract Fluid func_210197_e();

    public IFluidState func_207207_a(int n, boolean bl) {
        return (IFluidState)((IFluidState)this.func_210197_e().func_207188_f().func_206870_a(field_207210_b, n)).func_206870_a(field_207209_a, bl);
    }

    public abstract Fluid func_210198_f();

    public IFluidState func_207204_a(boolean bl) {
        return (IFluidState)this.func_210198_f().func_207188_f().func_206870_a(field_207209_a, bl);
    }

    protected abstract boolean func_205579_d();

    protected void func_205574_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing, IFluidState iFluidState) {
        if (iBlockState.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)((Object)iBlockState.func_177230_c())).func_204509_a(iWorld, blockPos, iBlockState, iFluidState);
        } else {
            if (!iBlockState.func_196958_f()) {
                this.func_205580_a(iWorld, blockPos, iBlockState);
            }
            iWorld.func_180501_a(blockPos, iFluidState.func_206883_i(), 3);
        }
    }

    protected abstract void func_205580_a(IWorld var1, BlockPos var2, IBlockState var3);

    private static short func_212752_a(BlockPos blockPos, BlockPos blockPos2) {
        int n = blockPos2.func_177958_n() - blockPos.func_177958_n();
        \u2603 = blockPos2.func_177952_p() - blockPos.func_177952_p();
        return (short)((n + 128 & 0xFF) << 8 | \u2603 + 128 & 0xFF);
    }

    protected int func_205571_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, int n2, EnumFacing enumFacing, IBlockState iBlockState, BlockPos blockPos2, Short2ObjectMap<Pair<IBlockState, IFluidState>> short2ObjectMap, Short2BooleanMap short2BooleanMap) {
        int \u26037 = 1000;
        for (EnumFacing enumFacing2 : EnumFacing.Plane.HORIZONTAL) {
            if (enumFacing2 == enumFacing) continue;
            BlockPos blockPos3 = blockPos.func_177972_a(enumFacing2);
            short \u26032 = FlowingFluid.func_212752_a(blockPos2, blockPos3);
            Pair \u26033 = (Pair)short2ObjectMap.computeIfAbsent(\u26032, n -> {
                IBlockState iBlockState = iWorldReaderBase.func_180495_p(blockPos3);
                return Pair.of((Object)iBlockState, (Object)iBlockState.func_204520_s());
            });
            IBlockState \u26034 = (IBlockState)\u26033.getFirst();
            IFluidState \u26035 = (IFluidState)\u26033.getSecond();
            if (!this.func_211760_a(iWorldReaderBase, this.func_210197_e(), blockPos, iBlockState, enumFacing2, blockPos3, \u26034, \u26035)) continue;
            boolean \u26036 = short2BooleanMap.computeIfAbsent(\u26032, n -> {
                BlockPos blockPos2 = blockPos3.func_177977_b();
                IBlockState \u26032 = iWorldReaderBase.func_180495_p(blockPos2);
                return this.func_211759_a(iWorldReaderBase, this.func_210197_e(), blockPos3, \u26034, blockPos2, \u26032);
            });
            if (\u26036) {
                return n2;
            }
            if (n2 >= this.func_185698_b(iWorldReaderBase) || (\u2603 = this.func_205571_a(iWorldReaderBase, blockPos3, n2 + 1, enumFacing2.func_176734_d(), \u26034, blockPos2, short2ObjectMap, short2BooleanMap)) >= \u26037) continue;
            \u26037 = \u2603;
        }
        return \u26037;
    }

    private boolean func_211759_a(IBlockReader iBlockReader, Fluid fluid, BlockPos blockPos, IBlockState iBlockState, BlockPos blockPos2, IBlockState iBlockState2) {
        if (!this.func_212751_a(EnumFacing.DOWN, iBlockReader, blockPos, iBlockState, blockPos2, iBlockState2)) {
            return false;
        }
        if (iBlockState2.func_204520_s().func_206886_c().func_207187_a(this)) {
            return true;
        }
        return this.func_211761_a(iBlockReader, blockPos2, iBlockState2, fluid);
    }

    private boolean func_211760_a(IBlockReader iBlockReader, Fluid fluid, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing, BlockPos blockPos2, IBlockState iBlockState2, IFluidState iFluidState) {
        return !this.func_211758_g(iFluidState) && this.func_212751_a(enumFacing, iBlockReader, blockPos, iBlockState, blockPos2, iBlockState2) && this.func_211761_a(iBlockReader, blockPos2, iBlockState2, fluid);
    }

    private boolean func_211758_g(IFluidState iFluidState) {
        return iFluidState.func_206886_c().func_207187_a(this) && iFluidState.func_206889_d();
    }

    protected abstract int func_185698_b(IWorldReaderBase var1);

    private int func_207936_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        int n = 0;
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
            IFluidState \u26032 = iWorldReaderBase.func_204610_c(blockPos2);
            if (!this.func_211758_g(\u26032)) continue;
            ++n;
        }
        return n;
    }

    protected Map<EnumFacing, IFluidState> func_205572_b(IWorldReaderBase iWorldReaderBase, BlockPos blockPos, IBlockState iBlockState) {
        int \u260312 = 1000;
        EnumMap \u26032 = Maps.newEnumMap(EnumFacing.class);
        Short2ObjectOpenHashMap \u26033 = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap \u26034 = new Short2BooleanOpenHashMap();
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
            short \u26035 = FlowingFluid.func_212752_a(blockPos, blockPos2);
            Pair \u26036 = (Pair)\u26033.computeIfAbsent(\u26035, n -> {
                IBlockState iBlockState = iWorldReaderBase.func_180495_p(blockPos2);
                return Pair.of((Object)iBlockState, (Object)iBlockState.func_204520_s());
            });
            IBlockState \u26037 = (IBlockState)\u26036.getFirst();
            IFluidState \u26038 = (IFluidState)\u26036.getSecond();
            IFluidState \u26039 = this.func_205576_a(iWorldReaderBase, blockPos2, \u26037);
            if (!this.func_211760_a(iWorldReaderBase, \u26039.func_206886_c(), blockPos, iBlockState, enumFacing, blockPos2, \u26037, \u26038)) continue;
            \u2603 = blockPos2.func_177977_b();
            boolean \u260310 = \u26034.computeIfAbsent(\u26035, n -> {
                IBlockState iBlockState2 = iWorldReaderBase.func_180495_p(\u2603);
                return this.func_211759_a(iWorldReaderBase, this.func_210197_e(), blockPos2, \u26037, \u2603, iBlockState2);
            });
            int \u260311 = \u260310 ? 0 : this.func_205571_a(iWorldReaderBase, blockPos2, 1, enumFacing.func_176734_d(), \u26037, blockPos, (Short2ObjectMap<Pair<IBlockState, IFluidState>>)\u26033, (Short2BooleanMap)\u26034);
            if (\u260311 < \u260312) {
                \u26032.clear();
            }
            if (\u260311 > \u260312) continue;
            \u26032.put(enumFacing, \u26039);
            \u260312 = \u260311;
        }
        return \u26032;
    }

    private boolean func_211761_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, Fluid fluid) {
        Block block = iBlockState.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)((Object)block)).func_204510_a(iBlockReader, blockPos, iBlockState, fluid);
        }
        if (block instanceof BlockDoor || block == Blocks.field_196649_cc || block == Blocks.field_150468_ap || block == Blocks.field_196608_cF || block == Blocks.field_203203_C) {
            return false;
        }
        Material \u26032 = iBlockState.func_185904_a();
        if (\u26032 == Material.field_151567_E || \u26032 == Material.field_189963_J || \u26032 == Material.field_203243_f || \u26032 == Material.field_204868_h) {
            return false;
        }
        return !\u26032.func_76230_c();
    }

    protected boolean func_205570_b(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, EnumFacing enumFacing, BlockPos blockPos2, IBlockState iBlockState2, IFluidState iFluidState, Fluid fluid) {
        return iFluidState.func_211725_a(fluid, enumFacing) && this.func_212751_a(enumFacing, iBlockReader, blockPos, iBlockState, blockPos2, iBlockState2) && this.func_211761_a(iBlockReader, blockPos2, iBlockState2, fluid);
    }

    protected abstract int func_204528_b(IWorldReaderBase var1);

    protected int func_205578_a(World world, IFluidState iFluidState, IFluidState iFluidState2) {
        return this.func_205569_a(world);
    }

    @Override
    public void func_207191_a(World world2, BlockPos blockPos, IFluidState iFluidState3) {
        World world2;
        if (!iFluidState3.func_206889_d()) {
            IFluidState iFluidState2;
            iFluidState2 = this.func_205576_a(world2, blockPos, world2.func_180495_p(blockPos));
            int n = this.func_205578_a(world2, iFluidState3, iFluidState2);
            if (iFluidState2.func_206888_e()) {
                IFluidState iFluidState3 = iFluidState2;
                world2.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (!iFluidState2.equals(iFluidState3)) {
                iFluidState3 = iFluidState2;
                IBlockState iBlockState = iFluidState3.func_206883_i();
                world2.func_180501_a(blockPos, iBlockState, 2);
                world2.func_205219_F_().func_205360_a(blockPos, iFluidState3.func_206886_c(), n);
                world2.func_195593_d(blockPos, iBlockState.func_177230_c());
            }
        }
        this.func_205575_a(world2, blockPos, iFluidState3);
    }

    protected static int func_207205_e(IFluidState iFluidState) {
        if (iFluidState.func_206889_d()) {
            return 0;
        }
        return 8 - Math.min(iFluidState.func_206882_g(), 8) + (iFluidState.func_177229_b(field_207209_a) != false ? 8 : 0);
    }

    @Override
    public float func_207181_a(IFluidState iFluidState) {
        return (float)iFluidState.func_206882_g() / 9.0f;
    }
}

