/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemSpawnEgg
extends Item {
    private static final Map<EntityType<?>, ItemSpawnEgg> field_195987_b = Maps.newIdentityHashMap();
    private final int field_195988_c;
    private final int field_195989_d;
    private final EntityType<?> field_200890_d;

    public ItemSpawnEgg(EntityType<?> entityType, int n, int n2, Item.Properties properties) {
        super(properties);
        this.field_200890_d = entityType;
        this.field_195988_c = n;
        this.field_195989_d = n2;
        field_195987_b.put(entityType, this);
    }

    @Override
    public EnumActionResult func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack \u26032 = itemUseContext.func_195996_i();
        BlockPos \u26033 = itemUseContext.func_195995_a();
        EnumFacing \u26034 = itemUseContext.func_196000_l();
        IBlockState \u26035 = world.func_180495_p(\u26033);
        Block \u26036 = \u26035.func_177230_c();
        if (\u26036 == Blocks.field_150474_ac && (object = world.func_175625_s(\u26033)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobSpawnerBaseLogic = ((TileEntityMobSpawner)object).func_145881_a();
            EntityType<?> \u26037 = this.func_208076_b(\u26032.func_77978_p());
            if (\u26037 != null) {
                mobSpawnerBaseLogic.func_200876_a(\u26037);
                ((TileEntity)object).func_70296_d();
                world.func_184138_a(\u26033, \u26035, \u26035, 3);
            }
            \u26032.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        Object object = \u26035.func_196952_d(world, \u26033).func_197766_b() ? \u26033 : \u26033.func_177972_a(\u26034);
        EntityType<?> \u26038 = this.func_208076_b(\u26032.func_77978_p());
        if (\u26038 == null || \u26038.func_208049_a(world, \u26032, itemUseContext.func_195999_j(), (BlockPos)object, true, !Objects.equals(\u26033, object) && \u26034 == EnumFacing.UP) != null) {
            \u26032.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer, EnumHand enumHand) {
        ItemStack itemStack = entityPlayer.func_184586_b(enumHand);
        if (world.field_72995_K) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStack);
        }
        RayTraceResult \u26032 = this.func_77621_a(world, entityPlayer, true);
        if (\u26032 == null || \u26032.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStack);
        }
        BlockPos \u26033 = \u26032.func_178782_a();
        if (!(world.func_180495_p(\u26033).func_177230_c() instanceof BlockFlowingFluid)) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStack);
        }
        if (!world.func_175660_a(entityPlayer, \u26033) || !entityPlayer.func_175151_a(\u26033, \u26032.field_178784_b, itemStack)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStack);
        }
        EntityType<?> \u26034 = this.func_208076_b(itemStack.func_77978_p());
        if (\u26034 == null || \u26034.func_208049_a(world, itemStack, entityPlayer, \u26033, false, false) == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStack);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        entityPlayer.func_71029_a(StatList.field_75929_E.func_199076_b(this));
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStack);
    }

    public boolean func_208077_a(@Nullable NBTTagCompound nBTTagCompound, EntityType<?> entityType) {
        return Objects.equals(this.func_208076_b(nBTTagCompound), entityType);
    }

    public static Iterable<ItemSpawnEgg> func_195985_g() {
        return Iterables.unmodifiableIterable(field_195987_b.values());
    }

    @Nullable
    public EntityType<?> func_208076_b(@Nullable NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("EntityTag", 10) && (\u2603 = nBTTagCompound.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_200713_a(\u2603.func_74779_i("id"));
        }
        return this.field_200890_d;
    }
}

